/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.util.Strings;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UserDictionary
implements EditableDictionary {
    private final String name;
    @NotNull
    private final Set<String> words;
    @NotNull
    private final Set<String> camelCaseWords;

    public UserDictionary(@NotNull String name) {
        if (name == null) {
            UserDictionary.$$$reportNull$$$0(0);
        }
        this.name = name;
        this.words = CollectionFactory.createSmallMemoryFootprintSet();
        this.camelCaseWords = CollectionFactory.createSmallMemoryFootprintSet();
    }

    public UserDictionary(@NotNull String name, @Nullable Collection<String> words) {
        if (name == null) {
            UserDictionary.$$$reportNull$$$0(1);
        }
        this.name = name;
        this.words = words == null ? CollectionFactory.createSmallMemoryFootprintSet() : CollectionFactory.createSmallMemoryFootprintSet((int)words.size());
        this.camelCaseWords = CollectionFactory.createSmallMemoryFootprintSet();
        this.addToDictionary(words);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            UserDictionary.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        if (word == null) {
            UserDictionary.$$$reportNull$$$0(3);
        }
        return this.words.contains(word) ? Boolean.valueOf(true) : null;
    }

    @Override
    @NotNull
    public Set<String> getWords() {
        Set<String> set = this.words;
        if (set == null) {
            UserDictionary.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getEditableWords() {
        Set<String> set = this.words;
        if (set == null) {
            UserDictionary.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getCamelCaseWords() {
        Set<String> set = this.camelCaseWords;
        if (set == null) {
            UserDictionary.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Override
    public void clear() {
        this.words.clear();
        this.camelCaseWords.clear();
    }

    @Override
    public void addToDictionary(String word) {
        if (word == null) {
            return;
        }
        this.words.add(word);
        if (Strings.isMixedCase(word)) {
            this.camelCaseWords.add(word);
        }
    }

    @Override
    public void removeFromDictionary(String word) {
        if (word == null) {
            return;
        }
        this.words.remove(word);
        this.camelCaseWords.remove(word);
    }

    @Override
    public void replaceAll(@Nullable Collection<String> words) {
        this.clear();
        this.addToDictionary(words);
    }

    @Override
    public void addToDictionary(@Nullable Collection<String> words) {
        if (words == null || words.isEmpty()) {
            return;
        }
        for (String word : words) {
            this.addToDictionary(word);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDictionary that = (UserDictionary)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @NonNls
    public String toString() {
        return "UserDictionary{name='" + this.name + "', words.count=" + this.words.size() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/dictionary/UserDictionary";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/dictionary/UserDictionary";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableWords";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCamelCaseWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

