/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.util.collectionUtil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleCollections {
    @NotNull
    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        List list = element == null ? Collections.emptyList() : Collections.singletonList(element);
        if (list == null) {
            GradleCollections.$$$reportNull$$$0(0);
        }
        return list;
    }

    public static List<String> mapToString(Iterable<?> collection) {
        return GradleCollections.map(collection, it -> String.valueOf(it));
    }

    public static <T, R> List<R> map(Iterable<T> collection, Function<T, R> mapper) {
        ArrayList<R> result = new ArrayList<R>();
        for (T item : collection) {
            result.add(mapper.apply(item));
        }
        return result;
    }

    public static <T> List<T> filter(Iterable<T> collection, Predicate<T> predicate) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : collection) {
            if (!predicate.test(item)) continue;
            result.add(item);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gradle/toolingExtension/impl/util/collectionUtil/GradleCollections", "createMaybeSingletonList"));
    }
}

