/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.completion;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.completion.ShellCommandSpecCompletion;
import com.intellij.terminal.completion.ShellCommandSpecsManager;
import com.intellij.terminal.completion.ShellDataGeneratorsExecutor;
import com.intellij.terminal.completion.ShellRuntimeContextProvider;
import com.intellij.terminal.completion.spec.ShellCompletionSuggestion;
import com.intellij.terminal.completion.spec.ShellRuntimeContext;
import com.intellij.terminal.completion.spec.ShellSuggestionType;
import com.intellij.terminal.frontend.view.completion.TerminalCommandSpecCompletionContributorGen2;
import com.intellij.terminal.frontend.view.completion.TerminalStatefulDelegatingIcon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.block.completion.TerminalCommandCompletionShowingMode;
import org.jetbrains.plugins.terminal.block.completion.TerminalCompletionUtil;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellDataGenerators;
import org.jetbrains.plugins.terminal.block.completion.spec.impl.TerminalCommandCompletionServices;
import org.jetbrains.plugins.terminal.block.reworked.TerminalAliasesStorage;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffset;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.exp.completion.TerminalShellSupport;
import org.jetbrains.plugins.terminal.session.TerminalOutputBlock;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001+B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J<\u0010\u000b\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J2\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0019Jt\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\"\u0010\u001c\u001a\u001e\b\u0001\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001d2*\u0010 \u001a&\b\u0001\u0012\u0004\u0012\u00020\u0010\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0!H\u0082@\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J.\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J8\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100(2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010)\u001a\u00020**\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006,"}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalCommandSpecCompletionContributorGen2;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "submitSuggestions", "suggestions", "", "Lcom/intellij/terminal/completion/spec/ShellCompletionSuggestion;", "allTokens", "", "shellType", "Lorg/jetbrains/plugins/terminal/util/ShellType;", "isAutoPopup", "", "computeSuggestions", "tokens", "context", "Lcom/intellij/terminal/frontend/view/completion/TerminalCommandSpecCompletionContributorGen2$TerminalCompletionContext;", "(Ljava/util/List;Lcom/intellij/terminal/frontend/view/completion/TerminalCommandSpecCompletionContributorGen2$TerminalCompletionContext;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "computeSuggestionsIfHasArguments", "commandExecutable", "fileProducer", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "specCompletionFunction", "Lkotlin/Function2;", "(Ljava/lang/String;Lcom/intellij/terminal/frontend/view/completion/TerminalCommandSpecCompletionContributorGen2$TerminalCompletionContext;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCommandNameVariants", "expandAliases", "aliasesStorage", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalAliasesStorage;", "aliases", "", "toLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "TerminalCompletionContext", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalCommandSpecCompletionContributorGen2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCommandSpecCompletionContributorGen2.kt\ncom/intellij/terminal/frontend/view/completion/TerminalCommandSpecCompletionContributorGen2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n1761#2,3:257\n1563#2:260\n1634#2,3:261\n774#2:264\n865#2,2:265\n774#2:268\n865#2,2:269\n1#3:267\n*S KotlinDebug\n*F\n+ 1 TerminalCommandSpecCompletionContributorGen2.kt\ncom/intellij/terminal/frontend/view/completion/TerminalCommandSpecCompletionContributorGen2\n*L\n105#1:257,3\n111#1:260\n111#1:261,3\n144#1:264\n144#1:265,2\n174#1:268\n174#1:269,2\n*E\n"})
public final class TerminalCommandSpecCompletionContributorGen2
extends CompletionContributor
implements DumbAware {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Editor editor = parameters.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        if (!TerminalDataContextUtils.INSTANCE.isReworkedTerminalEditor(editor)) {
            return;
        }
        TerminalOutputModel terminalOutputModel = (TerminalOutputModel)parameters.getEditor().getUserData(TerminalOutputModel.Companion.getKEY());
        if (terminalOutputModel == null) {
            return;
        }
        TerminalOutputModel outputModel = terminalOutputModel;
        TerminalBlocksModel terminalBlocksModel = (TerminalBlocksModel)parameters.getEditor().getUserData(TerminalBlocksModel.Companion.getKEY());
        if (terminalBlocksModel == null) {
            return;
        }
        TerminalBlocksModel blocksModel = terminalBlocksModel;
        TerminalOutputBlock terminalOutputBlock = (TerminalOutputBlock)CollectionsKt.lastOrNull(blocksModel.getBlocks());
        if (terminalOutputBlock == null) {
            return;
        }
        TerminalOutputBlock lastBlock = terminalOutputBlock;
        TerminalOffset terminalOffset = lastBlock.getCommandStartOffset();
        if (terminalOffset == null) {
            return;
        }
        TerminalOffset commandStartOffset = terminalOffset;
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        if (parameters.isAutoPopup() && !Registry.Companion.is("terminal.new.ui.autocompletion")) {
            result2.stopHere();
            return;
        }
        Editor editor2 = parameters.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        if (TerminalDataContextUtils.INSTANCE.isSuppressCompletion(editor2)) {
            result2.stopHere();
            return;
        }
        TerminalShellSupport terminalShellSupport = TerminalShellSupport.Companion.findByShellType(ShellType.ZSH);
        if (terminalShellSupport == null) {
            return;
        }
        TerminalShellSupport shellSupport = terminalShellSupport;
        TerminalCommandCompletionServices terminalCommandCompletionServices = (TerminalCommandCompletionServices)parameters.getEditor().getUserData(TerminalCommandCompletionServices.Companion.getKEY());
        if (terminalCommandCompletionServices == null) {
            return;
        }
        TerminalCommandCompletionServices completionServices = terminalCommandCompletionServices;
        TerminalCompletionContext context = new TerminalCompletionContext(completionServices.getCommandSpecsManager(), completionServices.getRuntimeContextProvider(), completionServices.getDataGeneratorsExecutor(), shellSupport, parameters, ShellType.ZSH);
        Document document = parameters.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int caretOffset = parameters.getEditor().getCaretModel().getOffset();
        String command2 = outputModel.getText(commandStartOffset, outputModel.getStartOffset().plus(caretOffset));
        Project project = parameters.getEditor().getProject();
        Intrinsics.checkNotNull((Object)project);
        List list = shellSupport.getCommandTokens(project, command2);
        if (list == null) {
            return;
        }
        List tokens = list;
        List allTokens = caretOffset != 0 && Intrinsics.areEqual((Object)document2.getText(TextRange.create((int)(caretOffset - 1), (int)caretOffset)), (Object)" ") ? CollectionsKt.plus((Collection)tokens, (Object)"") : tokens;
        TerminalAliasesStorage aliasesStorage = (TerminalAliasesStorage)parameters.getEditor().getUserData(TerminalAliasesStorage.Companion.getKEY());
        if (allTokens.isEmpty()) {
            return;
        }
        List suggestions2 = (List)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends ShellCompletionSuggestion>>, Object>(this, context, (List<String>)allTokens, aliasesStorage, parameters, null){
            Object L$0;
            int label;
            final /* synthetic */ TerminalCommandSpecCompletionContributorGen2 this$0;
            final /* synthetic */ TerminalCompletionContext $context;
            final /* synthetic */ List<String> $allTokens;
            final /* synthetic */ TerminalAliasesStorage $aliasesStorage;
            final /* synthetic */ CompletionParameters $parameters;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$allTokens = $allTokens;
                this.$aliasesStorage = $aliasesStorage;
                this.$parameters = $parameters;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        List expandedTokens = TerminalCommandSpecCompletionContributorGen2.access$expandAliases(this.this$0, this.$context, this.$allTokens, this.$aliasesStorage);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)expandedTokens);
                        this.label = 1;
                        Object object2 = TerminalCommandSpecCompletionContributorGen2.access$computeSuggestions(this.this$0, expandedTokens, this.$context, this.$parameters.isAutoPopup(), (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        List expandedTokens = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends ShellCompletionSuggestion>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        this.submitSuggestions(suggestions2, allTokens, result2, ShellType.ZSH, parameters.isAutoPopup());
    }

    /*
     * WARNING - void declaration
     */
    private final void submitSuggestions(List<? extends ShellCompletionSuggestion> suggestions2, List<String> allTokens, CompletionResultSet result2, ShellType shellType, boolean isAutoPopup) {
        void $this$mapTo$iv$iv;
        ShellCompletionSuggestion shellCompletionSuggestion = (ShellCompletionSuggestion)CollectionsKt.firstOrNull(suggestions2);
        int prefixReplacementIndex = shellCompletionSuggestion != null ? shellCompletionSuggestion.getPrefixReplacementIndex() : 0;
        String string = ((String)CollectionsKt.last(allTokens)).substring(prefixReplacementIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String prefix = string;
        CompletionResultSet completionResultSet = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix, true));
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"withPrefixMatcher(...)");
        CompletionResultSet resultSet = completionResultSet;
        if (isAutoPopup && TerminalOptionsProvider.Companion.getInstance().getCommandCompletionShowingMode() == TerminalCommandCompletionShowingMode.ONLY_PARAMETERS) {
            boolean containsShellCommand;
            block7: {
                Iterable $this$any$iv = suggestions2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ShellCompletionSuggestion it = (ShellCompletionSuggestion)element$iv;
                        boolean bl = false;
                        if (!(it.getType() == ShellSuggestionType.COMMAND)) continue;
                        v3 = true;
                        break block7;
                    }
                    v3 = containsShellCommand = false;
                }
            }
            if (containsShellCommand) {
                return;
            }
        }
        Iterable $this$map$iv = suggestions2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ShellCompletionSuggestion shellCompletionSuggestion2 = (ShellCompletionSuggestion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toLookupElement((ShellCompletionSuggestion)it, shellType));
        }
        List elements = (List)destination$iv$iv;
        resultSet.addAllElements((Iterable)elements);
        if (!((Collection)elements).isEmpty()) {
            resultSet.stopHere();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object computeSuggestions(List<String> tokens, TerminalCompletionContext context, boolean isAutoPopup, Continuation<? super List<? extends ShellCompletionSuggestion>> $completion) {
        if (!($completion instanceof computeSuggestions.1)) ** GOTO lbl-1000
        var22_5 = $completion;
        if ((var22_5.label & -2147483648) != 0) {
            var22_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalCommandSpecCompletionContributorGen2 this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalCommandSpecCompletionContributorGen2.access$computeSuggestions(this.this$0, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var23_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (tokens.isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                runtimeContext = context.getRuntimeContextProvider().getContext((String)CollectionsKt.last(tokens));
                completion = new ShellCommandSpecCompletion(context.getCommandSpecsManager(), context.getGeneratorsExecutor(), context.getRuntimeContextProvider());
                commandExecutable = (String)CollectionsKt.first(tokens);
                commandArguments = tokens.subList(1, tokens.size());
                fileProducer = (Function1)new Function1<Continuation<? super List<? extends ShellCompletionSuggestion>>, Object>(context, runtimeContext, null){
                    int label;
                    final /* synthetic */ TerminalCompletionContext $context;
                    final /* synthetic */ ShellRuntimeContext $runtimeContext;
                    {
                        this.$context = $context;
                        this.$runtimeContext = $runtimeContext;
                        super(1, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$context.getGeneratorsExecutor().execute(this.$runtimeContext, ShellDataGenerators.fileSuggestionsGenerator$default(ShellDataGenerators.INSTANCE, false, 1, null), (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Continuation<? super List<? extends ShellCompletionSuggestion>> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                };
                specCompletionFunction = (Function2)new Function2<String, Continuation<? super List<? extends ShellCompletionSuggestion>>, Object>(completion, commandArguments, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ ShellCommandSpecCompletion $completion;
                    final /* synthetic */ List<String> $commandArguments;
                    {
                        this.$completion = $completion;
                        this.$commandArguments = $commandArguments;
                        super(2, $completion2);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        String string = (String)this.L$0;
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void commandName;
                                ResultKt.throwOnFailure((Object)$result);
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)commandName);
                                this.label = 1;
                                Object object2 = this.$completion.computeCompletionItems((String)commandName, this.$commandArguments, (Continuation<? super List<? extends ShellCompletionSuggestion>>)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(String p1, Continuation<? super List<? extends ShellCompletionSuggestion>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                };
                if (!commandArguments.isEmpty()) break;
                if (context.getShellType() == ShellType.POWERSHELL || isAutoPopup) {
                    return CollectionsKt.emptyList();
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)tokens);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)context);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)runtimeContext);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)completion);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)commandExecutable);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable(commandArguments);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)fileProducer);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)specCompletionFunction);
                $continuation.Z$0 = isAutoPopup;
                $continuation.label = 1;
                v0 = fileProducer.invoke((Object)$continuation);
                if (v0 == var23_7) {
                    return var23_7;
                }
                ** GOTO lbl49
            }
            case 1: {
                isAutoPopup = $continuation.Z$0;
                specCompletionFunction = (Function2)$continuation.L$7;
                fileProducer = (Function1)$continuation.L$6;
                commandArguments = (List<String>)$continuation.L$5;
                commandExecutable = (String)$continuation.L$4;
                completion = (ShellCommandSpecCompletion)$continuation.L$3;
                runtimeContext = (ShellRuntimeContext)$continuation.L$2;
                context = (TerminalCompletionContext)$continuation.L$1;
                tokens = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl49:
                // 2 sources

                suggestions = (List)v0;
                $this$filter$iv = suggestions;
                $i$f$filter = false;
                var14_23 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ShellCompletionSuggestion)element$iv$iv;
                    $i$a$-filter-TerminalCommandSpecCompletionContributorGen2$computeSuggestions$2 = false;
                    if (!(it.isHidden() == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)tokens);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)context);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)runtimeContext);
        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)completion);
        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)commandExecutable);
        $continuation.L$5 = SpillingKt.nullOutSpilledVariable(commandArguments);
        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)fileProducer);
        $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)specCompletionFunction);
        $continuation.Z$0 = isAutoPopup;
        $continuation.label = 2;
        v1 = this.computeSuggestionsIfHasArguments(commandExecutable, context, (Function1<? super Continuation<? super List<? extends ShellCompletionSuggestion>>, ? extends Object>)fileProducer, (Function2<? super String, ? super Continuation<? super List<? extends ShellCompletionSuggestion>>, ? extends Object>)specCompletionFunction, (Continuation<? super List<? extends ShellCompletionSuggestion>>)$continuation);
        if (v1 == var23_7) {
            return var23_7;
        }
        ** GOTO lbl89
        {
            case 2: {
                isAutoPopup = $continuation.Z$0;
                specCompletionFunction = (Function2)$continuation.L$7;
                fileProducer = (Function1)$continuation.L$6;
                commandArguments = (List)$continuation.L$5;
                commandExecutable = (String)$continuation.L$4;
                completion = (ShellCommandSpecCompletion)$continuation.L$3;
                runtimeContext = (ShellRuntimeContext)$continuation.L$2;
                context = (TerminalCompletionContext)$continuation.L$1;
                tokens = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl89:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object computeSuggestionsIfHasArguments(String commandExecutable, TerminalCompletionContext context, Function1<? super Continuation<? super List<? extends ShellCompletionSuggestion>>, ? extends Object> fileProducer, Function2<? super String, ? super Continuation<? super List<? extends ShellCompletionSuggestion>>, ? extends Object> specCompletionFunction, Continuation<? super List<? extends ShellCompletionSuggestion>> $completion) {
        block15: {
            if (!($completion instanceof computeSuggestionsIfHasArguments.1)) ** GOTO lbl-1000
            var18_6 = $completion;
            if ((var18_6.label & -2147483648) != 0) {
                var18_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ TerminalCommandSpecCompletionContributorGen2 this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return TerminalCommandSpecCompletionContributorGen2.access$computeSuggestionsIfHasArguments(this.this$0, null, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var19_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    commandVariants = this.getCommandNameVariants(commandExecutable);
                    var10_10 = ((Iterable)commandVariants).iterator();
lbl14:
                    // 2 sources

                    while (var10_10.hasNext()) {
                        it = (String)var10_10.next();
                        $i$a$-firstNotNullOfOrNull-TerminalCommandSpecCompletionContributorGen2$computeSuggestionsIfHasArguments$items$1 = 0;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)commandExecutable);
                        $continuation.L$1 = context;
                        $continuation.L$2 = fileProducer;
                        $continuation.L$3 = specCompletionFunction;
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)commandVariants);
                        $continuation.L$5 = var10_10;
                        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)it);
                        $continuation.I$0 = $i$a$-firstNotNullOfOrNull-TerminalCommandSpecCompletionContributorGen2$computeSuggestionsIfHasArguments$items$1;
                        $continuation.label = 1;
                        v0 = specCompletionFunction.invoke(it, (Object)$continuation);
                        if (v0 == var19_8) {
                            return var19_8;
                        }
                        ** GOTO lbl42
                    }
                    break;
                }
                case 1: {
                    $i$a$-firstNotNullOfOrNull-TerminalCommandSpecCompletionContributorGen2$computeSuggestionsIfHasArguments$items$1 = $continuation.I$0;
                    it = (String)$continuation.L$6;
                    var10_10 = (Iterator)$continuation.L$5;
                    commandVariants = (List)$continuation.L$4;
                    specCompletionFunction = (Function2)$continuation.L$3;
                    fileProducer = (Function1)$continuation.L$2;
                    context = (TerminalCompletionContext)$continuation.L$1;
                    commandExecutable = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl42:
                    // 2 sources

                    if ((it = (List)v0) == null) ** GOTO lbl14
                    v1 = it;
                    break block15;
                }
            }
            v1 = v2 = null;
        }
        if (v1 == null) {
            v2 = CollectionsKt.emptyList();
        }
        if (((Collection)(items = v2)).isEmpty() == false) {
            return items;
        }
        if (context.getParameters().isAutoPopup()) {
            return CollectionsKt.emptyList();
        }
        if (context.getShellType() == ShellType.POWERSHELL) {
            return CollectionsKt.emptyList();
        }
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)commandExecutable);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)context);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)fileProducer);
        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)specCompletionFunction);
        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)commandVariants);
        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)items);
        $continuation.L$6 = null;
        $continuation.label = 2;
        v3 = fileProducer.invoke((Object)$continuation);
        if (v3 == var19_8) {
            return var19_8;
        }
        ** GOTO lbl76
        {
            case 2: {
                items = (List)$continuation.L$5;
                commandVariants = (List)$continuation.L$4;
                specCompletionFunction = (Function2)$continuation.L$3;
                fileProducer = (Function1)$continuation.L$2;
                context = (TerminalCompletionContext)$continuation.L$1;
                commandExecutable = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl76:
                // 2 sources

                $this$filter$iv = (Iterable)v3;
                $i$f$filter = false;
                var10_10 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ShellCompletionSuggestion)element$iv$iv;
                    $i$a$-filter-TerminalCommandSpecCompletionContributorGen2$computeSuggestionsIfHasArguments$2 = false;
                    if (!(it.isHidden() == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final List<String> getCommandNameVariants(String commandExecutable) {
        Object[] objectArray = new String[]{commandExecutable};
        List result2 = CollectionsKt.mutableListOf((Object[])objectArray);
        if (StringsKt.endsWith$default((String)commandExecutable, (String)".exe", (boolean)false, (int)2, null)) {
            ((Collection)result2).add(StringsKt.removeSuffix((String)commandExecutable, (CharSequence)".exe"));
        }
        return result2;
    }

    private final List<String> expandAliases(TerminalCompletionContext context, List<String> tokens, TerminalAliasesStorage aliasesStorage) {
        if (tokens.size() < 2) {
            return tokens;
        }
        if (aliasesStorage != null) {
            List<String> expandedTokens = this.expandAliases(tokens, aliasesStorage.getAliasesInfo().getAliases(), context);
            return expandedTokens;
        }
        return tokens;
    }

    private final List<String> expandAliases(List<String> tokens, Map<String, String> aliases, TerminalCompletionContext context) {
        if (aliases.isEmpty() || tokens.size() < 2) {
            return tokens;
        }
        List<String> completeTokens = tokens.subList(0, tokens.size() - 1);
        StringBuilder command2 = new StringBuilder();
        boolean anyAliasFound = false;
        for (String token : completeTokens) {
            String string;
            String aliasedCommand = aliases.get(token);
            if (aliasedCommand != null) {
                anyAliasFound = true;
            }
            if ((string = aliasedCommand) == null) {
                string = token;
            }
            command2.append(string);
            command2.append(' ');
        }
        if (!anyAliasFound) {
            return tokens;
        }
        TerminalShellSupport terminalShellSupport = context.getShellSupport();
        Project project = context.getProject();
        String string = command2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        List<String> expandedTokens = terminalShellSupport.getCommandTokens(project, string);
        List<String> list = expandedTokens;
        if (list == null) {
            list = completeTokens;
        }
        return CollectionsKt.plus((Collection)list, (Object)CollectionsKt.last(tokens));
    }

    private final LookupElement toLookupElement(ShellCompletionSuggestion $this$toLookupElement, ShellType shellType) {
        String string;
        Icon icon = $this$toLookupElement.getIcon();
        if (icon == null) {
            icon = TerminalCompletionUtil.INSTANCE.findIconForSuggestion($this$toLookupElement.getName(), $this$toLookupElement.getType());
        }
        Icon actualIcon = icon;
        String string2 = $this$toLookupElement.getInsertValue();
        String realInsertValue = string2 != null ? StringsKt.replace$default((String)string2, (String)"{cursor}", (String)"", (boolean)false, (int)4, null) : null;
        String it = string = TerminalCompletionUtil.INSTANCE.getNextSuggestionsString($this$toLookupElement);
        boolean bl = false;
        String nextSuggestions = ((CharSequence)it).length() > 0 ? string : null;
        String string3 = realInsertValue;
        if (string3 == null) {
            string3 = $this$toLookupElement.getName();
        }
        String string4 = StringUtil.escapeChar((String)string3, (char)' ');
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"escapeChar(...)");
        String escapedInsertValue = string4;
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)$this$toLookupElement, (String)escapedInsertValue);
        String string5 = $this$toLookupElement.getDisplayName();
        if (string5 == null) {
            string5 = $this$toLookupElement.getName();
        }
        LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder.withPresentableText(string5).withTailText(nextSuggestions, true).withIcon((Icon)new TerminalStatefulDelegatingIcon(actualIcon));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder2, (String)"withIcon(...)");
        LookupElementBuilder element = lookupElementBuilder2;
        element.putUserData(CodeCompletionHandlerBase.DIRECT_INSERTION, (Object)true);
        int adjustedPriority = RangesKt.coerceIn((int)$this$toLookupElement.getPriority(), (int)0, (int)100);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)element), (double)((double)adjustedPriority / 100.0));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"withPriority(...)");
        return lookupElement;
    }

    public static final /* synthetic */ List access$expandAliases(TerminalCommandSpecCompletionContributorGen2 $this, TerminalCompletionContext context, List tokens, TerminalAliasesStorage aliasesStorage) {
        return $this.expandAliases(context, tokens, aliasesStorage);
    }

    public static final /* synthetic */ Object access$computeSuggestions(TerminalCommandSpecCompletionContributorGen2 $this, List tokens, TerminalCompletionContext context, boolean isAutoPopup, Continuation $completion) {
        return $this.computeSuggestions(tokens, context, isAutoPopup, (Continuation<? super List<? extends ShellCompletionSuggestion>>)$completion);
    }

    public static final /* synthetic */ Object access$computeSuggestionsIfHasArguments(TerminalCommandSpecCompletionContributorGen2 $this, String commandExecutable, TerminalCompletionContext context, Function1 fileProducer2, Function2 specCompletionFunction2, Continuation $completion) {
        return $this.computeSuggestionsIfHasArguments(commandExecutable, context, (Function1<? super Continuation<? super List<? extends ShellCompletionSuggestion>>, ? extends Object>)fileProducer2, (Function2<? super String, ? super Continuation<? super List<? extends ShellCompletionSuggestion>>, ? extends Object>)specCompletionFunction2, (Continuation<? super List<? extends ShellCompletionSuggestion>>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalCommandSpecCompletionContributorGen2$TerminalCompletionContext;", "", "commandSpecsManager", "Lcom/intellij/terminal/completion/ShellCommandSpecsManager;", "runtimeContextProvider", "Lcom/intellij/terminal/completion/ShellRuntimeContextProvider;", "generatorsExecutor", "Lcom/intellij/terminal/completion/ShellDataGeneratorsExecutor;", "shellSupport", "Lorg/jetbrains/plugins/terminal/exp/completion/TerminalShellSupport;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "shellType", "Lorg/jetbrains/plugins/terminal/util/ShellType;", "<init>", "(Lcom/intellij/terminal/completion/ShellCommandSpecsManager;Lcom/intellij/terminal/completion/ShellRuntimeContextProvider;Lcom/intellij/terminal/completion/ShellDataGeneratorsExecutor;Lorg/jetbrains/plugins/terminal/exp/completion/TerminalShellSupport;Lcom/intellij/codeInsight/completion/CompletionParameters;Lorg/jetbrains/plugins/terminal/util/ShellType;)V", "getCommandSpecsManager", "()Lcom/intellij/terminal/completion/ShellCommandSpecsManager;", "getRuntimeContextProvider", "()Lcom/intellij/terminal/completion/ShellRuntimeContextProvider;", "getGeneratorsExecutor", "()Lcom/intellij/terminal/completion/ShellDataGeneratorsExecutor;", "getShellSupport", "()Lorg/jetbrains/plugins/terminal/exp/completion/TerminalShellSupport;", "getParameters", "()Lcom/intellij/codeInsight/completion/CompletionParameters;", "getShellType", "()Lorg/jetbrains/plugins/terminal/util/ShellType;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "intellij.terminal.frontend"})
    private static final class TerminalCompletionContext {
        @NotNull
        private final ShellCommandSpecsManager commandSpecsManager;
        @NotNull
        private final ShellRuntimeContextProvider runtimeContextProvider;
        @NotNull
        private final ShellDataGeneratorsExecutor generatorsExecutor;
        @NotNull
        private final TerminalShellSupport shellSupport;
        @NotNull
        private final CompletionParameters parameters;
        @NotNull
        private final ShellType shellType;

        public TerminalCompletionContext(@NotNull ShellCommandSpecsManager commandSpecsManager, @NotNull ShellRuntimeContextProvider runtimeContextProvider, @NotNull ShellDataGeneratorsExecutor generatorsExecutor, @NotNull TerminalShellSupport shellSupport, @NotNull CompletionParameters parameters, @NotNull ShellType shellType) {
            Intrinsics.checkNotNullParameter((Object)commandSpecsManager, (String)"commandSpecsManager");
            Intrinsics.checkNotNullParameter((Object)runtimeContextProvider, (String)"runtimeContextProvider");
            Intrinsics.checkNotNullParameter((Object)generatorsExecutor, (String)"generatorsExecutor");
            Intrinsics.checkNotNullParameter((Object)shellSupport, (String)"shellSupport");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)((Object)shellType), (String)"shellType");
            this.commandSpecsManager = commandSpecsManager;
            this.runtimeContextProvider = runtimeContextProvider;
            this.generatorsExecutor = generatorsExecutor;
            this.shellSupport = shellSupport;
            this.parameters = parameters;
            this.shellType = shellType;
        }

        @NotNull
        public final ShellCommandSpecsManager getCommandSpecsManager() {
            return this.commandSpecsManager;
        }

        @NotNull
        public final ShellRuntimeContextProvider getRuntimeContextProvider() {
            return this.runtimeContextProvider;
        }

        @NotNull
        public final ShellDataGeneratorsExecutor getGeneratorsExecutor() {
            return this.generatorsExecutor;
        }

        @NotNull
        public final TerminalShellSupport getShellSupport() {
            return this.shellSupport;
        }

        @NotNull
        public final CompletionParameters getParameters() {
            return this.parameters;
        }

        @NotNull
        public final ShellType getShellType() {
            return this.shellType;
        }

        @NotNull
        public final Project getProject() {
            Project project = this.parameters.getEditor().getProject();
            Intrinsics.checkNotNull((Object)project);
            return project;
        }
    }
}

