/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.patch.PatchNameChecker;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.project.ProjectKt;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u0010\u0018\u001a\u00020\tH\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u0013J\u0010\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0015J\u0006\u0010\u001f\u001a\u00020\tJ\u0006\u0010 \u001a\u00020\u0017J\u0006\u0010!\u001a\u00020\u0017J\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020&J\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020&J\u0006\u0010+\u001a\u00020&J\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020&J\u0006\u0010.\u001a\u00020&J\n\u0010/\u001a\u0004\u0018\u000100H\u0002J\n\u00101\u001a\u0004\u0018\u000100H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/CreatePatchConfigurationPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "fileNameField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "basePathField", "toClipboardRadioButton", "Ljavax/swing/JRadioButton;", "reverseCheckBox", "Ljavax/swing/JCheckBox;", "encodingComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Ljava/nio/charset/Charset;", "commonParentDir", "Ljava/io/File;", "selectFileName", "", "createPanel", "selectBasePath", "", "baseDir", "getEncoding", "setCommonParentPath", "commonParentPath", "getPanel", "getFileName", "getBaseDirName", "setFileName", "file", "Ljava/nio/file/Path;", "isReversePatch", "", "setReversePatch", "reverse", "setReverseEnabledAndVisible", "isAvailable", "isToClipboard", "setToClipboard", "toClipboard", "isOkToExecute", "validateFileName", "Lcom/intellij/openapi/ui/ValidationInfo;", "validateBaseDirPath", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCreatePatchConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreatePatchConfigurationPanel.kt\ncom/intellij/openapi/vcs/changes/patch/CreatePatchConfigurationPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n2746#2,3:187\n*S KotlinDebug\n*F\n+ 1 CreatePatchConfigurationPanel.kt\ncom/intellij/openapi/vcs/changes/patch/CreatePatchConfigurationPanel\n*L\n150#1:187,3\n*E\n"})
public final class CreatePatchConfigurationPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final DialogPanel panel;
    @NotNull
    private final TextFieldWithBrowseButton fileNameField;
    @NotNull
    private final TextFieldWithBrowseButton basePathField;
    private JRadioButton toClipboardRadioButton;
    private JCheckBox reverseCheckBox;
    private ComboBox<Charset> encodingComboBox;
    @Nullable
    private File commonParentDir;

    public CreatePatchConfigurationPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.fileNameField = new TextFieldWithBrowseButton();
        this.basePathField = new TextFieldWithBrowseButton();
        this.fileNameField.addActionListener(arg_0 -> CreatePatchConfigurationPanel._init_$lambda$0(this, arg_0));
        this.basePathField.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFolderDescriptor()));
        this.basePathField.setText(((Object)ProjectKt.getStateStore((Project)this.project).getProjectBasePath()).toString());
        this.panel = this.createPanel();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final String selectFileName() {
        String string;
        Path baseDir;
        FileSaverDescriptor descriptor = new FileSaverDescriptor(VcsBundle.message((String)"patch.creation.save.to.title", (Object[])new Object[0]), "");
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, (Component)this.fileNameField);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
        FileSaverDialog dialog = fileSaverDialog;
        String string2 = FileUtil.toSystemIndependentName((String)this.getFileName());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
        String path = string2;
        int index = StringsKt.lastIndexOf$default((CharSequence)path, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            v2 = ProjectKt.getStateStore((Project)this.project).getProjectBasePath();
        } else {
            String string3 = path.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            v2 = baseDir = Paths.get(string3, new String[0]);
        }
        if (index == -1) {
            string = path;
        } else {
            String string4 = path.substring(index + 1);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        }
        String name = string;
        VirtualFileWrapper virtualFileWrapper = dialog.save(baseDir, name);
        if (virtualFileWrapper == null) {
            return null;
        }
        VirtualFileWrapper fileWrapper = virtualFileWrapper;
        return fileWrapper.getFile().getPath();
    }

    private final DialogPanel createPanel() {
        return BuilderKt.panel(arg_0 -> CreatePatchConfigurationPanel.createPanel$lambda$0(this, arg_0));
    }

    public final void selectBasePath(@NotNull String baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        this.basePathField.setText(baseDir);
    }

    @NotNull
    public final Charset getEncoding() {
        ComboBox<Charset> comboBox = this.encodingComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"encodingComboBox");
            comboBox = null;
        }
        Object object = comboBox.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        return (Charset)object;
    }

    public final void setCommonParentPath(@Nullable File commonParentPath) {
        this.commonParentDir = commonParentPath != null && !commonParentPath.isDirectory() ? commonParentPath.getParentFile() : commonParentPath;
    }

    @NotNull
    public final DialogPanel getPanel() {
        return this.panel;
    }

    @NotNull
    public final String getFileName() {
        String string = this.fileNameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = OSAgnosticPathUtil.expandUserHome((String)((Object)StringsKt.trim((CharSequence)string)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"expandUserHome(...)");
        return string2;
    }

    @NotNull
    public final String getBaseDirName() {
        String string = this.basePathField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = OSAgnosticPathUtil.expandUserHome((String)((Object)StringsKt.trim((CharSequence)string)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"expandUserHome(...)");
        return string2;
    }

    public final void setFileName(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.fileNameField.setText(((Object)file).toString());
    }

    public final boolean isReversePatch() {
        JCheckBox jCheckBox = this.reverseCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reverseCheckBox");
            jCheckBox = null;
        }
        return jCheckBox.isSelected();
    }

    public final void setReversePatch(boolean reverse) {
        JCheckBox jCheckBox = this.reverseCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reverseCheckBox");
            jCheckBox = null;
        }
        jCheckBox.setSelected(reverse);
    }

    public final void setReverseEnabledAndVisible(boolean isAvailable) {
        JCheckBox jCheckBox = this.reverseCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reverseCheckBox");
            jCheckBox = null;
        }
        jCheckBox.setVisible(isAvailable);
        JCheckBox jCheckBox2 = this.reverseCheckBox;
        if (jCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reverseCheckBox");
            jCheckBox2 = null;
        }
        jCheckBox2.setEnabled(isAvailable);
    }

    public final boolean isToClipboard() {
        JRadioButton jRadioButton = this.toClipboardRadioButton;
        if (jRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toClipboardRadioButton");
            jRadioButton = null;
        }
        return jRadioButton.isSelected();
    }

    public final void setToClipboard(boolean toClipboard) {
        JRadioButton jRadioButton = this.toClipboardRadioButton;
        if (jRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toClipboardRadioButton");
            jRadioButton = null;
        }
        jRadioButton.setSelected(toClipboard);
    }

    public final boolean isOkToExecute() {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.panel.validateAll();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ValidationInfo it = (ValidationInfo)element$iv;
                    boolean bl2 = false;
                    if (!(!it.warning)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final ValidationInfo validateFileName() {
        String fileName = this.getFileName();
        String validateNameError = PatchNameChecker.validateName(fileName);
        if (validateNameError != null) {
            return new ValidationInfo(validateNameError, (JComponent)this.fileNameField);
        }
        if (new File(fileName).exists()) {
            Object[] objectArray = new Object[]{fileName};
            return new ValidationInfo(IdeBundle.message((String)"error.file.with.name.already.exists", (Object[])objectArray)).asWarning().withOKEnabled();
        }
        return null;
    }

    private final ValidationInfo validateBaseDirPath() {
        String baseDirName = this.getBaseDirName();
        if (StringsKt.isBlank((CharSequence)baseDirName)) {
            return new ValidationInfo(VcsBundle.message((String)"patch.creation.empty.base.path.error", (Object[])new Object[0]), (JComponent)this.basePathField);
        }
        File baseFile = new File(baseDirName);
        if (!baseFile.exists()) {
            return new ValidationInfo(VcsBundle.message((String)"patch.creation.base.dir.does.not.exist.error", (Object[])new Object[0]), (JComponent)this.basePathField);
        }
        File file = this.commonParentDir;
        if (file == null) {
            return null;
        }
        File commonParent = file;
        if (!FileUtil.isAncestor((File)baseFile, (File)commonParent, (boolean)false)) {
            Object[] objectArray = new Object[]{commonParent.getPath()};
            return new ValidationInfo(VcsBundle.message((String)"patch.creation.wrong.base.path.for.changes.error", (Object[])objectArray), (JComponent)this.basePathField);
        }
        return null;
    }

    private static final void _init_$lambda$0(CreatePatchConfigurationPanel this$0, ActionEvent it) {
        String fileName = this$0.selectFileName();
        if (fileName != null) {
            this$0.fileNameField.setText(fileName);
        }
    }

    private static final Unit createPanel$lambda$0(CreatePatchConfigurationPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, arg_0 -> CreatePatchConfigurationPanel.createPanel$lambda$0$0(this$0, arg_0), (int)3, null);
        String string = VcsBundle.message((String)"patch.creation.base.path.field", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> CreatePatchConfigurationPanel.createPanel$lambda$0$1(this$0, arg_0)).topGap(TopGap.SMALL);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CreatePatchConfigurationPanel.createPanel$lambda$0$2(this$0, arg_0), (int)1, null);
        String string2 = VcsBundle.message((String)"create.patch.encoding", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> CreatePatchConfigurationPanel.createPanel$lambda$0$3(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(CreatePatchConfigurationPanel this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> CreatePatchConfigurationPanel.createPanel$lambda$0$0$0(this$0, arg_0), (int)1, null).layout(RowLayout.LABEL_ALIGNED);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> CreatePatchConfigurationPanel.createPanel$lambda$0$0$1(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$0(CreatePatchConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"create.patch.file.path", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell toFileButton = Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null);
        ((JBRadioButton)toFileButton.getComponent()).setSelected(true);
        TextFieldWithBrowseButtonKt.columns((Cell)$this$row.cell((JComponent)this$0.fileNameField), (int)36).align((Align)AlignX.FILL.INSTANCE).enabledIf(ButtonKt.getSelected((Cell)toFileButton)).validationOnInput((arg_0, arg_1) -> CreatePatchConfigurationPanel.createPanel$lambda$0$0$0$0(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createPanel$lambda$0$0$0$0(CreatePatchConfigurationPanel this$0, ValidationInfoBuilder $this$validationOnInput, TextFieldWithBrowseButton it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validateFileName();
    }

    private static final Unit createPanel$lambda$0$0$1(CreatePatchConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"create.patch.to.clipboard", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.toClipboardRadioButton = (JRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(CreatePatchConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldWithBrowseButtonKt.columns((Cell)$this$row.cell((JComponent)this$0.basePathField), (int)36).align((Align)AlignX.FILL.INSTANCE).validationOnInput((arg_0, arg_1) -> CreatePatchConfigurationPanel.createPanel$lambda$0$1$0(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createPanel$lambda$0$1$0(CreatePatchConfigurationPanel this$0, ValidationInfoBuilder $this$validationOnInput, TextFieldWithBrowseButton it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validateBaseDirPath();
    }

    private static final Unit createPanel$lambda$0$2(CreatePatchConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"create.patch.reverse.checkbox", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.reverseCheckBox = (JCheckBox)$this$row.checkBox(string).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(CreatePatchConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.encodingComboBox = (ComboBox)Row.comboBox$default((Row)$this$row, (ComboBoxModel)new DefaultComboBoxModel<Charset>(CharsetToolkit.getAvailableCharsets()), null, (int)2, null).getComponent();
        ComboBox<Charset> comboBox = this$0.encodingComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"encodingComboBox");
            comboBox = null;
        }
        comboBox.setSelectedItem((Object)EncodingProjectManager.getInstance((Project)this$0.project).getDefaultCharset());
        return Unit.INSTANCE;
    }
}

