/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.completion;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionInitializationContextImpl;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.terminal.frontend.action.TerminalFrontendDataContextUtils;
import com.intellij.terminal.frontend.view.impl.TerminalViewImplKt;
import java.awt.event.InputEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ0\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionHandler;", "Lcom/intellij/codeInsight/completion/CodeCompletionHandlerBase;", "completionType", "Lcom/intellij/codeInsight/completion/CompletionType;", "invokedExplicitly", "", "autopopup", "synchronous", "<init>", "(Lcom/intellij/codeInsight/completion/CompletionType;ZZZ)V", "invokeCompletion", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "time", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "hasModifiers", "caret", "Lcom/intellij/openapi/editor/Caret;", "prepareCaret", "commonEditor", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "intellij.terminal.frontend"})
public final class TerminalCommandCompletionHandler
extends CodeCompletionHandlerBase {
    @NotNull
    private final CompletionType completionType;
    private final boolean invokedExplicitly;

    public TerminalCommandCompletionHandler(@NotNull CompletionType completionType, boolean invokedExplicitly, boolean autopopup, boolean synchronous) {
        Intrinsics.checkNotNullParameter((Object)completionType, (String)"completionType");
        super(completionType, invokedExplicitly, autopopup, synchronous);
        this.completionType = completionType;
        this.invokedExplicitly = invokedExplicitly;
    }

    public final void invokeCompletion(@NotNull AnActionEvent e, int time) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        TerminalOutputModel terminalOutputModel = TerminalFrontendDataContextUtils.INSTANCE.getTerminalOutputModel$intellij_terminal_frontend(e);
        if (terminalOutputModel == null) {
            throw new IllegalStateException("Output model is null during completion".toString());
        }
        TerminalOutputModel outputModel = terminalOutputModel;
        Editor editor = TerminalDataContextUtils.INSTANCE.getTerminalEditor(e);
        if (editor == null) {
            throw new IllegalStateException("Terminal editor is null during completion".toString());
        }
        Editor editor2 = editor;
        Project project = editor2.getProject();
        if (project == null) {
            throw new IllegalStateException("Project is null during completion".toString());
        }
        Project project2 = project;
        InputEvent inputEvent = e.getInputEvent();
        Caret caret = this.prepareCaret(editor2, outputModel);
        boolean hasModifiers = inputEvent != null && inputEvent.getModifiersEx() != 0;
        this.invokeCompletion(project2, editor2, time, hasModifiers, caret);
    }

    protected void invokeCompletion(@NotNull Project project, @NotNull Editor editor, int time, boolean hasModifiers, @NotNull Caret caret) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int time2 = time;
        CompletionPhase phase = CompletionServiceImpl.Companion.getCompletionPhase();
        CompletionProgressIndicator completionProgressIndicator = phase.indicator;
        boolean repeated = completionProgressIndicator != null ? completionProgressIndicator.isRepeatedInvocation(this.completionType, editor) : false;
        int newTime = phase.newCompletionStarted(time2, repeated);
        if (this.invokedExplicitly) {
            time2 = newTime;
        }
        int invocationCount = time2;
        Class[] classArray = new Class[]{CompletionPhase.InsertedSingleItem.class};
        if (CompletionServiceImpl.Companion.isPhase(classArray)) {
            CompletionServiceImpl.Companion.setCompletionPhase(CompletionPhase.NoCompletion);
        }
        classArray = new Class[]{CompletionPhase.NoCompletion.getClass(), CompletionPhase.CommittingDocuments.class};
        CompletionServiceImpl.Companion.assertPhase(classArray);
        long startingTime = System.currentTimeMillis();
        Runnable initCmd = () -> TerminalCommandCompletionHandler.invokeCompletion$lambda$0(project, editor, this, invocationCount, hasModifiers, startingTime);
        try {
            CommandProcessor.getInstance().executeCommand(project, initCmd, null, null, editor.getDocument());
        }
        catch (IndexNotReadyException e) {
            DumbService dumbService = DumbService.Companion.getInstance(project);
            String string = CodeInsightBundle.message((String)"completion.not.available.during.indexing", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            dumbService.showDumbModeNotificationForFunctionality(string, DumbModeBlockedFunctionality.CodeCompletion);
            throw e;
        }
    }

    private final Caret prepareCaret(Editor commonEditor, TerminalOutputModel outputModel) {
        CaretModel caretModel = commonEditor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caret = caretModel;
        Caret caret2 = caret.getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret2, (String)"getPrimaryCaret(...)");
        Caret primaryCaret = caret2;
        primaryCaret.moveToOffset(TerminalViewImplKt.toRelative(outputModel.getCursorOffset(), outputModel));
        CodeCompletionHandlerBase.clearCaretMarkers((Editor)commonEditor);
        CodeCompletionHandlerBase.markCaretAsProcessed((Caret)primaryCaret);
        return primaryCaret;
    }

    private static final void invokeCompletion$lambda$0(Project $project, Editor $editor, TerminalCommandCompletionHandler this$0, int $invocationCount, boolean $hasModifiers, long $startingTime) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)$project).getPsiFile($editor.getDocument());
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file = psiFile;
        CompletionInitializationContextImpl context = new CompletionInitializationContextImpl($editor, $editor.getCaretModel().getCurrentCaret(), file, this$0.completionType, $invocationCount);
        context.setDummyIdentifier("");
        this$0.doComplete(context, $hasModifiers, true, $startingTime);
    }
}

