/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.completion;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.frontend.view.completion.TerminalLookupManagerListenerKt;
import com.intellij.terminal.frontend.view.completion.TerminalStatefulDelegatingIcon;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\tH\u0002J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalSelectedItemIconUpdater;", "Lcom/intellij/codeInsight/lookup/impl/PrefixChangeListener;", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "<init>", "(Lcom/intellij/codeInsight/lookup/Lookup;)V", "curSelectedItem", "Lcom/intellij/codeInsight/lookup/LookupElement;", "afterAppend", "", "c", "", "afterTruncate", "updateSelectedItemIcon", "resetSelectedItemIcon", "getTerminalIcon", "Lcom/intellij/terminal/frontend/view/completion/TerminalStatefulDelegatingIcon;", "Companion", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalLookupManagerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalLookupManagerListener.kt\ncom/intellij/terminal/frontend/view/completion/TerminalSelectedItemIconUpdater\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,203:1\n13#2:204\n*S KotlinDebug\n*F\n+ 1 TerminalLookupManagerListener.kt\ncom/intellij/terminal/frontend/view/completion/TerminalSelectedItemIconUpdater\n*L\n164#1:204\n*E\n"})
final class TerminalSelectedItemIconUpdater
implements PrefixChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lookup lookup;
    @Nullable
    private LookupElement curSelectedItem;
    @NotNull
    private static final Logger LOG;

    public TerminalSelectedItemIconUpdater(@NotNull Lookup lookup) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        this.lookup = lookup;
    }

    public void afterAppend(char c) {
        this.updateSelectedItemIcon();
    }

    public void afterTruncate() {
        this.updateSelectedItemIcon();
    }

    private final void updateSelectedItemIcon() {
        LookupElement lookupElement = this.lookup.getCurrentItem();
        if (lookupElement == null) {
            TerminalSelectedItemIconUpdater $this$updateSelectedItemIcon_u24lambda_u240 = this;
            boolean bl = false;
            $this$updateSelectedItemIcon_u24lambda_u240.resetSelectedItemIcon();
            return;
        }
        LookupElement selectedItem = lookupElement;
        String string = this.lookup.itemPattern(selectedItem);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemPattern(...)");
        String typedPrefix = string;
        String string2 = selectedItem.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLookupString(...)");
        if (TerminalLookupManagerListenerKt.canExecuteWithChosenItem(string2, typedPrefix)) {
            TerminalStatefulDelegatingIcon terminalStatefulDelegatingIcon = this.getTerminalIcon(selectedItem);
            if (terminalStatefulDelegatingIcon != null) {
                Icon icon = AllIcons.Actions.Execute;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Execute");
                terminalStatefulDelegatingIcon.forceIcon(icon);
            }
            this.curSelectedItem = selectedItem;
        } else {
            this.resetSelectedItemIcon();
        }
    }

    private final void resetSelectedItemIcon() {
        Object object = this.curSelectedItem;
        if (object != null && (object = this.getTerminalIcon((LookupElement)object)) != null) {
            ((TerminalStatefulDelegatingIcon)object).useDefaultIcon();
        }
        this.curSelectedItem = null;
    }

    private final TerminalStatefulDelegatingIcon getTerminalIcon(LookupElement $this$getTerminalIcon) {
        TerminalStatefulDelegatingIcon terminalStatefulDelegatingIcon;
        LookupElementPresentation presentation = new LookupElementPresentation();
        $this$getTerminalIcon.renderElement(presentation);
        Icon icon = presentation.getIcon();
        if (!(icon instanceof TerminalStatefulDelegatingIcon)) {
            Object object = icon;
            LOG.warn("Unexpected icon type: " + (object != null && (object = object.getClass()) != null ? ((Class)object).getName() : null) + ". All elements in terminal lookup should use TerminalStatefulDelegatingIcon");
            terminalStatefulDelegatingIcon = null;
        } else {
            terminalStatefulDelegatingIcon = (TerminalStatefulDelegatingIcon)icon;
        }
        return terminalStatefulDelegatingIcon;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalSelectedItemIconUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalSelectedItemIconUpdater$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

