/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.CharacterSequences;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.CharacterGrid;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.terminal.TerminalUiSettingsManager;
import com.intellij.terminal.frontend.view.impl.TerminalCursorPainter;
import com.intellij.terminal.frontend.view.impl.TerminalCursorPainterListener;
import com.intellij.terminal.frontend.view.impl.TerminalViewImplKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.terminal.CursorShape;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.session.impl.TerminalState;
import org.jetbrains.plugins.terminal.view.TerminalCursorOffsetChangeEvent;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;
import org.jetbrains.plugins.terminal.view.TerminalOutputModelListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 -2\u00020\u0001:\t%&'()*+,-B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eJ\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0012H\u0003J\u0016\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0012H\u0083@\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0082@\u00a2\u0006\u0002\u0010!J\u001e\u0010\"\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0082@\u00a2\u0006\u0002\u0010!J\b\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter;", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Lkotlinx/coroutines/CoroutineScope;)V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainterListener;", "cursorPaintingJob", "Lkotlinx/coroutines/Job;", "curCursorState", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorState;", "addListener", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "updateCursor", "state", "paintCursor", "(Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "paintBlinkingCursor", "renderer", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorRenderer;", "offset", "Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "(Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorRenderer;Lorg/jetbrains/plugins/terminal/view/TerminalOffset;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "paintStaticCursor", "getDefaultCursorShape", "Lcom/jediterm/terminal/CursorShape;", "CursorState", "CursorRenderer", "CursorRendererBase", "BlockCursorRenderer", "EmptyBlockCursorRenderer", "LineCursorRenderer", "UnderlineCursorRenderer", "VerticalBarCursorRenderer", "Companion", "intellij.terminal.frontend"})
public final class TerminalCursorPainter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CopyOnWriteArrayList<TerminalCursorPainterListener> listeners;
    @Nullable
    private Job cursorPaintingJob;
    @NotNull
    private CursorState curCursorState;

    private TerminalCursorPainter(EditorEx editor, TerminalOutputModel outputModel, TerminalSessionModel sessionModel, CoroutineScope coroutineScope) {
        this.editor = editor;
        this.outputModel = outputModel;
        this.sessionModel = sessionModel;
        this.coroutineScope = coroutineScope;
        this.listeners = new CopyOnWriteArrayList();
        this.curCursorState = new CursorState(this.outputModel.getCursorOffset(), this.editor.getContentComponent().hasFocus(), ((TerminalState)this.sessionModel.getTerminalState().getValue()).isCursorVisible(), ((TerminalState)this.sessionModel.getTerminalState().getValue()).getCursorShape());
        this.updateCursor(this.curCursorState);
        this.outputModel.addListener(CoroutineScopeKt.asDisposable((CoroutineScope)this.coroutineScope), new TerminalOutputModelListener(){

            @Override
            public void cursorOffsetChanged(TerminalCursorOffsetChangeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                curCursorState = CursorState.copy$default(curCursorState, event.getNewOffset(), false, false, null, 14, null);
                this.updateCursor(curCursorState);
            }
        });
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalCursorPainter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.sessionModel.getTerminalState().collect(new FlowCollector(){

                            public final Object emit(TerminalState state, Continuation<? super Unit> $completion) {
                                boolean stateChanged = false;
                                if (state.getCursorShape() != this$0.curCursorState.getCursorShape()) {
                                    this$0.curCursorState = CursorState.copy$default(this$0.curCursorState, null, false, false, state.getCursorShape(), 7, null);
                                    stateChanged = true;
                                }
                                if (state.isCursorVisible() != this$0.curCursorState.isCursorVisible()) {
                                    this$0.curCursorState = CursorState.copy$default(this$0.curCursorState, null, false, state.isCursorVisible(), null, 11, null);
                                    stateChanged = true;
                                }
                                if (stateChanged) {
                                    this$0.updateCursor(this$0.curCursorState);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.editor.addFocusListener(new FocusChangeListener(){

            public void focusGained(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                curCursorState = CursorState.copy$default(curCursorState, null, true, false, null, 13, null);
                this.updateCursor(curCursorState);
            }

            public void focusLost(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                curCursorState = CursorState.copy$default(curCursorState, null, false, false, null, 13, null);
                this.updateCursor(curCursorState);
            }
        }, CoroutineScopeKt.asDisposable((CoroutineScope)this.coroutineScope));
    }

    public final void addListener(@NotNull Disposable parentDisposable, @NotNull TerminalCursorPainterListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        TerminalUtil.addItem((List)this.listeners, listener2, parentDisposable);
    }

    @RequiresEdt
    private final void updateCursor(CursorState state) {
        Job job2 = this.cursorPaintingJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        this.cursorPaintingJob = BuildersKt.launch((CoroutineScope)this.coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, state, null){
            int label;
            final /* synthetic */ TerminalCursorPainter this$0;
            final /* synthetic */ CursorState $state;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TerminalCursorPainter.access$paintCursor(this.this$0, this.$state, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @RequiresEdt
    private final Object paintCursor(CursorState state, Continuation<? super Unit> $completion) {
        if (!state.isCursorVisible()) {
            return Unit.INSTANCE;
        }
        CursorShape cursorShape = state.getCursorShape();
        if (cursorShape == null) {
            cursorShape = this.getDefaultCursorShape();
        }
        CursorShape cursorShape2 = cursorShape;
        boolean shouldBlink = state.isFocused() && cursorShape2.isBlinking();
        CursorRendererBase renderer = switch (WhenMappings.$EnumSwitchMapping$0[cursorShape2.ordinal()]) {
            case 1, 2 -> {
                if (state.isFocused()) {
                    yield new BlockCursorRenderer(this.editor, this.outputModel, (List<? extends TerminalCursorPainterListener>)this.listeners);
                }
                yield new EmptyBlockCursorRenderer(this.editor, this.outputModel, (List<? extends TerminalCursorPainterListener>)this.listeners);
            }
            case 3, 4 -> new UnderlineCursorRenderer(this.editor, this.outputModel, (List<? extends TerminalCursorPainterListener>)this.listeners);
            case 5, 6 -> new VerticalBarCursorRenderer(this.editor, this.outputModel, (List<? extends TerminalCursorPainterListener>)this.listeners);
            default -> throw new NoWhenBranchMatchedException();
        };
        TerminalOffset documentOffset = state.getOffset();
        if (shouldBlink) {
            Object object = this.paintBlinkingCursor(renderer, documentOffset, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = this.paintStaticCursor(renderer, documentOffset, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object paintBlinkingCursor(CursorRenderer renderer, TerminalOffset offset, Continuation<? super Unit> $completion) {
        if (!($completion instanceof paintBlinkingCursor.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                long J$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalCursorPainter this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalCursorPainter.access$paintBlinkingCursor(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                highlighter = renderer.installCursorHighlighter(offset);
                try {
                    blinkingPeriod = this.editor.getSettings().getCaretBlinkPeriod();
                    shouldPaint = 0;
                }
                catch (Throwable var5_9) {
                    v0 = highlighter;
                    if (v0 == null) throw var5_9;
                    v0.dispose();
                    throw var5_9;
                }
lbl24:
                // 2 sources

                while (true) {
                    $continuation.L$0 = renderer;
                    $continuation.L$1 = offset;
                    $continuation.L$2 = highlighter;
                    $continuation.J$0 = blinkingPeriod;
                    $continuation.I$0 = shouldPaint;
                    $continuation.label = 1;
                    v1 = DelayKt.delay((long)blinkingPeriod, (Continuation)$continuation);
                    if (v1 == var10_6) {
                        return var10_6;
                    }
                    ** GOTO lbl44
                    break;
                }
            }
            case 1: {
                shouldPaint = $continuation.I$0;
                blinkingPeriod = $continuation.J$0;
                highlighter = (RangeHighlighter)$continuation.L$2;
                offset = (TerminalOffset)$continuation.L$1;
                renderer = (CursorRenderer)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl44:
                    // 2 sources

                    if (shouldPaint != 0) {
                        highlighter = renderer.installCursorHighlighter(offset);
                    } else {
                        v2 = highlighter;
                        if (v2 != null) {
                            v2.dispose();
                        }
                        highlighter = null;
                    }
                    shouldPaint = shouldPaint == 0 ? 1 : 0;
                    ** continue;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object paintStaticCursor(CursorRenderer renderer, TerminalOffset offset, Continuation<? super Unit> $completion) {
        if (!($completion instanceof paintStaticCursor.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalCursorPainter this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalCursorPainter.access$paintStaticCursor(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                highlighter = renderer.installCursorHighlighter(offset);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)renderer);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)offset);
                $continuation.L$2 = highlighter;
                $continuation.label = 1;
                v0 = DelayKt.awaitCancellation((Continuation)$continuation);
                ** if (v0 != var8_6) goto lbl22
lbl21:
                // 1 sources

                return var8_6;
lbl22:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                highlighter = (RangeHighlighter)$continuation.L$2;
                offset = (TerminalOffset)$continuation.L$1;
                renderer = (CursorRenderer)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl31:
                    // 2 sources

                    throw new KotlinNothingValueException();
                }
                catch (Throwable var5_8) {
                    highlighter.dispose();
                    throw var5_8;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final CursorShape getDefaultCursorShape() {
        EditorSettings editorSettings = this.editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
        EditorSettings editorSettings2 = editorSettings;
        TerminalUiSettingsManager.CursorShape shapeFromSettings = TerminalOptionsProvider.Companion.getInstance().getCursorShape();
        switch (WhenMappings.$EnumSwitchMapping$1[shapeFromSettings.ordinal()]) {
            case 1: {
                return editorSettings2.isBlinkCaret() ? CursorShape.BLINK_BLOCK : CursorShape.STEADY_BLOCK;
            }
            case 2: {
                return editorSettings2.isBlinkCaret() ? CursorShape.BLINK_UNDERLINE : CursorShape.STEADY_UNDERLINE;
            }
        }
        return editorSettings2.isBlinkCaret() ? CursorShape.BLINK_VERTICAL_BAR : CursorShape.STEADY_VERTICAL_BAR;
    }

    public static final /* synthetic */ Object access$paintCursor(TerminalCursorPainter $this, CursorState state, Continuation $completion) {
        return $this.paintCursor(state, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$paintBlinkingCursor(TerminalCursorPainter $this, CursorRenderer renderer, TerminalOffset offset, Continuation $completion) {
        return $this.paintBlinkingCursor(renderer, offset, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$paintStaticCursor(TerminalCursorPainter $this, CursorRenderer renderer, TerminalOffset offset, Continuation $completion) {
        return $this.paintStaticCursor(renderer, offset, (Continuation<? super Unit>)$completion);
    }

    public /* synthetic */ TerminalCursorPainter(EditorEx editor, TerminalOutputModel outputModel, TerminalSessionModel sessionModel, CoroutineScope coroutineScope, DefaultConstructorMarker $constructor_marker) {
        this(editor, outputModel, sessionModel, coroutineScope);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$BlockCursorRenderer;", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorRendererBase;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "listeners", "", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainterListener;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Ljava/util/List;)V", "inverseForeground", "", "getInverseForeground", "()Z", "paintCursor", "", "g", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/geom/Rectangle2D$Double;", "color", "Ljava/awt/Color;", "intellij.terminal.frontend"})
    @SourceDebugExtension(value={"SMAP\nTerminalCursorPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$BlockCursorRenderer\n+ 2 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorRendererBase\n*L\n1#1,332:1\n211#2,9:333\n*S KotlinDebug\n*F\n+ 1 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$BlockCursorRenderer\n*L\n269#1:333,9\n*E\n"})
    private static final class BlockCursorRenderer
    extends CursorRendererBase {
        private final boolean inverseForeground;

        public BlockCursorRenderer(@NotNull EditorEx editor, @NotNull TerminalOutputModel outputModel, @NotNull List<? extends TerminalCursorPainterListener> listeners) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
            Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
            super(editor, outputModel, listeners, null);
            this.inverseForeground = true;
        }

        @Override
        public boolean getInverseForeground() {
            return this.inverseForeground;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void paintCursor(@NotNull Graphics2D g, @NotNull Rectangle2D.Double rect, @NotNull Color color) {
            void $this$withColor$iv;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            CursorRendererBase cursorRendererBase = this;
            Graphics2D graphics2D = g;
            Color color$iv = color;
            boolean $i$f$withColor = false;
            Color oldColor$iv = color$iv;
            try {
                $this$withColor$iv.setColor(color$iv);
                boolean bl = false;
                g.fill(rect);
            }
            finally {
                $this$withColor$iv.setColor(oldColor$iv);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$Companion;", "", "<init>", "()V", "install", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        @NotNull
        public final TerminalCursorPainter install(@NotNull EditorEx editor, @NotNull TerminalOutputModel outputModel, @NotNull TerminalSessionModel sessionModel, @NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
            Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            return new TerminalCursorPainter(editor, outputModel, sessionModel, coroutineScope, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'\u0082\u0001\u0001\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorRenderer;", "", "installCursorHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "offset", "Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorRendererBase;", "intellij.terminal.frontend"})
    private static sealed interface CursorRenderer
    permits CursorRendererBase {
        @RequiresEdt
        @NotNull
        public RangeHighlighter installCursorHighlighter(@NotNull TerminalOffset var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B'\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H&J&\u0010\u0019\u001a\u00020\u0012*\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001bH\u0084\b\u00f8\u0001\u0000J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0003\"#$\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006%"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorRendererBase;", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorRenderer;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "listeners", "", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainterListener;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Ljava/util/List;)V", "grid", "Lcom/intellij/openapi/editor/impl/view/CharacterGrid;", "inverseForeground", "", "getInverseForeground", "()Z", "paintCursor", "", "g", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/geom/Rectangle2D$Double;", "color", "Ljava/awt/Color;", "withColor", "block", "Lkotlin/Function0;", "installCursorHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "offset", "Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "getCursorTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$BlockCursorRenderer;", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$EmptyBlockCursorRenderer;", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$LineCursorRenderer;", "intellij.terminal.frontend"})
    @SourceDebugExtension(value={"SMAP\nTerminalCursorPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorRendererBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,332:1\n1#2:333\n*E\n"})
    private static abstract sealed class CursorRendererBase
    implements CursorRenderer
    permits BlockCursorRenderer, EmptyBlockCursorRenderer, LineCursorRenderer {
        @NotNull
        private final EditorEx editor;
        @NotNull
        private final TerminalOutputModel outputModel;
        @NotNull
        private final List<TerminalCursorPainterListener> listeners;
        @NotNull
        private final CharacterGrid grid;
        private final boolean inverseForeground;

        private CursorRendererBase(EditorEx editor, TerminalOutputModel outputModel, List<? extends TerminalCursorPainterListener> listeners) {
            this.editor = editor;
            this.outputModel = outputModel;
            this.listeners = listeners;
            EditorEx editorEx = this.editor;
            EditorImpl editorImpl = editorEx instanceof EditorImpl ? (EditorImpl)editorEx : null;
            Object object = editorImpl != null ? editorImpl.getCharacterGrid() : null;
            if (object == null) {
                CursorRendererBase cursorRendererBase = this;
                boolean bl = false;
                CursorRendererBase cursorRendererBase2 = cursorRendererBase;
                String string = "The editor is not in the grid mode";
                throw new IllegalArgumentException(string.toString());
            }
            this.grid = object;
        }

        public boolean getInverseForeground() {
            return this.inverseForeground;
        }

        public abstract void paintCursor(@NotNull Graphics2D var1, @NotNull Rectangle2D.Double var2, @NotNull Color var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void withColor(@NotNull Graphics2D $this$withColor, @NotNull Color color, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$withColor, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$withColor = false;
            Color oldColor = color;
            try {
                $this$withColor.setColor(color);
                block.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                $this$withColor.setColor(oldColor);
                InlineMarker.finallyEnd((int)1);
            }
        }

        @Override
        @NotNull
        public final RangeHighlighter installCursorHighlighter(@NotNull TerminalOffset offset) {
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            TextAttributes cursorAttributes = this.getCursorTextAttributes(offset);
            Color color = cursorAttributes.getForegroundColor();
            if (color == null) {
                Color color2 = this.editor.getColorsScheme().getDefaultForeground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultForeground(...)");
            }
            Color foregroundColor = color;
            Color color3 = cursorAttributes.getBackgroundColor();
            if (color3 == null) {
                Color color4 = this.editor.getColorsScheme().getDefaultBackground();
                color3 = color4;
                Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"getDefaultBackground(...)");
            }
            Color backgroundColor = color3;
            Color effectiveForeground = this.getInverseForeground() ? backgroundColor : foregroundColor;
            TextAttributes attributes = new TextAttributes(effectiveForeground, null, null, null, 0);
            int relativeOffset = TerminalViewImplKt.toRelative(offset, this.outputModel);
            int startOffset = RangesKt.coerceIn((int)relativeOffset, (ClosedRange)((ClosedRange)new IntRange(0, this.editor.getDocument().getTextLength())));
            int endOffset = RangesKt.coerceIn((int)(relativeOffset + 1), (ClosedRange)((ClosedRange)new IntRange(0, this.editor.getDocument().getTextLength())));
            RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 6000, attributes, HighlighterTargetArea.EXACT_RANGE);
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
            RangeHighlighter highlighter = rangeHighlighter;
            highlighter.setCustomRenderer((arg_0, arg_1, arg_2) -> CursorRendererBase.installCursorHighlighter$lambda$0(highlighter, this, foregroundColor, arg_0, arg_1, arg_2));
            return highlighter;
        }

        private final TextAttributes getCursorTextAttributes(TerminalOffset offset) {
            HighlightingInfo highlighting = this.outputModel.getHighlightingAt(offset);
            Object object = highlighting;
            if (object == null || (object = ((HighlightingInfo)object).getTextAttributesProvider()) == null || (object = object.getTextAttributes()) == null) {
                TextAttributes textAttributes = TextAttributes.ERASE_MARKER;
                object = textAttributes;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"ERASE_MARKER");
            }
            return object;
        }

        private static final void installCursorHighlighter$lambda$0(RangeHighlighter $highlighter, CursorRendererBase this$0, Color $foregroundColor, Editor editor, RangeHighlighter rangeHighlighter, Graphics g) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)rangeHighlighter, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            int offset = $highlighter.getStartOffset();
            Point2D point2D = this$0.editor.offsetToPoint2D(offset);
            Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"offsetToPoint2D(...)");
            Point2D point = point2D;
            CharSequence charSequence = this$0.editor.getDocument().getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
            CharSequence text = charSequence;
            int codePoint = (0 <= offset ? offset < text.length() : false) ? CharacterSequences.codePointAt((CharSequence)text, (int)offset) : 87;
            float cursorWidth = this$0.grid.codePointWidth(codePoint);
            int cursorHeight = this$0.editor.getLineHeight();
            Rectangle2D.Double rect = new Rectangle2D.Double(point.getX(), point.getY(), cursorWidth, cursorHeight);
            Graphics2D cfr_ignored_0 = (Graphics2D)g;
            this$0.paintCursor((Graphics2D)g, rect, $foregroundColor);
            for (TerminalCursorPainterListener listener2 : this$0.listeners) {
                listener2.cursorPainted();
            }
        }

        public /* synthetic */ CursorRendererBase(EditorEx editor, TerminalOutputModel outputModel, List listeners, DefaultConstructorMarker $constructor_marker) {
            this(editor, outputModel, listeners);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorState;", "", "offset", "Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "isFocused", "", "isCursorVisible", "cursorShape", "Lcom/jediterm/terminal/CursorShape;", "<init>", "(Lorg/jetbrains/plugins/terminal/view/TerminalOffset;ZZLcom/jediterm/terminal/CursorShape;)V", "getOffset", "()Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "()Z", "getCursorShape", "()Lcom/jediterm/terminal/CursorShape;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.terminal.frontend"})
    private static final class CursorState {
        @NotNull
        private final TerminalOffset offset;
        private final boolean isFocused;
        private final boolean isCursorVisible;
        @Nullable
        private final CursorShape cursorShape;

        public CursorState(@NotNull TerminalOffset offset, boolean isFocused, boolean isCursorVisible, @Nullable CursorShape cursorShape) {
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            this.offset = offset;
            this.isFocused = isFocused;
            this.isCursorVisible = isCursorVisible;
            this.cursorShape = cursorShape;
        }

        @NotNull
        public final TerminalOffset getOffset() {
            return this.offset;
        }

        public final boolean isFocused() {
            return this.isFocused;
        }

        public final boolean isCursorVisible() {
            return this.isCursorVisible;
        }

        @Nullable
        public final CursorShape getCursorShape() {
            return this.cursorShape;
        }

        @NotNull
        public final TerminalOffset component1() {
            return this.offset;
        }

        public final boolean component2() {
            return this.isFocused;
        }

        public final boolean component3() {
            return this.isCursorVisible;
        }

        @Nullable
        public final CursorShape component4() {
            return this.cursorShape;
        }

        @NotNull
        public final CursorState copy(@NotNull TerminalOffset offset, boolean isFocused, boolean isCursorVisible, @Nullable CursorShape cursorShape) {
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            return new CursorState(offset, isFocused, isCursorVisible, cursorShape);
        }

        public static /* synthetic */ CursorState copy$default(CursorState cursorState, TerminalOffset terminalOffset, boolean bl, boolean bl2, CursorShape cursorShape, int n, Object object) {
            if ((n & 1) != 0) {
                terminalOffset = cursorState.offset;
            }
            if ((n & 2) != 0) {
                bl = cursorState.isFocused;
            }
            if ((n & 4) != 0) {
                bl2 = cursorState.isCursorVisible;
            }
            if ((n & 8) != 0) {
                cursorShape = cursorState.cursorShape;
            }
            return cursorState.copy(terminalOffset, bl, bl2, cursorShape);
        }

        @NotNull
        public String toString() {
            return "CursorState(offset=" + this.offset + ", isFocused=" + this.isFocused + ", isCursorVisible=" + this.isCursorVisible + ", cursorShape=" + this.cursorShape + ")";
        }

        public int hashCode() {
            int result2 = this.offset.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isFocused);
            result2 = result2 * 31 + Boolean.hashCode(this.isCursorVisible);
            result2 = result2 * 31 + (this.cursorShape == null ? 0 : this.cursorShape.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CursorState)) {
                return false;
            }
            CursorState cursorState = (CursorState)other;
            if (!Intrinsics.areEqual((Object)this.offset, (Object)cursorState.offset)) {
                return false;
            }
            if (this.isFocused != cursorState.isFocused) {
                return false;
            }
            if (this.isCursorVisible != cursorState.isCursorVisible) {
                return false;
            }
            return this.cursorShape == cursorState.cursorShape;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$EmptyBlockCursorRenderer;", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorRendererBase;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "listeners", "", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainterListener;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Ljava/util/List;)V", "paintCursor", "", "g", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/geom/Rectangle2D$Double;", "color", "Ljava/awt/Color;", "intellij.terminal.frontend"})
    @SourceDebugExtension(value={"SMAP\nTerminalCursorPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$EmptyBlockCursorRenderer\n+ 2 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorRendererBase\n*L\n1#1,332:1\n211#2,9:333\n*S KotlinDebug\n*F\n+ 1 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$EmptyBlockCursorRenderer\n*L\n281#1:333,9\n*E\n"})
    private static final class EmptyBlockCursorRenderer
    extends CursorRendererBase {
        public EmptyBlockCursorRenderer(@NotNull EditorEx editor, @NotNull TerminalOutputModel outputModel, @NotNull List<? extends TerminalCursorPainterListener> listeners) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
            Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
            super(editor, outputModel, listeners, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void paintCursor(@NotNull Graphics2D g, @NotNull Rectangle2D.Double rect, @NotNull Color color) {
            void $this$withColor$iv;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            CursorRendererBase cursorRendererBase = this;
            Graphics2D graphics2D = g;
            Color color$iv = color;
            boolean $i$f$withColor = false;
            Color oldColor$iv = color$iv;
            try {
                $this$withColor$iv.setColor(color$iv);
                boolean bl = false;
                g.draw(rect);
            }
            finally {
                $this$withColor$iv.setColor(oldColor$iv);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H$J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u000b\u001a\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$LineCursorRenderer;", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorRendererBase;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "listeners", "", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainterListener;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Ljava/util/List;)V", "lineThickness", "", "getLineThickness", "()D", "shape", "Ljava/awt/geom/Rectangle2D$Double;", "rect", "paintCursor", "", "g", "Ljava/awt/Graphics2D;", "color", "Ljava/awt/Color;", "intellij.terminal.frontend"})
    @SourceDebugExtension(value={"SMAP\nTerminalCursorPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$LineCursorRenderer\n+ 2 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$CursorRendererBase\n*L\n1#1,332:1\n211#2,9:333\n*S KotlinDebug\n*F\n+ 1 TerminalCursorPainter.kt\ncom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$LineCursorRenderer\n*L\n297#1:333,9\n*E\n"})
    private static abstract non-sealed class LineCursorRenderer
    extends CursorRendererBase {
        public LineCursorRenderer(@NotNull EditorEx editor, @NotNull TerminalOutputModel outputModel, @NotNull List<? extends TerminalCursorPainterListener> listeners) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
            Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
            super(editor, outputModel, listeners, null);
        }

        protected final double getLineThickness() {
            return JBUIScale.scale((float)2.0f);
        }

        @NotNull
        protected abstract Rectangle2D.Double shape(@NotNull Rectangle2D.Double var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void paintCursor(@NotNull Graphics2D g, @NotNull Rectangle2D.Double rect, @NotNull Color color) {
            void $this$withColor$iv;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            CursorRendererBase cursorRendererBase = this;
            Graphics2D graphics2D = g;
            Color color$iv = color;
            boolean $i$f$withColor = false;
            Color oldColor$iv = color$iv;
            try {
                $this$withColor$iv.setColor(color$iv);
                boolean bl = false;
                g.fill(this.shape(rect));
            }
            finally {
                $this$withColor$iv.setColor(oldColor$iv);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$UnderlineCursorRenderer;", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$LineCursorRenderer;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "listeners", "", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainterListener;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Ljava/util/List;)V", "shape", "Ljava/awt/geom/Rectangle2D$Double;", "rect", "intellij.terminal.frontend"})
    private static final class UnderlineCursorRenderer
    extends LineCursorRenderer {
        public UnderlineCursorRenderer(@NotNull EditorEx editor, @NotNull TerminalOutputModel outputModel, @NotNull List<? extends TerminalCursorPainterListener> listeners) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
            Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
            super(editor, outputModel, listeners);
        }

        @Override
        @NotNull
        protected Rectangle2D.Double shape(@NotNull Rectangle2D.Double rect) {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            return new Rectangle2D.Double(rect.x, rect.y + rect.height - this.getLineThickness(), rect.width, this.getLineThickness());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$VerticalBarCursorRenderer;", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainter$LineCursorRenderer;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "listeners", "", "Lcom/intellij/terminal/frontend/view/impl/TerminalCursorPainterListener;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Ljava/util/List;)V", "shape", "Ljava/awt/geom/Rectangle2D$Double;", "rect", "intellij.terminal.frontend"})
    private static final class VerticalBarCursorRenderer
    extends LineCursorRenderer {
        public VerticalBarCursorRenderer(@NotNull EditorEx editor, @NotNull TerminalOutputModel outputModel, @NotNull List<? extends TerminalCursorPainterListener> listeners) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
            Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
            super(editor, outputModel, listeners);
        }

        @Override
        @NotNull
        protected Rectangle2D.Double shape(@NotNull Rectangle2D.Double rect) {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            return new Rectangle2D.Double(rect.x, rect.y, this.getLineThickness(), rect.height);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CursorShape.values().length];
            try {
                nArray[CursorShape.BLINK_BLOCK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorShape.STEADY_BLOCK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorShape.BLINK_UNDERLINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorShape.STEADY_UNDERLINE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorShape.BLINK_VERTICAL_BAR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorShape.STEADY_VERTICAL_BAR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TerminalUiSettingsManager.CursorShape.values().length];
            try {
                nArray[TerminalUiSettingsManager.CursorShape.BLOCK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalUiSettingsManager.CursorShape.UNDERLINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

