/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.ArrayTerminalDataStream;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.util.CharUtils;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class TtyBasedArrayDataStream
extends ArrayTerminalDataStream {
    private final TtyConnector myTtyConnector;
    @Nullable
    private final Runnable myOnBeforeBlockingWait;

    public TtyBasedArrayDataStream(TtyConnector ttyConnector, @Nullable Runnable onBeforeBlockingWait) {
        super(new char[1024], 0, 0);
        this.myTtyConnector = ttyConnector;
        this.myOnBeforeBlockingWait = onBeforeBlockingWait;
    }

    public TtyBasedArrayDataStream(TtyConnector ttyConnector) {
        super(new char[1024], 0, 0);
        this.myTtyConnector = ttyConnector;
        this.myOnBeforeBlockingWait = null;
    }

    private void fillBuf() throws IOException {
        this.myOffset = 0;
        if (!this.myTtyConnector.ready() && this.myOnBeforeBlockingWait != null) {
            this.myOnBeforeBlockingWait.run();
        }
        this.myLength = this.myTtyConnector.read(this.myBuf, this.myOffset, this.myBuf.length);
        if (this.myLength <= 0) {
            this.myLength = 0;
            throw new TerminalDataStream.EOF();
        }
    }

    @Override
    public char getChar() throws IOException {
        if (this.myLength == 0) {
            this.fillBuf();
        }
        return super.getChar();
    }

    @Override
    public String readNonControlCharacters(int maxChars) throws IOException {
        if (this.myLength == 0) {
            this.fillBuf();
        }
        return super.readNonControlCharacters(maxChars);
    }

    public String toString() {
        return CharUtils.toHumanReadableText(new String(this.myBuf, this.myOffset, this.myLength));
    }
}

