/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J/\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/maven/dom/inspections/MavenNoRootDefinedInspection;", "Lcom/intellij/util/xml/highlighting/BasicDomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "<init>", "()V", "getGroupDisplayName", "", "getDefaultLevel", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "fixAddMvnDirectoryInRootDir", "Lcom/intellij/codeInspection/LocalQuickFix;", "fixAddRootTag", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenNoRootDefinedInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenNoRootDefinedInspection.kt\norg/jetbrains/idea/maven/dom/inspections/MavenNoRootDefinedInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n669#2,11:98\n*S KotlinDebug\n*F\n+ 1 MavenNoRootDefinedInspection.kt\norg/jetbrains/idea/maven/dom/inspections/MavenNoRootDefinedInspection\n*L\n35#1:98,11\n*E\n"})
public final class MavenNoRootDefinedInspection
extends BasicDomElementsInspection<MavenDomProjectModel> {
    @NotNull
    private final LocalQuickFix fixAddMvnDirectoryInRootDir = new LocalQuickFix(){

        public String getName() {
            String string = MavenDomBundle.message("inspection.absence.dir.fix.create.dir", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public String getFamilyName() {
            String string = MavenDomBundle.message("inspection.absence.root.dir.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(Project project, ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            descriptor2.getPsiElement().getContainingFile().getContainingDirectory().createSubdirectory(".mvn");
        }
    };
    @NotNull
    private final LocalQuickFix fixAddRootTag = new LocalQuickFix(){

        public String getName() {
            String string = MavenDomBundle.message("inspection.absence.dir.fix.add.root", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public String getFamilyName() {
            String string = MavenDomBundle.message("inspection.absence.root.dir.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(Project project, ProblemDescriptor descriptor2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement = descriptor2.getPsiElement();
                XmlTag xmlTag = psiElement instanceof XmlTag ? (XmlTag)psiElement : null;
                if (xmlTag == null) break block0;
                xmlTag.setAttribute("root", "true");
            }
        }
    };

    public MavenNoRootDefinedInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.WARNING;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (file2 instanceof XmlFile && file2.isPhysical()) {
            Object v2;
            block12: {
                MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstanceIfCreated(((XmlFile)file2).getProject());
                if (mavenProjectsManager == null) {
                    return null;
                }
                MavenProjectsManager projectManager = mavenProjectsManager;
                List<MavenProject> list = projectManager.getRootProjects();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getRootProjects(...)");
                Iterable $this$singleOrNull$iv = list;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    MavenProject it = (MavenProject)element$iv;
                    boolean bl = false;
                    if (!((XmlFile)file2).getVirtualFile().equals((Object)it.getFile())) continue;
                    if (found$iv) {
                        v2 = null;
                        break block12;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            MavenProject mavenProject = v2;
            if (mavenProject == null) {
                return null;
            }
            MavenProject rootMavenProject = mavenProject;
            DomFileElement domFileElement = DomManager.getDomManager((Project)file2.getProject()).getFileElement((XmlFile)file2, MavenDomProjectModel.class);
            if (domFileElement == null) {
                return null;
            }
            DomFileElement model = domFileElement;
            MavenDomProjectModel mavenDomProjectModel = (MavenDomProjectModel)model.getRootElement();
            if (mavenDomProjectModel == null) {
                return null;
            }
            MavenDomProjectModel rootElement = mavenDomProjectModel;
            XmlTag xmlTag = model.getRootTag();
            if (xmlTag == null) {
                return null;
            }
            XmlTag rootTag = xmlTag;
            ProblemDescriptor[] problemDescriptorArray = rootMavenProject.getFile().getParent().toNioPath().resolve(".mvn");
            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"resolve(...)");
            ProblemDescriptor[] problemDescriptorArray2 = problemDescriptorArray;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory((Path)problemDescriptorArray2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return null;
            }
            if (Intrinsics.areEqual((Object)rootElement.getModelVersion().getStringValue(), (Object)"4.1.0")) {
                Object object = model.getRootTag();
                boolean bl = object != null && (object = object.getAttributeValue("root")) != null ? Boolean.parseBoolean((String)object) : false;
                if (bl) {
                    return null;
                }
            }
            if (Intrinsics.areEqual((Object)rootElement.getModelVersion().getStringValue(), (Object)"4.1.0")) {
                problemDescriptorArray2 = new ProblemDescriptor[1];
                linkOptionArray = new LocalQuickFix[]{this.fixAddRootTag, this.fixAddMvnDirectoryInRootDir};
                problemDescriptorArray2[0] = manager.createProblemDescriptor((PsiElement)rootTag, MavenDomBundle.message("inspection.absence.root.dir.description", new Object[0]), (LocalQuickFix[])linkOptionArray, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, false);
                return problemDescriptorArray2;
            }
            problemDescriptorArray2 = new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)rootTag, MavenDomBundle.message("inspection.absence.root.dir.description", new Object[0]), this.fixAddMvnDirectoryInRootDir, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
            return problemDescriptorArray2;
        }
        return null;
    }
}

