/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.dev.psiViewer.debug;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.memory.action.DebuggerTreeAction;
import com.intellij.dev.psiViewer.PsiViewerDialog;
import com.intellij.idea.AppMode;
import com.intellij.java.dev.JavaDevBundle;
import com.intellij.java.dev.psiViewer.debug.PsiDebuggerUtilKt;
import com.intellij.java.dev.psiViewer.debug.PsiViewerDebugAction;
import com.intellij.java.dev.psiViewer.debug.PsiViewerDebugActionKt;
import com.intellij.java.dev.psiViewer.debug.PsiViewerDebugPanel;
import com.intellij.java.dev.psiViewer.debug.PsiViewerDebugSettings;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeBackendOnlyActionBase;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J'\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\r\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J%\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugAction;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeBackendOnlyActionBase;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isEnabled", "", "value", "Lcom/intellij/xdebugger/frame/XValue;", "nodeName", "", "Lcom/intellij/openapi/util/NlsSafe;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "", "intellij.java.dev"})
public final class PsiViewerDebugAction
extends XDebuggerTreeBackendOnlyActionBase {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected boolean isEnabled(@NotNull XValue value, @Nullable String nodeName, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ObjectReference objectReference = DebuggerTreeAction.getObjectReference((XValue)value);
        ReferenceType refType = objectReference != null ? objectReference.referenceType() : null;
        return DebuggerUtils.instanceOf((Type)refType, (String)"com.intellij.psi.PsiElement");
    }

    protected void perform(@NotNull XValue value, @NotNull String nodeName, @NotNull AnActionEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            DebugProcessImpl debugProcess = JavaDebugProcess.getCurrentDebugProcess((AnActionEvent)e);
            XDebugSessionProxy debugSessionProxy = DebuggerUIUtil.getSessionProxy((AnActionEvent)e);
            DebugProcessImpl debugProcessImpl = debugProcess;
            SuspendContextImpl suspendContext = debugProcessImpl != null && (debugProcessImpl = debugProcessImpl.getSuspendManager()) != null ? debugProcessImpl.getPausedContext() : null;
            SuspendContextImpl suspendContextImpl = suspendContext;
            if (suspendContextImpl == null || (suspendContextImpl = suspendContextImpl.getManagerThread()) == null) break block1;
            suspendContextImpl.schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(suspendContext, value, debugProcess, project2, debugSessionProxy, nodeName){
                final /* synthetic */ XValue $value;
                final /* synthetic */ DebugProcessImpl $debugProcess;
                final /* synthetic */ Project $project;
                final /* synthetic */ XDebugSessionProxy $debugSessionProxy;
                final /* synthetic */ String $nodeName;
                {
                    this.$value = $value;
                    this.$debugProcess = $debugProcess;
                    this.$project = $project;
                    this.$debugSessionProxy = $debugSessionProxy;
                    this.$nodeName = $nodeName;
                    super($suspendContext);
                }

                public void contextAction(SuspendContextImpl suspendContext) {
                    Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                    try {
                        EvaluationContextImpl evalContext = new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy());
                        ObjectReference objectReference = DebuggerTreeAction.getObjectReference((XValue)this.$value);
                        if (objectReference == null) {
                            return;
                        }
                        ObjectReference psiElemObj = objectReference;
                        Value value = PsiDebuggerUtilKt.invokeMethod((DebugProcess)this.$debugProcess, psiElemObj, "getContainingFile", (EvaluationContext)evalContext);
                        ObjectReference objectReference2 = value instanceof ObjectReference ? (ObjectReference)value : null;
                        if (objectReference2 == null) {
                            return;
                        }
                        ObjectReference psiFileObj = objectReference2;
                        String string = PsiDebuggerUtilKt.getText(psiFileObj, (DebugProcess)this.$debugProcess, (EvaluationContext)evalContext);
                        if (string == null) {
                            return;
                        }
                        String fileText = string;
                        String fileName = DebuggerUtils.getValueAsString((EvaluationContext)((EvaluationContext)evalContext), (Value)PsiDebuggerUtilKt.invokeMethod((DebugProcess)this.$debugProcess, psiFileObj, "getName", (EvaluationContext)evalContext));
                        TextRange psiRangeInFile = PsiDebuggerUtilKt.getTextRange(psiElemObj, (DebugProcess)this.$debugProcess, (EvaluationContext)evalContext);
                        String languageId = PsiDebuggerUtilKt.getLanguageId(psiFileObj, (DebugProcess)this.$debugProcess, (EvaluationContext)evalContext);
                        Language language = Language.findLanguageByID((String)languageId);
                        if (language == null) {
                            return;
                        }
                        Language language2 = language;
                        DebuggerUIUtil.invokeLater(() -> perform.1.contextAction$lambda$0(fileText, psiRangeInFile, this.$project, this.$debugProcess, this.$debugSessionProxy, language2, this.$nodeName, fileName));
                    }
                    catch (EvaluateException e) {
                        NotificationGroup notificationGroup = XDebuggerManagerImpl.getNotificationGroup();
                        String string = JavaDevBundle.message("psi.viewer.debug.evaluation.failed", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        notificationGroup.createNotification(string, NotificationType.ERROR);
                        PsiViewerDebugActionKt.access$getLOG$p().warn("Failed to evaluate PSI expression", (Throwable)e);
                    }
                }

                private static final void contextAction$lambda$0(String $fileText, TextRange $psiRangeInFile, Project $project, DebugProcessImpl $debugProcess, XDebugSessionProxy $debugSessionProxy, Language $language, String $nodeName, String $fileName) {
                    EditorFactory editorFactory = EditorFactory.getInstance();
                    Document document = editorFactory.createDocument((CharSequence)$fileText);
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
                    Document document2 = document;
                    Editor editor = editorFactory.createEditor(document2);
                    Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
                    EditorEx editor2 = (EditorEx)editor;
                    if ($psiRangeInFile != null) {
                        editor2.getSelectionModel().setSelection($psiRangeInFile.getStartOffset(), $psiRangeInFile.getEndOffset());
                    }
                    if (PsiViewerDebugSettings.Companion.getInstance().getShowDialogFromDebugAction() || AppMode.isRemoteDevHost()) {
                        perform.1.contextAction$lambda$0$showDialog($project, editor2);
                    } else {
                        perform.1.contextAction$lambda$0$showDebugTab($debugProcess, $debugSessionProxy, $project, editor2, $language, $nodeName, $fileName);
                    }
                }

                private static final void contextAction$lambda$0$showDialog(Project project, EditorEx editor) {
                    PsiViewerDialog dialog = new PsiViewerDialog(project, (Editor)editor);
                    dialog.show();
                }

                private static final void contextAction$lambda$0$showDebugTab(DebugProcessImpl debugProcess, XDebugSessionProxy debugSessionProxy, Project project, EditorEx editor, Language language, String $nodeName, String fileName) {
                    DebuggerSession debuggerSession = debugProcess.getSession();
                    if (debuggerSession == null || (debuggerSession = debuggerSession.getXDebugSession()) == null) {
                        return;
                    }
                    DebuggerSession debugSession = debuggerSession;
                    XDebugSessionProxy xDebugSessionProxy = debugSessionProxy;
                    if (xDebugSessionProxy == null || (xDebugSessionProxy = xDebugSessionProxy.getSessionTab()) == null || (xDebugSessionProxy = xDebugSessionProxy.getUi()) == null) {
                        return;
                    }
                    XDebugSessionProxy runnerLayoutUi = xDebugSessionProxy;
                    PsiViewerDebugPanel psiViewerPanel = new PsiViewerDebugPanel(project, editor, language, $nodeName, (XDebugSession)debugSession, fileName);
                    String id = PsiViewerDebugPanel.Companion.getTitle($nodeName, PsiViewerDebugSettings.Companion.getInstance().getWatchMode());
                    Content content = runnerLayoutUi.createContent(id, (JComponent)psiViewerPanel, id, null, null);
                    Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
                    Content content2 = content;
                    runnerLayoutUi.addContent(content2);
                    runnerLayoutUi.selectAndFocus(content2, true, true);
                }
            });
        }
    }
}

