/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tR\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/JsCodeCallsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "jsRelatedSymbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols$JsRelatedSymbols;", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "getJsRelatedSymbols", "()Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols$JsRelatedSymbols;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformFunction", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "transformProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getJsCode", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nJsCodeCallsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsCodeCallsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/JsCodeCallsLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,128:1\n1807#2,3:129\n1586#2:132\n1661#2,3:133\n1924#2,3:147\n1924#2,3:150\n418#3,10:136\n76#4:146\n77#4:153\n*S KotlinDebug\n*F\n+ 1 JsCodeCallsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/JsCodeCallsLowering\n*L\n70#1:129,3\n83#1:132\n83#1:133,3\n86#1:147,3\n89#1:150,3\n84#1:136,10\n84#1:146\n84#1:153\n*E\n"})
public final class JsCodeCallsLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;

    public JsCodeCallsLowering(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    private final WasmSymbols.JsRelatedSymbols getJsRelatedSymbols() {
        return this.context.getWasmSymbols().getJsRelatedSymbols();
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (!this.context.isWasmJsTarget()) {
            return;
        }
        TransformKt.transformDeclarationsFlat((IrDeclarationContainer)((IrDeclarationContainer)irFile), arg_0 -> JsCodeCallsLowering.lower$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrDeclaration> transformFunction(IrSimpleFunction function2) {
        void it;
        IrConstructorCall irConstructorCall;
        boolean bl;
        String jsFunCode;
        block18: {
            StringBuilder stringBuilder;
            IrBody irBody = function2.getBody();
            if (irBody == null) {
                return null;
            }
            IrBody body = irBody;
            IrBody irBody2 = body;
            IrStatement statement = irBody2 instanceof IrExpressionBody ? (IrStatement)((IrExpressionBody)body).getExpression() : (irBody2 instanceof IrBlockBody ? (IrStatement)CollectionsKt.singleOrNull((List)((IrBlockBody)body).getStatements()) : null);
            boolean isSingleExpressionJsCode = false;
            String jsCode = null;
            IrStatement irStatement = statement;
            if (irStatement instanceof IrReturn) {
                String string = this.getJsCode(((IrReturn)statement).getValue());
                if (string == null) {
                    return null;
                }
                jsCode = string;
                isSingleExpressionJsCode = true;
            } else if (irStatement instanceof IrCall) {
                String string = this.getJsCode((IrExpression)statement);
                if (string == null) {
                    return null;
                }
                jsCode = string;
                isSingleExpressionJsCode = false;
            } else {
                return null;
            }
            List valueParameters = function2.getParameters();
            StringBuilder $this$transformFunction_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$transformFunction_u24lambda_u240.append('(');
            $this$transformFunction_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)valueParameters, null, null, null, (int)0, null, JsCodeCallsLowering::transformFunction$lambda$0$0, (int)31, null));
            $this$transformFunction_u24lambda_u240.append(") => ");
            if (!isSingleExpressionJsCode) {
                $this$transformFunction_u24lambda_u240.append("{ ");
            }
            $this$transformFunction_u24lambda_u240.append(jsCode);
            if (!isSingleExpressionJsCode) {
                $this$transformFunction_u24lambda_u240.append(" }");
            }
            jsFunCode = stringBuilder.toString();
            Iterable $this$any$iv = function2.getParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrValueParameter it2 = (IrValueParameter)element$iv;
                    boolean bl3 = false;
                    if (!(it2.getDefaultValue() != null)) continue;
                    bl = true;
                    break block18;
                }
                bl = false;
            }
        }
        if (bl) {
            IrTypeParameter parameter;
            int index;
            int n;
            void $this$transformFunction_u24lambda_u244;
            void this_$iv$iv;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv;
            IrSimpleFunction externalFun = (IrSimpleFunction)this.context.getIrFactory().getStageController().restrictTo((IrDeclaration)function2, () -> JsCodeCallsLowering.transformFunction$lambda$2(this, function2, jsFunCode));
            IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)((IrTypeParametersContainer)externalFun), (IrTypeParametersContainer)((IrTypeParametersContainer)function2), null, null, (int)6, null);
            Iterable $i$f$any = function2.getParameters();
            IrSimpleFunction irSimpleFunction = externalFun;
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it3;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(IrUtilsKt.copyTo$default((IrValueParameter)it3, (IrFunction)((IrFunction)externalFun), null, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, null, null, (int)16126, null));
            }
            irSimpleFunction.setParameters((List)destination$iv$iv);
            IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((LoweringContext)((LoweringContext)this.context), (IrSymbol)((IrSymbol)function2.getSymbol()), (int)0, (int)0, (int)6, null);
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder $i$f$mapTo22 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            item$iv$iv2 = this_$iv$iv;
            irSimpleFunction = function2;
            boolean bl5 = false;
            IrCall call = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$transformFunction_u24lambda_u244), (IrSimpleFunctionSymbol)externalFun.getSymbol());
            Iterable $this$forEachIndexed$iv = function2.getParameters();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv;
                index = n;
                boolean bl6 = false;
                call.getArguments().set(index, (Object)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$transformFunction_u24lambda_u244), (IrValueDeclaration)((IrValueDeclaration)parameter)));
            }
            $this$forEachIndexed$iv = function2.getTypeParameters();
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void typeParameter;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                parameter = (IrTypeParameter)item$iv;
                index = n;
                boolean bl7 = false;
                call.getTypeArguments().set(index, IrTypesKt.getDefaultType((IrTypeParameter)typeParameter));
            }
            $this$transformFunction_u24lambda_u244.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)((IrBuilderWithScope)$this$transformFunction_u24lambda_u244), (IrExpression)((IrExpression)call)));
            irSimpleFunction.setBody((IrBody)this_$iv$iv.doBuild());
            Object[] objectArray = new IrSimpleFunction[]{function2, externalFun};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder$default((LoweringContext)((LoweringContext)this.context), (IrSymbol)((IrSymbol)function2.getSymbol()), (int)0, (int)0, (int)6, null);
        IrConstructorCall startOffset$iv = irConstructorCall = ExpressionHelpersKt.irCallConstructor((IrBuilder)((IrBuilder)builder), (IrConstructorSymbol)this.getJsRelatedSymbols().getJsFunConstructor(), (List)CollectionsKt.emptyList());
        Collection collection = function2.getAnnotations();
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl8 = false;
        it.getArguments().set(0, (Object)ExpressionHelpersKt.irString((IrBuilder)((IrBuilder)builder), (String)jsFunCode));
        Unit unit = Unit.INSTANCE;
        irSimpleFunction.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)irConstructorCall));
        function2.setBody(null);
        return null;
    }

    private final List<IrDeclaration> transformProperty(IrProperty property2) {
        IrField irField = property2.getBackingField();
        if (irField == null) {
            return null;
        }
        IrField field = irField;
        IrExpressionBody irExpressionBody = field.getInitializer();
        if (irExpressionBody == null) {
            return null;
        }
        IrExpressionBody initializer = irExpressionBody;
        String string = this.getJsCode(initializer.getExpression());
        if (string == null) {
            return null;
        }
        String jsCode = string;
        IrSimpleFunction externalFun = (IrSimpleFunction)this.context.getIrFactory().getStageController().restrictTo((IrDeclaration)field, () -> JsCodeCallsLowering.transformProperty$lambda$0(this, property2, field, jsCode));
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder$default((LoweringContext)((LoweringContext)this.context), (IrSymbol)((IrSymbol)field.getSymbol()), (int)0, (int)0, (int)6, null);
        initializer.setExpression((IrExpression)ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)builder), (IrFunction)((IrFunction)externalFun)));
        Object[] objectArray = new IrDeclaration[]{property2, externalFun};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final String getJsCode(IrExpression $this$getJsCode) {
        IrCall irCall = $this$getJsCode instanceof IrCall ? (IrCall)$this$getJsCode : null;
        if (irCall == null) {
            return null;
        }
        IrCall call = irCall;
        if (!Intrinsics.areEqual((Object)call.getSymbol(), (Object)this.getJsRelatedSymbols().getJsCode())) {
            return null;
        }
        Object object = call.getArguments().get(0);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst");
        Object object2 = ((IrConst)object).getValue();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object2;
    }

    private static final List lower$lambda$0(JsCodeCallsLowering this$0, IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrDeclaration irDeclaration = declaration;
        return irDeclaration instanceof IrSimpleFunction ? this$0.transformFunction((IrSimpleFunction)declaration) : (irDeclaration instanceof IrProperty ? this$0.transformProperty((IrProperty)declaration) : null);
    }

    private static final CharSequence transformFunction$lambda$0$0(IrValueParameter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
        return string;
    }

    private static final IrSimpleFunction transformFunction$lambda$2(JsCodeCallsLowering this$0, IrSimpleFunction $function, String $jsFunCode) {
        return ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.createExternalJsFunction(this$0.context, $function.getName(), "_js_code", $function.getReturnType(), $jsFunCode);
    }

    private static final IrSimpleFunction transformProperty$lambda$0(JsCodeCallsLowering this$0, IrProperty $property, IrField $field, String $jsCode) {
        return ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.createExternalJsFunction(this$0.context, $property.getName(), "_js_code", $field.getType(), "() => (" + $jsCode + ')');
    }
}

