/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitSvnRemoteBranch;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitSimplePathsBrowser;
import git4idea.util.GitUIUtil;
import git4idea.util.StringScanner;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class GitUtil {
    @NonNls
    public static final String DOT_GIT = ".git";
    @NonNls
    public static final String COMMENT_CHAR = "\u0001";
    @NonNls
    public static final String ORIGIN_HEAD = "origin/HEAD";
    @NlsSafe
    public static final String HEAD = "HEAD";
    @NonNls
    public static final String CHERRY_PICK_HEAD = "CHERRY_PICK_HEAD";
    @NonNls
    public static final String MERGE_HEAD = "MERGE_HEAD";
    @NonNls
    public static final String REBASE_HEAD = "REBASE_HEAD";
    @NonNls
    private static final String REPO_PATH_LINK_PREFIX = "gitdir:";
    private static final Logger LOG = Logger.getInstance(GitUtil.class);
    @NonNls
    private static final String HEAD_FILE = "HEAD";
    private static final Pattern HASH_STRING_PATTERN = Pattern.compile("[a-fA-F0-9]{40}");

    private GitUtil() {
    }

    public static void updateHead(@NotNull GitRepository repository2, @NotNull Hash newObjectId, @Nullable String reflogMessage) throws VcsException {
        if (repository2 == null) {
            GitUtil.$$$reportNull$$$0(0);
        }
        if (newObjectId == null) {
            GitUtil.$$$reportNull$$$0(1);
        }
        Git.getInstance().updateReference(repository2, "HEAD", newObjectId, reflogMessage).throwOnError(new int[0]);
    }

    @Nullable
    public static VirtualFile findGitDir(@NotNull VirtualFile rootDir) {
        VirtualFile dotGit;
        if (rootDir == null) {
            GitUtil.$$$reportNull$$$0(2);
        }
        if ((dotGit = VfsUtil.refreshAndFindChild((VirtualFile)rootDir, (String)DOT_GIT)) == null) {
            return null;
        }
        if (dotGit.isDirectory()) {
            boolean headExists = VfsUtil.refreshAndFindChild((VirtualFile)dotGit, (String)"HEAD") != null;
            return headExists ? dotGit : null;
        }
        String content = GitUtil.readContent(dotGit);
        if (content == null) {
            return null;
        }
        String pathToDir = GitUtil.parsePathToRepository(content);
        if (pathToDir == null) {
            return null;
        }
        Path file = GitUtil.findRealRepositoryDir(rootDir.toNioPath(), pathToDir);
        if (file == null) {
            return null;
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByNioFile(file);
    }

    @Nullable
    private static Path findRealRepositoryDir(@NotNull @NonNls Path rootPath, @NotNull @NonNls String path) {
        Path file;
        if (rootPath == null) {
            GitUtil.$$$reportNull$$$0(3);
        }
        if (path == null) {
            GitUtil.$$$reportNull$$$0(4);
        }
        if (!FileUtil.isAbsolute((String)path)) {
            String canonicalPath = FileUtil.toCanonicalPath((String)FileUtil.join((String[])new String[]{rootPath.toString(), path}), (boolean)true);
            path = FileUtil.toSystemIndependentName((String)canonicalPath);
        }
        if (!Files.isDirectory(file = Path.of(path, new String[0]), new LinkOption[0])) {
            return null;
        }
        return file;
    }

    @ApiStatus.Internal
    @Nullable
    public static String parsePathToRepository(@NotNull @NonNls String content) {
        if (content == null) {
            GitUtil.$$$reportNull$$$0(5);
        }
        if ((content = content.trim()).startsWith(REPO_PATH_LINK_PREFIX)) {
            content = content.substring(REPO_PATH_LINK_PREFIX.length()).trim();
        }
        if (content.isEmpty() || content.contains("\n")) {
            return null;
        }
        return content;
    }

    @Nullable
    private static String readContent(@NotNull VirtualFile dotGit) {
        String content;
        if (dotGit == null) {
            GitUtil.$$$reportNull$$$0(6);
        }
        try {
            content = GitUtil.readFile(dotGit);
        }
        catch (IOException e) {
            LOG.error("Couldn't read the content of " + String.valueOf(dotGit), (Throwable)e);
            return null;
        }
        return content;
    }

    @NotNull
    private static String readFile(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            GitUtil.$$$reportNull$$$0(7);
        }
        int ATTEMPTS = 3;
        int attempt = 1;
        while (true) {
            try {
                return new String(file.contentsToByteArray(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LOG.info(String.format("IOException while reading %s (attempt #%s)", file, attempt));
                if (attempt++ < 3) continue;
                throw e;
            }
            break;
        }
    }

    @RequiresBackgroundThread
    @NotNull
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(8);
        }
        if (virtualFiles == null) {
            GitUtil.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.assertBackgroundThread();
        return GitUtil.sortFilesByGitRoot(project, virtualFiles, false);
    }

    @RequiresBackgroundThread
    @NotNull
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRootIgnoringMissing(@NotNull Project project, @NotNull Collection<? extends VirtualFile> filePaths) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(10);
        }
        if (filePaths == null) {
            GitUtil.$$$reportNull$$$0(11);
        }
        ThreadingAssertions.assertBackgroundThread();
        try {
            return GitUtil.sortFilesByGitRoot(project, filePaths, true);
        }
        catch (VcsException e) {
            LOG.error((Throwable)new IllegalArgumentException(e));
            Map<VirtualFile, List<VirtualFile>> map2 = Collections.emptyMap();
            if (map2 == null) {
                GitUtil.$$$reportNull$$$0(12);
            }
            return map2;
        }
    }

    @RequiresBackgroundThread
    @NotNull
    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(@NotNull Project project, @NotNull Collection<? extends FilePath> filePaths) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(13);
        }
        if (filePaths == null) {
            GitUtil.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.assertBackgroundThread();
        return GitUtil.sortFilePathsByGitRoot(project, filePaths, false);
    }

    @RequiresBackgroundThread
    @NotNull
    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRootIgnoringMissing(@NotNull Project project, @NotNull Collection<? extends FilePath> filePaths) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(15);
        }
        if (filePaths == null) {
            GitUtil.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.assertBackgroundThread();
        try {
            return GitUtil.sortFilePathsByGitRoot(project, filePaths, true);
        }
        catch (VcsException e) {
            LOG.error((Throwable)new IllegalArgumentException(e));
            Map<VirtualFile, List<FilePath>> map2 = Collections.emptyMap();
            if (map2 == null) {
                GitUtil.$$$reportNull$$$0(17);
            }
            return map2;
        }
    }

    @RequiresBackgroundThread
    @NotNull
    private static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles, boolean ignoreNonGit) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(18);
        }
        if (virtualFiles == null) {
            GitUtil.$$$reportNull$$$0(19);
        }
        ThreadingAssertions.assertBackgroundThread();
        Map<GitRepository, List<VirtualFile>> map2 = GitUtil.sortFilesByRepository(project, virtualFiles, ignoreNonGit);
        HashMap<VirtualFile, List<VirtualFile>> result2 = new HashMap<VirtualFile, List<VirtualFile>>();
        map2.forEach((repo, files) -> result2.put(repo.getRoot(), (List<VirtualFile>)files));
        HashMap<VirtualFile, List<VirtualFile>> hashMap = result2;
        if (hashMap == null) {
            GitUtil.$$$reportNull$$$0(20);
        }
        return hashMap;
    }

    @RequiresBackgroundThread
    @NotNull
    public static Map<GitRepository, List<VirtualFile>> sortFilesByRepository(@NotNull Project project, @NotNull Collection<? extends VirtualFile> filePaths) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(21);
        }
        if (filePaths == null) {
            GitUtil.$$$reportNull$$$0(22);
        }
        ThreadingAssertions.assertBackgroundThread();
        return GitUtil.sortFilesByRepository(project, filePaths, false);
    }

    @RequiresBackgroundThread
    @NotNull
    public static Map<GitRepository, List<VirtualFile>> sortFilesByRepositoryIgnoringMissing(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(23);
        }
        if (virtualFiles == null) {
            GitUtil.$$$reportNull$$$0(24);
        }
        ThreadingAssertions.assertBackgroundThread();
        try {
            return GitUtil.sortFilesByRepository(project, virtualFiles, true);
        }
        catch (VcsException e) {
            LOG.error((Throwable)new IllegalArgumentException(e));
            Map<GitRepository, List<VirtualFile>> map2 = Collections.emptyMap();
            if (map2 == null) {
                GitUtil.$$$reportNull$$$0(25);
            }
            return map2;
        }
    }

    @RequiresBackgroundThread
    @NotNull
    private static Map<GitRepository, List<VirtualFile>> sortFilesByRepository(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles, boolean ignoreNonGit) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(26);
        }
        if (virtualFiles == null) {
            GitUtil.$$$reportNull$$$0(27);
        }
        ThreadingAssertions.assertBackgroundThread();
        GitRepositoryManager manager2 = GitRepositoryManager.getInstance(project);
        HashMap<GitRepository, List<VirtualFile>> result2 = new HashMap<GitRepository, List<VirtualFile>>();
        for (VirtualFile virtualFile : virtualFiles) {
            VirtualFile actualFile = virtualFile.isDirectory() ? virtualFile.getParent() : virtualFile;
            GitRepository repository2 = (GitRepository)manager2.getRepositoryForFile(actualFile);
            if (repository2 == null) {
                if (ignoreNonGit) continue;
                throw new GitRepositoryNotFoundException(virtualFile);
            }
            List files = result2.computeIfAbsent(repository2, key -> new ArrayList());
            files.add(virtualFile);
        }
        HashMap<GitRepository, List<VirtualFile>> hashMap = result2;
        if (hashMap == null) {
            GitUtil.$$$reportNull$$$0(28);
        }
        return hashMap;
    }

    @NotNull
    private static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(@NotNull Project project, @NotNull Collection<? extends FilePath> filePaths, boolean ignoreNonGit) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(29);
        }
        if (filePaths == null) {
            GitUtil.$$$reportNull$$$0(30);
        }
        ProjectLevelVcsManager manager2 = ProjectLevelVcsManager.getInstance((Project)project);
        GitVcs gitVcs = GitVcs.getInstance(project);
        HashMap<VirtualFile, List<FilePath>> result2 = new HashMap<VirtualFile, List<FilePath>>();
        for (FilePath filePath : filePaths) {
            AbstractVcs vcs;
            VcsRoot vcsRoot = manager2.getVcsRootObjectFor(filePath);
            AbstractVcs abstractVcs = vcs = vcsRoot != null ? vcsRoot.getVcs() : null;
            if (vcs == null || !vcs.equals((Object)gitVcs)) {
                if (ignoreNonGit) continue;
                throw new GitRepositoryNotFoundException(filePath);
            }
            List paths = result2.computeIfAbsent(vcsRoot.getPath(), key -> new ArrayList());
            paths.add(filePath);
        }
        HashMap<VirtualFile, List<FilePath>> hashMap = result2;
        if (hashMap == null) {
            GitUtil.$$$reportNull$$$0(31);
        }
        return hashMap;
    }

    public static Date parseTimestamp(@NonNls String value) {
        long parsed = Long.parseLong(value.trim());
        return new Date(parsed * 1000L);
    }

    public static Date parseTimestampWithNFEReport(@NonNls String value, GitHandler handler, String gitOutput) {
        try {
            return GitUtil.parseTimestamp(value);
        }
        catch (NumberFormatException e) {
            LOG.error("annotate(). NFE. Handler: " + String.valueOf(handler) + ". Output: " + gitOutput, (Throwable)e);
            return new Date();
        }
    }

    @ApiStatus.Obsolete
    @Nullable
    public static VirtualFile findGitRootFor(@NotNull Path path) {
        if (path == null) {
            GitUtil.$$$reportNull$$$0(32);
        }
        try {
            for (Path root = path; root != null; root = root.getParent()) {
                if (!GitUtil.isGitRoot(root)) continue;
                return LocalFileSystem.getInstance().findFileByNioFile(root);
            }
            return null;
        }
        catch (InvalidPathException e) {
            LOG.warn(e.getMessage());
            return null;
        }
    }

    @Deprecated
    public static boolean isGitRoot(@NotNull File folder) {
        if (folder == null) {
            GitUtil.$$$reportNull$$$0(33);
        }
        try {
            return GitUtil.isGitRoot(folder.toPath());
        }
        catch (InvalidPathException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }

    @ApiStatus.Obsolete
    public static boolean isUnderGit(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            GitUtil.$$$reportNull$$$0(34);
        }
        try {
            return GitUtil.findGitRootFor(vFile.toNioPath()) != null;
        }
        catch (InvalidPathException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }

    @ApiStatus.Obsolete
    public static boolean isUnderGit(@NotNull FilePath path) {
        if (path == null) {
            GitUtil.$$$reportNull$$$0(35);
        }
        try {
            return GitUtil.findGitRootFor(Paths.get(path.getPath(), new String[0])) != null;
        }
        catch (InvalidPathException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }

    @NlsSafe
    public static String adjustAuthorName(@NlsSafe String authorName, @NlsSafe String committerName) {
        if (!authorName.equals(committerName)) {
            committerName = GitBundle.message("commit.author.with.committer", authorName, committerName);
        }
        return committerName;
    }

    @RequiresBackgroundThread
    @NotNull
    public static Set<GitRepository> getRepositoriesForFiles(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(36);
        }
        if (files == null) {
            GitUtil.$$$reportNull$$$0(37);
        }
        ThreadingAssertions.assertBackgroundThread();
        HashSet<GitRepository> result2 = new HashSet<GitRepository>();
        for (VirtualFile virtualFile : files) {
            result2.add(GitUtil.getRepositoryForFile(project, virtualFile));
        }
        HashSet<GitRepository> hashSet = result2;
        if (hashSet == null) {
            GitUtil.$$$reportNull$$$0(38);
        }
        return hashSet;
    }

    @NonNls
    public static String gitTime(Date time) {
        long t = time.getTime() / 1000L;
        return Long.toString(t);
    }

    @NonNls
    public static String formatLongRev(long rev) {
        return String.format("%015x%x", rev >>> 4, rev & 0xFL);
    }

    public static void getLocalCommittedChanges(Project project, VirtualFile root, Consumer<? super GitHandler> parametersSpecifier, Consumer<? super GitCommittedChangeList> consumer, boolean skipDiffsForMerge) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        h.setSilent(true);
        h.addParameters("--pretty=format:%x04%x01%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03", "--name-status");
        parametersSpecifier.consume((Object)h);
        String output2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        LOG.debug("getLocalCommittedChanges output: '" + output2 + "'");
        StringScanner s = new StringScanner(output2);
        StringBuilder sb = new StringBuilder();
        boolean firstStep = true;
        while (s.hasMoreData()) {
            String line = s.line();
            boolean lineIsAStart = line.startsWith("\u0004\u0001");
            if (!firstStep && lineIsAStart) {
                StringScanner innerScanner = new StringScanner(sb.toString());
                sb.setLength(0);
                consumer.consume((Object)GitChangeUtils.parseChangeList(project, root, innerScanner, skipDiffsForMerge, h, false, false));
            }
            sb.append(lineIsAStart ? line.substring(2) : line).append('\n');
            firstStep = false;
        }
        if (!sb.isEmpty()) {
            StringScanner innerScanner = new StringScanner(sb.toString());
            sb.setLength(0);
            consumer.consume((Object)GitChangeUtils.parseChangeList(project, root, innerScanner, skipDiffsForMerge, h, false, false));
        }
        if (s.hasMoreData()) {
            throw new IllegalStateException("More input is available: " + s.line());
        }
    }

    public static List<GitCommittedChangeList> getLocalCommittedChanges(Project project, VirtualFile root, Consumer<? super GitHandler> parametersSpecifier) throws VcsException {
        ArrayList<GitCommittedChangeList> rc = new ArrayList<GitCommittedChangeList>();
        GitUtil.getLocalCommittedChanges(project, root, parametersSpecifier, (Consumer<? super GitCommittedChangeList>)((Consumer)committedChangeList -> rc.add((GitCommittedChangeList)((Object)committedChangeList))), false);
        return rc;
    }

    @NotNull
    public static String unescapePath(@NotNull @NonNls String path) throws VcsException {
        String string;
        if (path == null) {
            GitUtil.$$$reportNull$$$0(39);
        }
        try {
            string = VcsFileUtil.unescapeGitPath((String)path);
        }
        catch (IllegalStateException e) {
            throw new VcsException((Throwable)e);
        }
        if (string == null) {
            GitUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    public static boolean justOneGitRepository(Project project) {
        if (project.isDisposed()) {
            return true;
        }
        GitRepositoryManager manager2 = GitUtil.getRepositoryManager(project);
        return !manager2.moreThanOneRoot();
    }

    @Nullable
    public static GitRemote findRemoteByName(@NotNull GitRepository repository2, @NotNull @NonNls String name) {
        if (repository2 == null) {
            GitUtil.$$$reportNull$$$0(41);
        }
        if (name == null) {
            GitUtil.$$$reportNull$$$0(42);
        }
        return GitUtil.findRemoteByName(repository2.getRemotes(), name);
    }

    @Nullable
    public static GitRemote findRemoteByName(Collection<GitRemote> remotes, @NotNull @NonNls String name) {
        if (name == null) {
            GitUtil.$$$reportNull$$$0(43);
        }
        return (GitRemote)ContainerUtil.find(remotes, remote -> remote.getName().equals(name));
    }

    @Nullable
    public static GitRemoteBranch findRemoteBranch(@NotNull GitRepository repository2, @NotNull GitRemote remote, @NotNull @NonNls String nameAtRemote) {
        if (repository2 == null) {
            GitUtil.$$$reportNull$$$0(44);
        }
        if (remote == null) {
            GitUtil.$$$reportNull$$$0(45);
        }
        if (nameAtRemote == null) {
            GitUtil.$$$reportNull$$$0(46);
        }
        return (GitRemoteBranch)ContainerUtil.find(repository2.getBranches().getRemoteBranches(), remoteBranch -> remoteBranch.getRemote().equals(remote) && remoteBranch.getNameForRemoteOperations().equals(GitBranchUtil.stripRefsPrefix(nameAtRemote)));
    }

    @NotNull
    public static GitRemoteBranch findOrCreateRemoteBranch(@NotNull GitRepository repository2, @NotNull GitRemote remote, @NotNull @NonNls String branchName) {
        if (repository2 == null) {
            GitUtil.$$$reportNull$$$0(47);
        }
        if (remote == null) {
            GitUtil.$$$reportNull$$$0(48);
        }
        if (branchName == null) {
            GitUtil.$$$reportNull$$$0(49);
        }
        GitRemoteBranch remoteBranch = GitUtil.findRemoteBranch(repository2, remote, branchName);
        GitRemoteBranch gitRemoteBranch = (GitRemoteBranch)ObjectUtils.notNull((Object)remoteBranch, (Object)new GitStandardRemoteBranch(remote, branchName));
        if (gitRemoteBranch == null) {
            GitUtil.$$$reportNull$$$0(50);
        }
        return gitRemoteBranch;
    }

    @NotNull
    public static GitRemoteBranch parseRemoteBranch(@NotNull String fullBranchName, @NotNull Collection<GitRemote> remotes) {
        String branchName;
        String remoteName;
        GitRemote remote;
        String stdName;
        int slash;
        if (fullBranchName == null) {
            GitUtil.$$$reportNull$$$0(51);
        }
        if (remotes == null) {
            GitUtil.$$$reportNull$$$0(52);
        }
        if ((slash = (stdName = GitBranchUtil.stripRefsPrefix(fullBranchName)).indexOf(47)) == -1) {
            return new GitSvnRemoteBranch(fullBranchName);
        }
        do {
            remoteName = stdName.substring(0, slash);
            branchName = stdName.substring(slash + 1);
            remote = GitUtil.findRemoteByName(remotes, remoteName);
            slash = stdName.indexOf(47, slash + 1);
        } while (remote == null && slash >= 0);
        if (remote == null) {
            int firstSlash = stdName.indexOf(47);
            remoteName = stdName.substring(0, firstSlash);
            branchName = stdName.substring(firstSlash + 1);
            LOG.trace(String.format("No remote found with the name [%s]. All remotes: %s", remoteName, remotes));
            GitRemote fakeRemote = new GitRemote(remoteName, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            return new GitStandardRemoteBranch(fakeRemote, branchName);
        }
        return new GitStandardRemoteBranch(remote, branchName);
    }

    public static @Unmodifiable @NotNull Collection<VirtualFile> getRootsFromRepositories(@NotNull @Unmodifiable Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitUtil.$$$reportNull$$$0(53);
        }
        List list = ContainerUtil.map(repositories, Repository::getRoot);
        if (list == null) {
            GitUtil.$$$reportNull$$$0(54);
        }
        return list;
    }

    @RequiresBackgroundThread
    @NotNull
    public static Collection<GitRepository> getRepositoriesFromRoots(@NotNull GitRepositoryManager repositoryManager, @NotNull Collection<? extends VirtualFile> roots) {
        if (repositoryManager == null) {
            GitUtil.$$$reportNull$$$0(55);
        }
        if (roots == null) {
            GitUtil.$$$reportNull$$$0(56);
        }
        ThreadingAssertions.assertBackgroundThread();
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(roots.size());
        for (VirtualFile virtualFile : roots) {
            GitRepository repo = (GitRepository)repositoryManager.getRepositoryForRoot(virtualFile);
            if (repo == null) {
                LOG.error("Repository not found for root " + String.valueOf(virtualFile));
                continue;
            }
            repositories.add(repo);
        }
        ArrayList<GitRepository> arrayList = repositories;
        if (arrayList == null) {
            GitUtil.$$$reportNull$$$0(57);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<String> getPathsDiffBetweenRefs(@NotNull Git git, @NotNull GitRepository repository2, @NotNull @NonNls String beforeRef, @NotNull @NonNls String afterRef) throws VcsException {
        String range;
        List<String> parameters;
        GitCommandResult result2;
        if (git == null) {
            GitUtil.$$$reportNull$$$0(58);
        }
        if (repository2 == null) {
            GitUtil.$$$reportNull$$$0(59);
        }
        if (beforeRef == null) {
            GitUtil.$$$reportNull$$$0(60);
        }
        if (afterRef == null) {
            GitUtil.$$$reportNull$$$0(61);
        }
        if (!(result2 = git.diff(repository2, parameters = Arrays.asList("--name-only", "--pretty=format:"), range = beforeRef + ".." + afterRef)).success()) {
            LOG.info(String.format("Couldn't get diff in range [%s] for repository [%s]", range, repository2.toLogString()));
            List<String> list = Collections.emptyList();
            if (list == null) {
                GitUtil.$$$reportNull$$$0(62);
            }
            return list;
        }
        HashSet<String> remoteChanges = new HashSet<String>();
        StringScanner s = new StringScanner(result2.getOutputAsJoinedString());
        while (s.hasMoreData()) {
            String relative = s.line();
            if (StringUtil.isEmptyOrSpaces((String)relative)) continue;
            String path = repository2.getRoot().getPath() + "/" + GitUtil.unescapePath(relative);
            remoteChanges.add(path);
        }
        HashSet<String> hashSet = remoteChanges;
        if (hashSet == null) {
            GitUtil.$$$reportNull$$$0(63);
        }
        return hashSet;
    }

    @NotNull
    public static GitRepositoryManager getRepositoryManager(@NotNull Project project) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(64);
        }
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        if (gitRepositoryManager == null) {
            GitUtil.$$$reportNull$$$0(65);
        }
        return gitRepositoryManager;
    }

    @RequiresBackgroundThread
    @NotNull
    public static GitRepository getRepositoryForFile(@NotNull Project project, @NotNull VirtualFile file) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(66);
        }
        if (file == null) {
            GitUtil.$$$reportNull$$$0(67);
        }
        ThreadingAssertions.assertBackgroundThread();
        GitRepository repository2 = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFile(file);
        if (repository2 == null) {
            throw new GitRepositoryNotFoundException(file);
        }
        GitRepository gitRepository = repository2;
        if (gitRepository == null) {
            GitUtil.$$$reportNull$$$0(68);
        }
        return gitRepository;
    }

    @RequiresBackgroundThread
    @NotNull
    public static GitRepository getRepositoryForFile(@NotNull Project project, @NotNull FilePath file) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(69);
        }
        if (file == null) {
            GitUtil.$$$reportNull$$$0(70);
        }
        ThreadingAssertions.assertBackgroundThread();
        GitRepository repository2 = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFile(file);
        if (repository2 == null) {
            throw new GitRepositoryNotFoundException(file);
        }
        GitRepository gitRepository = repository2;
        if (gitRepository == null) {
            GitUtil.$$$reportNull$$$0(71);
        }
        return gitRepository;
    }

    @RequiresBackgroundThread
    @NotNull
    public static GitRepository getRepositoryForRoot(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(72);
        }
        if (root == null) {
            GitUtil.$$$reportNull$$$0(73);
        }
        ThreadingAssertions.assertBackgroundThread();
        GitRepository repository2 = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRoot(root);
        if (repository2 == null) {
            throw new GitRepositoryNotFoundException(root);
        }
        GitRepository gitRepository = repository2;
        if (gitRepository == null) {
            GitUtil.$$$reportNull$$$0(74);
        }
        return gitRepository;
    }

    @Nullable
    public static GitRepository getRepositoryForRootOrLogError(@NotNull Project project, @NotNull VirtualFile root) {
        GitRepository repository2;
        if (project == null) {
            GitUtil.$$$reportNull$$$0(75);
        }
        if (root == null) {
            GitUtil.$$$reportNull$$$0(76);
        }
        if ((repository2 = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRoot(root)) == null) {
            LOG.error((Throwable)((Object)new GitRepositoryNotFoundException(root)));
        }
        return repository2;
    }

    @NotNull
    public static VirtualFile getRootForFile(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        VcsRoot root;
        if (project == null) {
            GitUtil.$$$reportNull$$$0(77);
        }
        if (filePath == null) {
            GitUtil.$$$reportNull$$$0(78);
        }
        if (GitUtil.isGitVcsRoot(root = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootObjectFor(filePath))) {
            VirtualFile virtualFile = root.getPath();
            if (virtualFile == null) {
                GitUtil.$$$reportNull$$$0(79);
            }
            return virtualFile;
        }
        Repository repository2 = VcsRepositoryManager.getInstance((Project)project).getExternalRepositoryForFile(filePath);
        if (repository2 instanceof GitRepository) {
            VirtualFile virtualFile = repository2.getRoot();
            if (virtualFile == null) {
                GitUtil.$$$reportNull$$$0(80);
            }
            return virtualFile;
        }
        throw new GitRepositoryNotFoundException(filePath);
    }

    @NotNull
    public static VirtualFile getRootForFile(@NotNull Project project, @NotNull VirtualFile file) throws VcsException {
        VcsRoot root;
        if (project == null) {
            GitUtil.$$$reportNull$$$0(81);
        }
        if (file == null) {
            GitUtil.$$$reportNull$$$0(82);
        }
        if (GitUtil.isGitVcsRoot(root = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootObjectFor(file))) {
            VirtualFile virtualFile = root.getPath();
            if (virtualFile == null) {
                GitUtil.$$$reportNull$$$0(83);
            }
            return virtualFile;
        }
        Repository repository2 = VcsRepositoryManager.getInstance((Project)project).getExternalRepositoryForFile(file);
        if (repository2 instanceof GitRepository) {
            VirtualFile virtualFile = repository2.getRoot();
            if (virtualFile == null) {
                GitUtil.$$$reportNull$$$0(84);
            }
            return virtualFile;
        }
        throw new GitRepositoryNotFoundException(file);
    }

    private static boolean isGitVcsRoot(@Nullable VcsRoot root) {
        if (root == null) {
            return false;
        }
        AbstractVcs vcs = root.getVcs();
        if (vcs == null) {
            return false;
        }
        return GitVcs.getKey().equals((Object)vcs.getKeyInstanceMethod());
    }

    public static void showSubmittedFiles(final Project project, final @NonNls String revision, final VirtualFile file, final boolean local, final boolean revertable) {
        new Task.Backgroundable(project, GitBundle.message("changes.retrieving", revision)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                try {
                    VirtualFile vcsRoot = GitUtil.getRootForFile(project, file);
                    GitCommittedChangeList changeList = GitChangeUtils.getRevisionChanges(project, vcsRoot, revision, true, local, revertable);
                    UIUtil.invokeLaterIfNeeded(() -> 1.lambda$run$0(project, (CommittedChangeList)changeList, revision));
                }
                catch (VcsException e) {
                    UIUtil.invokeLaterIfNeeded(() -> GitUIUtil.showOperationError(project, e, GitBundle.message("operation.name.loading.revision", new Object[0])));
                }
            }

            private static /* synthetic */ void lambda$run$0(Project project2, CommittedChangeList changeList, String revision2) {
                AbstractVcsHelper.getInstance((Project)project2).showChangesListBrowser(changeList, GitBundle.message("paths.affected.title", revision2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/GitUtil$1", "run"));
            }
        }.queue();
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfoForCurrentBranch(@NotNull GitRepository repository2) {
        GitLocalBranch currentBranch;
        if (repository2 == null) {
            GitUtil.$$$reportNull$$$0(85);
        }
        if ((currentBranch = repository2.getCurrentBranch()) == null) {
            return null;
        }
        return GitBranchUtil.getTrackInfoForBranch(repository2, currentBranch);
    }

    public static boolean hasLocalChanges(boolean staged2, Project project, VirtualFile root) throws VcsException {
        GitLineHandler diff = new GitLineHandler(project, root, GitCommand.DIFF);
        diff.addParameters("--name-only");
        diff.addParameters("--no-renames");
        if (staged2) {
            diff.addParameters("--cached");
        }
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        String output2 = Git.getInstance().runCommand(diff).getOutputOrThrow(new int[0]);
        return !output2.trim().isEmpty();
    }

    @Nullable
    public static VirtualFile findRefreshFileOrLog(@NotNull @NonNls String absolutePath) {
        VirtualFile file;
        if (absolutePath == null) {
            GitUtil.$$$reportNull$$$0(86);
        }
        if ((file = LocalFileSystem.getInstance().findFileByPath(absolutePath)) == null) {
            file = LocalFileSystem.getInstance().refreshAndFindFileByPath(absolutePath);
        }
        if (file == null) {
            LOG.debug("VirtualFile not found for " + absolutePath);
        }
        return file;
    }

    @NotNull
    public static String toAbsolute(@NotNull VirtualFile root, @NotNull @NonNls String relativePath) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(87);
        }
        if (relativePath == null) {
            GitUtil.$$$reportNull$$$0(88);
        }
        String string = StringUtil.trimEnd((String)root.getPath(), (String)"/") + "/" + StringUtil.trimStart((String)relativePath, (String)"/");
        if (string == null) {
            GitUtil.$$$reportNull$$$0(89);
        }
        return string;
    }

    @NotNull
    public static Collection<String> toAbsolute(@NotNull VirtualFile root, @NotNull Collection<@NonNls String> relativePaths) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(90);
        }
        if (relativePaths == null) {
            GitUtil.$$$reportNull$$$0(91);
        }
        List list = ContainerUtil.map(relativePaths, s -> GitUtil.toAbsolute(root, s));
        if (list == null) {
            GitUtil.$$$reportNull$$$0(92);
        }
        return list;
    }

    @NotNull
    public static List<Change> findLocalChangesForPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<@NonNls String> affectedPaths, boolean relativePaths) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(93);
        }
        if (root == null) {
            GitUtil.$$$reportNull$$$0(94);
        }
        if (affectedPaths == null) {
            GitUtil.$$$reportNull$$$0(95);
        }
        ChangeListManagerEx changeListManager = ChangeListManagerEx.getInstanceEx((Project)project);
        ArrayList<Change> affectedChanges = new ArrayList<Change>();
        for (String path : affectedPaths) {
            String absolutePath = relativePaths ? GitUtil.toAbsolute(root, path) : path;
            VirtualFile file = GitUtil.findRefreshFileOrLog(absolutePath);
            if (file == null) continue;
            Change change = changeListManager.getChange(file);
            if (change != null) {
                affectedChanges.add(change);
                continue;
            }
            String message = "Change is not found for " + file.getPath();
            if (changeListManager.isInUpdate()) {
                message = message + " because ChangeListManager is being updated.";
            }
            LOG.debug(message);
        }
        ArrayList<Change> arrayList = affectedChanges;
        if (arrayList == null) {
            GitUtil.$$$reportNull$$$0(96);
        }
        return arrayList;
    }

    public static void showPathsInDialog(@NotNull Project project, @NotNull Collection<@NonNls String> absolutePaths, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DialogMessage @Nullable String description) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(97);
        }
        if (absolutePaths == null) {
            GitUtil.$$$reportNull$$$0(98);
        }
        if (title == null) {
            GitUtil.$$$reportNull$$$0(99);
        }
        GitUtil.showPathsInDialog(project, absolutePaths, title, description, null);
    }

    public static void showPathsInDialog(@NotNull Project project, @NotNull Collection<@NonNls String> absolutePaths, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DialogMessage @Nullable String description, @NlsContexts.StatusText @Nullable String emptyText) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(100);
        }
        if (absolutePaths == null) {
            GitUtil.$$$reportNull$$$0(101);
        }
        if (title == null) {
            GitUtil.$$$reportNull$$$0(102);
        }
        DialogBuilder builder = new DialogBuilder(project);
        GitSimplePathsBrowser browser = new GitSimplePathsBrowser(project, absolutePaths);
        if (emptyText != null) {
            browser.setEmptyText(emptyText);
        }
        builder.setCenterPanel((JComponent)browser);
        if (description != null) {
            builder.setNorthPanel((JComponent)new MultiLineLabel(description));
        }
        builder.addOkAction();
        builder.setTitle(title);
        builder.show();
    }

    @NlsSafe
    @NotNull
    public static String cleanupErrorPrefixes(@NotNull @NlsSafe String msg) {
        if (msg == null) {
            GitUtil.$$$reportNull$$$0(103);
        }
        @NonNls String[] PREFIXES = new String[]{"fatal:", "error:"};
        msg = msg.trim();
        for (String prefix : PREFIXES) {
            if (!msg.startsWith(prefix)) continue;
            msg = msg.substring(prefix.length()).trim();
        }
        String string = msg;
        if (string == null) {
            GitUtil.$$$reportNull$$$0(104);
        }
        return string;
    }

    @Nullable
    public static GitRemote getDefaultRemote(@NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            GitUtil.$$$reportNull$$$0(105);
        }
        return (GitRemote)ContainerUtil.find(remotes, r -> r.getName().equals("origin"));
    }

    @Nullable
    public static GitRemote getDefaultOrFirstRemote(@NotNull Collection<GitRemote> remotes) {
        GitRemote result2;
        if (remotes == null) {
            GitUtil.$$$reportNull$$$0(106);
        }
        return (result2 = GitUtil.getDefaultRemote(remotes)) == null ? (GitRemote)ContainerUtil.getFirstItem(remotes) : result2;
    }

    @NotNull
    public static String joinToHtml(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitUtil.$$$reportNull$$$0(107);
        }
        String string = StringUtil.join(repositories, repository2 -> repository2.getPresentableUrl(), (String)"<br/>");
        if (string == null) {
            GitUtil.$$$reportNull$$$0(108);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String mention(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitUtil.$$$reportNull$$$0(109);
        }
        return GitUtil.getRepositoryManager(repository2.getProject()).moreThanOneRoot() ? GitBundle.message("mention.in", DvcsUtil.getShortRepositoryName((Repository)repository2)) : "";
    }

    @Nls
    @NotNull
    public static String mention(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitUtil.$$$reportNull$$$0(110);
        }
        if (repositories.isEmpty()) {
            return "";
        }
        String string = GitBundle.message("mention.in", DvcsUtil.joinShortNames(repositories, (int)-1));
        if (string == null) {
            GitUtil.$$$reportNull$$$0(111);
        }
        return string;
    }

    public static void updateRepositories(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitUtil.$$$reportNull$$$0(112);
        }
        for (GitRepository gitRepository : repositories) {
            gitRepository.update();
        }
    }

    public static boolean hasGitRepositories(@NotNull Project project) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(113);
        }
        return !GitUtil.getRepositories(project).isEmpty();
    }

    @NotNull
    public static Collection<GitRepository> getRepositories(@NotNull Project project) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(114);
        }
        List<GitRepository> list = GitUtil.getRepositoryManager(project).getRepositories();
        if (list == null) {
            GitUtil.$$$reportNull$$$0(115);
        }
        return list;
    }

    @NotNull
    public static Collection<GitRepository> getRepositoriesInStates(@NotNull Project project, Repository.State ... states) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(116);
        }
        if (states == null) {
            GitUtil.$$$reportNull$$$0(117);
        }
        HashSet stateSet = ContainerUtil.newHashSet((Object[])states);
        List list = ContainerUtil.filter(GitUtil.getRepositories(project), repository2 -> stateSet.contains(repository2.getState()));
        if (list == null) {
            GitUtil.$$$reportNull$$$0(118);
        }
        return list;
    }

    public static boolean isCaseOnlyChange(@NotNull @NonNls String oldPath, @NotNull @NonNls String newPath) {
        if (oldPath == null) {
            GitUtil.$$$reportNull$$$0(119);
        }
        if (newPath == null) {
            GitUtil.$$$reportNull$$$0(120);
        }
        if (oldPath.equalsIgnoreCase(newPath)) {
            if (oldPath.equals(newPath)) {
                LOG.info("Comparing perfectly equal paths: " + newPath);
            }
            return true;
        }
        return false;
    }

    @NonNls
    @NotNull
    public static String getLogStringGitDiffChanges(@NotNull @NonNls String root, @NotNull Collection<? extends GitChangeUtils.GitDiffChange> changes) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(121);
        }
        if (changes == null) {
            GitUtil.$$$reportNull$$$0(122);
        }
        return GitUtil.getLogString(root, changes, it -> it.getBeforePath(), it -> it.getAfterPath());
    }

    @NonNls
    @NotNull
    public static String getLogString(@NotNull @NonNls String root, @NotNull Collection<? extends Change> changes) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(123);
        }
        if (changes == null) {
            GitUtil.$$$reportNull$$$0(124);
        }
        return GitUtil.getLogString(root, changes, ChangesUtil::getBeforePath, ChangesUtil::getAfterPath);
    }

    @NonNls
    @NotNull
    public static <T> String getLogString(@NotNull @NonNls String root, @NotNull Collection<? extends T> changes, @NotNull Convertor<? super T, ? extends FilePath> beforePathGetter, @NotNull Convertor<? super T, ? extends FilePath> afterPathGetter) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(125);
        }
        if (changes == null) {
            GitUtil.$$$reportNull$$$0(126);
        }
        if (beforePathGetter == null) {
            GitUtil.$$$reportNull$$$0(127);
        }
        if (afterPathGetter == null) {
            GitUtil.$$$reportNull$$$0(128);
        }
        String string = StringUtil.join(changes, change -> {
            FilePath after = (FilePath)afterPathGetter.convert(change);
            FilePath before = (FilePath)beforePathGetter.convert(change);
            if (before == null) {
                return "A: " + GitUtil.getRelativePath(root, after);
            }
            if (after == null) {
                return "D: " + GitUtil.getRelativePath(root, before);
            }
            if (ChangesUtil.equalsCaseSensitive((FilePath)before, (FilePath)after)) {
                return "M: " + GitUtil.getRelativePath(root, after);
            }
            return "R: " + GitUtil.getRelativePath(root, before) + " -> " + GitUtil.getRelativePath(root, after);
        }, (String)", ");
        if (string == null) {
            GitUtil.$$$reportNull$$$0(129);
        }
        return string;
    }

    @Nullable
    public static String getRelativePath(@NotNull String root, @NotNull FilePath after) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(130);
        }
        if (after == null) {
            GitUtil.$$$reportNull$$$0(131);
        }
        return FileUtil.getRelativePath((String)root, (String)after.getPath(), (char)File.separatorChar);
    }

    @NotNull
    public static Collection<Change> findCorrespondentLocalChanges(@NotNull ChangeListManager changeListManager, @NotNull Collection<? extends Change> originalChanges) {
        if (changeListManager == null) {
            GitUtil.$$$reportNull$$$0(132);
        }
        if (originalChanges == null) {
            GitUtil.$$$reportNull$$$0(133);
        }
        ObjectOpenHashSet allChanges = new ObjectOpenHashSet(changeListManager.getAllChanges());
        List list = ContainerUtil.mapNotNull(originalChanges, arg_0 -> ((ObjectOpenHashSet)allChanges).get(arg_0));
        if (list == null) {
            GitUtil.$$$reportNull$$$0(134);
        }
        return list;
    }

    public static void refreshVfs(@NotNull VirtualFile root, @Nullable Collection<? extends Change> changes) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(135);
        }
        if (changes == null || Registry.is((String)"git.refresh.vfs.total")) {
            GitUtil.refreshVfsInRoot(root);
        } else {
            RefreshVFsSynchronously.updateChanges(changes);
            SaveAndSyncHandler.getInstance().refreshOpenFiles();
        }
    }

    public static void refreshVfsInRoot(@NotNull VirtualFile root) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(136);
        }
        GitUtil.refreshVfsInRoots(Collections.singleton(root));
    }

    public static void refreshVfsInRoots(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            GitUtil.$$$reportNull$$$0(137);
        }
        RefreshVFsSynchronously.trace((String)("refresh roots " + String.valueOf(roots)));
        RefreshVFsSynchronously.refreshVirtualFilesRecursive(roots);
    }

    public static void updateAndRefreshChangedVfs(@NotNull GitRepository repository2, @Nullable Hash startHash) {
        if (repository2 == null) {
            GitUtil.$$$reportNull$$$0(138);
        }
        repository2.update();
        GitUtil.refreshChangedVfs(repository2, startHash);
    }

    public static void refreshChangedVfs(@NotNull GitRepository repository2, @Nullable Hash startHash) {
        Hash currentHash;
        if (repository2 == null) {
            GitUtil.$$$reportNull$$$0(139);
        }
        Collection<Change> changes = null;
        if (startHash != null && (currentHash = GitUtil.getHead(repository2)) != null) {
            RefreshVFsSynchronously.trace((String)String.format("changes: %s -> %s", startHash.asString(), currentHash.asString()));
            changes = GitChangeUtils.getDiff(repository2, startHash.asString(), currentHash.asString(), false);
        }
        GitUtil.refreshVfs(repository2.getRoot(), changes);
    }

    @ApiStatus.Obsolete
    public static boolean isGitRoot(@NotNull Path rootDir) {
        if (rootDir == null) {
            GitUtil.$$$reportNull$$$0(140);
        }
        return GitUtil.findGitDir(rootDir) != null;
    }

    @ApiStatus.Obsolete
    @Nullable
    public static Path findGitDir(@NotNull Path rootDir) {
        String content;
        BasicFileAttributes attributes;
        if (rootDir == null) {
            GitUtil.$$$reportNull$$$0(141);
        }
        Path dotGit = rootDir.resolve(DOT_GIT);
        try {
            attributes = Files.readAttributes(dotGit, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException ignore) {
            return null;
        }
        if (attributes.isDirectory()) {
            try {
                BasicFileAttributes headExists = Files.readAttributes(dotGit.resolve("HEAD"), BasicFileAttributes.class, new LinkOption[0]);
                if (headExists.isRegularFile()) {
                    return dotGit;
                }
                return null;
            }
            catch (IOException ignore) {
                return null;
            }
        }
        if (!attributes.isRegularFile()) {
            return null;
        }
        try {
            content = (String)DvcsUtil.tryOrThrow(() -> StringUtil.convertLineSeparators((String)Files.readString(dotGit)).trim(), (Object)dotGit);
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            return null;
        }
        String pathToDir = GitUtil.parsePathToRepository(content);
        if (pathToDir == null) {
            return null;
        }
        return GitUtil.findRealRepositoryDir(rootDir, pathToDir);
    }

    public static void generateGitignoreFileIfNeeded(@NotNull Project project, @NotNull VirtualFile ignoreFileRoot) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(142);
        }
        if (ignoreFileRoot == null) {
            GitUtil.$$$reportNull$$$0(143);
        }
        VcsImplUtil.generateIgnoreFileIfNeeded((Project)project, (AbstractVcs)GitVcs.getInstance(project), (VirtualFile)ignoreFileRoot);
    }

    public static <T extends Throwable> void tryRunOrClose(@NotNull AutoCloseable closeable, @NotNull ThrowableRunnable<T> runnable) throws T {
        if (closeable == null) {
            GitUtil.$$$reportNull$$$0(144);
        }
        if (runnable == null) {
            GitUtil.$$$reportNull$$$0(145);
        }
        try {
            runnable.run();
        }
        catch (Throwable e) {
            try {
                closeable.close();
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    @NotNull
    public static <T extends GitHandler> T createHandlerWithPaths(@Nullable Collection<? extends FilePath> paths, @NotNull Computable<T> handlerBuilder) {
        if (handlerBuilder == null) {
            GitUtil.$$$reportNull$$$0(146);
        }
        GitHandler handler = (GitHandler)handlerBuilder.compute();
        handler.endOptions();
        if (paths != null) {
            handler.addRelativePaths(paths);
            if (handler.isLargeCommandLine()) {
                handler = (GitHandler)handlerBuilder.compute();
                handler.endOptions();
            }
        }
        GitHandler gitHandler = handler;
        if (gitHandler == null) {
            GitUtil.$$$reportNull$$$0(147);
        }
        return (T)gitHandler;
    }

    @Nullable
    public static Hash getHead(@NotNull GitRepository repository2) {
        GitCommandResult result2;
        if (repository2 == null) {
            GitUtil.$$$reportNull$$$0(148);
        }
        if (!(result2 = Git.getInstance().tip(repository2, "HEAD")).success()) {
            LOG.warn("Couldn't identify the HEAD for " + String.valueOf(repository2) + ": " + result2.getErrorOutputAsJoinedString());
            return null;
        }
        String head = result2.getOutputAsJoinedString();
        return HashImpl.build((String)head);
    }

    public static boolean isHashString(@NotNull @NonNls String revision) {
        if (revision == null) {
            GitUtil.$$$reportNull$$$0(149);
        }
        return GitUtil.isHashString(revision, true);
    }

    public static boolean isHashString(@NotNull @NonNls String revision, boolean fullHashOnly) {
        if (revision == null) {
            GitUtil.$$$reportNull$$$0(150);
        }
        if (fullHashOnly) {
            return HASH_STRING_PATTERN.matcher(revision).matches();
        }
        return VcsLogUtil.HASH_REGEX.matcher(revision).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 17, 20, 25, 28, 31, 38, 40, 50, 54, 57, 62, 63, 65, 68, 71, 74, 79, 80, 83, 84, 89, 92, 96, 104, 108, 111, 115, 118, 129, 134, 147 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newObjectId";
                break;
            }
            case 2: 
            case 140: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 4: 
            case 32: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dotGit";
                break;
            }
            case 7: 
            case 67: 
            case 70: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 29: 
            case 36: 
            case 64: 
            case 66: 
            case 69: 
            case 72: 
            case 75: 
            case 77: 
            case 81: 
            case 93: 
            case 97: 
            case 100: 
            case 113: 
            case 114: 
            case 116: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 19: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 12: 
            case 17: 
            case 20: 
            case 25: 
            case 28: 
            case 31: 
            case 38: 
            case 40: 
            case 50: 
            case 54: 
            case 57: 
            case 62: 
            case 63: 
            case 65: 
            case 68: 
            case 71: 
            case 74: 
            case 79: 
            case 80: 
            case 83: 
            case 84: 
            case 89: 
            case 92: 
            case 96: 
            case 104: 
            case 108: 
            case 111: 
            case 115: 
            case 118: 
            case 129: 
            case 134: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitUtil";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameAtRemote";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullBranchName";
                break;
            }
            case 52: 
            case 105: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotes";
                break;
            }
            case 53: 
            case 107: 
            case 110: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 56: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeRef";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterRef";
                break;
            }
            case 73: 
            case 76: 
            case 87: 
            case 90: 
            case 94: 
            case 121: 
            case 123: 
            case 125: 
            case 130: 
            case 135: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePath";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedPaths";
                break;
            }
            case 98: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePaths";
                break;
            }
            case 99: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 122: 
            case 124: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforePathGetter";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterPathGetter";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalChanges";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreFileRoot";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeable";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerBuilder";
                break;
            }
            case 149: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilesByGitRootIgnoringMissing";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilePathsByGitRootIgnoringMissing";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilesByGitRoot";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilesByRepositoryIgnoringMissing";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilesByRepository";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilePathsByGitRoot";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoriesForFiles";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapePath";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateRemoteBranch";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsFromRepositories";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoriesFromRoots";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsDiffBetweenRefs";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryManager";
                break;
            }
            case 68: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryForFile";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryForRoot";
                break;
            }
            case 79: 
            case 80: 
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootForFile";
                break;
            }
            case 89: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "toAbsolute";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "findLocalChangesForPaths";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanupErrorPrefixes";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "joinToHtml";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "mention";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoriesInStates";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogString";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "findCorrespondentLocalChanges";
                break;
            }
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandlerWithPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateHead";
                break;
            }
            case 2: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "findGitDir";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRealRepositoryDir";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parsePathToRepository";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readContent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readFile";
                break;
            }
            case 8: 
            case 9: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sortFilesByGitRoot";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sortFilesByGitRootIgnoringMissing";
                break;
            }
            case 12: 
            case 17: 
            case 20: 
            case 25: 
            case 28: 
            case 31: 
            case 38: 
            case 40: 
            case 50: 
            case 54: 
            case 57: 
            case 62: 
            case 63: 
            case 65: 
            case 68: 
            case 71: 
            case 74: 
            case 79: 
            case 80: 
            case 83: 
            case 84: 
            case 89: 
            case 92: 
            case 96: 
            case 104: 
            case 108: 
            case 111: 
            case 115: 
            case 118: 
            case 129: 
            case 134: 
            case 147: {
                break;
            }
            case 13: 
            case 14: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "sortFilePathsByGitRoot";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sortFilePathsByGitRootIgnoringMissing";
                break;
            }
            case 21: 
            case 22: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "sortFilesByRepository";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sortFilesByRepositoryIgnoringMissing";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findGitRootFor";
                break;
            }
            case 33: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "isGitRoot";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isUnderGit";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoriesForFiles";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "unescapePath";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteByName";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteBranch";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateRemoteBranch";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "parseRemoteBranch";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getRootsFromRepositories";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoriesFromRoots";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getPathsDiffBetweenRefs";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryManager";
                break;
            }
            case 66: 
            case 67: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForFile";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForRoot";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForRootOrLogError";
                break;
            }
            case 77: 
            case 78: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getRootForFile";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getTrackInfoForCurrentBranch";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "findRefreshFileOrLog";
                break;
            }
            case 87: 
            case 88: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "toAbsolute";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "findLocalChangesForPaths";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "showPathsInDialog";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "cleanupErrorPrefixes";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRemote";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultOrFirstRemote";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "joinToHtml";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "mention";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "updateRepositories";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "hasGitRepositories";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoriesInStates";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "isCaseOnlyChange";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getLogStringGitDiffChanges";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "getLogString";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "findCorrespondentLocalChanges";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "refreshVfs";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "refreshVfsInRoot";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "refreshVfsInRoots";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "updateAndRefreshChangedVfs";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "refreshChangedVfs";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "generateGitignoreFileIfNeeded";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "tryRunOrClose";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "createHandlerWithPaths";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "getHead";
                break;
            }
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "isHashString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 17, 20, 25, 28, 31, 38, 40, 50, 54, 57, 62, 63, 65, 68, 71, 74, 79, 80, 83, 84, 89, 92, 96, 104, 108, 111, 115, 118, 129, 134, 147 -> new IllegalStateException(string);
        };
    }

    private static final class GitRepositoryNotFoundException
    extends VcsException {
        private GitRepositoryNotFoundException(@NotNull VirtualFile file) {
            if (file == null) {
                GitRepositoryNotFoundException.$$$reportNull$$$0(0);
            }
            super(GitBundle.message("repository.not.found.error", file.getPresentableUrl()));
        }

        private GitRepositoryNotFoundException(@NotNull FilePath filePath) {
            if (filePath == null) {
                GitRepositoryNotFoundException.$$$reportNull$$$0(1);
            }
            super(GitBundle.message("repository.not.found.error", filePath.getPresentableUrl()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePath";
                    break;
                }
            }
            objectArray[1] = "git4idea/GitUtil$GitRepositoryNotFoundException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

