/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure;

import java.io.BufferedWriter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCacheStorage;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure.LLSessionStructureGraph;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure.LLSessionStructureGraphBuilder;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure.LLSessionStructureGraphNode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStructureWriter;", "", "<init>", "()V", "writeSessionStructure", "", "storage", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCacheStorage;", "analysisRoots", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "writer", "Ljava/io/BufferedWriter;", "writeGraph", "graph", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStructureGraph;", "escapeXml", "", "text", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLSessionStructureWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLSessionStructureWriter.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStructureWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1915#2:108\n1915#2,2:109\n1916#2:111\n*S KotlinDebug\n*F\n+ 1 LLSessionStructureWriter.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStructureWriter\n*L\n72#1:108\n87#1:109,2\n72#1:111\n*E\n"})
public final class LLSessionStructureWriter {
    @NotNull
    public static final LLSessionStructureWriter INSTANCE = new LLSessionStructureWriter();

    private LLSessionStructureWriter() {
    }

    public final void writeSessionStructure(@NotNull LLFirSessionCacheStorage storage, @NotNull List<? extends LLFirSession> analysisRoots, @NotNull BufferedWriter writer) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(analysisRoots, (String)"analysisRoots");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        LLSessionStructureGraph graph = LLSessionStructureGraphBuilder.INSTANCE.buildGraph(storage, analysisRoots);
        this.writeGraph(graph, writer);
    }

    private final void writeGraph(LLSessionStructureGraph graph, BufferedWriter writer) {
        BufferedWriter $this$writeGraph_u24lambda_u240 = writer;
        boolean bl = false;
        ((Appendable)$this$writeGraph_u24lambda_u240).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append('\n');
        ((Appendable)$this$writeGraph_u24lambda_u240).append("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"").append('\n');
        ((Appendable)$this$writeGraph_u24lambda_u240).append("         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append('\n');
        ((Appendable)$this$writeGraph_u24lambda_u240).append("         xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">").append('\n');
        ((Appendable)$this$writeGraph_u24lambda_u240).append("  <key id=\"label\" for=\"node\" attr.name=\"label\" attr.type=\"string\"/>").append('\n');
        ((Appendable)$this$writeGraph_u24lambda_u240).append("  <key id=\"uuid\" for=\"node\" attr.name=\"uuid\" attr.type=\"string\"/>").append('\n');
        ((Appendable)$this$writeGraph_u24lambda_u240).append("  <key id=\"weight\" for=\"node\" attr.name=\"weight\" attr.type=\"long\"/>").append('\n');
        ((Appendable)$this$writeGraph_u24lambda_u240).append("  <key id=\"kotlinWeight\" for=\"node\" attr.name=\"kotlinWeight\" attr.type=\"long\"/>").append('\n');
        ((Appendable)$this$writeGraph_u24lambda_u240).append("  <key id=\"javaWeight\" for=\"node\" attr.name=\"javaWeight\" attr.type=\"long\"/>").append('\n');
        ((Appendable)$this$writeGraph_u24lambda_u240).append("  <key id=\"lifetime\" for=\"node\" attr.name=\"lifetime\" attr.type=\"double\"/>").append('\n');
        ((Appendable)$this$writeGraph_u24lambda_u240).append("  <key id=\"analysisRootDistance\" for=\"node\" attr.name=\"analysisRootDistance\" attr.type=\"int\"/>").append('\n');
        ((Appendable)$this$writeGraph_u24lambda_u240).append("  <graph id=\"SessionWeightGraph\" edgedefault=\"directed\">").append('\n');
        Iterable $this$forEach$iv = graph.getNodesBySession().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LLSessionStructureGraphNode node = (LLSessionStructureGraphNode)element$iv;
            boolean bl2 = false;
            if (!node.isSignificant()) continue;
            ((Appendable)$this$writeGraph_u24lambda_u240).append("    <node id=\"n" + node.getId() + "\">").append('\n');
            ((Appendable)$this$writeGraph_u24lambda_u240).append("      <data key=\"label\">" + INSTANCE.escapeXml(node.getLabel()) + "</data>").append('\n');
            ((Appendable)$this$writeGraph_u24lambda_u240).append("      <data key=\"uuid\">" + INSTANCE.escapeXml(node.getSession().getUuid().toHexDashString()) + "</data>").append('\n');
            ((Appendable)$this$writeGraph_u24lambda_u240).append("      <data key=\"weight\">" + node.getStatistics().getWeight() + "</data>").append('\n');
            ((Appendable)$this$writeGraph_u24lambda_u240).append("      <data key=\"kotlinWeight\">" + node.getStatistics().getKotlinWeight() + "</data>").append('\n');
            ((Appendable)$this$writeGraph_u24lambda_u240).append("      <data key=\"javaWeight\">" + node.getStatistics().getJavaWeight() + "</data>").append('\n');
            ((Appendable)$this$writeGraph_u24lambda_u240).append("      <data key=\"lifetime\">" + node.getStatistics().getLifetime() + "</data>").append('\n');
            Integer n = node.getAnalysisRootDistance();
            if (n != null) {
                int distance = ((Number)n).intValue();
                boolean bl3 = false;
                ((Appendable)$this$writeGraph_u24lambda_u240).append("      <data key=\"analysisRootDistance\">" + distance + "</data>").append('\n');
            }
            ((Appendable)$this$writeGraph_u24lambda_u240).append("    </node>").append('\n');
            Iterable $this$forEach$iv2 = node.getDependencies();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                LLSessionStructureGraphNode dependencyNode = (LLSessionStructureGraphNode)element$iv2;
                boolean bl4 = false;
                if (!dependencyNode.isSignificant()) continue;
                ((Appendable)$this$writeGraph_u24lambda_u240).append("    <edge source=\"n" + node.getId() + "\" target=\"n" + dependencyNode.getId() + "\"/>").append('\n');
            }
        }
        ((Appendable)$this$writeGraph_u24lambda_u240).append("  </graph>").append('\n');
        ((Appendable)$this$writeGraph_u24lambda_u240).append("</graphml>").append('\n');
    }

    private final String escapeXml(String text) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null), (String)"\"", (String)"&quot;", (boolean)false, (int)4, null), (String)"'", (String)"&apos;", (boolean)false, (int)4, null);
    }
}

