/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirOptInAnnotationClassChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirRetentionAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.resolve.checkers.OptInDescription;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInAnnotationClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "checkers"})
public final class FirOptInAnnotationClassChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirOptInAnnotationClassChecker INSTANCE = new FirOptInAnnotationClassChecker();

    private FirOptInAnnotationClassChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration) {
        Set wrongTargets;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        FirSession session2 = context2.getSession();
        if (FirAnnotationUtilsKt.getAnnotationByClassId(declaration, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), session2) == null) {
            return;
        }
        if (FirRetentionAnnotationHelpersKt.getRetention(declaration, session2) == AnnotationRetention.SOURCE) {
            FirAnnotation target = FirRetentionAnnotationHelpersKt.getRetentionAnnotation(declaration, session2);
            FirAnnotation firAnnotation = target;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)(firAnnotation != null ? firAnnotation.getSource() : null)), (KtDiagnosticFactory0)FirErrors.INSTANCE.getOPT_IN_MARKER_WITH_WRONG_RETENTION(), null, (int)8, null);
        }
        if (!((Collection)(wrongTargets = CollectionsKt.intersect((Iterable)FirAnnotationHelpersKt.getAllowedAnnotationTargets(declaration, session2), (Iterable)OptInDescription.Companion.getWRONG_TARGETS_FOR_MARKER()))).isEmpty()) {
            FirAnnotation target = FirAnnotationHelpersKt.getTargetAnnotation(declaration, session2);
            FirAnnotation firAnnotation = target;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)(firAnnotation != null ? firAnnotation.getSource() : null)), FirErrors.INSTANCE.getOPT_IN_MARKER_WITH_WRONG_TARGET(), (Object)CollectionsKt.joinToString$default((Iterable)wrongTargets, null, null, null, (int)0, null, (Function1)((Function1)check.1.INSTANCE), (int)31, null), null, (int)16, null);
        }
    }
}

