/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u000e\u001a\u00020\u000f*\u00020\u0012H\u0002R\u00020\u0010j\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSealedClassConstructorCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "isAllowedJavaNonAbstractSealedClass", "", "Lorg/jetbrains/kotlin/fir/SessionHolder;", "c", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lorg/jetbrains/kotlin/fir/SessionHolder;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)Z", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSealedClassConstructorCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSealedClassConstructorCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSealedClassConstructorCallChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,47:1\n44#2:48\n*S KotlinDebug\n*F\n+ 1 FirSealedClassConstructorCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSealedClassConstructorCallChecker\n*L\n36#1:48\n*E\n"})
public final class FirSealedClassConstructorCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSealedClassConstructorCallChecker INSTANCE = new FirSealedClassConstructorCallChecker();

    private FirSealedClassConstructorCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression) {
        FirRegularClassSymbol firRegularClassSymbol;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        FirConstructorSymbol firConstructorSymbol = FirReferenceUtilsKt.toResolvedConstructorSymbol(expression.getCalleeReference(), true);
        if (firConstructorSymbol == null) {
            return;
        }
        FirConstructorSymbol constructorSymbol = firConstructorSymbol;
        ConeClassLikeLookupTag coneClassLikeLookupTag = ConeTypeUtilsKt.getClassLikeLookupTagIfAny(TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, constructorSymbol.getResolvedReturnTypeRef().getConeType()));
        if (coneClassLikeLookupTag == null || (firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, coneClassLikeLookupTag)) == null) {
            return;
        }
        FirRegularClassSymbol typeSymbol = firRegularClassSymbol;
        FirClassLikeSymbol $this$modality$iv = typeSymbol;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getResolvedStatus().getModality() == Modality.SEALED && !this.isAllowedJavaNonAbstractSealedClass(context2, typeSymbol)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getSEALED_CLASS_CONSTRUCTOR_CALL(), null, (int)8, null);
        }
    }

    private final boolean isAllowedJavaNonAbstractSealedClass(SessionHolder c, FirRegularClassSymbol $this$isAllowedJavaNonAbstractSealedClass) {
        return Intrinsics.areEqual((Object)ClassMembersKt.isJavaNonAbstractSealed((FirRegularClass)$this$isAllowedJavaNonAbstractSealedClass.getFir()), (Object)true) && LanguageVersionUtilsKt.isEnabled(c, LanguageFeature.AllowCallingJavaOpenSealedClassConstructor);
    }
}

