/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmSuspensionPointInsideMutexLockChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "synchronizedCallableId", "Lorg/jetbrains/kotlin/name/CallableId;", "withLockCallableId", "synchronizedBlockParamName", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmSuspensionPointInsideMutexLockChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmSuspensionPointInsideMutexLockChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmSuspensionPointInsideMutexLockChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,79:1\n35#2:80\n71#3,4:81\n233#4:85\n54#5:86\n*S KotlinDebug\n*F\n+ 1 FirJvmSuspensionPointInsideMutexLockChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmSuspensionPointInsideMutexLockChecker\n*L\n36#1:80\n44#1:81,4\n46#1:85\n62#1:86\n*E\n"})
public final class FirJvmSuspensionPointInsideMutexLockChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirJvmSuspensionPointInsideMutexLockChecker INSTANCE = new FirJvmSuspensionPointInsideMutexLockChecker();
    @NotNull
    private static final CallableId synchronizedCallableId;
    @NotNull
    private static final CallableId withLockCallableId;
    @NotNull
    private static final Name synchronizedBlockParamName;

    private FirJvmSuspensionPointInsideMutexLockChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression) {
        FirCallableSymbol symbol;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol $this$isSuspend$iv = symbol = firCallableSymbol;
        boolean $i$f$isSuspend = false;
        if (!$this$isSuspend$iv.getRawStatus().isSuspend()) {
            return;
        }
        FirElement anonymousFunctionArg = null;
        boolean isMutexLockFound = false;
        boolean isSuspendFunctionFound = false;
        for (FirElement element : CollectionsKt.asReversed(context2.getContainingElements())) {
            block18: {
                block20: {
                    FirCallableSymbol callableSymbol;
                    block19: {
                        FirValueParameter enclosingAnonymousFuncParam;
                        FirValueParameter firValueParameter;
                        block17: {
                            if (!(element instanceof FirFunctionCall)) break block18;
                            if (FirReferenceUtilsKt.toResolvedCallableSymbol$default(((FirFunctionCall)element).getCalleeReference(), false, 1, null) == null) continue;
                            FirCall $this$resolvedArgumentMapping$iv = (FirCall)element;
                            boolean $i$f$getResolvedArgumentMapping = false;
                            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
                            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
                            if (linkedHashMap != null) {
                                for (Map.Entry entry : ((Map)linkedHashMap).entrySet()) {
                                    FirValueParameter firValueParameter2;
                                    FirValueParameter firValueParameter3;
                                    boolean bl = false;
                                    if (FirExpressionUtilKt.unwrapAnonymousFunctionExpression((FirExpression)entry.getKey()) != null) {
                                        FirAnonymousFunction it;
                                        boolean bl2 = false;
                                        boolean condition$iv = Intrinsics.areEqual((Object)it, (Object)anonymousFunctionArg);
                                        boolean $i$f$runIf = false;
                                        if (condition$iv) {
                                            boolean bl3 = false;
                                            firValueParameter3 = (FirValueParameter)entry.getValue();
                                        } else {
                                            firValueParameter3 = null;
                                        }
                                    } else {
                                        firValueParameter3 = null;
                                    }
                                    if ((firValueParameter2 = firValueParameter3) == null) continue;
                                    firValueParameter = firValueParameter2;
                                    break block17;
                                }
                                firValueParameter = null;
                            } else {
                                firValueParameter = null;
                            }
                        }
                        FirValueParameter firValueParameter4 = enclosingAnonymousFuncParam = firValueParameter;
                        FirTypeRef firTypeRef = firValueParameter4 != null ? firValueParameter4.getReturnTypeRef() : null;
                        Object object = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
                        boolean bl = object != null && (object = ((FirResolvedTypeRef)object).getConeType()) != null ? FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType((ConeKotlinType)object, context2.getSession()) : false;
                        if (bl) {
                            isSuspendFunctionFound = true;
                            break;
                        }
                        if (!Intrinsics.areEqual((Object)callableSymbol.getCallableId(), (Object)synchronizedCallableId)) break block19;
                        FirValueParameter firValueParameter5 = enclosingAnonymousFuncParam;
                        if (Intrinsics.areEqual((Object)(firValueParameter5 != null ? firValueParameter5.getName() : null), (Object)synchronizedBlockParamName)) break block20;
                    }
                    if (!Intrinsics.areEqual((Object)callableSymbol.getCallableId(), (Object)withLockCallableId)) continue;
                }
                isMutexLockFound = true;
                continue;
            }
            if (!(element instanceof FirFunction)) continue;
            FirMemberDeclaration $this$isSuspend$iv2 = (FirMemberDeclaration)element;
            boolean $i$f$isSuspend2 = false;
            if ($this$isSuspend$iv2.getStatus().isSuspend()) {
                isSuspendFunctionFound = true;
                break;
            }
            if (!(element instanceof FirAnonymousFunction)) continue;
            anonymousFunctionArg = element;
        }
        if (isMutexLockFound && isSuspendFunctionFound) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), FirJvmErrors.INSTANCE.getSUSPENSION_POINT_INSIDE_CRITICAL_SECTION(), (Object)symbol, null, (int)16, null);
        }
    }

    static {
        FqName fqName2 = new FqName("kotlin");
        Name name2 = Name.identifier((String)"synchronized");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        synchronizedCallableId = new CallableId(fqName2, name2);
        FqName fqName3 = new FqName("kotlin.concurrent");
        Name name3 = Name.identifier((String)"withLock");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        withLockCallableId = new CallableId(fqName3, name3);
        Name name4 = Name.identifier((String)"block");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        synchronizedBlockParamName = name4;
    }
}

