/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.debugger.core.CodeFragmentContextTuner;
import org.jetbrains.kotlin.idea.debugger.core.KotlinEditorTextProvider;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/K1CodeFragmentContextTuner;", "Lorg/jetbrains/kotlin/idea/debugger/core/CodeFragmentContextTuner;", "<init>", "()V", "tuneContextElement", "Lcom/intellij/psi/PsiElement;", "element", "getAccurateContextElement", "elementAt", "containingFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getElementSkippingWhitespaces", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCodeFragmentContextTuner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFragmentContextTuner.kt\norg/jetbrains/kotlin/idea/debugger/core/K1CodeFragmentContextTuner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,174:1\n1#2:175\n183#3,2:176\n*S KotlinDebug\n*F\n+ 1 CodeFragmentContextTuner.kt\norg/jetbrains/kotlin/idea/debugger/core/K1CodeFragmentContextTuner\n*L\n157#1:176,2\n*E\n"})
public final class K1CodeFragmentContextTuner
implements CodeFragmentContextTuner {
    @Override
    @Nullable
    public PsiElement tuneContextElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiCodeBlock) {
            PsiElement psiElement = ((PsiCodeBlock)element).getContext();
            return this.tuneContextElement((PsiElement)(psiElement != null ? psiElement.getContext() : null));
        }
        if (element instanceof KtLightClass) {
            return this.tuneContextElement((PsiElement)((KtLightClass)element).getKotlinOrigin());
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof PsiJavaFile) {
            return element;
        }
        if (!(containingFile instanceof KtFile)) {
            return null;
        }
        PsiElement accurateElement = this.getAccurateContextElement(element, (KtFile)containingFile);
        if (accurateElement != null) {
            return accurateElement;
        }
        return (PsiElement)containingFile;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement getAccurateContextElement(PsiElement elementAt, KtFile containingFile) {
        PsiElement elementAtSkippingWhitespaces = this.getElementSkippingWhitespaces(elementAt);
        if (elementAtSkippingWhitespaces instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)elementAtSkippingWhitespaces).getElementType(), (Object)KtTokens.RBRACE)) {
            PsiElement declarationParent;
            KtClassOrObject classOrObject;
            KtClassBody classBody;
            PsiElement psiElement = ((LeafPsiElement)elementAtSkippingWhitespaces).getParent();
            KtClassBody ktClassBody = classBody = psiElement instanceof KtClassBody ? (KtClassBody)psiElement : null;
            PsiElement psiElement2 = ktClassBody != null ? ktClassBody.getParent() : null;
            KtClassOrObject ktClassOrObject = classOrObject = psiElement2 instanceof KtClassOrObject ? (KtClassOrObject)psiElement2 : null;
            Object object = declarationParent = ktClassOrObject != null ? ktClassOrObject.getParent() : null;
            if (declarationParent instanceof KtObjectLiteralExpression) {
                declarationParent = ((KtObjectLiteralExpression)declarationParent).getParent();
            }
            if (declarationParent != null) {
                return this.getAccurateContextElement(declarationParent, containingFile);
            }
        }
        int lineStartOffset = elementAtSkippingWhitespaces.getTextOffset();
        KtExpression targetExpression = (KtExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)((PsiFile)containingFile), (int)lineStartOffset, KtExpression.class, (boolean)false);
        KotlinEditorTextProvider editorTextProvider = KotlinEditorTextProvider.Companion.getInstance();
        if (targetExpression != null) {
            Object v3;
            PsiElement psiElement;
            block8: {
                void $this$firstOrNull$iv;
                if (editorTextProvider.isAcceptedAsCodeFragmentContext((PsiElement)targetExpression)) {
                    return (PsiElement)targetExpression;
                }
                psiElement = editorTextProvider.findEvaluationTarget(elementAt, true);
                if (psiElement != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    return it;
                }
                Sequence sequence = PsiTreeUtilKt.parents((PsiElement)((PsiElement)targetExpression), (boolean)false);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!editorTextProvider.isAcceptedAsCodeFragmentContext(it)) continue;
                    v3 = element$iv;
                    break block8;
                }
                v3 = null;
            }
            psiElement = v3;
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    private final PsiElement getElementSkippingWhitespaces(PsiElement elementAt) {
        Class[] classArray;
        PsiElement newElement2;
        if ((elementAt instanceof PsiWhiteSpace || elementAt instanceof PsiComment) && (newElement2 = PsiTreeUtil.skipSiblingsForward((PsiElement)elementAt, (Class[])(classArray = new Class[]{PsiWhiteSpace.class, PsiComment.class}))) != null) {
            return newElement2;
        }
        return elementAt;
    }
}

