/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.filter;

import com.intellij.debugger.engine.SyntheticTypeComponentProvider;
import com.intellij.debugger.impl.DexDebugFacility;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DexBytecodeInspector;
import org.jetbrains.kotlin.idea.debugger.core.filter.KotlinSyntheticTypeComponentProviderKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u000f\u0010\t\u001a\u00020\u0005*\u0004\u0018\u00010\nH\u0082\u0010J\f\u0010\u000b\u001a\u00020\u0005*\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/filter/KotlinSyntheticTypeComponentProvider;", "Lcom/intellij/debugger/engine/SyntheticTypeComponentProvider;", "<init>", "()V", "isSynthetic", "", "typeComponent", "Lcom/sun/jdi/TypeComponent;", "isNotSynthetic", "isCallableReferenceSyntheticClass", "Lcom/sun/jdi/ReferenceType;", "isDelegateToDefaultInterfaceImpl", "Lcom/sun/jdi/Method;", "hasOnlyInvokeStatic", "m", "hasOnlyInvokeStaticJVM", "hasInterfaceWithImplementation", "method", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinSyntheticTypeComponentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSyntheticTypeComponentProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/filter/KotlinSyntheticTypeComponentProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1761#2,3:159\n1761#2,3:162\n1374#2:165\n1460#2,5:166\n1761#2,3:171\n*S KotlinDebug\n*F\n+ 1 KotlinSyntheticTypeComponentProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/filter/KotlinSyntheticTypeComponentProvider\n*L\n40#1:159,3\n44#1:162,3\n149#1:165\n149#1:166,5\n150#1:171,3\n*E\n"})
public final class KotlinSyntheticTypeComponentProvider
implements SyntheticTypeComponentProvider {
    public boolean isSynthetic(@Nullable TypeComponent typeComponent) {
        if (!(typeComponent instanceof Method)) {
            return false;
        }
        if (KotlinPositionManagerKt.isGeneratedErasedLambdaMethod((Method)typeComponent)) {
            return true;
        }
        ReferenceType containingType = ((Method)typeComponent).declaringType();
        String typeName = containingType.name();
        if (!FqNameUnsafe.Companion.isValid(typeName)) {
            return false;
        }
        if (this.isCallableReferenceSyntheticClass(containingType)) {
            return true;
        }
        try {
            boolean bl;
            block17: {
                Location it;
                boolean bl2;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block16: {
                    if (this.isDelegateToDefaultInterfaceImpl((Method)typeComponent)) {
                        return true;
                    }
                    Location location = ((Method)typeComponent).location();
                    if (!(location != null ? location.lineNumber() == 1 : false)) {
                        return false;
                    }
                    List<Location> list2 = ((Method)typeComponent).allLineLocations();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"allLineLocations(...)");
                    $this$any$iv = list2;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Location)element$iv;
                            boolean bl3 = false;
                            if (!(it.lineNumber() != 1)) continue;
                            bl2 = true;
                            break block16;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return false;
                }
                ReferenceType referenceType = ((Method)typeComponent).declaringType();
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
                $this$any$iv = SafeUtilKt.safeAllLineLocations(referenceType);
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Location)element$iv;
                        boolean bl4 = false;
                        if (!(it.lineNumber() != 1)) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            return !bl;
        }
        catch (AbsentInformationException e) {
            return false;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    public boolean isNotSynthetic(@Nullable TypeComponent typeComponent) {
        if (typeComponent instanceof Method) {
            String name2 = ((Method)typeComponent).name();
            Intrinsics.checkNotNull((Object)name2);
            if (StringsKt.endsWith$default((String)name2, (String)"$suspendImpl", (boolean)false, (int)2, null)) {
                Location location = ((Method)typeComponent).location();
                boolean bl = location != null ? DebuggerUtil.isInKotlinSources(location) : false;
                if (bl) {
                    ReferenceType containingClass = ((Method)typeComponent).declaringType();
                    List<String> list2 = ((Method)typeComponent).argumentTypeNames();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"argumentTypeNames(...)");
                    if (Intrinsics.areEqual((Object)CollectionsKt.firstOrNull(list2), (Object)containingClass.name())) {
                        return true;
                    }
                }
            } else {
                if (StringsKt.endsWith$default((String)name2, (String)"$default", (boolean)false, (int)2, null)) {
                    String originalName = StringsKt.dropLast((String)name2, (int)8);
                    List<Method> list3 = ((Method)typeComponent).declaringType().methodsByName(originalName);
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"methodsByName(...)");
                    return !((Collection)list3).isEmpty();
                }
                if (KotlinSteppingCommandProviderKt.isSyntheticMethodForDefaultParameters((Method)typeComponent)) {
                    return true;
                }
            }
        }
        return super.isNotSynthetic(typeComponent);
    }

    private final boolean isCallableReferenceSyntheticClass(ReferenceType $this$isCallableReferenceSyntheticClass) {
        KotlinSyntheticTypeComponentProvider kotlinSyntheticTypeComponentProvider = this;
        while (true) {
            ClassType superClass;
            if (!($this$isCallableReferenceSyntheticClass instanceof ClassType)) {
                return false;
            }
            if (((ClassType)$this$isCallableReferenceSyntheticClass).superclass() == null) {
                return false;
            }
            String superClassName = superClass.name();
            if (Intrinsics.areEqual((Object)superClassName, (Object)PropertyReference.class.getName()) || Intrinsics.areEqual((Object)superClassName, (Object)FunctionReference.class.getName())) {
                return true;
            }
            Intrinsics.checkNotNull((Object)superClassName);
            if (!StringsKt.startsWith$default((String)superClassName, (String)"kotlin.jvm.internal.", (boolean)false, (int)2, null)) break;
            $this$isCallableReferenceSyntheticClass = superClass;
        }
        return false;
    }

    private final boolean isDelegateToDefaultInterfaceImpl(Method $this$isDelegateToDefaultInterfaceImpl) {
        if (SafeUtilKt.safeAllLineLocations($this$isDelegateToDefaultInterfaceImpl).size() != 1) {
            return false;
        }
        if (!$this$isDelegateToDefaultInterfaceImpl.virtualMachine().canGetBytecodes()) {
            return false;
        }
        if (!this.hasOnlyInvokeStatic($this$isDelegateToDefaultInterfaceImpl)) {
            return false;
        }
        return this.hasInterfaceWithImplementation($this$isDelegateToDefaultInterfaceImpl);
    }

    private final boolean hasOnlyInvokeStatic(Method m) {
        VirtualMachine virtualMachine = m.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            DexBytecodeInspector dexBytecodeInspector = (DexBytecodeInspector)CollectionsKt.firstOrNull((List)DexBytecodeInspector.Companion.getEP$intellij_kotlin_jvm_debugger_core().getExtensionList());
            return dexBytecodeInspector != null ? dexBytecodeInspector.hasOnlyInvokeStatic(m) : false;
        }
        return this.hasOnlyInvokeStaticJVM(m);
    }

    private final boolean hasOnlyInvokeStaticJVM(Method m) {
        byte[] instructions = m.bytecodes();
        int i2 = 0;
        boolean isALoad0BeforeStaticCall = false;
        while (i2 < instructions.length) {
            int n;
            int n2;
            int n3;
            IntRange intRange;
            int instr;
            block11: {
                byte nextInstr;
                block10: {
                    instr = instructions[i2];
                    if (instr == 42) {
                        ++i2;
                        isALoad0BeforeStaticCall = true;
                        continue;
                    }
                    intRange = KotlinSyntheticTypeComponentProviderKt.access$getLOAD_INSTRUCTIONS_WITH_INDEX$p();
                    n3 = intRange.getFirst();
                    n2 = intRange.getLast();
                    n = instr;
                    if (n3 <= n ? n <= n2 : false) break block10;
                    intRange = KotlinSyntheticTypeComponentProviderKt.access$getLOAD_INSTRUCTIONS$p();
                    n3 = intRange.getFirst();
                    n2 = intRange.getLast();
                    n = instr;
                    boolean bl = n3 <= n ? n <= n2 : false;
                    if (!bl) break block11;
                }
                ++i2;
                intRange = KotlinSyntheticTypeComponentProviderKt.access$getLOAD_INSTRUCTIONS_WITH_INDEX$p();
                n3 = intRange.getFirst();
                n2 = intRange.getLast();
                n = instr;
                boolean bl = n3 <= n ? n <= n2 : false;
                if (bl) {
                    ++i2;
                }
                if ((nextInstr = instructions[i2]) != 18) continue;
                i2 += 2;
                isALoad0BeforeStaticCall = false;
                continue;
            }
            if (instr == -72) {
                if (!isALoad0BeforeStaticCall || (i2 += 3) != instructions.length - 1) continue;
                byte nextInstr = instructions[i2];
                IntRange intRange2 = KotlinSyntheticTypeComponentProviderKt.access$getRETURN_INSTRUCTIONS$p();
                n2 = intRange2.getFirst();
                n = intRange2.getLast();
                byte by = nextInstr;
                return n2 <= by ? by <= n : false;
            }
            if (instr == -64) {
                if (instructions[++i2] != 0) {
                    return false;
                }
                intRange = KotlinSyntheticTypeComponentProviderKt.access$getICONST_INSTRUCTIONS$p();
                n3 = intRange.getFirst();
                n2 = intRange.getLast();
                if (!(n3 <= (n = instructions[++i2]) ? n <= n2 : false)) {
                    return false;
                }
                ++i2;
                continue;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasInterfaceWithImplementation(Method method) {
        boolean bl;
        block5: {
            void $this$flatMapTo$iv$iv;
            ReferenceType referenceType = method.declaringType();
            ClassType classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
            if (classType == null) {
                return false;
            }
            ClassType declaringType = classType;
            List<InterfaceType> interfaces = declaringType.allInterfaces();
            VirtualMachine vm = declaringType.virtualMachine();
            Intrinsics.checkNotNull(interfaces);
            Iterable $this$flatMap$iv = interfaces;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                InterfaceType it = (InterfaceType)element$iv$iv;
                boolean bl2 = false;
                List<ReferenceType> list2 = vm.classesByName(it.name() + "$DefaultImpls");
                Intrinsics.checkNotNullExpressionValue(list2, (String)"classesByName(...)");
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List traitImpls = (List)destination$iv$iv;
            Iterable $this$any$iv = traitImpls;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ReferenceType it = (ReferenceType)element$iv;
                    boolean bl3 = false;
                    List<Method> list3 = it.methodsByName(method.name());
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"methodsByName(...)");
                    boolean bl4 = !((Collection)list3).isEmpty();
                    if (!bl4) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }
}

