/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Range;
import com.intellij.xdebugger.stepping.ForceSmartStepIntoSource;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.debugger.base.util.AnalyseUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.JvmNameUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.CallableMemberInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTargetKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTarget;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B?\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\u00020\u001b2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\u0005H\u0016R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodSmartStepTarget;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTarget;", "Lcom/intellij/xdebugger/stepping/ForceSmartStepIntoSource;", "lines", "Lcom/intellij/util/Range;", "", "highlightElement", "Lcom/intellij/psi/PsiElement;", "label", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "ordinal", "methodInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;", "<init>", "(Lcom/intellij/util/Range;Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtDeclaration;ILorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;)V", "getOrdinal", "()I", "getMethodInfo", "()Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;", "declarationPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "getIcon", "Ljavax/swing/Icon;", "getClassName", "needForceSmartStepInto", "", "getDeclaration", "createMethodFilter", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilter;", "equals", "other", "", "hashCode", "intellij.kotlin.jvm.debugger.core"})
public final class KotlinMethodSmartStepTarget
extends KotlinSmartStepTarget
implements ForceSmartStepIntoSource {
    private final int ordinal;
    @NotNull
    private final CallableMemberInfo methodInfo;
    @Nullable
    private final SmartPsiElementPointer<KtDeclaration> declarationPtr;

    public KotlinMethodSmartStepTarget(@NotNull Range<Integer> lines, @NotNull PsiElement highlightElement, @NotNull String label2, @Nullable KtDeclaration declaration, int ordinal, @NotNull CallableMemberInfo methodInfo) {
        boolean bl;
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)highlightElement, (String)"highlightElement");
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)methodInfo, (String)"methodInfo");
        super(label2, highlightElement, false, lines);
        this.ordinal = ordinal;
        this.methodInfo = methodInfo;
        KtDeclaration ktDeclaration = declaration;
        this.declarationPtr = ktDeclaration != null && (ktDeclaration = KotlinMethodSmartStepTargetKt.access$fetchNavigationElement(ktDeclaration)) != null ? SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)ktDeclaration)) : null;
        boolean bl2 = bl = declaration != null || this.methodInfo.isInvoke();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final int getOrdinal() {
        return this.ordinal;
    }

    @NotNull
    public final CallableMemberInfo getMethodInfo() {
        return this.methodInfo;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2;
        if (this.methodInfo.isExtension()) {
            Icon icon3 = KotlinIcons.EXTENSION_FUNCTION;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"EXTENSION_FUNCTION");
        } else {
            Icon icon4 = KotlinIcons.FUNCTION;
            icon2 = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"FUNCTION");
        }
        return icon2;
    }

    @Nullable
    public String getClassName() {
        KtDeclaration ktDeclaration = this.getDeclaration();
        if (ktDeclaration == null) {
            return null;
        }
        KtDeclaration declaration = ktDeclaration;
        return AnalyseUtilsKt.runDumbAnalyze((KtElement)declaration, null, arg_0 -> KotlinMethodSmartStepTarget.getClassName$lambda$0(declaration, arg_0));
    }

    public boolean needForceSmartStepInto() {
        return this.methodInfo.isInvoke() && this.methodInfo.isSuspend();
    }

    @Nullable
    public final KtDeclaration getDeclaration() {
        return KotlinMethodSmartStepTargetKt.getElementInReadAction(this.declarationPtr);
    }

    @NotNull
    public KotlinMethodFilter createMethodFilter() {
        KtDeclaration declaration = KotlinMethodSmartStepTargetKt.getElementInReadAction(this.declarationPtr);
        return new KotlinMethodFilter((PsiElement)declaration, (Range<Integer>)this.getCallingExpressionLines(), this.methodInfo);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof KotlinMethodSmartStepTarget)) {
            return false;
        }
        if (this.methodInfo.isInvoke() && ((KotlinMethodSmartStepTarget)((Object)other)).methodInfo.isInvoke()) {
            return true;
        }
        return this.getHighlightElement() == ((KotlinMethodSmartStepTarget)((Object)other)).getHighlightElement();
    }

    public int hashCode() {
        if (this.methodInfo.isInvoke()) {
            return 42;
        }
        PsiElement psiElement = this.getHighlightElement();
        return psiElement != null ? psiElement.hashCode() : 0;
    }

    private static final String getClassName$lambda$0(KtDeclaration $declaration, KaSession $this$runDumbAnalyze) {
        Intrinsics.checkNotNullParameter((Object)$this$runDumbAnalyze, (String)"$this$runDumbAnalyze");
        return JvmNameUtilKt.getClassName($this$runDumbAnalyze, $declaration);
    }
}

