/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleCodeInsightCommon;

import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectNotificationAware;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.configuration.GradleDetectorKt;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManager;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurationService;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.GradleBuildScriptSupport;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.KotlinGradleCodeInsightUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/gradleCodeInsightCommon/GradleKotlinBuildSystemDependencyManager;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinBuildSystemDependencyManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isApplicable", "", "module", "Lcom/intellij/openapi/module/Module;", "addDependency", "", "libraryDescriptor", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "isProjectSyncPending", "getBuildScriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isProjectSyncInProgress", "startProjectSync", "intellij.kotlin.gradle.codeInsight.common"})
@ApiStatus.Internal
public final class GradleKotlinBuildSystemDependencyManager
implements KotlinBuildSystemDependencyManager {
    @NotNull
    private final Project project;

    public GradleKotlinBuildSystemDependencyManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ProjectStructureUtils.isGradleModule(module);
    }

    @Override
    public void addDependency(@NotNull Module module, @NotNull ExternalLibraryDescriptor libraryDescriptor) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)libraryDescriptor, (String)"libraryDescriptor");
        DependencyScope dependencyScope = libraryDescriptor.getPreferredScope();
        if (dependencyScope == null) {
            dependencyScope = DependencyScope.COMPILE;
        }
        DependencyScope scope = dependencyScope;
        PsiFile psiFile = KotlinGradleCodeInsightUtils.getBuildScriptPsiFile(module);
        if (psiFile == null) {
            return;
        }
        PsiFile buildScriptFile = psiFile;
        GradleBuildScriptManipulator gradleBuildScriptManipulator = GradleBuildScriptSupport.Companion.findManipulator$default(GradleBuildScriptSupport.Companion, buildScriptFile, false, 2, null);
        if (gradleBuildScriptManipulator != null) {
            gradleBuildScriptManipulator.addKotlinLibraryToModuleBuildScript(module, scope, libraryDescriptor);
        }
    }

    @Override
    public boolean isProjectSyncPending() {
        ObservableProperty isNotificationVisible = ExternalSystemProjectNotificationAware.Companion.isNotificationVisibleProperty(this.project, GradleDetectorKt.getGRADLE_SYSTEM_ID());
        return (Boolean)isNotificationVisible.get();
    }

    @Override
    @Nullable
    public VirtualFile getBuildScriptFile(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        PsiFile psiFile = KotlinGradleCodeInsightUtils.getBuildScriptPsiFile(module);
        return psiFile != null ? psiFile.getVirtualFile() : null;
    }

    @Override
    public boolean isProjectSyncInProgress() {
        return KotlinProjectConfigurationService.Companion.getInstance(this.project).isSyncInProgress();
    }

    @Override
    public void startProjectSync() {
        KotlinProjectConfigurationService.Companion.getInstance(this.project).queueSync();
    }
}

