/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinClassTooltipLinkHandler;", "Lcom/intellij/codeInsight/highlighting/TooltipLinkHandler;", "<init>", "()V", "handleLink", "", "refSuffix", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.kotlin.base.codeInsight"})
@SourceDebugExtension(value={"SMAP\nKotlinClassTooltipLinkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinClassTooltipLinkHandler.kt\norg/jetbrains/kotlin/idea/highlighter/markers/KotlinClassTooltipLinkHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n1#2:33\n*E\n"})
final class KotlinClassTooltipLinkHandler
extends TooltipLinkHandler {
    public boolean handleLink(@NotNull String refSuffix, @NotNull Editor editor) {
        PsiElement psiElement;
        GlobalSearchScope globalSearchScope;
        String qualifiedName;
        JavaPsiFacade javaPsiFacade;
        Project project;
        block9: {
            block10: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)refSuffix, (String)"refSuffix");
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    Project project2 = editor.getProject();
                    if (project2 == null) {
                        return false;
                    }
                    project = project2;
                    javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
                    qualifiedName = StringsKt.substringAfterLast$default((String)refSuffix, (String)":", null, (int)2, null);
                    if (qualifiedName.length() != refSuffix.length()) break block8;
                    globalSearchScope = GlobalSearchScope.allScope((Project)project);
                    break block9;
                }
                String moduleName = StringsKt.substringBeforeLast$default((String)refSuffix, (String)":", null, (int)2, null);
                Module module = ModuleManager.Companion.getInstance(project).findModuleByName(moduleName);
                globalSearchScope = module;
                if (globalSearchScope == null) break block10;
                GlobalSearchScope it = globalSearchScope;
                boolean bl = false;
                GlobalSearchScope globalSearchScope2 = GlobalSearchScope.moduleScope((Module)it);
                globalSearchScope = globalSearchScope2;
                if (globalSearchScope2 != null) break block9;
            }
            GlobalSearchScope globalSearchScope3 = GlobalSearchScope.allScope((Project)project);
            globalSearchScope = globalSearchScope3;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"allScope(...)");
        }
        GlobalSearchScope globalSearchScope4 = globalSearchScope;
        Intrinsics.checkNotNull((Object)globalSearchScope4);
        GlobalSearchScope scope = globalSearchScope4;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)CollectionsKt.firstOrNull((Iterable)KotlinFullClassNameIndex.Helper.get(qualifiedName, project, scope));
        if (ktClassOrObject != null) {
            psiElement = (PsiElement)ktClassOrObject;
        } else {
            PsiClass psiClass = javaPsiFacade.findClass(qualifiedName, scope);
            if (psiClass != null) {
                psiElement = (PsiElement)psiClass;
            } else {
                return false;
            }
        }
        PsiElement aClassElement = psiElement;
        NavigationUtil.activateFileWithPsiElement$default((PsiElement)aClassElement, (boolean)false, (int)2, null);
        return true;
    }
}

