/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.renderersUtil;

import com.google.common.html.HtmlEscapers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.RenderersKt;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.SmartDescriptorRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.SmartTypeRenderer;
import org.jetbrains.kotlin.idea.base.fe10.highlighting.KotlinBaseFe10HighlightingBundle;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.ClassifierNamePolicy;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.renderer.RenderingFormat;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\u000b\u001a\u00020\u00012\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"RED_TEMPLATE", "", "STRONG_TEMPLATE", "renderStrong", "o", "", "renderError", "error", "", "HTML_FOR_UNINFERRED_TYPE_PARAMS", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "renderResolvedCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "kotlin.highlighting.k1"})
@SourceDebugExtension(value={"SMAP\nrenderersUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 renderersUtil.kt\norg/jetbrains/kotlin/idea/highlighter/renderersUtil/RenderersUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n3301#2,10:109\n*S KotlinDebug\n*F\n+ 1 renderersUtil.kt\norg/jetbrains/kotlin/idea/highlighter/renderersUtil/RenderersUtilKt\n*L\n66#1:109,10\n*E\n"})
public final class RenderersUtilKt {
    @NotNull
    private static final String RED_TEMPLATE = "<font color=red><b>%s</b></font>";
    @NotNull
    private static final String STRONG_TEMPLATE = "<b>%s</b>";
    @NotNull
    private static final DescriptorRenderer HTML_FOR_UNINFERRED_TYPE_PARAMS = DescriptorRenderer.Companion.withOptions(RenderersUtilKt::HTML_FOR_UNINFERRED_TYPE_PARAMS$lambda$0);

    @NotNull
    public static final String renderStrong(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        String string = STRONG_TEMPLATE;
        Object[] objectArray = new Object[]{o};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public static final String renderError(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        String string = RED_TEMPLATE;
        Object[] objectArray = new Object[]{o};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public static final String renderStrong(@NotNull Object o, boolean error) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        String string = error ? RED_TEMPLATE : STRONG_TEMPLATE;
        Object[] objectArray = new Object[]{o};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public static final String renderResolvedCall(@NotNull ResolvedCall<?> resolvedCall, @NotNull RenderingContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        SmartTypeRenderer typeRenderer2 = new SmartTypeRenderer(HTML_FOR_UNINFERRED_TYPE_PARAMS);
        SmartDescriptorRenderer descriptorRenderer = RenderersKt.asRenderer((DescriptorRenderer)HTML_FOR_UNINFERRED_TYPE_PARAMS);
        StringBuilder stringBuilder = new StringBuilder("");
        String indent = "&nbsp;&nbsp;";
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
        CallableDescriptor resultingDescriptor = callableDescriptor;
        ReceiverParameterDescriptor receiverParameter = resultingDescriptor.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            KotlinType kotlinType = receiverParameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            RenderersUtilKt.renderResolvedCall$append(stringBuilder, typeRenderer2.render(kotlinType, context2)).append(".");
        }
        String string = HtmlEscapers.htmlEscaper().escape(resultingDescriptor.getName().asString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escape(...)");
        RenderersUtilKt.renderResolvedCall$append(stringBuilder, string).append("(");
        List list2 = resultingDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        RenderersUtilKt.renderResolvedCall$append(stringBuilder, CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, (Function1)((Function1)new Function1<ValueParameterDescriptor, String>(typeRenderer2, context2, resolvedCall){
            final /* synthetic */ SmartTypeRenderer $typeRenderer;
            final /* synthetic */ RenderingContext $context;
            final /* synthetic */ ResolvedCall<?> $resolvedCall;
            {
                this.$typeRenderer = $typeRenderer;
                this.$context = $context;
                this.$resolvedCall = $resolvedCall;
                super(1, Intrinsics.Kotlin.class, "renderParameter", "renderResolvedCall$renderParameter(Lorg/jetbrains/kotlin/diagnostics/rendering/SmartTypeRenderer;Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)Ljava/lang/String;", 0);
            }

            public final String invoke(ValueParameterDescriptor p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RenderersUtilKt.access$renderResolvedCall$renderParameter(this.$typeRenderer, this.$context, this.$resolvedCall, p0);
            }
        }), (int)31, null));
        RenderersUtilKt.renderResolvedCall$append(stringBuilder, CallUtilKt.hasUnmappedArguments(resolvedCall) ? RenderersUtilKt.renderError(")") : ")");
        List list3 = resolvedCall.getCandidateDescriptor().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getTypeParameters(...)");
        if (!((Collection)list3).isEmpty()) {
            RenderersUtilKt.renderResolvedCall$appendTypeParametersSubstitution(resolvedCall, indent, stringBuilder, typeRenderer2, context2);
            Object[] objectArray = new Object[]{indent};
            RenderersUtilKt.renderResolvedCall$append(stringBuilder, KotlinBaseFe10HighlightingBundle.message("i.for.i.br.0", objectArray));
            CallableDescriptor callableDescriptor2 = resolvedCall.getCandidateDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor2, (String)"getCandidateDescriptor(...)");
            objectArray = new Object[]{resolvedCall.getCandidateDescriptor()};
            v6 = RenderersUtilKt.renderResolvedCall$append(stringBuilder, descriptorRenderer.render((DeclarationDescriptor)callableDescriptor2, RenderingContext.Companion.of(objectArray)));
        } else {
            RenderersUtilKt.renderResolvedCall$append(stringBuilder, " <i>" + KotlinBaseFe10HighlightingBundle.message("defined.in", new Object[0]) + "</i> ");
            DeclarationDescriptor declarationDescriptor = resultingDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            DeclarationDescriptor containingDeclaration = declarationDescriptor;
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName((DeclarationDescriptor)containingDeclaration);
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"getFqName(...)");
            FqNameUnsafe fqName2 = fqNameUnsafe;
            v6 = RenderersUtilKt.renderResolvedCall$append(stringBuilder, fqName2.isRoot() ? KotlinBaseFe10HighlightingBundle.message("root.package", new Object[0]) : fqName2.asString());
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final Unit HTML_FOR_UNINFERRED_TYPE_PARAMS$lambda$0(DescriptorRendererOptions $this$withOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$withOptions, (String)"$this$withOptions");
        $this$withOptions.setUninferredTypeParameterAsName(true);
        $this$withOptions.setModifiers(SetsKt.emptySet());
        $this$withOptions.setClassifierNamePolicy((ClassifierNamePolicy)ClassifierNamePolicy.SHORT.INSTANCE);
        $this$withOptions.setTextFormat(RenderingFormat.HTML);
        return Unit.INSTANCE;
    }

    private static final StringBuilder renderResolvedCall$append(StringBuilder stringBuilder, Object any) {
        StringBuilder stringBuilder2 = stringBuilder.append(any);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        return stringBuilder2;
    }

    private static final String renderResolvedCall$renderParameter(SmartTypeRenderer typeRenderer2, RenderingContext $context, ResolvedCall<?> $resolvedCall, ValueParameterDescriptor parameter) {
        KotlinType varargElementType = parameter.getVarargElementType();
        KotlinType kotlinType = varargElementType;
        if (kotlinType == null) {
            KotlinType kotlinType2 = parameter.getType();
            kotlinType = kotlinType2;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
        }
        KotlinType parameterType = kotlinType;
        String renderedParameter = (varargElementType != null ? "<b>vararg</b> " : "") + typeRenderer2.render(parameterType, $context) + (ArgumentsUtilsKt.hasDefaultValue((ValueParameterDescriptor)parameter) ? " = ..." : "");
        return CallUtilKt.hasTypeMismatchErrorOnParameter($resolvedCall, (ValueParameterDescriptor)parameter) ? RenderersUtilKt.renderError(renderedParameter) : renderedParameter;
    }

    private static final void renderResolvedCall$appendTypeParametersSubstitution(ResolvedCall<?> $resolvedCall, String indent, StringBuilder stringBuilder, SmartTypeRenderer typeRenderer2, RenderingContext $context) {
        Map map2 = $resolvedCall.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getTypeArguments(...)");
        Map parametersToArgumentsMap = map2;
        List list2 = $resolvedCall.getCandidateDescriptor().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeParameters(...)");
        List typeParameters2 = list2;
        Iterable $this$partition$iv = typeParameters2;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            TypeParameterDescriptor p0 = (TypeParameterDescriptor)element$iv;
            boolean bl = false;
            boolean bl2 = RenderersUtilKt.renderResolvedCall$appendTypeParametersSubstitution$isInferred(p0, parametersToArgumentsMap) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List inferredTypeParameters = (List)pair.component1();
        List notInferredTypeParameters = (List)pair.component2();
        RenderersUtilKt.renderResolvedCall$append(stringBuilder, "<br/>" + indent + "<i>" + KotlinBaseFe10HighlightingBundle.message("type.parameters.where", new Object[0]) + "</i> ");
        if (!((Collection)notInferredTypeParameters).isEmpty()) {
            RenderersUtilKt.renderResolvedCall$append(stringBuilder, CollectionsKt.joinToString$default((Iterable)notInferredTypeParameters, null, null, null, (int)0, null, RenderersUtilKt::renderResolvedCall$appendTypeParametersSubstitution$lambda$0, (int)31, null));
            RenderersUtilKt.renderResolvedCall$append(stringBuilder, "<i> " + KotlinBaseFe10HighlightingBundle.message("cannot.be.inferred", new Object[0]) + "</i>");
            if (!((Collection)inferredTypeParameters).isEmpty()) {
                RenderersUtilKt.renderResolvedCall$append(stringBuilder, "; ");
            }
        }
        Map map3 = $resolvedCall.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getTypeArguments(...)");
        Map typeParameterToTypeArgumentMap = map3;
        if (!((Collection)inferredTypeParameters).isEmpty()) {
            RenderersUtilKt.renderResolvedCall$append(stringBuilder, CollectionsKt.joinToString$default((Iterable)inferredTypeParameters, null, null, null, (int)0, null, arg_0 -> RenderersUtilKt.renderResolvedCall$appendTypeParametersSubstitution$lambda$1(typeRenderer2, typeParameterToTypeArgumentMap, $context, arg_0), (int)31, null));
        }
    }

    private static final boolean renderResolvedCall$appendTypeParametersSubstitution$isInferred(TypeParameterDescriptor $this$renderResolvedCall_u24appendTypeParametersSubstitution_u24isInferred, Map<TypeParameterDescriptor, KotlinType> parametersToArgumentsMap) {
        KotlinType kotlinType = parametersToArgumentsMap.get($this$renderResolvedCall_u24appendTypeParametersSubstitution_u24isInferred);
        if (kotlinType == null) {
            return false;
        }
        KotlinType typeArgument = kotlinType;
        return !ErrorUtils.isUninferredTypeVariable((KotlinType)typeArgument);
    }

    private static final CharSequence renderResolvedCall$appendTypeParametersSubstitution$lambda$0(TypeParameterDescriptor typeParameter) {
        Name name2 = typeParameter.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
        return RenderersUtilKt.renderError(name2);
    }

    private static final CharSequence renderResolvedCall$appendTypeParametersSubstitution$lambda$1(SmartTypeRenderer $typeRenderer, Map $typeParameterToTypeArgumentMap, RenderingContext $context, TypeParameterDescriptor typeParameter) {
        Name name2 = typeParameter.getName();
        Object v = $typeParameterToTypeArgumentMap.get(typeParameter);
        Intrinsics.checkNotNull(v);
        return name2 + " = " + $typeRenderer.render((KotlinType)v, $context);
    }

    public static final /* synthetic */ String access$renderResolvedCall$renderParameter(SmartTypeRenderer typeRenderer2, RenderingContext $context, ResolvedCall $resolvedCall, ValueParameterDescriptor parameter) {
        return RenderersUtilKt.renderResolvedCall$renderParameter(typeRenderer2, $context, $resolvedCall, parameter);
    }
}

