/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbol;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ConvertTryFinallyToUseCallInspection;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0003*\u00020\u00152\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0014\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertTryFinallyToUseCallInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertTryFinallyToUseCallInspection$Context;", "<init>", "()V", "getProblemDescription", "", "element", "context", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "isApplicableByPsi", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Context", "intellij.kotlin.codeInsight.inspections"})
@SourceDebugExtension(value={"SMAP\nConvertTryFinallyToUseCallInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertTryFinallyToUseCallInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertTryFinallyToUseCallInspection\n+ 2 KaCallInfo.kt\norg/jetbrains/kotlin/analysis/api/resolution/KaCallInfoKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,141:1\n67#2:142\n672#3,11:143\n2275#4,2:154\n*S KotlinDebug\n*F\n+ 1 ConvertTryFinallyToUseCallInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertTryFinallyToUseCallInspection\n*L\n64#1:142\n64#1:143,11\n79#1:154,2\n*E\n"})
public final class ConvertTryFinallyToUseCallInspection
extends KotlinApplicableInspectionBase.Simple<KtTryExpression, Context> {
    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtTryExpression element, @NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinBundle.message((String)"convert.try.finally.to.use.before.text", (Object[])new Object[0]);
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return new KtVisitorVoid(this, holder2, isOnTheFly){
            final /* synthetic */ ConvertTryFinallyToUseCallInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            public void visitTryExpression(KtTryExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                ConvertTryFinallyToUseCallInspection.access$visitTargetElement(this.this$0, expression, this.$holder, this.$isOnTheFly);
            }
        };
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtTryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getTryBlock().getLBrace();
        TextRange textRange = new TextRange(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element)), psiElement != null ? PsiUtilsKt.getEndOffset((PsiElement)psiElement) : PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)element))).shiftLeft(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element)));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftLeft(...)");
        TextRange range2 = textRange;
        return CollectionsKt.listOf((Object)range2);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtTryExpression element) {
        String calleeText;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List list2 = element.getCatchClauses();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getCatchClauses(...)");
        if (!((Collection)list2).isEmpty()) {
            return false;
        }
        KtFinallySection ktFinallySection = element.getFinallyBlock();
        if (ktFinallySection == null) {
            return false;
        }
        KtFinallySection finallySection = ktFinallySection;
        List list3 = finallySection.getFinalExpression().getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getStatements(...)");
        KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull((List)list3);
        if (ktExpression == null) {
            return false;
        }
        KtExpression stmt = ktExpression;
        KtQualifiedExpression ktQualifiedExpression = stmt instanceof KtQualifiedExpression ? (KtQualifiedExpression)stmt : null;
        Object object = ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
        KtCallExpression ktCallExpression = object instanceof KtCallExpression ? (KtCallExpression)object : null;
        if (ktCallExpression == null && (ktCallExpression = stmt instanceof KtCallExpression ? (KtCallExpression)stmt : null) == null) {
            return false;
        }
        KtCallExpression call2 = ktCallExpression;
        KtExpression ktExpression2 = call2.getCalleeExpression();
        String string = calleeText = ktExpression2 != null ? ktExpression2.getText() : null;
        return Intrinsics.areEqual((Object)calleeText, (Object)"close");
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtTryExpression element) {
        KtExpression receiverExpression;
        KtQualifiedExpression ktQualifiedExpression;
        boolean bl;
        KtExpression ktExpression;
        KtCallExpression call2;
        KtExpression stmt;
        block19: {
            Object $this$singleOrNull$iv$iv;
            KaLifetimeOwner kaLifetimeOwner;
            block21: {
                block20: {
                    Object v6;
                    block18: {
                        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        KtFinallySection ktFinallySection = element.getFinallyBlock();
                        if (ktFinallySection == null) {
                            return null;
                        }
                        KtFinallySection finallySection = ktFinallySection;
                        List list2 = finallySection.getFinalExpression().getStatements();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
                        KtExpression ktExpression2 = (KtExpression)CollectionsKt.singleOrNull((List)list2);
                        if (ktExpression2 == null) {
                            return null;
                        }
                        stmt = ktExpression2;
                        KtQualifiedExpression ktQualifiedExpression2 = stmt instanceof KtQualifiedExpression ? (KtQualifiedExpression)stmt : null;
                        Object object = ktQualifiedExpression2 != null ? ktQualifiedExpression2.getSelectorExpression() : null;
                        KtCallExpression ktCallExpression = object instanceof KtCallExpression ? (KtCallExpression)object : null;
                        if (ktCallExpression == null && (ktCallExpression = stmt instanceof KtCallExpression ? (KtCallExpression)stmt : null) == null) {
                            return null;
                        }
                        call2 = ktCallExpression;
                        if (!((Collection)call2.getValueArguments()).isEmpty()) {
                            return null;
                        }
                        kaLifetimeOwner = $this$prepareContext.resolveToCall((KtElement)call2);
                        if (kaLifetimeOwner == null) break block20;
                        KaCallInfo $this$singleCallOrNull$iv = kaLifetimeOwner;
                        boolean $i$f$singleCallOrNull = false;
                        $this$singleOrNull$iv$iv = KaCallInfoKt.getCalls($this$singleCallOrNull$iv);
                        boolean $i$f$singleOrNull = false;
                        Object single$iv$iv = null;
                        boolean found$iv$iv = false;
                        ktExpression = $this$singleOrNull$iv$iv.iterator();
                        while (ktExpression.hasNext()) {
                            Object element$iv$iv = ktExpression.next();
                            KaCall it$iv = (KaCall)element$iv$iv;
                            boolean bl2 = false;
                            if (!(it$iv instanceof KaCallableMemberCall)) continue;
                            if (found$iv$iv) {
                                v6 = null;
                                break block18;
                            }
                            single$iv$iv = element$iv$iv;
                            found$iv$iv = true;
                        }
                        v6 = !found$iv$iv ? null : single$iv$iv;
                    }
                    if ((kaLifetimeOwner = (KaCallableMemberCall)((KaCall)v6)) != null) break block21;
                }
                return null;
            }
            KaLifetimeOwner resolved = kaLifetimeOwner;
            KaPartiallyAppliedSymbol partiallyAppliedSymbol = resolved.getPartiallyAppliedSymbol();
            Object callableSymbol = KaPartiallyAppliedSymbolKt.getSymbol(partiallyAppliedSymbol);
            Name name2 = KaSymbolKt.getName((KaSymbol)callableSymbol);
            if (!Intrinsics.areEqual((Object)(name2 != null ? name2.asString() : null), (Object)"close")) {
                return null;
            }
            $this$singleOrNull$iv$iv = $this$prepareContext.getContainingSymbol((KaSymbol)callableSymbol);
            KaClassSymbol kaClassSymbol = $this$singleOrNull$iv$iv instanceof KaClassSymbol ? (KaClassSymbol)$this$singleOrNull$iv$iv : null;
            if (kaClassSymbol == null) {
                return null;
            }
            KaClassSymbol classSymbol = kaClassSymbol;
            KaClassSymbol kaClassSymbol2 = $this$prepareContext.findClass(ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"java.io/Closeable", (boolean)false, (int)2, null));
            if (kaClassSymbol2 == null) {
                return null;
            }
            KaClassSymbol closeableClass = kaClassSymbol2;
            KaClassSymbol autoCloseableClass = $this$prepareContext.findClass(ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"java.lang/AutoCloseable", (boolean)false, (int)2, null));
            if (!(Intrinsics.areEqual((Object)classSymbol, (Object)closeableClass) || Intrinsics.areEqual((Object)classSymbol, (Object)autoCloseableClass) || $this$prepareContext.isSubClassOf(classSymbol, closeableClass) || autoCloseableClass != null && $this$prepareContext.isSubClassOf(classSymbol, autoCloseableClass))) {
                return null;
            }
            Sequence<KaCallableSymbol> $this$none$iv = $this$prepareContext.getAllOverriddenSymbols((KaCallableSymbol)callableSymbol);
            boolean $i$f$none = false;
            for (Object element$iv : $this$none$iv) {
                KaCallableSymbol it = (KaCallableSymbol)element$iv;
                boolean bl3 = false;
                Object[] objectArray = new KaClassSymbol[]{closeableClass, autoCloseableClass};
                if (!CollectionsKt.contains((Iterable)SetsKt.setOfNotNull((Object[])objectArray), (Object)$this$prepareContext.getContainingSymbol(it))) continue;
                bl = false;
                break block19;
            }
            bl = true;
        }
        if (bl) {
            return null;
        }
        KtQualifiedExpression ktQualifiedExpression3 = ktQualifiedExpression = stmt instanceof KtQualifiedExpression ? (KtQualifiedExpression)stmt : null;
        Object object = receiverExpression = ktQualifiedExpression3 != null ? ktQualifiedExpression3.getReceiverExpression() : null;
        if (receiverExpression != null && !(receiverExpression instanceof KtThisExpression)) {
            ktExpression = receiverExpression;
            KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
            if (ktNameReferenceExpression == null) {
                return null;
            }
            ktQualifiedExpression = ktNameReferenceExpression;
        }
        return new Context(call2);
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtTryExpression> createQuickFix(@NotNull KtTryExpression element, @NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new KotlinModCommandQuickFix<KtTryExpression>(){

            public String getFamilyName() {
                return KotlinBundle.message((String)"convert.try.finally.to.use", (Object[])new Object[0]);
            }

            protected void applyFix(Project project, KtTryExpression element, ModPsiUpdater updater2) {
                KtCallExpression ktCallExpression;
                KtNameReferenceExpression resourceReference;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                KtFinallySection ktFinallySection = element.getFinallyBlock();
                if (ktFinallySection == null) {
                    return;
                }
                KtFinallySection finallySection = ktFinallySection;
                List list2 = finallySection.getFinalExpression().getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
                KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull((List)list2);
                if (ktExpression == null) {
                    return;
                }
                KtExpression finallyExpression = ktExpression;
                KtQualifiedExpression ktQualifiedExpression = finallyExpression instanceof KtQualifiedExpression ? (KtQualifiedExpression)finallyExpression : null;
                KtExpression finallyExpressionReceiver = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
                KtNameReferenceExpression ktNameReferenceExpression = resourceReference = finallyExpressionReceiver instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)finallyExpressionReceiver : null;
                Name resourceName = ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedNameAsName() : null;
                Project project2 = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
                KtExpression useCallExpression = CreateByPatternKt.buildExpression$default((KtPsiFactory)psiFactory, (boolean)false, arg_0 -> createQuickFix.1.applyFix$lambda$0(resourceName, finallyExpressionReceiver, element, arg_0), (int)1, null);
                PsiElement psiElement = element.replace((PsiElement)useCallExpression);
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                KtExpression result2 = (KtExpression)psiElement;
                if (result2 instanceof KtQualifiedExpression) {
                    KtExpression ktExpression2 = ((KtQualifiedExpression)result2).getSelectorExpression();
                    ktCallExpression = ktExpression2 instanceof KtCallExpression ? (KtCallExpression)ktExpression2 : null;
                    if (ktCallExpression == null) {
                        return;
                    }
                } else if (result2 instanceof KtCallExpression) {
                    ktCallExpression = (KtCallExpression)result2;
                } else {
                    return;
                }
                KtCallExpression call2 = ktCallExpression;
                KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)call2.getLambdaArguments());
                if (ktLambdaArgument == null) {
                    return;
                }
                KtLambdaArgument lambda2 = ktLambdaArgument;
                Object object = lambda2.getLambdaExpression();
                if (object == null || (object = object.getValueParameters()) == null || (object = (KtParameter)CollectionsKt.firstOrNull((List)object)) == null) {
                    return;
                }
                Object lambdaParameter = object;
                updater2.select((PsiElement)lambdaParameter);
            }

            private static final Unit applyFix$lambda$0(Name $resourceName, KtExpression $finallyExpressionReceiver, KtTryExpression $element, BuilderByPattern $this$buildExpression) {
                Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
                if ($resourceName != null) {
                    $this$buildExpression.appendName($resourceName);
                    $this$buildExpression.appendFixedText(".");
                } else if ($finallyExpressionReceiver instanceof KtThisExpression) {
                    String string = ((KtThisExpression)$finallyExpressionReceiver).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    $this$buildExpression.appendFixedText(string);
                    $this$buildExpression.appendFixedText(".");
                }
                $this$buildExpression.appendFixedText("use {");
                if ($resourceName != null) {
                    $this$buildExpression.appendName($resourceName);
                    $this$buildExpression.appendFixedText("->");
                }
                $this$buildExpression.appendFixedText("\n");
                KtBlockExpression ktBlockExpression = $element.getTryBlock();
                Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"getTryBlock(...)");
                $this$buildExpression.appendChildRange(KtPsiUtilKt.contentRange((KtBlockExpression)ktBlockExpression));
                $this$buildExpression.appendFixedText("\n}");
                return Unit.INSTANCE;
            }
        };
    }

    public static final /* synthetic */ void access$visitTargetElement(ConvertTryFinallyToUseCallInspection $this, KtTryExpression element, ProblemsHolder holder2, boolean isOnTheFly) {
        $this.visitTargetElement((KtElement)element, holder2, isOnTheFly);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ConvertTryFinallyToUseCallInspection$Context;", "", "qualifiedFinallyCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "getQualifiedFinallyCall", "()Lorg/jetbrains/kotlin/psi/KtCallExpression;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.kotlin.codeInsight.inspections"})
    public static final class Context {
        @NotNull
        private final KtCallExpression qualifiedFinallyCall;

        public Context(@NotNull KtCallExpression qualifiedFinallyCall) {
            Intrinsics.checkNotNullParameter((Object)qualifiedFinallyCall, (String)"qualifiedFinallyCall");
            this.qualifiedFinallyCall = qualifiedFinallyCall;
        }

        @NotNull
        public final KtCallExpression getQualifiedFinallyCall() {
            return this.qualifiedFinallyCall;
        }

        @NotNull
        public final KtCallExpression component1() {
            return this.qualifiedFinallyCall;
        }

        @NotNull
        public final Context copy(@NotNull KtCallExpression qualifiedFinallyCall) {
            Intrinsics.checkNotNullParameter((Object)qualifiedFinallyCall, (String)"qualifiedFinallyCall");
            return new Context(qualifiedFinallyCall);
        }

        public static /* synthetic */ Context copy$default(Context context2, KtCallExpression ktCallExpression, int n, Object object) {
            if ((n & 1) != 0) {
                ktCallExpression = context2.qualifiedFinallyCall;
            }
            return context2.copy(ktCallExpression);
        }

        @NotNull
        public String toString() {
            return "Context(qualifiedFinallyCall=" + this.qualifiedFinallyCall + ")";
        }

        public int hashCode() {
            return this.qualifiedFinallyCall.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context2 = (Context)other;
            return Intrinsics.areEqual((Object)this.qualifiedFinallyCall, (Object)context2.qualifiedFinallyCall);
        }
    }
}

