/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolVisibility;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaDynamicType;
import org.jetbrains.kotlin.analysis.api.types.KaStarTypeProjection;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeNullability;
import org.jetbrains.kotlin.analysis.api.types.KaTypeProjection;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.CallableReturnTypeUpdaterUtils;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFix;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtDeclarationWithReturnType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0014\u0010\f\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0013\u001a\u0004\u0018\u00010\u000f*\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J$\u0010\u0016\u001a\u00020\u0017*\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0002J\r\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001dH\u0016R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/HasPlatformTypeInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "publicAPIOnly", "", "reportPlatformArguments", "<init>", "(ZZ)V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "isFlexibleRecursive", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "publicApiVisibilities", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbolVisibility;", "dangerousFlexibleTypeOrNull", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "checkForPlatformType", "", "element", "nameIdentifier", "Lcom/intellij/psi/PsiElement;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "Lorg/jetbrains/annotations/NotNull;", "intellij.kotlin.codeInsight.inspections"})
@SourceDebugExtension(value={"SMAP\nHasPlatformTypeInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HasPlatformTypeInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/HasPlatformTypeInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,102:1\n1761#2,2:103\n1763#2:106\n1563#2:107\n1634#2,3:108\n1#3:105\n37#4,2:111\n*S KotlinDebug\n*F\n+ 1 HasPlatformTypeInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/HasPlatformTypeInspection\n*L\n44#1:103,2\n44#1:106\n94#1:107\n94#1:108,3\n94#1:111,2\n*E\n"})
public final class HasPlatformTypeInspection
extends AbstractKotlinInspection {
    @JvmField
    public boolean publicAPIOnly;
    @JvmField
    public boolean reportPlatformArguments;
    @NotNull
    private final Set<KaSymbolVisibility> publicApiVisibilities;

    public HasPlatformTypeInspection(boolean publicAPIOnly, boolean reportPlatformArguments) {
        this.publicAPIOnly = publicAPIOnly;
        this.reportPlatformArguments = reportPlatformArguments;
        KaSymbolVisibility[] kaSymbolVisibilityArray = new KaSymbolVisibility[]{KaSymbolVisibility.PUBLIC, KaSymbolVisibility.PROTECTED};
        this.publicApiVisibilities = SetsKt.setOf((Object[])kaSymbolVisibilityArray);
    }

    public /* synthetic */ HasPlatformTypeInspection(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)new KtVisitorVoid(this, holder2){
            final /* synthetic */ HasPlatformTypeInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitNamedDeclaration(KtNamedDeclaration declaration) {
                void this_$iv$iv;
                void useSiteElement$iv;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                if (!(declaration instanceof KtCallableDeclaration) || ((KtCallableDeclaration)declaration).getTypeReference() != null) {
                    return;
                }
                PsiElement psiElement = ((KtCallableDeclaration)declaration).getNameIdentifier();
                if (psiElement == null) {
                    return;
                }
                PsiElement nameIdentifier = psiElement;
                KtElement ktElement = (KtElement)declaration;
                HasPlatformTypeInspection hasPlatformTypeInspection = this.this$0;
                ProblemsHolder problemsHolder = this.$holder;
                boolean $i$f$analyze = false;
                Project project = useSiteElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                void useSiteElement$iv$iv = useSiteElement$iv;
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)useSiteElement$iv$iv);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)useSiteElement$iv$iv);
                try {
                    Unit unit;
                    Object lock$iv$iv;
                    Object object = lock$iv$iv = new Object();
                    synchronized (object) {
                        boolean bl = false;
                        KaSession $this$visitNamedDeclaration_u24lambda_u240 = analysisSession$iv$iv;
                        boolean bl2 = false;
                        HasPlatformTypeInspection.access$checkForPlatformType(hasPlatformTypeInspection, $this$visitNamedDeclaration_u24lambda_u240, (KtCallableDeclaration)declaration, nameIdentifier, problemsHolder);
                        unit = Unit.INSTANCE;
                    }
                    Unit unit2 = unit;
                }
                catch (Throwable throwable$iv$iv) {
                    this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, (KtElement)useSiteElement$iv$iv);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)useSiteElement$iv$iv);
                }
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFlexibleRecursive(KaSession $this$isFlexibleRecursive, KaType type2) {
        boolean bl;
        if ($this$isFlexibleRecursive.getHasFlexibleNullability(type2)) {
            return true;
        }
        if (!(type2 instanceof KaClassType)) return false;
        KaClassType kaClassType = (KaClassType)type2;
        if (kaClassType == null) {
            return false;
        }
        KaClassType classType = kaClassType;
        Iterable $this$any$iv = classType.getTypeArguments();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            KaTypeProjection arg = (KaTypeProjection)element$iv;
            boolean bl2 = false;
            if (!(arg instanceof KaStarTypeProjection)) {
                boolean bl3;
                if (arg.getType() != null) {
                    KaType it;
                    boolean bl4 = false;
                    if (this.isFlexibleRecursive($this$isFlexibleRecursive, it)) {
                        return true;
                    }
                    bl3 = false;
                } else {
                    bl3 = false;
                }
                if (bl3) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final KaType dangerousFlexibleTypeOrNull(KaSession $this$dangerousFlexibleTypeOrNull, KtCallableDeclaration declaration, boolean publicAPIOnly, boolean reportPlatformArguments) {
        KtCallableDeclaration ktCallableDeclaration = declaration;
        if (ktCallableDeclaration instanceof KtFunction) {
            if (((KtFunction)declaration).isLocal() || ((KtFunction)declaration).hasDeclaredReturnType()) {
                return null;
            }
        } else if (ktCallableDeclaration instanceof KtProperty) {
            if (((KtProperty)declaration).isLocal() || ((KtProperty)declaration).getTypeReference() != null) {
                return null;
            }
        } else {
            return null;
        }
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
        boolean bl = ktClassOrObject != null ? ktClassOrObject.isLocal() : false;
        if (bl) {
            return null;
        }
        if (publicAPIOnly && !this.publicApiVisibilities.contains((Object)$this$dangerousFlexibleTypeOrNull.getSymbol((KtDeclaration)declaration).getVisibility())) {
            return null;
        }
        KaType type2 = $this$dangerousFlexibleTypeOrNull.getReturnType((KtDeclarationWithReturnType)declaration);
        if (type2 instanceof KaDynamicType) {
            return null;
        }
        if (reportPlatformArguments ? !this.isFlexibleRecursive($this$dangerousFlexibleTypeOrNull, type2) : !$this$dangerousFlexibleTypeOrNull.getHasFlexibleNullability(type2)) {
            return null;
        }
        return type2;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkForPlatformType(KaSession $this$checkForPlatformType, KtCallableDeclaration element, PsiElement nameIdentifier, ProblemsHolder holder2) {
        void $this$toTypedArray$iv;
        Collection<LocalQuickFix> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Iterable expression;
        KaType kaType = this.dangerousFlexibleTypeOrNull($this$checkForPlatformType, element, this.publicAPIOnly, this.reportPlatformArguments);
        if (kaType == null) {
            return;
        }
        KaType dangerousFlexibleType = kaType;
        Object[] objectArray = new ModCommandAction[]{new CallableReturnTypeUpdaterUtils.SpecifyExplicitTypeQuickFix(element, CallableReturnTypeUpdaterUtils.getTypeInfo$default(CallableReturnTypeUpdaterUtils.INSTANCE, $this$checkForPlatformType, element, false, holder2.isOnTheFly(), 4, null))};
        List fixes = CollectionsKt.mutableListOf((Object[])objectArray);
        if ($this$checkForPlatformType.isNullable(dangerousFlexibleType)) {
            KaType nonNullableType = $this$checkForPlatformType.withNullability(dangerousFlexibleType, KaTypeNullability.NON_NULLABLE);
            KtDeclarationWithInitializer ktDeclarationWithInitializer = element instanceof KtDeclarationWithInitializer ? (KtDeclarationWithInitializer)element : null;
            Object object = expression = ktDeclarationWithInitializer != null ? ktDeclarationWithInitializer.getInitializer() : null;
            if (!(expression == null || this.reportPlatformArguments && this.isFlexibleRecursive($this$checkForPlatformType, nonNullableType))) {
                fixes.add(new AddExclExclCallFix((PsiElement)expression, false, 2, null));
            }
        }
        expression = fixes;
        String string = KotlinBundle.message((String)"declaration.has.type.inferred.from.a.platform.call.which.can.lead.to.unchecked.nullability.issues", (Object[])new Object[0]);
        PsiElement psiElement = nameIdentifier;
        ProblemsHolder problemsHolder = holder2;
        boolean $i$f$map = false;
        void var10_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void action2;
            ModCommandAction modCommandAction = (ModCommandAction)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UtilsKt.asQuickFix((ModCommandAction)action2));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
        problemsHolder.registerProblem(psiElement, string, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"publicAPIOnly", (String)KotlinBundle.message((String)"apply.only.to.public.or.protected.members", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"reportPlatformArguments", (String)KotlinBundle.message((String)"report.for.types.with.platform.arguments", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    public HasPlatformTypeInspection() {
        this(false, false, 3, null);
    }

    public static final /* synthetic */ void access$checkForPlatformType(HasPlatformTypeInspection $this, KaSession $receiver, KtCallableDeclaration element, PsiElement nameIdentifier, ProblemsHolder holder2) {
        $this.checkForPlatformType($receiver, element, nameIdentifier, holder2);
    }
}

