/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.k2.codeinsight.intentions.ConvertReceiverToParameterIntention;
import org.jetbrains.kotlin.idea.k2.refactoring.UtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.changeSignature.KotlinChangeInfo;
import org.jetbrains.kotlin.idea.k2.refactoring.changeSignature.KotlinChangeSignatureProcessor;
import org.jetbrains.kotlin.idea.k2.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertReceiverToParameterIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "startInWriteAction", "", "isApplicableTo", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.kotlin.codeInsight.intentions"})
public final class ConvertReceiverToParameterIntention
extends SelfTargetingOffsetIndependentIntention<KtTypeReference>
implements LowPriorityAction {
    public ConvertReceiverToParameterIntention() {
        super(KtTypeReference.class, KotlinBundle.messagePointer((String)"convert.receiver.to.parameter", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public boolean isApplicableTo(@NotNull KtTypeReference element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        KtNamedFunction ktNamedFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
        return Intrinsics.areEqual((Object)(ktNamedFunction != null ? ktNamedFunction.getReceiverTypeReference() : null), (Object)element);
    }

    @Override
    public void applyTo(@NotNull KtTypeReference element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        KtNamedFunction ktNamedFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
        if (ktNamedFunction == null) {
            return;
        }
        KtNamedFunction function = ktNamedFunction;
        KtDeclaration ktDeclaration = (KtDeclaration)function;
        Collection collection = CollectionsKt.emptyList();
        String string = RefactoringBundle.message((String)"to.refactor");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        List<PsiElement> superMethods = UtilsKt.checkSuperMethods(ktDeclaration, collection, string);
        Object object = CollectionsKt.lastOrNull(superMethods);
        KtNamedFunction ktNamedFunction2 = object instanceof KtNamedFunction ? (KtNamedFunction)object : null;
        if (ktNamedFunction2 == null) {
            return;
        }
        KtNamedFunction superFunction = ktNamedFunction2;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        KotlinMethodDescriptor methodDescriptor = new KotlinMethodDescriptor((KtNamedDeclaration)superFunction);
        KotlinChangeInfo changeInfo = new KotlinChangeInfo(methodDescriptor, null, null, null, null, null, false, 126, null);
        changeInfo.setReceiverParameterInfo((KotlinParameterInfo)null);
        new KotlinChangeSignatureProcessor(project2, changeInfo, function, editor){
            final /* synthetic */ Project $project;
            final /* synthetic */ KtNamedFunction $function;
            final /* synthetic */ Editor $editor;
            {
                this.$project = $project;
                this.$function = $function;
                this.$editor = $editor;
                super($project, $changeInfo);
            }

            protected void performRefactoring(UsageInfo[] usages2) {
                Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
                super.performRefactoring(usages2);
                DumbService.Companion.getInstance(this.$project).smartInvokeLater(() -> applyTo.1.performRefactoring$lambda$0(this.$function, this.$editor));
            }

            private static final void performRefactoring$lambda$0(KtNamedFunction $function, Editor $editor) {
                if ($function.isValid() && $editor != null && !$editor.isDisposed()) {
                    KtParameter firstParameter;
                    Object object = $function.getValueParameterList();
                    KtParameter ktParameter = object != null && (object = object.getParameters()) != null ? (KtParameter)object.get(0) : (firstParameter = null);
                    if (firstParameter != null) {
                        UtilsKt.renameParameter(firstParameter, $editor);
                    }
                }
            }
        }.run();
    }
}

