/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.pushDown;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolModality;
import org.jetbrains.kotlin.analysis.api.types.KaSubstitutor;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.pullUp.PullUpUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.pushDown.PushDownImplKt;
import org.jetbrains.kotlin.idea.k2.refactoring.pushDown.RemovalAction;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapper;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a&\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001e\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u000b"}, d2={"createRemoveOriginalMemberAction", "Lorg/jetbrains/kotlin/idea/k2/refactoring/pushDown/RemovalAction;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "sourceClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "memberInfo", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "substitutor", "Lorg/jetbrains/kotlin/analysis/api/types/KaSubstitutor;", "createRemoveCallableMemberAction", "createRemoveClassLikeMemberAction", "intellij.kotlin.refactorings"})
public final class PushDownMemberRemovalKt {
    @Nullable
    public static final RemovalAction createRemoveOriginalMemberAction(@NotNull KaSession $this$createRemoveOriginalMemberAction, @NotNull KtClass sourceClass, @NotNull KotlinMemberInfo memberInfo, @NotNull KaSubstitutor substitutor2) {
        Intrinsics.checkNotNullParameter((Object)$this$createRemoveOriginalMemberAction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sourceClass, (String)"sourceClass");
        Intrinsics.checkNotNullParameter((Object)((Object)memberInfo), (String)"memberInfo");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)memberInfo.getMember();
        return ktNamedDeclaration instanceof KtProperty || ktNamedDeclaration instanceof KtNamedFunction ? PushDownMemberRemovalKt.createRemoveCallableMemberAction($this$createRemoveOriginalMemberAction, memberInfo, sourceClass, substitutor2) : (ktNamedDeclaration instanceof KtClassOrObject || ktNamedDeclaration instanceof KtPsiClassWrapper ? PushDownMemberRemovalKt.createRemoveClassLikeMemberAction($this$createRemoveOriginalMemberAction, memberInfo, sourceClass) : null);
    }

    private static final RemovalAction createRemoveCallableMemberAction(KaSession $this$createRemoveCallableMemberAction, KotlinMemberInfo memberInfo, KtClass sourceClass, KaSubstitutor substitutor2) {
        PsiElement psiElement = memberInfo.getMember();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
        KtCallableDeclaration member = (KtCallableDeclaration)psiElement;
        KaDeclarationSymbol kaDeclarationSymbol = $this$createRemoveCallableMemberAction.getSymbol((KtDeclaration)member);
        KaCallableSymbol kaCallableSymbol = kaDeclarationSymbol instanceof KaCallableSymbol ? (KaCallableSymbol)kaDeclarationSymbol : null;
        if (kaCallableSymbol == null) {
            return null;
        }
        KaCallableSymbol memberSymbol = kaCallableSymbol;
        if (memberSymbol.getModality() != KaSymbolModality.ABSTRACT && memberInfo.isToAbstract()) {
            String renderedType = PullUpUtilsKt.computeAndRenderReturnType($this$createRemoveCallableMemberAction, memberSymbol, member, substitutor2);
            return () -> PushDownMemberRemovalKt.createRemoveCallableMemberAction$lambda$0(member, renderedType, sourceClass);
        }
        return () -> PushDownMemberRemovalKt.createRemoveCallableMemberAction$lambda$1(member);
    }

    private static final RemovalAction createRemoveClassLikeMemberAction(KaSession $this$createRemoveClassLikeMemberAction, KotlinMemberInfo memberInfo, KtClass sourceClass) {
        RemovalAction removalAction;
        KtNamedDeclaration member = (KtNamedDeclaration)memberInfo.getMember();
        if (memberInfo.getOverrides() != null) {
            KtClassOrObject ktClassOrObject = (KtClassOrObject)sourceClass;
            Intrinsics.checkNotNull((Object)member);
            KaDeclarationSymbol kaDeclarationSymbol = $this$createRemoveClassLikeMemberAction.getSymbol((KtDeclaration)member);
            Intrinsics.checkNotNull((Object)kaDeclarationSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol");
            KtSuperTypeListEntry ktSuperTypeListEntry = PushDownImplKt.getSuperTypeEntryBySymbol($this$createRemoveClassLikeMemberAction, ktClassOrObject, (KaClassSymbol)kaDeclarationSymbol);
            if (ktSuperTypeListEntry == null) {
                return null;
            }
            KtSuperTypeListEntry superTypeListEntry = ktSuperTypeListEntry;
            removalAction = () -> PushDownMemberRemovalKt.createRemoveClassLikeMemberAction$lambda$0(sourceClass, superTypeListEntry);
        } else {
            removalAction = () -> PushDownMemberRemovalKt.createRemoveClassLikeMemberAction$lambda$1(member);
        }
        return removalAction;
    }

    private static final void createRemoveCallableMemberAction$lambda$0(KtCallableDeclaration $member, String $renderedType, KtClass $sourceClass) {
        block2: {
            if ($member.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                $member.addModifier(KtTokens.PROTECTED_KEYWORD);
            }
            if ($renderedType != null) {
                Project project = $member.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                $member.setTypeReference(new KtPsiFactory(project, false, 2, null).createType($renderedType));
            }
            PullUpUtilsKt.makeAbstract($member, $sourceClass);
            KtTypeReference ktTypeReference = $member.getTypeReference();
            if (ktTypeReference == null) break block2;
            KtTypeReference typeReference = ktTypeReference;
            boolean bl = false;
            ShortenUtilsKt.shortenReferences$default((KtElement)typeReference, null, null, null, 14, null);
        }
    }

    private static final void createRemoveCallableMemberAction$lambda$1(KtCallableDeclaration $member) {
        $member.delete();
    }

    private static final void createRemoveClassLikeMemberAction$lambda$0(KtClass $sourceClass, KtSuperTypeListEntry $superTypeListEntry) {
        $sourceClass.removeSuperTypeListEntry($superTypeListEntry);
    }

    private static final void createRemoveClassLikeMemberAction$lambda$1(KtNamedDeclaration $member) {
        $member.delete();
    }
}

