/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.actions.generate.AbstractDomGenerateProvider;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.actions.MavenPomActionsKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0014J(\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/maven/actions/KotlinMavenExecutionProvider;", "Lcom/intellij/util/xml/actions/generate/AbstractDomGenerateProvider;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "goal", "", "phase", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getGoal", "()Ljava/lang/String;", "getPhase", "generate", "parent", "Lcom/intellij/util/xml/DomElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getElementToNavigate", "t", "getParentDomElement", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailableForElement", "", "contextElement", "intellij.kotlin.maven"})
@SourceDebugExtension(value={"SMAP\nMavenPomActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenPomActions.kt\norg/jetbrains/kotlin/idea/maven/actions/KotlinMavenExecutionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n2746#2,2:136\n1761#2,3:138\n2748#2:141\n*S KotlinDebug\n*F\n+ 1 MavenPomActions.kt\norg/jetbrains/kotlin/idea/maven/actions/KotlinMavenExecutionProvider\n*L\n106#1:136,2\n106#1:138,3\n106#1:141\n*E\n"})
final class KotlinMavenExecutionProvider
extends AbstractDomGenerateProvider<MavenDomPlugin> {
    @NotNull
    private final String goal;
    @NotNull
    private final String phase;

    public KotlinMavenExecutionProvider(@NotNull String goal, @NotNull String phase) {
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        super("kotlin-maven-execution-provider", "kotlin-maven-execution-provider", MavenDomPlugin.class);
        this.goal = goal;
        this.phase = phase;
    }

    @NotNull
    public final String getGoal() {
        return this.goal;
    }

    @NotNull
    public final String getPhase() {
        return this.phase;
    }

    @Nullable
    public MavenDomPlugin generate(@Nullable DomElement parent, @Nullable Editor editor) {
        block2: {
            if (!(parent instanceof MavenDomPlugin)) {
                return null;
            }
            XmlFile xmlFile = DomUtil.getFile((DomElement)parent);
            Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
            PomFile pomFile = PomFile.Companion.forFileOrNull(xmlFile);
            if (pomFile == null) {
                return null;
            }
            PomFile file = pomFile;
            MavenDomPluginExecution execution = file.addExecution((MavenDomPlugin)parent, this.goal, this.phase, CollectionsKt.listOf((Object)this.goal));
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block2;
            XmlElement xmlElement = execution.ensureXmlElementExists();
            Intrinsics.checkNotNullExpressionValue((Object)xmlElement, (String)"ensureXmlElementExists(...)");
            editor2.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)xmlElement)));
        }
        return (MavenDomPlugin)parent;
    }

    @Nullable
    protected DomElement getElementToNavigate(@Nullable MavenDomPlugin t) {
        return null;
    }

    @Nullable
    protected DomElement getParentDomElement(@Nullable Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        if (project == null || editor == null || file == null) {
            return null;
        }
        DomElement domElement = DomUtil.getContextElement((Editor)editor);
        return (DomElement)(domElement != null ? MavenPomActionsKt.access$findPlugin(domElement) : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailableForElement(@NotNull DomElement contextElement) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)contextElement, (String)"contextElement");
        MavenDomPlugin plugin = MavenPomActionsKt.access$findPlugin(contextElement);
        if (plugin == null) return false;
        if (!MavenPomActionsKt.access$isKotlinMavenPlugin(plugin)) return false;
        List list2 = plugin.getExecutions().getExecutions();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExecutions(...)");
        Iterable $this$none$iv = list2;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            MavenDomPluginExecution it = (MavenDomPluginExecution)element$iv;
            boolean bl2 = false;
            List list3 = it.getGoals().getGoals();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getGoals(...)");
            Iterable $this$any$iv = list3;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
                continue;
            }
            for (Object element$iv2 : $this$any$iv) {
                MavenDomGoal it2 = (MavenDomGoal)element$iv2;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it2.getValue(), (Object)this.goal)) continue;
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }
}

