/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectConfiguration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.LibraryKind;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.projectConfiguration.CustomLibraryDescriptionWithDeferredConfig;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/projectConfiguration/JavaRuntimeLibraryDescription;", "Lorg/jetbrains/kotlin/idea/projectConfiguration/CustomLibraryDescriptionWithDeferredConfig;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "configureKotlinSettings", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "Companion", "intellij.kotlin.projectConfiguration"})
public final class JavaRuntimeLibraryDescription
extends CustomLibraryDescriptionWithDeferredConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final LibraryKind KOTLIN_JAVA_RUNTIME_KIND;
    @NotNull
    public static final String LIBRARY_NAME = "KotlinJavaRuntime";
    @NotNull
    private static final Set<LibraryKind> SUITABLE_LIBRARY_KINDS;

    public JavaRuntimeLibraryDescription(@Nullable Project project) {
        super(project, "java", LIBRARY_NAME, KOTLIN_JAVA_RUNTIME_KIND, SUITABLE_LIBRARY_KINDS);
    }

    @Override
    protected void configureKotlinSettings(@NotNull Project project, @Nullable Sdk sdk2) {
        Kotlin2JvmCompilerArgumentsHolder kotlin2JvmCompilerArgumentsHolder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JvmTarget defaultJvmTarget = KotlinProjectConfigurationUtils.getDefaultJvmTarget(sdk2, KotlinPluginLayout.getIdeCompilerVersion());
        if (defaultJvmTarget != null && ((K2JVMCompilerArguments)(kotlin2JvmCompilerArgumentsHolder = Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance(project)).getSettings()).getJvmTarget() == null) {
            kotlin2JvmCompilerArgumentsHolder.update(arg_0 -> JavaRuntimeLibraryDescription.configureKotlinSettings$lambda$0(defaultJvmTarget, arg_0));
        }
    }

    private static final Unit configureKotlinSettings$lambda$0(JvmTarget $defaultJvmTarget, K2JVMCompilerArguments $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        $this$update.setJvmTarget($defaultJvmTarget.getDescription());
        return Unit.INSTANCE;
    }

    static {
        LibraryKind libraryKind = LibraryKind.create((String)"kotlin-java-runtime");
        Intrinsics.checkNotNullExpressionValue((Object)libraryKind, (String)"create(...)");
        KOTLIN_JAVA_RUNTIME_KIND = libraryKind;
        SUITABLE_LIBRARY_KINDS = SetsKt.setOf((Object)KOTLIN_JAVA_RUNTIME_KIND);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/projectConfiguration/JavaRuntimeLibraryDescription$Companion;", "", "<init>", "()V", "KOTLIN_JAVA_RUNTIME_KIND", "Lcom/intellij/openapi/roots/libraries/LibraryKind;", "getKOTLIN_JAVA_RUNTIME_KIND", "()Lcom/intellij/openapi/roots/libraries/LibraryKind;", "LIBRARY_NAME", "", "JAVA_RUNTIME_LIBRARY_CREATION", "getJAVA_RUNTIME_LIBRARY_CREATION", "()Ljava/lang/String;", "DIALOG_TITLE", "getDIALOG_TITLE", "SUITABLE_LIBRARY_KINDS", "", "getSUITABLE_LIBRARY_KINDS", "()Ljava/util/Set;", "intellij.kotlin.projectConfiguration"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LibraryKind getKOTLIN_JAVA_RUNTIME_KIND() {
            return KOTLIN_JAVA_RUNTIME_KIND;
        }

        @Nls
        @NotNull
        public final String getJAVA_RUNTIME_LIBRARY_CREATION() {
            return KotlinProjectConfigurationBundle.message("java.runtime.library.creation", new Object[0]);
        }

        @Nls
        @NotNull
        public final String getDIALOG_TITLE() {
            return KotlinProjectConfigurationBundle.message("create.kotlin.java.runtime.library", new Object[0]);
        }

        @NotNull
        public final Set<LibraryKind> getSUITABLE_LIBRARY_KINDS() {
            return SUITABLE_LIBRARY_KINDS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

