/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinPsiUpdateModCommandAction;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0015\u0016B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\r\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeToMutableCollectionFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinPsiUpdateModCommandAction$ElementBased;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeToMutableCollectionFix$ElementContext;", "property", "context", "<init>", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/idea/quickfix/ChangeToMutableCollectionFix$ElementContext;)V", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "Lcom/intellij/modcommand/ActionContext;", "element", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "invoke", "", "actionContext", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "ElementContext", "Companion", "kotlin.idea"})
public final class ChangeToMutableCollectionFix
extends KotlinPsiUpdateModCommandAction.ElementBased<KtProperty, ElementContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String COLLECTIONS = "kotlin.collections";
    @NotNull
    private static final Map<String, String> mutableConversionMap;

    public ChangeToMutableCollectionFix(@NotNull KtProperty property, @NotNull ElementContext context2) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((PsiElement)property, context2);
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ElementContext elementContext = (ElementContext)this.getElementContext(context2, (PsiElement)element);
        Object[] objectArray = new Object[]{"Mutable" + elementContext.getTypeName()};
        Presentation presentation = Presentation.of((String)KotlinBundle.message((String)"fix.change.to.mutable.type.text", (Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
        return presentation;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.change.to.mutable.type.family", (Object[])new Object[0]);
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtProperty element, @NotNull ElementContext elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        KtProperty property = element;
        BindingContext context2 = ResolutionUtils.analyze((KtElement)property, BodyResolveMode.PARTIAL);
        KtExpression ktExpression = property.getInitializer();
        if (ktExpression == null || (ktExpression = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)context2)) == null) {
            return;
        }
        KtExpression type2 = ktExpression;
        Companion.applyFix(property, (KotlinType)type2);
        updater2.moveCaretTo(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)property)));
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"kotlin.collections.listOf", (Object)"mutableListOf"), TuplesKt.to((Object)"kotlin.collections.setOf", (Object)"mutableSetOf"), TuplesKt.to((Object)"kotlin.collections.mapOf", (Object)"mutableMapOf")};
        mutableConversionMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\nR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeToMutableCollectionFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "isReadOnlyListOrMap", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "isApplicable", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "applyFix", "", "type", "COLLECTIONS", "", "mutableConversionMap", "", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nChangeToMutableCollectionFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeToMutableCollectionFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeToMutableCollectionFix$Companion\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n29#2,7:106\n29#2,7:113\n1#3:120\n*S KotlinDebug\n*F\n+ 1 ChangeToMutableCollectionFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeToMutableCollectionFix$Companion\n*L\n77#1:106,7\n86#1:113,7\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = ((SimpleDiagnostic)Errors.NO_SET_METHOD.cast((UnboundDiagnostic)diagnostic)).getPsiElement();
            KtArrayAccessExpression ktArrayAccessExpression = psiElement instanceof KtArrayAccessExpression ? (KtArrayAccessExpression)psiElement : null;
            if (ktArrayAccessExpression == null) {
                return null;
            }
            KtArrayAccessExpression element = ktArrayAccessExpression;
            KtExpression ktExpression = element.getArrayExpression();
            if (ktExpression == null) {
                return null;
            }
            KtExpression arrayExpr = ktExpression;
            BindingContext context2 = ResolutionUtils.analyze((KtElement)arrayExpr, BodyResolveMode.PARTIAL);
            KotlinType kotlinType = CallUtilKt.getType((KtExpression)arrayExpr, (BindingContext)context2);
            if (kotlinType == null) {
                return null;
            }
            KotlinType type2 = kotlinType;
            if (!this.isReadOnlyListOrMap(type2, PlatformKt.getBuiltIns((KtElement)element))) {
                return null;
            }
            KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)arrayExpr));
            PsiElement psiElement2 = ktReference != null ? ktReference.resolve() : null;
            KtProperty ktProperty = psiElement2 instanceof KtProperty ? (KtProperty)psiElement2 : null;
            if (ktProperty == null) {
                return null;
            }
            KtProperty property = ktProperty;
            if (!this.isApplicable(property)) {
                return null;
            }
            Object object = type2.getConstructor().getDeclarationDescriptor();
            if (object == null || (object = object.getName()) == null || (object = object.asString()) == null) {
                return null;
            }
            Object typeName = object;
            return new ChangeToMutableCollectionFix(property, new ElementContext((String)typeName)).asIntention();
        }

        private final boolean isReadOnlyListOrMap(KotlinType $this$isReadOnlyListOrMap, KotlinBuiltIns builtIns) {
            ClassifierDescriptor classifierDescriptor = $this$isReadOnlyListOrMap.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null || (classifierDescriptor = classifierDescriptor.getDefaultType()) == null) {
                return false;
            }
            ClassifierDescriptor leftDefaultType = classifierDescriptor;
            Object[] objectArray = new SimpleType[]{builtIns.getList().getDefaultType(), builtIns.getMap().getDefaultType()};
            return CollectionsKt.listOf((Object[])objectArray).contains(leftDefaultType);
        }

        public final boolean isApplicable(@NotNull KtProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            return property.isLocal() && property.getInitializer() != null;
        }

        /*
         * WARNING - void declaration
         */
        public final void applyFix(@NotNull KtProperty property, @NotNull KotlinType type2) {
            block18: {
                KtTypeReference ktTypeReference;
                KtPsiFactory psiFactory;
                block17: {
                    PsiElement psiElement;
                    void newElement$iv;
                    void $this$replaced$iv;
                    KtCallExpression ktCallExpression;
                    KtExpression initializer2;
                    block15: {
                        block16: {
                            PsiElement psiElement2;
                            void $this$replaced$iv2;
                            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                            KtExpression ktExpression = property.getInitializer();
                            if (ktExpression == null) {
                                return;
                            }
                            initializer2 = ktExpression;
                            ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)initializer2, null, 1, null);
                            String fqName2 = resolvedCall != null && (resolvedCall = resolvedCall.getResultingDescriptor()) != null && (resolvedCall = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall))) != null ? resolvedCall.asString() : null;
                            Project project = property.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                            psiFactory = new KtPsiFactory(project, false, 2, null);
                            String mutableOf = (String)mutableConversionMap.get(fqName2);
                            if (mutableOf == null) break block15;
                            ktCallExpression = initializer2 instanceof KtCallExpression ? (KtCallExpression)initializer2 : null;
                            if (ktCallExpression == null || (ktCallExpression = ktCallExpression.getCalleeExpression()) == null) break block16;
                            PsiElement psiElement3 = (PsiElement)ktCallExpression;
                            PsiElement newElement$iv2 = (PsiElement)psiFactory.createExpression(mutableOf);
                            boolean $i$f$replaced = false;
                            if (Intrinsics.areEqual((Object)$this$replaced$iv2, (Object)newElement$iv2)) {
                                psiElement2 = newElement$iv2;
                            } else {
                                PsiElement result$iv = $this$replaced$iv2.replace(newElement$iv2);
                                if (result$iv instanceof KtExpression) {
                                    psiElement2 = result$iv;
                                } else {
                                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                                    KtExpression ktExpression2 = ((KtParenthesizedExpression)result$iv).getExpression();
                                    if (ktExpression2 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                                    }
                                    psiElement2 = (PsiElement)ktExpression2;
                                }
                            }
                            if ((ktCallExpression = (KtExpression)psiElement2) != null) break block17;
                        }
                        return;
                    }
                    KotlinBuiltIns builtIns = PlatformKt.getBuiltIns((KtElement)property);
                    TypeConstructor $this$replaced$iv2 = type2.getConstructor();
                    String string = Intrinsics.areEqual((Object)$this$replaced$iv2, (Object)builtIns.getList().getDefaultType().getConstructor()) ? "toMutableList" : (Intrinsics.areEqual((Object)$this$replaced$iv2, (Object)builtIns.getSet().getDefaultType().getConstructor()) ? "toMutableSet" : (Intrinsics.areEqual((Object)$this$replaced$iv2, (Object)builtIns.getMap().getDefaultType().getConstructor()) ? "toMutableMap" : null));
                    if (string == null) {
                        return;
                    }
                    String toMutable = string;
                    PsiElement newElement$iv2 = (PsiElement)initializer2;
                    Object[] $i$f$replaced = new Object[]{initializer2, toMutable};
                    $i$f$replaced = (Object[])CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"($0).$1()", (Object[])$i$f$replaced, (boolean)false, (int)4, null);
                    boolean $i$f$replaced2 = false;
                    if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                        psiElement = newElement$iv;
                    } else {
                        PsiElement result$iv = $this$replaced$iv.replace((PsiElement)newElement$iv);
                        if (result$iv instanceof KtExpression) {
                            psiElement = result$iv;
                        } else {
                            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                            if (ktExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                            }
                            psiElement = (PsiElement)ktExpression;
                        }
                    }
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
                    KtDotQualifiedExpression dotQualifiedExpression = (KtDotQualifiedExpression)psiElement;
                    KtExpression receiver2 = dotQualifiedExpression.getReceiverExpression();
                    KtExpression deparenthesize = KtPsiUtil.deparenthesize((KtExpression)dotQualifiedExpression.getReceiverExpression());
                    if (deparenthesize != null && !Intrinsics.areEqual((Object)receiver2, (Object)deparenthesize)) {
                        receiver2.replace((PsiElement)deparenthesize);
                    }
                    ktCallExpression = Unit.INSTANCE;
                }
                KtTypeReference ktTypeReference2 = property.getTypeReference();
                if (ktTypeReference2 == null) break block18;
                KtTypeReference it = ktTypeReference = ktTypeReference2;
                boolean bl = false;
                it.replace((PsiElement)psiFactory.createType("Mutable" + it.getText()));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeToMutableCollectionFix$ElementContext;", "", "typeName", "", "<init>", "(Ljava/lang/String;)V", "getTypeName", "()Ljava/lang/String;", "kotlin.idea"})
    public static final class ElementContext {
        @NotNull
        private final String typeName;

        public ElementContext(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            this.typeName = typeName;
        }

        @NotNull
        public final String getTypeName() {
            return this.typeName;
        }
    }
}

