/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.migration;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.CleanupFix;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.intentions.declarations.ConvertMemberToExtensionIntention;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrateExternalExtensionFix$fixNativeClass$;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002$%B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0094\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0002H\u0002J\u001a\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\"\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00182\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J4\u0010\u001d\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0004\u001a\u00020 2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\b\b\u0002\u0010#\u001a\u00020\u000bH\u0002\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/CleanupFix;", "declaration", "<init>", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)V", "getText", "", "getFamilyName", "startInWriteAction", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "fixNativeClass", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "fetchJsNativeAnnotations", "Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix$JsNativeAnnotations;", "fixExtensionMemberDeclaration", "fixAnnotations", "annotations", "convertNativeAnnotationToJsName", "appendParameters", "Lorg/jetbrains/kotlin/psi/BuilderByPattern;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "lParenth", "rParenth", "skipLast", "JsNativeAnnotations", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nMigrateExternalExtensionFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrateExternalExtensionFix.kt\norg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n1#2:289\n477#3:290\n1869#4,2:291\n1869#4,2:293\n1869#4,2:295\n*S KotlinDebug\n*F\n+ 1 MigrateExternalExtensionFix.kt\norg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix\n*L\n52#1:290\n59#1:291,2\n91#1:293,2\n197#1:295,2\n*E\n"})
public final class MigrateExternalExtensionFix
extends KotlinQuickFixAction<KtNamedDeclaration>
implements CleanupFix {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MigrateExternalExtensionFix(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        super((PsiElement)declaration);
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message((String)"fix.with.asdynamic", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)this.getElement();
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration declaration = ktNamedDeclaration;
        if (MigrateExternalExtensionFix.Companion.isMemberExtensionDeclaration((PsiElement)declaration)) {
            this.fixExtensionMemberDeclaration(declaration, editor);
        } else if (MigrateExternalExtensionFix.Companion.isMemberDeclaration((PsiElement)declaration)) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
            if (ktClassOrObject != null) {
                KtClassOrObject p0 = ktClassOrObject;
                boolean bl = false;
                this.fixNativeClass(p0);
            }
        } else if (declaration instanceof KtClassOrObject) {
            this.fixNativeClass((KtClassOrObject)declaration);
        }
    }

    private final void fixNativeClass(KtClassOrObject containingClass) {
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)containingClass.getDeclarations());
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)fixNativeClass$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List membersToFix = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)sequence, MigrateExternalExtensionFix::fixNativeClass$lambda$0), arg_0 -> MigrateExternalExtensionFix.fixNativeClass$lambda$1(this, arg_0)), MigrateExternalExtensionFix::fixNativeClass$lambda$2));
        Iterable $this$forEach$iv = CollectionsKt.asReversed((List)membersToFix);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            KtCallableDeclaration memberDeclaration = (KtCallableDeclaration)pair.component1();
            JsNativeAnnotations annotations2 = (JsNativeAnnotations)pair.component2();
            if (!(annotations2.getNativeAnnotation() == null || annotations2.isGetter() || annotations2.isSetter() || annotations2.isInvoke())) {
                this.convertNativeAnnotationToJsName((KtNamedDeclaration)memberDeclaration, annotations2);
                annotations2.getNativeAnnotation().delete();
                continue;
            }
            KtCallableDeclaration externalDeclaration = ConvertMemberToExtensionIntention.Holder.INSTANCE.convert(memberDeclaration);
            ActionsKt.runWriteAction(() -> MigrateExternalExtensionFix.fixNativeClass$lambda$3$0(this, externalDeclaration));
        }
        JsNativeAnnotations classAnnotations = this.fetchJsNativeAnnotations((KtNamedDeclaration)containingClass);
        this.fixAnnotations((KtNamedDeclaration)containingClass, classAnnotations, null);
    }

    private final JsNativeAnnotations fetchJsNativeAnnotations(KtNamedDeclaration declaration) {
        ArrayList<KtAnnotationEntry> nativeAnnotations;
        KtAnnotationEntry nativeAnnotation;
        boolean isInvoke;
        boolean isSetter;
        boolean isGetter;
        block4: {
            isGetter = false;
            isSetter = false;
            isInvoke = false;
            nativeAnnotation = null;
            nativeAnnotations = new ArrayList<KtAnnotationEntry>();
            Object object = declaration.getModifierList();
            if (object == null || (object = object.getAnnotationEntries()) == null) break block4;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                PredefinedAnnotation[] predefinedAnnotationArray = new PredefinedAnnotation[]{PredefinedAnnotation.NATIVE_GETTER};
                if (MigrateExternalExtensionFix.Companion.isJsAnnotation(it, predefinedAnnotationArray)) {
                    isGetter = true;
                    nativeAnnotations.add(it);
                    continue;
                }
                predefinedAnnotationArray = new PredefinedAnnotation[]{PredefinedAnnotation.NATIVE_SETTER};
                if (MigrateExternalExtensionFix.Companion.isJsAnnotation(it, predefinedAnnotationArray)) {
                    isSetter = true;
                    nativeAnnotations.add(it);
                    continue;
                }
                predefinedAnnotationArray = new PredefinedAnnotation[]{PredefinedAnnotation.NATIVE_INVOKE};
                if (MigrateExternalExtensionFix.Companion.isJsAnnotation(it, predefinedAnnotationArray)) {
                    isInvoke = true;
                    nativeAnnotations.add(it);
                    continue;
                }
                predefinedAnnotationArray = new PredefinedAnnotation[]{PredefinedAnnotation.NATIVE};
                if (!MigrateExternalExtensionFix.Companion.isJsAnnotation(it, predefinedAnnotationArray)) continue;
                nativeAnnotations.add(it);
                nativeAnnotation = it;
            }
        }
        return new JsNativeAnnotations((List<? extends KtAnnotationEntry>)nativeAnnotations, nativeAnnotation, isGetter, isSetter, isInvoke);
    }

    private final void fixExtensionMemberDeclaration(KtNamedDeclaration declaration, Editor editor) {
        Name name2 = declaration.getNameAsSafeName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getNameAsSafeName(...)");
        Name name3 = name2;
        JsNativeAnnotations annotations2 = this.fetchJsNativeAnnotations(declaration);
        ActionsKt.runWriteAction(() -> MigrateExternalExtensionFix.fixExtensionMemberDeclaration$lambda$0(this, declaration, annotations2, editor, name3));
    }

    private final void fixAnnotations(KtNamedDeclaration declaration, JsNativeAnnotations annotations2, Editor editor) {
        Iterable $this$forEach$iv = annotations2.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
            boolean bl = false;
            it.delete();
        }
        if (declaration instanceof KtClassOrObject) {
            ((KtClassOrObject)declaration).addModifier(KtTokens.EXTERNAL_KEYWORD);
        } else {
            declaration.addModifier(KtTokens.INLINE_KEYWORD);
            declaration.removeModifier(KtTokens.EXTERNAL_KEYWORD);
        }
        if (declaration instanceof KtFunction) {
            ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)declaration, StandardNames.FqNames.suppress, "\"NOTHING_TO_INLINE\"", null, null, 12, null);
        }
        this.convertNativeAnnotationToJsName(declaration, annotations2);
        if (declaration instanceof KtFunction && !((KtFunction)declaration).hasDeclaredReturnType() && !annotations2.isSetter() && !annotations2.isInvoke() && editor != null) {
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)declaration;
            SimpleType simpleType = PlatformKt.getBuiltIns((KtElement)declaration).getUnitType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getUnitType(...)");
            SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(editor, ktCallableDeclaration, (KotlinType)simpleType);
        }
    }

    private final void convertNativeAnnotationToJsName(KtNamedDeclaration declaration, JsNativeAnnotations annotations2) {
        KtAnnotationEntry nativeAnnotation = annotations2.getNativeAnnotation();
        if (nativeAnnotation != null) {
            List list2 = nativeAnnotation.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
            if (!((Collection)list2).isEmpty()) {
                KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)declaration;
                FqName fqName2 = new FqName("JsName");
                List list3 = nativeAnnotation.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueArguments(...)");
                ModifierListModifactorKt.addAnnotation$default(ktModifierListOwner, fqName2, CollectionsKt.joinToString$default((Iterable)list3, null, null, null, (int)0, null, MigrateExternalExtensionFix::convertNativeAnnotationToJsName$lambda$0, (int)31, null), null, null, 12, null);
            }
        }
    }

    private final void appendParameters(BuilderByPattern<KtExpression> $this$appendParameters, KtNamedFunction declaration, String lParenth, String rParenth, boolean skipLast) {
        List list2;
        $this$appendParameters.appendFixedText(lParenth);
        List it = declaration.getValueParameters();
        boolean bl = false;
        if (skipLast) {
            Intrinsics.checkNotNull((Object)it);
            list2 = CollectionsKt.take((Iterable)it, (int)(it.size() - 1));
        } else {
            Intrinsics.checkNotNull((Object)it);
            list2 = it;
        }
        Iterator iterator2 = ((Iterable)list2).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            Name paramName;
            int index2 = n++;
            KtParameter param = (KtParameter)iterator2.next();
            if (param.getNameAsName() == null) continue;
            boolean bl2 = false;
            if (index2 > 0) {
                $this$appendParameters.appendFixedText(",");
            }
            $this$appendParameters.appendName(paramName);
        }
        $this$appendParameters.appendFixedText(rParenth);
    }

    static /* synthetic */ void appendParameters$default(MigrateExternalExtensionFix migrateExternalExtensionFix, BuilderByPattern builderByPattern, KtNamedFunction ktNamedFunction, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        migrateExternalExtensionFix.appendParameters((BuilderByPattern<KtExpression>)builderByPattern, ktNamedFunction, string, string2, bl);
    }

    private static final boolean fixNativeClass$lambda$0(KtCallableDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MigrateExternalExtensionFix.Companion.isMemberDeclaration((PsiElement)it) && !MigrateExternalExtensionFix.Companion.isMemberExtensionDeclaration((PsiElement)it);
    }

    private static final Pair fixNativeClass$lambda$1(MigrateExternalExtensionFix this$0, KtCallableDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TuplesKt.to((Object)it, (Object)this$0.fetchJsNativeAnnotations((KtNamedDeclaration)it));
    }

    private static final boolean fixNativeClass$lambda$2(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !((Collection)((JsNativeAnnotations)it.getSecond()).getAnnotations()).isEmpty();
    }

    private static final Unit fixNativeClass$lambda$3$0(MigrateExternalExtensionFix this$0, KtCallableDeclaration $externalDeclaration) {
        this$0.fixExtensionMemberDeclaration((KtNamedDeclaration)$externalDeclaration, null);
        return Unit.INSTANCE;
    }

    private static final Unit fixExtensionMemberDeclaration$lambda$0(MigrateExternalExtensionFix this$0, KtNamedDeclaration $declaration, JsNativeAnnotations $annotations, Editor $editor, Name $name) {
        this$0.fixAnnotations($declaration, $annotations, $editor);
        Project project = $declaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtExpression body2 = CreateByPatternKt.buildExpression$default((KtPsiFactory)psiFactory, (boolean)false, arg_0 -> MigrateExternalExtensionFix.fixExtensionMemberDeclaration$lambda$0$0($annotations, $declaration, this$0, $name, arg_0), (int)1, null);
        if ($declaration instanceof KtNamedFunction) {
            KtExpression ktExpression = ((KtNamedFunction)$declaration).getBodyExpression();
            if (ktExpression != null) {
                ktExpression.delete();
            }
            PsiElement psiElement = ((KtNamedFunction)$declaration).getEqualsToken();
            if (psiElement != null) {
                psiElement.delete();
            }
            if ($annotations.isSetter() || $annotations.isInvoke()) {
                KtBlockExpression blockBody = KtPsiFactory.createSingleStatementBlock$default((KtPsiFactory)psiFactory, (KtExpression)body2, null, null, (int)6, null);
                v3 = ((KtNamedFunction)$declaration).add((PsiElement)blockBody);
            } else {
                ((KtNamedFunction)$declaration).add(psiFactory.createEQ());
                v3 = ((KtNamedFunction)$declaration).add((PsiElement)body2);
            }
        } else if ($declaration instanceof KtProperty) {
            KtPropertyAccessor ktPropertyAccessor = ((KtProperty)$declaration).getSetter();
            if (ktPropertyAccessor != null) {
                ktPropertyAccessor.delete();
            }
            KtPropertyAccessor ktPropertyAccessor2 = ((KtProperty)$declaration).getGetter();
            if (ktPropertyAccessor2 != null) {
                ktPropertyAccessor2.delete();
            }
            KtPropertyAccessor getter = psiFactory.createPropertyGetter(body2);
            ((KtProperty)$declaration).add((PsiElement)getter);
            if (((KtProperty)$declaration).isVar()) {
                KtExpression setterBody = CreateByPatternKt.buildExpression$default((KtPsiFactory)psiFactory, (boolean)false, arg_0 -> MigrateExternalExtensionFix.fixExtensionMemberDeclaration$lambda$0$1($name, arg_0), (int)1, null);
                KtProperty setterStubProperty = psiFactory.createProperty("val x: Unit set(value) { Unit }");
                KtPropertyAccessor ktPropertyAccessor3 = setterStubProperty.getSetter();
                Intrinsics.checkNotNull((Object)ktPropertyAccessor3);
                KtBlockExpression ktBlockExpression = ktPropertyAccessor3.getBodyBlockExpression();
                Intrinsics.checkNotNull((Object)ktBlockExpression);
                KtBlockExpression block = ktBlockExpression;
                List list2 = block.getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
                ((KtExpression)CollectionsKt.single((List)list2)).replace((PsiElement)setterBody);
                KtProperty ktProperty = (KtProperty)$declaration;
                KtPropertyAccessor ktPropertyAccessor4 = setterStubProperty.getSetter();
                Intrinsics.checkNotNull((Object)ktPropertyAccessor4);
                ktProperty.add((PsiElement)ktPropertyAccessor4);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit fixExtensionMemberDeclaration$lambda$0$0(JsNativeAnnotations $annotations, KtNamedDeclaration $declaration, MigrateExternalExtensionFix this$0, Name $name, BuilderByPattern $this$buildExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
        Name name2 = Name.identifier((String)"asDynamic");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        $this$buildExpression.appendName(name2);
        if ($annotations.isGetter()) {
            $this$buildExpression.appendFixedText("()");
            if ($declaration instanceof KtNamedFunction) {
                MigrateExternalExtensionFix.appendParameters$default(this$0, $this$buildExpression, (KtNamedFunction)$declaration, "[", "]", false, 8, null);
            }
        } else if ($annotations.isSetter()) {
            $this$buildExpression.appendFixedText("()");
            if ($declaration instanceof KtNamedFunction) {
                this$0.appendParameters((BuilderByPattern<KtExpression>)$this$buildExpression, (KtNamedFunction)$declaration, "[", "]", true);
                List list2 = ((KtNamedFunction)$declaration).getValueParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
                Name name3 = ((KtParameter)CollectionsKt.last((List)list2)).getNameAsName();
                if (name3 != null) {
                    Name it = name3;
                    boolean bl = false;
                    $this$buildExpression.appendFixedText(" = ");
                    $this$buildExpression.appendName(it);
                }
            }
        } else if ($annotations.isInvoke()) {
            $this$buildExpression.appendFixedText("()");
            if ($declaration instanceof KtNamedFunction) {
                MigrateExternalExtensionFix.appendParameters$default(this$0, $this$buildExpression, (KtNamedFunction)$declaration, "(", ")", false, 8, null);
            }
        } else {
            $this$buildExpression.appendFixedText("().");
            $this$buildExpression.appendName($name);
            if ($declaration instanceof KtNamedFunction) {
                MigrateExternalExtensionFix.appendParameters$default(this$0, $this$buildExpression, (KtNamedFunction)$declaration, "(", ")", false, 8, null);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit fixExtensionMemberDeclaration$lambda$0$1(Name $name, BuilderByPattern $this$buildExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
        Name name2 = Name.identifier((String)"asDynamic");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        $this$buildExpression.appendName(name2);
        $this$buildExpression.appendFixedText("().");
        $this$buildExpression.appendName($name);
        $this$buildExpression.appendFixedText(" = ");
        Name name3 = Name.identifier((String)"value");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        $this$buildExpression.appendName(name3);
        return Unit.INSTANCE;
    }

    private static final CharSequence convertNativeAnnotationToJsName$lambda$0(ValueArgument it) {
        String string = it.asElement().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tH\u0002\u00a2\u0006\u0002\u0010\nJ\f\u0010\u000b\u001a\u00020\u0005*\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "isJsAnnotation", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "predefinedAnnotations", "", "Lorg/jetbrains/kotlin/js/PredefinedAnnotation;", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;[Lorg/jetbrains/kotlin/js/PredefinedAnnotation;)Z", "isJsNativeAnnotation", "isMemberExtensionDeclaration", "psiElement", "Lcom/intellij/psi/PsiElement;", "isMemberDeclaration", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nMigrateExternalExtensionFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrateExternalExtensionFix.kt\norg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n12970#2,2:289\n232#3:291\n232#3:292\n232#3:293\n1761#4,3:294\n*S KotlinDebug\n*F\n+ 1 MigrateExternalExtensionFix.kt\norg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix$Companion\n*L\n246#1:289,2\n268#1:291\n273#1:292\n274#1:293\n278#1:294,3\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isJsAnnotation(KtAnnotationEntry $this$isJsAnnotation, PredefinedAnnotation ... predefinedAnnotations) {
            BindingContext bindingContext = ResolutionUtils.analyze((KtElement)$this$isJsAnnotation, BodyResolveMode.PARTIAL);
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)$this$isJsAnnotation);
            if (annotationDescriptor == null) return false;
            PredefinedAnnotation[] $this$any$iv = predefinedAnnotations;
            boolean $i$f$any = false;
            int n = 0;
            int n2 = $this$any$iv.length;
            while (n < n2) {
                PredefinedAnnotation element$iv;
                PredefinedAnnotation it = element$iv = $this$any$iv[n];
                boolean bl = false;
                if (Intrinsics.areEqual((Object)annotationDescriptor.getFqName(), (Object)it.getFqName())) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private final boolean isJsNativeAnnotation(KtAnnotationEntry $this$isJsNativeAnnotation) {
            PredefinedAnnotation[] predefinedAnnotationArray = new PredefinedAnnotation[]{PredefinedAnnotation.NATIVE, PredefinedAnnotation.NATIVE_GETTER, PredefinedAnnotation.NATIVE_SETTER, PredefinedAnnotation.NATIVE_INVOKE};
            return this.isJsAnnotation($this$isJsNativeAnnotation, predefinedAnnotationArray);
        }

        private final boolean isMemberExtensionDeclaration(PsiElement psiElement) {
            return psiElement instanceof KtNamedFunction && ((KtNamedFunction)psiElement).getReceiverTypeReference() != null || psiElement instanceof KtProperty && ((KtProperty)psiElement).getReceiverTypeReference() != null;
        }

        private final boolean isMemberDeclaration(PsiElement psiElement) {
            return psiElement instanceof KtNamedFunction && ((KtNamedFunction)psiElement).getReceiverTypeReference() == null || psiElement instanceof KtProperty && ((KtProperty)psiElement).getReceiverTypeReference() == null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement e = diagnostic.getPsiElement();
            DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)ErrorsJs.WRONG_EXTERNAL_DECLARATION)) {
                if (this.isMemberExtensionDeclaration(e)) {
                    void $this$getParentOfType$iv;
                    PsiElement psiElement = e;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType = false;
                    if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClassOrObject.class, (boolean)strict$iv) == null) {
                        Intrinsics.checkNotNull((Object)e, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                        return new MigrateExternalExtensionFix((KtNamedDeclaration)e);
                    }
                }
            } else if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.DEPRECATION_ERROR) || Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.DEPRECATION)) {
                boolean bl;
                Object object;
                PsiElement $this$getParentOfType$iv;
                PsiElement strict$iv = e;
                boolean strict$iv2 = false;
                boolean $i$f$getParentOfType = false;
                KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtAnnotationEntry.class, (boolean)strict$iv2);
                boolean bl2 = ktAnnotationEntry != null ? this.isJsNativeAnnotation(ktAnnotationEntry) : false;
                if (bl2) {
                    $this$getParentOfType$iv = e;
                    strict$iv2 = false;
                    $i$f$getParentOfType = false;
                    KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtNamedDeclaration.class, (boolean)strict$iv2);
                    if (ktNamedDeclaration != null) {
                        KtNamedDeclaration it = ktNamedDeclaration;
                        boolean bl3 = false;
                        return new MigrateExternalExtensionFix(it);
                    }
                }
                if ((object = e instanceof KtNamedDeclaration ? (KtNamedDeclaration)e : null) != null && (object = object.getModifierList()) != null && (object = object.getAnnotationEntries()) != null) {
                    boolean bl4;
                    block13: {
                        Iterable $this$any$iv = (Iterable)object;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                                boolean bl5 = false;
                                Intrinsics.checkNotNull((Object)it);
                                if (!Companion.isJsNativeAnnotation(it)) continue;
                                bl4 = true;
                                break block13;
                            }
                            bl4 = false;
                        }
                    }
                    bl = bl4;
                } else {
                    bl = false;
                }
                if (bl) {
                    return new MigrateExternalExtensionFix((KtNamedDeclaration)e);
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003JC\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix$JsNativeAnnotations;", "", "annotations", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "nativeAnnotation", "isGetter", "", "isSetter", "isInvoke", "<init>", "(Ljava/util/List;Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;ZZZ)V", "getAnnotations", "()Ljava/util/List;", "getNativeAnnotation", "()Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "()Z", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "kotlin.idea"})
    private static final class JsNativeAnnotations {
        @NotNull
        private final List<KtAnnotationEntry> annotations;
        @Nullable
        private final KtAnnotationEntry nativeAnnotation;
        private final boolean isGetter;
        private final boolean isSetter;
        private final boolean isInvoke;

        public JsNativeAnnotations(@NotNull List<? extends KtAnnotationEntry> annotations2, @Nullable KtAnnotationEntry nativeAnnotation, boolean isGetter, boolean isSetter, boolean isInvoke) {
            Intrinsics.checkNotNullParameter(annotations2, (String)"annotations");
            this.annotations = annotations2;
            this.nativeAnnotation = nativeAnnotation;
            this.isGetter = isGetter;
            this.isSetter = isSetter;
            this.isInvoke = isInvoke;
        }

        @NotNull
        public final List<KtAnnotationEntry> getAnnotations() {
            return this.annotations;
        }

        @Nullable
        public final KtAnnotationEntry getNativeAnnotation() {
            return this.nativeAnnotation;
        }

        public final boolean isGetter() {
            return this.isGetter;
        }

        public final boolean isSetter() {
            return this.isSetter;
        }

        public final boolean isInvoke() {
            return this.isInvoke;
        }

        @NotNull
        public final List<KtAnnotationEntry> component1() {
            return this.annotations;
        }

        @Nullable
        public final KtAnnotationEntry component2() {
            return this.nativeAnnotation;
        }

        public final boolean component3() {
            return this.isGetter;
        }

        public final boolean component4() {
            return this.isSetter;
        }

        public final boolean component5() {
            return this.isInvoke;
        }

        @NotNull
        public final JsNativeAnnotations copy(@NotNull List<? extends KtAnnotationEntry> annotations2, @Nullable KtAnnotationEntry nativeAnnotation, boolean isGetter, boolean isSetter, boolean isInvoke) {
            Intrinsics.checkNotNullParameter(annotations2, (String)"annotations");
            return new JsNativeAnnotations(annotations2, nativeAnnotation, isGetter, isSetter, isInvoke);
        }

        public static /* synthetic */ JsNativeAnnotations copy$default(JsNativeAnnotations jsNativeAnnotations, List list2, KtAnnotationEntry ktAnnotationEntry, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = jsNativeAnnotations.annotations;
            }
            if ((n & 2) != 0) {
                ktAnnotationEntry = jsNativeAnnotations.nativeAnnotation;
            }
            if ((n & 4) != 0) {
                bl = jsNativeAnnotations.isGetter;
            }
            if ((n & 8) != 0) {
                bl2 = jsNativeAnnotations.isSetter;
            }
            if ((n & 0x10) != 0) {
                bl3 = jsNativeAnnotations.isInvoke;
            }
            return jsNativeAnnotations.copy(list2, ktAnnotationEntry, bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "JsNativeAnnotations(annotations=" + this.annotations + ", nativeAnnotation=" + this.nativeAnnotation + ", isGetter=" + this.isGetter + ", isSetter=" + this.isSetter + ", isInvoke=" + this.isInvoke + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.annotations).hashCode();
            result2 = result2 * 31 + (this.nativeAnnotation == null ? 0 : this.nativeAnnotation.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.isGetter);
            result2 = result2 * 31 + Boolean.hashCode(this.isSetter);
            result2 = result2 * 31 + Boolean.hashCode(this.isInvoke);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JsNativeAnnotations)) {
                return false;
            }
            JsNativeAnnotations jsNativeAnnotations = (JsNativeAnnotations)other;
            if (!Intrinsics.areEqual(this.annotations, jsNativeAnnotations.annotations)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nativeAnnotation, (Object)jsNativeAnnotations.nativeAnnotation)) {
                return false;
            }
            if (this.isGetter != jsNativeAnnotations.isGetter) {
                return false;
            }
            if (this.isSetter != jsNativeAnnotations.isSetter) {
                return false;
            }
            return this.isInvoke == jsNativeAnnotations.isInvoke;
        }
    }
}

