/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridColumnLayout;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ResultViewColumn;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.openapi.util.Key;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class DefaultGridColumnLayout
implements GridColumnLayout<GridRow, GridColumn> {
    private static final Key<Integer> MAX_CELL_WIDTH_KEY = new Key("MaxCellWidth");
    private static final double GOLD = 0.5 * (3.0 - Math.sqrt(5.0));
    private static final int MIN_COLUMN_WIDTH = 40;
    private static final int FIRST_ROWS_FOR_SIZE_CALCULATION = 100;
    private static final int FIRST_ROWS_FOR_SIZE_CALCULATION_LOTS_OF_COLUMNS = 5;
    private static final int MAX_ROW_IDX_FOR_SIZE_CALCULATION = 10000;
    private static final int MAX_ROW_IDX_FOR_SIZE_CALCULATION_LOTS_OF_COLUMNS = 10;
    private static final int FIRST_ROWS_FOR_SIZE_CALCULATION_TRANSPOSED = 10;
    private static final int MAX_ROW_IDX_FOR_SIZE_CALCULATION_TRANSPOSED = 10;
    private final TableResultView myResultView;
    private final DataGrid myGrid;
    private boolean myInvalidateWidestCellValues;

    public DefaultGridColumnLayout(@NotNull TableResultView resultView, @NotNull DataGrid grid) {
        if (resultView == null) {
            DefaultGridColumnLayout.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            DefaultGridColumnLayout.$$$reportNull$$$0(1);
        }
        this.myResultView = resultView;
        this.myGrid = grid;
    }

    @Override
    public boolean resetLayout() {
        return this.doLayout((this.myResultView.isTransposed() ? this.myGrid.getVisibleRows() : this.myGrid.getVisibleColumns()).asList());
    }

    @Override
    public void newColumnsAdded(ModelIndexSet<GridColumn> columnIndices) {
        this.updateWidestCellValueCaches((ModelIndexSet<GridRow>)this.myGrid.getVisibleRows(), columnIndices);
    }

    @Override
    public void newRowsAdded(ModelIndexSet<GridRow> rowIndices) {
        this.updateWidestCellValueCaches(rowIndices, (ModelIndexSet<GridColumn>)this.myGrid.getVisibleColumns());
    }

    @Override
    public void columnsShown(ModelIndexSet<?> columnDataIndices) {
        this.doLayout(columnDataIndices.asList());
    }

    @Override
    public void invalidateCache() {
        this.myInvalidateWidestCellValues = true;
    }

    protected boolean doLayout(List<? extends ModelIndex<?>> columnDataIndices) {
        class LayoutInfo {
            int min;
            int preferred;
            int full;

            LayoutInfo(DefaultGridColumnLayout this$0) {
            }
        }
        LayoutInfo layoutInfo;
        int availableWidth;
        if (this.myInvalidateWidestCellValues) {
            this.updateWidestCellValueCaches((ModelIndexSet<GridRow>)this.myGrid.getVisibleRows(), (ModelIndexSet<GridColumn>)this.myGrid.getVisibleColumns());
        }
        int allColumnsPreferredWidth = 0;
        int extraWidth = 0;
        int allColumnsFullWidth = 0;
        HashMap<ResultViewColumn, LayoutInfo> columnWidths = new HashMap<ResultViewColumn, LayoutInfo>();
        HashSet columnsToResize = new HashSet(columnDataIndices);
        List visibleColumnDataIndices = (this.myResultView.isTransposed() ? this.myGrid.getVisibleRows() : this.myGrid.getVisibleColumns()).asList();
        JBLoadingPanel gridPanel = this.myGrid.getPanel().getComponent();
        JScrollPane scrollPane = (JScrollPane)UIUtil.findComponentOfType((JComponent)gridPanel, JScrollPane.class);
        int n = availableWidth = scrollPane != null ? scrollPane.getViewportBorderBounds().width : gridPanel.getWidth();
        if (availableWidth == 0) {
            return false;
        }
        availableWidth = Math.max(availableWidth, 400);
        for (ModelIndex columnDataIdx : visibleColumnDataIndices) {
            ResultViewColumn column = this.myResultView.getLayoutColumn(columnDataIdx);
            if (column == null) continue;
            if (columnsToResize.contains(columnDataIdx)) {
                layoutInfo = new LayoutInfo(this);
                layoutInfo.min = Math.max(40, this.computeHeaderWidth(column));
                layoutInfo.full = Math.max(layoutInfo.min, DefaultGridColumnLayout.computeColumnWidth(column));
                layoutInfo.preferred = Math.min(layoutInfo.full, (int)((double)availableWidth * GOLD));
                columnWidths.put(column, layoutInfo);
                allColumnsPreferredWidth += layoutInfo.preferred;
                extraWidth += layoutInfo.min == layoutInfo.full ? layoutInfo.preferred : 0;
                allColumnsFullWidth += layoutInfo.full;
                continue;
            }
            int currentWidth = column.getColumnWidth();
            allColumnsPreferredWidth += currentWidth;
            extraWidth += currentWidth;
            allColumnsFullWidth += currentWidth;
        }
        if (columnDataIndices.size() == 1 && visibleColumnDataIndices.size() > 1) {
            ResultViewColumn insertedColumn;
            ModelIndex<?> insertedIdx = columnDataIndices.get(0);
            boolean insertedIdxIsValid = this.myResultView.isTransposed() && GridUtil.isInsertedRow(this.myGrid, DefaultGridColumnLayout.cast(insertedIdx));
            ResultViewColumn resultViewColumn = insertedColumn = insertedIdxIsValid ? this.myResultView.getLayoutColumn(insertedIdx) : null;
            if (insertedColumn != null) {
                layoutInfo = (LayoutInfo)columnWidths.get(insertedColumn);
                int averageColumnWidth = (allColumnsPreferredWidth - layoutInfo.preferred) / (visibleColumnDataIndices.size() - 1);
                if (averageColumnWidth > layoutInfo.preferred) {
                    extraWidth -= layoutInfo.preferred;
                    allColumnsPreferredWidth -= layoutInfo.preferred;
                    allColumnsFullWidth -= layoutInfo.full;
                    layoutInfo.min = Math.min(averageColumnWidth, layoutInfo.min);
                    layoutInfo.preferred = averageColumnWidth;
                    layoutInfo.full = averageColumnWidth;
                    extraWidth += layoutInfo.preferred;
                    allColumnsPreferredWidth += layoutInfo.preferred;
                    allColumnsFullWidth += layoutInfo.full;
                }
            }
        }
        int requiredWidth = availableWidth >= allColumnsFullWidth ? allColumnsFullWidth : Math.max(availableWidth, allColumnsPreferredWidth);
        int requiredPlusExtra = requiredWidth + extraWidth;
        int widthToDistribute = visibleColumnDataIndices.isEmpty() || availableWidth <= requiredWidth ? 0 : (int)(((double)requiredPlusExtra < GOLD * (double)availableWidth ? GOLD * (double)availableWidth : ((double)requiredPlusExtra < (1.0 - GOLD) * (double)availableWidth ? (1.0 - GOLD) * (double)availableWidth : (double)availableWidth)) - (double)allColumnsPreferredWidth);
        boolean oneColumn = columnWidths.size() == 1;
        for (ResultViewColumn column : columnWidths.keySet()) {
            LayoutInfo layoutInfo2 = (LayoutInfo)columnWidths.get(column);
            if (oneColumn) {
                column.setColumnWidth(Math.min(availableWidth, layoutInfo2.full));
                continue;
            }
            int expandedWidth = layoutInfo2.preferred + (int)((double)(widthToDistribute * layoutInfo2.full) / (double)allColumnsFullWidth);
            column.setColumnWidth(Math.min(availableWidth, Math.min(expandedWidth, (int)((double)layoutInfo2.full * 1.2))));
        }
        return true;
    }

    private static int computeColumnWidth(ResultViewColumn column) {
        return (Integer)ObjectUtils.notNull((Object)((Integer)column.getUserData(MAX_CELL_WIDTH_KEY)), (Object)0) + column.getAdditionalWidth();
    }

    private int computeHeaderWidth(ResultViewColumn column) {
        Component headerComponent;
        JTableHeader tableHeader = this.myResultView.getTableHeader();
        CellRendererPane cellRendererPane = new CellRendererPane();
        tableHeader.add(cellRendererPane);
        TableCellRenderer cellRenderer = tableHeader.getDefaultRenderer();
        TableResultView.MyCellRenderer renderer2 = (TableResultView.MyCellRenderer)ObjectUtils.tryCast((Object)cellRenderer, TableResultView.MyCellRenderer.class);
        if (renderer2 != null) {
            headerComponent = renderer2.getHeaderCellRendererComponent(column.getModelIndex(), false);
        } else {
            int viewIndex = this.myResultView.convertColumnIndexToView(column.getModelIndex());
            headerComponent = cellRenderer.getTableCellRendererComponent((JTable)((Object)this.myResultView), column.getHeaderValue(), false, false, -1, viewIndex);
        }
        cellRendererPane.add(headerComponent);
        headerComponent.validate();
        int res = headerComponent.getPreferredSize().width + column.getAdditionalWidth();
        tableHeader.remove(cellRendererPane);
        return res;
    }

    private void updateWidestCellValueCaches(ModelIndexSet<GridRow> rowIndices, ModelIndexSet<GridColumn> columnIndices) {
        JBIterable viewRowIndices = (this.myResultView.isTransposed() ? columnIndices : rowIndices).toView((CoreGrid)this.myGrid).asIterable();
        JBIterable columnDataIndices = (this.myResultView.isTransposed() ? rowIndices : columnIndices).asIterable();
        ArrayList<ModelIndex> toLayOut = new ArrayList<ModelIndex>();
        int columnNum = 0;
        for (ModelIndex columnDataIdx : columnDataIndices) {
            ViewIndex viewColumnIdx;
            ResultViewColumn layoutColumn = this.myResultView.getLayoutColumn(columnDataIdx, viewColumnIdx = columnDataIdx.toView((CoreGrid)this.myGrid));
            if (layoutColumn == null) continue;
            Integer cachedMaxCellWidth = this.myInvalidateWidestCellValues ? null : (Integer)layoutColumn.getUserData(MAX_CELL_WIDTH_KEY);
            int maxCellWidth = this.getMaximumPreferredWidth(viewRowIndices, viewColumnIdx, columnNum++);
            if (!this.myInvalidateWidestCellValues && cachedMaxCellWidth == null) {
                toLayOut.add(columnDataIdx);
            }
            if (cachedMaxCellWidth != null && maxCellWidth <= cachedMaxCellWidth) continue;
            layoutColumn.putUserData(MAX_CELL_WIDTH_KEY, (Object)(maxCellWidth > 0 ? Integer.valueOf(maxCellWidth) : null));
        }
        this.myInvalidateWidestCellValues = false;
        if (!toLayOut.isEmpty()) {
            this.doLayout(toLayOut);
        }
    }

    private int getMaximumPreferredWidth(JBIterable<? extends ViewIndex<?>> viewRowIndices, ViewIndex<?> viewColumnIdx, int columnNum) {
        ViewIndex viewRowIdx;
        int rowIdxInt;
        int maxRowForSizeCalc;
        int widestCell = 0;
        int n = columnNum > 100 ? 10 : (maxRowForSizeCalc = this.myResultView.isTransposed() ? 10 : 10000);
        int firstRowsForSizeCalc = columnNum > 100 ? 5 : (this.myResultView.isTransposed() ? 10 : 100);
        Iterator iterator = viewRowIndices.iterator();
        while (iterator.hasNext() && (rowIdxInt = (viewRowIdx = (ViewIndex)iterator.next()).toModel((CoreGrid)this.myGrid).asInteger()) <= maxRowForSizeCalc) {
            ViewIndex columnIdx;
            ViewIndex rowIdx;
            JComponent component;
            if (rowIdxInt > firstRowsForSizeCalc && rowIdxInt % firstRowsForSizeCalc != 0 || (component = this.myResultView.getCellRendererComponent(rowIdx = this.myResultView.isTransposed() ? DefaultGridColumnLayout.cast(viewColumnIdx) : DefaultGridColumnLayout.cast(viewRowIdx), columnIdx = this.myResultView.isTransposed() ? DefaultGridColumnLayout.cast(viewRowIdx) : DefaultGridColumnLayout.cast(viewColumnIdx), false)) == null) continue;
            widestCell = Math.max(widestCell, component.getPreferredSize().width);
        }
        return widestCell;
    }

    @NotNull
    private static <T> ViewIndex<T> cast(@NotNull ViewIndex<?> idx) {
        if (idx == null) {
            DefaultGridColumnLayout.$$$reportNull$$$0(2);
        }
        ViewIndex<?> viewIndex = idx;
        if (viewIndex == null) {
            DefaultGridColumnLayout.$$$reportNull$$$0(3);
        }
        return viewIndex;
    }

    @NotNull
    private static <T> ModelIndex<T> cast(@NotNull ModelIndex<?> idx) {
        if (idx == null) {
            DefaultGridColumnLayout.$$$reportNull$$$0(4);
        }
        ModelIndex<?> modelIndex = idx;
        if (modelIndex == null) {
            DefaultGridColumnLayout.$$$reportNull$$$0(5);
        }
        return modelIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/DefaultGridColumnLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/DefaultGridColumnLayout";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cast";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cast";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

