/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.optimizations;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ir.IrUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.optimizations.LivenessAnalysisKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.utils.BitSetUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fJ\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007*\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/LivenessAnalysis;", "", "<init>", "()V", "run", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "filter", "Lkotlin/Function1;", "", "getImmediateChildren", "LivenessAnalysisVisitor", "ir.backend.common"})
public final class LivenessAnalysis {
    @NotNull
    public static final LivenessAnalysis INSTANCE = new LivenessAnalysis();

    private LivenessAnalysis() {
    }

    @NotNull
    public final Map<IrElement, List<IrVariable>> run(@NotNull IrBody body, @NotNull Function1<? super IrElement, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return new LivenessAnalysisVisitor(filter).run(body);
    }

    private final List<IrElement> getImmediateChildren(IrElement $this$getImmediateChildren) {
        List result = new ArrayList();
        IrVisitorsKt.acceptChildrenVoid($this$getImmediateChildren, new IrVisitorVoid(result){
            final /* synthetic */ List<IrElement> $result;
            {
                this.$result = $result;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                this.$result.add(element);
            }
        });
        return result;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ\f\u0010\u001e\u001a\u00020\u001f*\u00020\u0002H\u0002J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\rH\u0002J6\u0010\"\u001a\u00020\u0002\"\b\b\u0000\u0010#*\u00020\u00052\u0006\u0010$\u001a\u0002H#2\u0006\u0010%\u001a\u00020\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'H\u0082\b\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u0010.\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u00102\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u00103\u001a\u00020\u00022\u0006\u00100\u001a\u0002042\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u00105\u001a\u00020\u00022\u0006\u00100\u001a\u0002062\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u00107\u001a\u00020\u00022\u0006\u00100\u001a\u0002082\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u00109\u001a\u00020\u00022\u0006\u00100\u001a\u00020:2\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u0010;\u001a\u00020\u00022\u0006\u00100\u001a\u00020<2\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u0010=\u001a\u00020\u00022\u0006\u0010>\u001a\u00020?2\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u0010@\u001a\u00020\u00022\u0006\u00100\u001a\u00020A2\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u0010B\u001a\u00020\u00022\u0006\u0010C\u001a\u00020D2\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u0010E\u001a\u00020\u00022\u0006\u0010C\u001a\u00020F2\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u0010G\u001a\u00020\u00022\u0006\u0010H\u001a\u00020I2\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u0010J\u001a\u00020\u00022\u0006\u0010H\u001a\u00020K2\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u0010L\u001a\u00020\u00022\u0006\u0010H\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0002H\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/LivenessAnalysis$LivenessAnalysisVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitor;", "Ljava/util/BitSet;", "filter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/IrElement;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getFilter", "()Lkotlin/jvm/functions/Function1;", "variables", "", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "variableIds", "", "", "filteredElementEndsLV", "returnableBlockEndsLV", "Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;", "loopEndsLV", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "loopStartsLV", "catchesLV", "suspensionPointIdParameters", "run", "", "", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "format", "", "getVariableId", "variable", "saveAndCompute", "T", "element", "liveVariables", "compute", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/IrElement;Ljava/util/BitSet;Lkotlin/jvm/functions/Function0;)Ljava/util/BitSet;", "visitDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "data", "visitElement", "visitGetValue", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitVariable", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitSuspensionPoint", "Lorg/jetbrains/kotlin/ir/expressions/IrSuspensionPoint;", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "handleLoop", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nLivenessAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LivenessAnalysis.kt\norg/jetbrains/kotlin/backend/common/lower/optimizations/LivenessAnalysis$LivenessAnalysisVisitor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BitSetUtil.kt\norg/jetbrains/kotlin/utils/BitSetUtilKt\n*L\n1#1,264:1\n80#1,3:299\n83#1,6:309\n80#1,3:315\n83#1,6:325\n80#1,3:331\n83#1,6:341\n80#1,3:347\n83#1,6:357\n80#1,3:363\n83#1,6:373\n80#1,3:379\n83#1,6:389\n80#1,3:395\n83#1,6:405\n80#1,3:411\n83#1,6:421\n80#1,3:427\n83#1,6:437\n80#1,3:443\n83#1,6:453\n80#1,3:459\n83#1,6:469\n80#1,3:475\n83#1,6:485\n80#1,3:491\n83#1,6:501\n466#2:265\n415#2:266\n383#2,7:285\n383#2,7:292\n383#2,7:302\n383#2,7:318\n383#2,7:334\n383#2,7:350\n383#2,7:366\n383#2,7:382\n383#2,7:398\n383#2,7:414\n383#2,7:430\n383#2,7:446\n383#2,7:462\n383#2,7:478\n383#2,7:494\n1266#3,2:267\n1269#3:277\n1#4:269\n13#5,7:270\n13#5,7:278\n*S KotlinDebug\n*F\n+ 1 LivenessAnalysis.kt\norg/jetbrains/kotlin/backend/common/lower/optimizations/LivenessAnalysis$LivenessAnalysisVisitor\n*L\n95#1:299,3\n95#1:309,6\n104#1:315,3\n104#1:325,6\n109#1:331,3\n109#1:341,6\n117#1:347,3\n117#1:357,6\n123#1:363,3\n123#1:373,6\n131#1:379,3\n131#1:389,6\n154#1:395,3\n154#1:405,6\n167#1:411,3\n167#1:421,6\n177#1:427,3\n177#1:437,6\n199#1:443,3\n199#1:453,6\n203#1:459,3\n203#1:469,6\n218#1:475,3\n218#1:485,6\n239#1:491,3\n239#1:501,6\n56#1:265\n56#1:266\n74#1:285,7\n82#1:292,7\n95#1:302,7\n104#1:318,7\n109#1:334,7\n117#1:350,7\n123#1:366,7\n131#1:382,7\n154#1:398,7\n167#1:414,7\n177#1:430,7\n199#1:446,7\n203#1:462,7\n218#1:478,7\n239#1:494,7\n56#1:267,2\n56#1:277\n57#1:270,7\n66#1:278,7\n*E\n"})
    private static final class LivenessAnalysisVisitor
    extends IrVisitor<BitSet, BitSet> {
        @NotNull
        private final Function1<IrElement, Boolean> filter;
        @NotNull
        private final List<IrVariable> variables;
        @NotNull
        private final Map<IrVariable, Integer> variableIds;
        @NotNull
        private final Map<IrElement, BitSet> filteredElementEndsLV;
        @NotNull
        private final Map<IrReturnableBlock, BitSet> returnableBlockEndsLV;
        @NotNull
        private final Map<IrLoop, BitSet> loopEndsLV;
        @NotNull
        private final Map<IrLoop, BitSet> loopStartsLV;
        @NotNull
        private BitSet catchesLV;
        @NotNull
        private final BitSet suspensionPointIdParameters;

        public LivenessAnalysisVisitor(@NotNull Function1<? super IrElement, Boolean> filter) {
            Intrinsics.checkNotNullParameter(filter, (String)"filter");
            this.filter = filter;
            this.variables = new ArrayList();
            this.variableIds = new LinkedHashMap();
            this.filteredElementEndsLV = new LinkedHashMap();
            this.returnableBlockEndsLV = new LinkedHashMap();
            this.loopEndsLV = new LinkedHashMap();
            this.loopStartsLV = new LinkedHashMap();
            this.catchesLV = new BitSet();
            this.suspensionPointIdParameters = new BitSet();
        }

        @NotNull
        public final Function1<IrElement, Boolean> getFilter() {
            return this.filter;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<IrElement, List<IrVariable>> run(@NotNull IrBody body) {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapValuesTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            body.accept(this, new BitSet());
            Map<IrElement, BitSet> $this$mapValues$iv = this.filteredElementEndsLV;
            boolean $i$f$mapValues = false;
            Map<IrElement, BitSet> map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                List list;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                BitSet liveVariables = (BitSet)entry2.getValue();
                List $this$run_u24lambda_u240_u240 = list = CollectionsKt.createListBuilder();
                boolean bl3 = false;
                BitSet $this$forEachBit$iv = liveVariables;
                boolean $i$f$forEachBit = false;
                int i$iv = -1;
                while ((i$iv = $this$forEachBit$iv.nextSetBit(i$iv + 1)) >= 0) {
                    int it = i$iv;
                    boolean bl4 = false;
                    $this$run_u24lambda_u240_u240.add(this.variables.get(it));
                }
                List list2 = CollectionsKt.build((List)list);
                map3.put(k, list2);
            }
            return destination$iv$iv$iv;
        }

        private final String format(BitSet $this$format) {
            StringBuilder stringBuilder;
            StringBuilder $this$format_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$format_u24lambda_u240.append('[');
            boolean first = false;
            first = true;
            BitSet $this$forEachBit$iv = $this$format;
            boolean $i$f$forEachBit = false;
            int i$iv = -1;
            while ((i$iv = $this$forEachBit$iv.nextSetBit(i$iv + 1)) >= 0) {
                int it = i$iv;
                boolean bl2 = false;
                if (!first) {
                    $this$format_u24lambda_u240.append(", ");
                }
                first = false;
                $this$format_u24lambda_u240.append(this.variables.get(it).getName());
            }
            $this$format_u24lambda_u240.append(']');
            return stringBuilder.toString();
        }

        /*
         * WARNING - void declaration
         */
        private final int getVariableId(IrVariable variable) {
            Object object;
            void $this$getOrPut$iv;
            Map<IrVariable, Integer> map = this.variableIds;
            IrVariable key$iv = variable;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                this.variables.add(variable);
                Integer answer$iv = CollectionsKt.getLastIndex(this.variables);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return ((Number)object).intValue();
        }

        /*
         * WARNING - void declaration
         */
        private final <T extends IrElement> BitSet saveAndCompute(T element, BitSet liveVariables, Function0<? extends BitSet> compute) {
            boolean $i$f$saveAndCompute = false;
            if (((Boolean)this.filter.invoke(element)).booleanValue()) {
                Object object;
                void $this$getOrPut$iv;
                Map<IrElement, BitSet> map = this.filteredElementEndsLV;
                T key$iv = element;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    BitSet answer$iv = new BitSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                BitSet elementLV = (BitSet)object;
                elementLV.or(liveVariables);
                elementLV.or(this.catchesLV);
                elementLV.andNot(this.suspensionPointIdParameters);
            }
            return (BitSet)compute.invoke();
        }

        @Override
        @NotNull
        public Void visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull BitSet data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            throw new IllegalStateException("Local declarations should've been popped out by this point".toString());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BitSet visitElement(@NotNull IrElement element, @NotNull BitSet data) {
            void element$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            LivenessAnalysisVisitor livenessAnalysisVisitor = this;
            IrElement irElement = element;
            BitSet liveVariables$iv = data;
            boolean $i$f$saveAndCompute = false;
            if (((Boolean)this_$iv.filter.invoke((Object)element$iv)).booleanValue()) {
                Object object;
                void $this$getOrPut$iv$iv;
                Map<IrElement, BitSet> map = this_$iv.filteredElementEndsLV;
                void key$iv$iv = element$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    BitSet answer$iv$iv = new BitSet();
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                BitSet elementLV$iv = (BitSet)object;
                elementLV$iv.or(liveVariables$iv);
                elementLV$iv.or(this_$iv.catchesLV);
                elementLV$iv.andNot(this_$iv.suspensionPointIdParameters);
            }
            boolean bl = false;
            List children = INSTANCE.getImmediateChildren(element);
            BitSet liveVariables = data;
            for (int i = children.size() - 1; -1 < i; --i) {
                liveVariables = (BitSet)((IrElement)children.get(i)).accept(this, liveVariables);
            }
            return liveVariables;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BitSet visitGetValue(@NotNull IrGetValue expression, @NotNull BitSet data) {
            BitSet bitSet;
            void element$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            LivenessAnalysisVisitor livenessAnalysisVisitor = this;
            IrElement irElement = expression;
            BitSet liveVariables$iv = data;
            boolean $i$f$saveAndCompute = false;
            if (((Boolean)this_$iv.filter.invoke((Object)element$iv)).booleanValue()) {
                Object object;
                void $this$getOrPut$iv$iv;
                Map<IrElement, BitSet> map = this_$iv.filteredElementEndsLV;
                void key$iv$iv = element$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    BitSet answer$iv$iv = new BitSet();
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                BitSet elementLV$iv = (BitSet)object;
                elementLV$iv.or(liveVariables$iv);
                elementLV$iv.or(this_$iv.catchesLV);
                elementLV$iv.andNot(this_$iv.suspensionPointIdParameters);
            }
            boolean bl = false;
            IrValueDeclaration irValueDeclaration = expression.getSymbol().getOwner();
            IrVariable irVariable = irValueDeclaration instanceof IrVariable ? (IrVariable)irValueDeclaration : null;
            if (irVariable == null) {
                bitSet = data;
            } else {
                IrVariable variable = irVariable;
                bitSet = LivenessAnalysisKt.access$withBit(data, this.getVariableId(variable));
            }
            return bitSet;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BitSet visitVariable(@NotNull IrVariable declaration, @NotNull BitSet data) {
            void element$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            LivenessAnalysisVisitor livenessAnalysisVisitor = this;
            IrElement irElement = declaration;
            BitSet liveVariables$iv = data;
            boolean $i$f$saveAndCompute = false;
            if (((Boolean)this_$iv.filter.invoke((Object)element$iv)).booleanValue()) {
                Object object;
                void $this$getOrPut$iv$iv;
                Map<IrElement, BitSet> map = this_$iv.filteredElementEndsLV;
                void key$iv$iv = element$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    BitSet answer$iv$iv = new BitSet();
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                BitSet elementLV$iv = (BitSet)object;
                elementLV$iv.or(liveVariables$iv);
                elementLV$iv.or(this_$iv.catchesLV);
                elementLV$iv.andNot(this_$iv.suspensionPointIdParameters);
            }
            boolean bl = false;
            int variableId = this.getVariableId(declaration);
            Object liveVariables = LivenessAnalysisKt.access$withOutBit(data, variableId);
            Object object = declaration.getInitializer();
            if (object == null || (object = (BitSet)object.accept(this, liveVariables)) == null) {
                object = liveVariables;
            }
            if (!(!((BitSet)(liveVariables = object)).get(variableId))) {
                boolean bl2 = false;
                String string = "Use of uninitialized variable " + RenderIrElementKt.render$default(declaration, null, 1, null);
                throw new IllegalArgumentException(string.toString());
            }
            return liveVariables;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BitSet visitSetValue(@NotNull IrSetValue expression, @NotNull BitSet data) {
            void element$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            LivenessAnalysisVisitor livenessAnalysisVisitor = this;
            IrElement irElement = expression;
            BitSet liveVariables$iv = data;
            boolean $i$f$saveAndCompute = false;
            if (((Boolean)this_$iv.filter.invoke((Object)element$iv)).booleanValue()) {
                Object object;
                void $this$getOrPut$iv$iv;
                Map<IrElement, BitSet> map = this_$iv.filteredElementEndsLV;
                void key$iv$iv = element$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    BitSet answer$iv$iv = new BitSet();
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                BitSet elementLV$iv = (BitSet)object;
                elementLV$iv.or(liveVariables$iv);
                elementLV$iv.or(this_$iv.catchesLV);
                elementLV$iv.andNot(this_$iv.suspensionPointIdParameters);
            }
            boolean bl = false;
            IrValueDeclaration irValueDeclaration = expression.getSymbol().getOwner();
            IrVariable irVariable = irValueDeclaration instanceof IrVariable ? (IrVariable)irValueDeclaration : null;
            if (irVariable == null) {
                throw new IllegalStateException(("Unexpected parameter rewrite: " + RenderIrElementKt.render$default(expression, null, 1, null)).toString());
            }
            IrVariable variable = irVariable;
            BitSet liveVariables = LivenessAnalysisKt.access$withOutBit(data, this.getVariableId(variable));
            return (BitSet)expression.getValue().accept(this, liveVariables);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BitSet visitReturn(@NotNull IrReturn expression, @NotNull BitSet data) {
            Object object;
            block8: {
                block7: {
                    void element$iv;
                    void this_$iv;
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    LivenessAnalysisVisitor livenessAnalysisVisitor = this;
                    IrElement irElement = expression;
                    BitSet liveVariables$iv = data;
                    boolean $i$f$saveAndCompute = false;
                    if (((Boolean)this_$iv.filter.invoke((Object)element$iv)).booleanValue()) {
                        Object object2;
                        void $this$getOrPut$iv$iv;
                        Map<IrElement, BitSet> map = this_$iv.filteredElementEndsLV;
                        void key$iv$iv = element$iv;
                        boolean $i$f$getOrPut = false;
                        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                        if (value$iv$iv == null) {
                            boolean bl = false;
                            BitSet answer$iv$iv = new BitSet();
                            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                            object2 = answer$iv$iv;
                        } else {
                            object2 = value$iv$iv;
                        }
                        BitSet elementLV$iv = (BitSet)object2;
                        elementLV$iv.or(liveVariables$iv);
                        elementLV$iv.or(this_$iv.catchesLV);
                        elementLV$iv.andNot(this_$iv.suspensionPointIdParameters);
                    }
                    boolean bl = false;
                    IrReturnTarget irReturnTarget = expression.getReturnTargetSymbol().getOwner();
                    object = irReturnTarget instanceof IrReturnableBlock ? (IrReturnableBlock)irReturnTarget : null;
                    if (object == null) break block7;
                    IrReturnableBlock it = object;
                    boolean bl2 = false;
                    BitSet bitSet = this.returnableBlockEndsLV.get(it);
                    if (bitSet == null) {
                        throw new IllegalStateException(("Unknown return target " + RenderIrElementKt.render$default(expression.getReturnTargetSymbol().getOwner(), null, 1, null)).toString());
                    }
                    object = bitSet;
                    if (bitSet != null) break block8;
                }
                object = new BitSet();
            }
            Object liveVariables = object;
            return (BitSet)expression.getValue().accept(this, liveVariables);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BitSet visitContainerExpression(@NotNull IrContainerExpression expression, @NotNull BitSet data) {
            block3: {
                void element$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                LivenessAnalysisVisitor livenessAnalysisVisitor = this;
                IrElement irElement = expression;
                BitSet liveVariables$iv = data;
                boolean $i$f$saveAndCompute = false;
                if (((Boolean)this_$iv.filter.invoke((Object)element$iv)).booleanValue()) {
                    Object object;
                    void $this$getOrPut$iv$iv;
                    Map<IrElement, BitSet> map = this_$iv.filteredElementEndsLV;
                    void key$iv$iv = element$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                    if (value$iv$iv == null) {
                        boolean bl = false;
                        BitSet answer$iv$iv = new BitSet();
                        $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                        object = answer$iv$iv;
                    } else {
                        object = value$iv$iv;
                    }
                    BitSet elementLV$iv = (BitSet)object;
                    elementLV$iv.or(liveVariables$iv);
                    elementLV$iv.or(this_$iv.catchesLV);
                    elementLV$iv.andNot(this_$iv.suspensionPointIdParameters);
                }
                boolean bl = false;
                IrReturnableBlock irReturnableBlock = expression instanceof IrReturnableBlock ? (IrReturnableBlock)expression : null;
                if (irReturnableBlock == null) break block3;
                IrReturnableBlock returnableBlock = irReturnableBlock;
                boolean bl2 = false;
                this.returnableBlockEndsLV.put(returnableBlock, data);
            }
            return this.visitElement((IrElement)expression, data);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BitSet visitWhen(@NotNull IrWhen expression, @NotNull BitSet data) {
            void element$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            LivenessAnalysisVisitor livenessAnalysisVisitor = this;
            IrElement irElement = expression;
            BitSet liveVariables$iv = data;
            boolean $i$f$saveAndCompute = false;
            if (((Boolean)this_$iv.filter.invoke((Object)element$iv)).booleanValue()) {
                Object object;
                void $this$getOrPut$iv$iv;
                Map<IrElement, BitSet> map = this_$iv.filteredElementEndsLV;
                void key$iv$iv = element$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    BitSet answer$iv$iv = new BitSet();
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                BitSet elementLV$iv = (BitSet)object;
                elementLV$iv.or(liveVariables$iv);
                elementLV$iv.or(this_$iv.catchesLV);
                elementLV$iv.andNot(this_$iv.suspensionPointIdParameters);
            }
            boolean bl = false;
            boolean isExhaustive = IrUtilsKt.isUnconditional((IrBranch)CollectionsKt.last(expression.getBranches()));
            BitSet liveVariables = isExhaustive ? new BitSet() : data;
            for (int i = expression.getBranches().size() - 1; -1 < i; --i) {
                IrBranch branch = expression.getBranches().get(i);
                BitSet conditionEndLV = BitSetUtilKt.copy((BitSet)liveVariables);
                conditionEndLV.or((BitSet)branch.getResult().accept(this, data));
                liveVariables = (BitSet)branch.getCondition().accept(this, conditionEndLV);
            }
            return liveVariables;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BitSet visitThrow(@NotNull IrThrow expression, @NotNull BitSet data) {
            void element$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            LivenessAnalysisVisitor livenessAnalysisVisitor = this;
            IrElement irElement = expression;
            BitSet liveVariables$iv = data;
            boolean $i$f$saveAndCompute = false;
            if (((Boolean)this_$iv.filter.invoke((Object)element$iv)).booleanValue()) {
                Object object;
                void $this$getOrPut$iv$iv;
                Map<IrElement, BitSet> map = this_$iv.filteredElementEndsLV;
                void key$iv$iv = element$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    BitSet answer$iv$iv = new BitSet();
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                BitSet elementLV$iv = (BitSet)object;
                elementLV$iv.or(liveVariables$iv);
                elementLV$iv.or(this_$iv.catchesLV);
                elementLV$iv.andNot(this_$iv.suspensionPointIdParameters);
            }
            boolean bl = false;
            return (BitSet)expression.getValue().accept(this, this.catchesLV);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BitSet visitTry(@NotNull IrTry aTry, @NotNull BitSet data) {
            BitSet bitSet;
            void element$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            LivenessAnalysisVisitor livenessAnalysisVisitor = this;
            IrElement irElement = aTry;
            BitSet liveVariables$iv = data;
            boolean $i$f$saveAndCompute = false;
            if (((Boolean)this_$iv.filter.invoke((Object)element$iv)).booleanValue()) {
                Object object;
                void $this$getOrPut$iv$iv;
                Map<IrElement, BitSet> map = this_$iv.filteredElementEndsLV;
                void key$iv$iv = element$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    BitSet answer$iv$iv = new BitSet();
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                BitSet elementLV$iv = (BitSet)object;
                elementLV$iv.or(liveVariables$iv);
                elementLV$iv.or(this_$iv.catchesLV);
                elementLV$iv.andNot(this_$iv.suspensionPointIdParameters);
            }
            boolean bl = false;
            if (!(aTry.getFinallyExpression() == null)) {
                boolean $i$a$-require-LivenessAnalysis$LivenessAnalysisVisitor$visitTry$1$22 = false;
                String $i$a$-require-LivenessAnalysis$LivenessAnalysisVisitor$visitTry$1$22 = "All finally clauses should've been lowered";
                throw new IllegalArgumentException($i$a$-require-LivenessAnalysis$LivenessAnalysisVisitor$visitTry$1$22.toString());
            }
            BitSet currentCatchesLV = new BitSet();
            for (IrCatch aCatch : aTry.getCatches()) {
                currentCatchesLV.or((BitSet)aCatch.accept(this, data));
            }
            BitSet prevCatchesLV = this.catchesLV;
            this.catchesLV = currentCatchesLV;
            BitSet it = bitSet = BitSetUtilKt.copy((BitSet)data);
            boolean bl2 = false;
            it.or(currentCatchesLV);
            BitSet lvAfterTry = bitSet;
            currentCatchesLV.or((BitSet)aTry.getTryResult().accept(this, lvAfterTry));
            this.catchesLV = prevCatchesLV;
            return currentCatchesLV;
        }

        @Override
        @NotNull
        public BitSet visitSuspensionPoint(@NotNull IrSuspensionPoint expression, @NotNull BitSet data) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            int variableId = this.getVariableId(expression.getSuspensionPointIdParameter());
            this.suspensionPointIdParameters.set(variableId);
            Object r = super.visitSuspensionPoint(expression, data);
            BitSet it = (BitSet)r;
            boolean bl = false;
            this.suspensionPointIdParameters.clear(variableId);
            return (BitSet)r;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BitSet visitBreak(@NotNull IrBreak jump, @NotNull BitSet data) {
            void element$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            LivenessAnalysisVisitor livenessAnalysisVisitor = this;
            IrElement irElement = jump;
            BitSet liveVariables$iv = data;
            boolean $i$f$saveAndCompute = false;
            if (((Boolean)this_$iv.filter.invoke((Object)element$iv)).booleanValue()) {
                Object object;
                void $this$getOrPut$iv$iv;
                Map<IrElement, BitSet> map = this_$iv.filteredElementEndsLV;
                void key$iv$iv = element$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    BitSet answer$iv$iv = new BitSet();
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                BitSet elementLV$iv = (BitSet)object;
                elementLV$iv.or(liveVariables$iv);
                elementLV$iv.or(this_$iv.catchesLV);
                elementLV$iv.andNot(this_$iv.suspensionPointIdParameters);
            }
            boolean bl = false;
            BitSet bitSet = this.loopEndsLV.get(jump.getLoop());
            if (bitSet == null) {
                throw new IllegalStateException(("Break from an unknown loop " + RenderIrElementKt.render$default(jump.getLoop(), null, 1, null)).toString());
            }
            return bitSet;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BitSet visitContinue(@NotNull IrContinue jump, @NotNull BitSet data) {
            void element$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            LivenessAnalysisVisitor livenessAnalysisVisitor = this;
            IrElement irElement = jump;
            BitSet liveVariables$iv = data;
            boolean $i$f$saveAndCompute = false;
            if (((Boolean)this_$iv.filter.invoke((Object)element$iv)).booleanValue()) {
                Object object;
                void $this$getOrPut$iv$iv;
                Map<IrElement, BitSet> map = this_$iv.filteredElementEndsLV;
                void key$iv$iv = element$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    BitSet answer$iv$iv = new BitSet();
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                BitSet elementLV$iv = (BitSet)object;
                elementLV$iv.or(liveVariables$iv);
                elementLV$iv.or(this_$iv.catchesLV);
                elementLV$iv.andNot(this_$iv.suspensionPointIdParameters);
            }
            boolean bl = false;
            BitSet bitSet = this.loopStartsLV.get(jump.getLoop());
            if (bitSet == null) {
                throw new IllegalStateException(("Continue to an unknown loop " + RenderIrElementKt.render$default(jump.getLoop(), null, 1, null)).toString());
            }
            return bitSet;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BitSet visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @NotNull BitSet data) {
            void element$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            LivenessAnalysisVisitor livenessAnalysisVisitor = this;
            IrElement irElement = loop;
            BitSet liveVariables$iv = data;
            boolean $i$f$saveAndCompute = false;
            if (((Boolean)this_$iv.filter.invoke((Object)element$iv)).booleanValue()) {
                Object object;
                void $this$getOrPut$iv$iv;
                Map<IrElement, BitSet> map = this_$iv.filteredElementEndsLV;
                void key$iv$iv = element$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    BitSet answer$iv$iv = new BitSet();
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                BitSet elementLV$iv = (BitSet)object;
                elementLV$iv.or(liveVariables$iv);
                elementLV$iv.or(this_$iv.catchesLV);
                elementLV$iv.andNot(this_$iv.suspensionPointIdParameters);
            }
            boolean bl = false;
            return this.handleLoop(loop, data);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BitSet visitWhileLoop(@NotNull IrWhileLoop loop, @NotNull BitSet data) {
            void element$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            LivenessAnalysisVisitor livenessAnalysisVisitor = this;
            IrElement irElement = loop;
            BitSet liveVariables$iv = data;
            boolean $i$f$saveAndCompute = false;
            if (((Boolean)this_$iv.filter.invoke((Object)element$iv)).booleanValue()) {
                Object object;
                void $this$getOrPut$iv$iv;
                Map<IrElement, BitSet> map = this_$iv.filteredElementEndsLV;
                void key$iv$iv = element$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    BitSet answer$iv$iv = new BitSet();
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                BitSet elementLV$iv = (BitSet)object;
                elementLV$iv.or(liveVariables$iv);
                elementLV$iv.or(this_$iv.catchesLV);
                elementLV$iv.andNot(this_$iv.suspensionPointIdParameters);
            }
            boolean bl = false;
            BitSet liveVariables = BitSetUtilKt.copy((BitSet)data);
            liveVariables.or(this.handleLoop(loop, data));
            return (BitSet)loop.getCondition().accept(this, liveVariables);
        }

        private final BitSet handleLoop(IrLoop loop, BitSet data) {
            boolean lvHaveChanged;
            this.loopEndsLV.put(loop, data);
            BitSet bodyEndLV = (BitSet)loop.getCondition().accept(this, data);
            IrExpression irExpression = loop.getBody();
            if (irExpression == null) {
                return bodyEndLV;
            }
            IrExpression body = irExpression;
            BitSet bodyStartLV = new BitSet();
            do {
                this.loopStartsLV.put(loop, bodyEndLV);
                BitSet curBodyStartLV = (BitSet)body.accept(this, bodyEndLV);
                bodyStartLV.or(curBodyStartLV);
                BitSet nextBodyEndLV = (BitSet)loop.getCondition().accept(this, curBodyStartLV);
                lvHaveChanged = !Intrinsics.areEqual((Object)nextBodyEndLV, (Object)bodyEndLV);
                bodyEndLV = nextBodyEndLV;
            } while (lvHaveChanged);
            return bodyStartLV;
        }
    }
}

