/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.csv.CsvSettingsService;
import com.intellij.database.settings.DataGridAppearanceSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import java.util.concurrent.atomic.AtomicLong;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="DataGridAppearanceSettingsImpl", storages={@Storage(value="dataViewsSettings.xml")}, category=SettingsCategory.UI)
public final class DataGridAppearanceSettingsImpl
implements PersistentStateComponent<DataGridAppearanceSettingsImpl>,
ModificationTracker,
DataGridAppearanceSettings {
    private static final int CURRENT_VERSION = 1;
    static final String STATE_NAME = "dataViewsSettings";
    private final AtomicLong myModificationCount = new AtomicLong();
    @Attribute(value="version")
    @Property(alwaysWrite=true)
    private int version = 0;
    @OptionTag(value="striped-table")
    public boolean stripedTable = false;
    @OptionTag(value="use-custom-font")
    public boolean useGridCustomFont = false;
    @OptionTag(value="grid-font-family")
    public String gridFontFamily = null;
    @OptionTag(value="grid-font-size")
    public int gridFontSize = -1;
    @OptionTag(value="grid-line-spacing")
    public float gridLineSpacing = -1.0f;
    @OptionTag(value="boolean-mode")
    public DataGridAppearanceSettings.BooleanMode booleanMode = DataGridAppearanceSettings.BooleanMode.TEXT;

    public long getModificationCount() {
        return this.myModificationCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataGridAppearanceSettingsImpl getSettings() {
        DataGridAppearanceSettingsImpl settings = (DataGridAppearanceSettingsImpl)ApplicationManager.getApplication().getService(DataGridAppearanceSettingsImpl.class);
        if (settings != null && settings.version == 0) {
            DataGridAppearanceSettingsImpl dataGridAppearanceSettingsImpl = settings;
            synchronized (dataGridAppearanceSettingsImpl) {
                settings.ensureDefaultsSet();
            }
        }
        return settings;
    }

    public void fireChanged() {
        DataGridAppearanceSettingsImpl.fireSettingsChanged();
    }

    public static void fireSettingsChanged() {
        DataGridAppearanceSettingsImpl instance = DataGridAppearanceSettingsImpl.getSettings();
        instance.myModificationCount.incrementAndGet();
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        ((DataGridAppearanceSettings.Listener)messageBus.syncPublisher(DataGridAppearanceSettings.TOPIC)).settingsChanged();
    }

    public static DataGridAppearanceSettings create() {
        DataGridAppearanceSettingsImpl settings = new DataGridAppearanceSettingsImpl();
        settings.ensureDefaultsSet();
        return settings;
    }

    private DataGridAppearanceSettingsImpl() {
    }

    @NotNull
    public DataGridAppearanceSettingsImpl getState() {
        DataGridAppearanceSettingsImpl dataGridAppearanceSettingsImpl = this;
        if (dataGridAppearanceSettingsImpl == null) {
            DataGridAppearanceSettingsImpl.$$$reportNull$$$0(0);
        }
        return dataGridAppearanceSettingsImpl;
    }

    @TestOnly
    public DataGridAppearanceSettingsImpl copy() {
        return (DataGridAppearanceSettingsImpl)XmlSerializer.deserialize((Element)XmlSerializer.serialize((Object)this), DataGridAppearanceSettingsImpl.class);
    }

    public void loadState(@NotNull DataGridAppearanceSettingsImpl state) {
        if (state == null) {
            DataGridAppearanceSettingsImpl.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        this.ensureDefaultsSet();
    }

    private void ensureDefaultsSet() {
        DataGridAppearanceSettings databaseSettings;
        if (this.version < 1 && (databaseSettings = (DataGridAppearanceSettings)ObjectUtils.tryCast((Object)CsvSettingsService.getDatabaseSettings(), DataGridAppearanceSettings.class)) != null) {
            this.setStripedTable(databaseSettings.isStripedTable());
            this.setUseGridCustomFont(databaseSettings.getUseGridCustomFont());
            this.setGridFontFamily(databaseSettings.getGridFontFamily());
            this.setGridFontSize(databaseSettings.getGridFontSize());
            this.setGridLineSpacing(databaseSettings.getGridLineSpacing());
            this.setBooleanMode(databaseSettings.getBooleanMode());
            this.myModificationCount.incrementAndGet();
        }
        this.version = 1;
    }

    @Override
    public boolean getUseGridCustomFont() {
        return this.useGridCustomFont;
    }

    @Override
    public void setUseGridCustomFont(boolean value) {
        this.useGridCustomFont = value;
    }

    @Override
    @Nullable
    public String getGridFontFamily() {
        return this.gridFontFamily;
    }

    @Override
    public void setGridFontFamily(@Nullable String value) {
        this.gridFontFamily = value;
    }

    @Override
    public int getGridFontSize() {
        return this.gridFontSize;
    }

    @Override
    public void setGridFontSize(int value) {
        this.gridFontSize = value;
    }

    @Override
    public float getGridLineSpacing() {
        return this.gridLineSpacing;
    }

    @Override
    public void setGridLineSpacing(float value) {
        this.gridLineSpacing = value;
    }

    @Override
    public boolean isStripedTable() {
        return this.stripedTable;
    }

    @Override
    public void setStripedTable(boolean striped) {
        this.stripedTable = striped;
    }

    @Override
    public DataGridAppearanceSettings.BooleanMode getBooleanMode() {
        return this.booleanMode;
    }

    @Override
    public void setBooleanMode(@NotNull DataGridAppearanceSettings.BooleanMode mode) {
        if (mode == null) {
            DataGridAppearanceSettingsImpl.$$$reportNull$$$0(2);
        }
        this.booleanMode = mode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/settings/DataGridAppearanceSettingsImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/settings/DataGridAppearanceSettingsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setBooleanMode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

