/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0006\u0010\b\u001a\u00020\u0003J\u0011\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0003J\n\u0010\u0014\u001a\u00020\u0015H\u0096\u0080\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/utils/IntArrayList;", "", "initialCapacity", "", "<init>", "(I)V", "data", "", "size", "trimToSize", "", "ensureCapacity", "minCapacity", "isEmpty", "", "()Z", "get", "index", "add", "o", "toString", "", "util"})
public final class IntArrayList {
    @NotNull
    private int[] data;
    private int size;

    public IntArrayList(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    public final void trimToSize() {
        if (this.size < this.data.length) {
            int[] nArray = Arrays.copyOf(this.data, this.size);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.data = nArray;
        }
    }

    private final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.data.length) {
            int[] nArray = Arrays.copyOf(this.data, Math.max(this.data.length * 3 / 2 + 1, minCapacity));
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.data = nArray;
        }
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int get(int index) {
        return this.data[index];
    }

    public final void add(int o) {
        this.ensureCapacity(this.size + 1);
        int n = this.size;
        this.size = n + 1;
        this.data[n] = o;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)this.size)), (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, arg_0 -> IntArrayList.toString$lambda$0(this, arg_0), (int)24, null);
    }

    private static final CharSequence toString$lambda$0(IntArrayList this$0, int it) {
        return String.valueOf(this$0.get(it));
    }
}

