/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.settings;

import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.settings.Setting;
import ai.grazie.rules.settings.TextStyle;
import ai.grazie.rules.tree.Parameter;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuleSetting
implements Setting {
    public final Rule rule;
    private final Parameter[] subSettings;
    public static final Setting.Value ENABLED = new Setting.Value("enabled", "enabled");
    public static final Setting.Value DISABLED = new Setting.Value("disabled", "disabled");

    public RuleSetting(@NotNull Rule rule, Parameter ... subSettings) {
        this.rule = rule;
        this.subSettings = subSettings;
    }

    @Override
    @NotNull
    public String displayName() {
        return this.rule.displayName;
    }

    @Override
    @NotNull
    public Setting.Value defaultValue(TextStyle style, RuleClient client) {
        return this.rule.isRuleEnabledByDefault(style, client) ? ENABLED : DISABLED;
    }

    public List<Parameter> getSubSettings() {
        return List.of(this.subSettings);
    }

    @Nullable
    public Parameter headerParameter() {
        return this.subSettings.length == 0 ? null : this.subSettings[0];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuleSetting)) {
            return false;
        }
        RuleSetting setting = (RuleSetting)o;
        return Objects.equals(this.rule, setting.rule);
    }

    public int hashCode() {
        return Objects.hash(this.rule);
    }

    public String toString() {
        return this.rule.id + this.getSubSettings().toString();
    }
}

