/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.tree.Node;
import ai.grazie.rules.util.CharUtil;
import java.util.List;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;

class TreePainter {
    private final int[] depths;
    private final char[][] tree;

    private TreePainter(List<Node> nodes) {
        this.depths = new int[nodes.size()];
        for (Node value : nodes) {
            List hierarchy = value.hierarchy().toList();
            for (int j = 0; j < hierarchy.size(); ++j) {
                Node node = (Node)hierarchy.get(j);
                this.depths[node.index] = Math.max(this.depths[node.index], j);
            }
        }
        int maxDepth = IntStreamEx.of((int[])this.depths).max().orElseThrow();
        this.tree = new char[nodes.size()][];
        for (int i = 0; i < this.tree.length; ++i) {
            this.tree[i] = " ".repeat(maxDepth + 1).toCharArray();
        }
    }

    static char[][] drawTree(List<Node> nodes) {
        if (nodes.isEmpty()) {
            return new char[0][];
        }
        TreePainter painter = new TreePainter(nodes);
        for (Node node : nodes) {
            if (node.head() != null) continue;
            painter.drawNode(node);
        }
        return painter.tree;
    }

    private void drawNode(Node node) {
        List<Node> dependents = node.allDependents();
        if (dependents.isEmpty()) {
            return;
        }
        int depth = this.depths[node.index];
        List branches = ((StreamEx)StreamEx.of(dependents).append((Object)node).sortedBy(n -> n.index)).toList();
        Node first = (Node)branches.get(0);
        Node last = (Node)branches.get(branches.size() - 1);
        Node prev = null;
        for (Node branch : branches) {
            for (int i = 0; i < depth; ++i) {
                this.putChar(branch.index, i, branch == node ? (char)'\u254c' : '\u2500');
            }
            this.putChar(branch.index, depth, (char)(branch == node ? (branch == first ? 9516 : (branch == last ? 9524 : (node.head() == null ? 9534 : 9532))) : (branch == first ? 9582 : (branch == last ? 9583 : 9508))));
            if (prev != null) {
                for (int j = prev.index + 1; j < branch.index; ++j) {
                    this.putChar(j, depth, '\u2502');
                }
            }
            prev = branch;
        }
        for (Node dependent : dependents) {
            this.drawNode(dependent);
        }
    }

    private void putChar(int line, int col, char c) {
        char prev = this.tree[line][col];
        if (prev != ' ' && !TreePainter.isOverwritingAllowed(c, prev)) {
            c = (char)88;
        }
        this.tree[line][col] = c;
    }

    private static boolean isOverwritingAllowed(char c, char prev) {
        return prev == '\u2500' && CharUtil.isAnyOf("\u2500\u253c\u2534\u252c\u254c", c) || prev == '\u2502' && CharUtil.isAnyOf("\u2524\u253c", c);
    }
}

