/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.jvmcompat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataParser;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataState;
import org.jetbrains.plugins.gradle.util.Ranges;
import org.jetbrains.plugins.gradle.util.RangesKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u000f*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataParser;", "T", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataState;", "", "<init>", "()V", "parseVersionedJson", "json", "", "ideVersion", "(Ljava/lang/String;Ljava/lang/String;)Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataState;", "parseJson", "data", "Lcom/google/gson/JsonObject;", "(Lcom/google/gson/JsonObject;)Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataState;", "Companion", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nIdeVersionedDataParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeVersionedDataParser.kt\norg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public abstract class IdeVersionedDataParser<T extends IdeVersionedDataState> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final T parseVersionedJson(@NotNull String json, @NotNull String ideVersion) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        JsonElement element = JsonParser.parseReader((Reader)new StringReader(json));
        if (!element.isJsonArray()) {
            return null;
        }
        JsonArray versionEntries = element.getAsJsonArray();
        Companion.IdeVersion currentVersion = new Companion.IdeVersion(ideVersion);
        Iterator iterator = versionEntries.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            T t;
            Object versionInfo;
            Ranges<Comparable> ideaRange2;
            JsonElement entry;
            JsonElement jsonElement;
            JsonElement it = jsonElement = (entry = (JsonElement)iterator2.next());
            boolean bl = false;
            Object object = it.isJsonObject() ? jsonElement : null;
            if (object == null || (object = object.getAsJsonObject()) == null) continue;
            JsonElement obj = object;
            Object object2 = obj.get("ideVersion");
            if (object2 == null) continue;
            JsonElement jsonElement2 = object2;
            Object it2 = jsonElement2;
            boolean bl2 = false;
            object2 = it2.isJsonPrimitive() ? jsonElement2 : null;
            if (object2 == null) continue;
            if ((object2 = object2.getAsString()) == null || !(ideaRange2 = Companion.parseRange(CollectionsKt.listOf((Object)(versionInfo = object2)), parseVersionedJson.ideaRange.1.INSTANCE)).contains(currentVersion) || (t = this.parseJson((JsonObject)obj)) == null) continue;
            it2 = t;
            boolean bl3 = false;
            ((IdeVersionedDataState)((Object)it2)).setDefault(false);
            ((IdeVersionedDataState)((Object)it2)).setIdeVersion(ideVersion);
            ((IdeVersionedDataState)((Object)it2)).setLastUpdateTime(System.currentTimeMillis());
            return (T)it2;
        }
        return null;
    }

    @Nullable
    public abstract T parseJson(@NotNull JsonObject var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0001\u0010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u00050\t\u00a2\u0006\u0002\u0010\nJ>\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\f\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u00050\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataParser$Companion;", "", "<init>", "()V", "parseVersion", "T", "p", "", "transform", "Lkotlin/Function1;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "parseRange", "Lorg/jetbrains/plugins/gradle/util/Ranges;", "", "data", "", "IdeVersion", "intellij.gradle"})
    @SourceDebugExtension(value={"SMAP\nIdeVersionedDataParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeVersionedDataParser.kt\norg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataParser$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,62:1\n1563#2:63\n1634#2,3:64\n295#2,2:67\n1563#2:69\n1634#2,3:70\n37#3,2:73\n*S KotlinDebug\n*F\n+ 1 IdeVersionedDataParser.kt\norg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataParser$Companion\n*L\n25#1:63\n25#1:64,3\n27#1:67,2\n31#1:69\n31#1:70,3\n31#1:73,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final <T> T parseVersion(@Nullable String p, @NotNull Function1<? super String, ? extends T> transform) {
            Intrinsics.checkNotNullParameter(transform, (String)"transform");
            if (p == null || Intrinsics.areEqual((Object)p, (Object)"INF")) {
                return null;
            }
            return (T)transform.invoke((Object)p);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final <T extends Comparable<? super T>> Ranges<T> parseRange(@NotNull List<String> data, @NotNull Function1<? super String, ? extends T> transform) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Object v0;
            List list;
            Collection collection;
            block4: {
                void $this$mapTo$iv$iv2;
                Intrinsics.checkNotNullParameter(data, (String)"data");
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                Iterable $this$map$iv = data;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    char[] cArray = new char[]{'-'};
                    collection.add(StringsKt.split$default((CharSequence)((CharSequence)it), (char[])cArray, (boolean)false, (int)0, (int)6, null));
                }
                list = (List)destination$iv$iv;
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    List t = (List)element$iv;
                    boolean bl = false;
                    if (!(t.size() != 2)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            Pair[] pairArray = v0;
            if (pairArray != null) {
                Pair[] it = pairArray;
                boolean bl = false;
                throw new IllegalArgumentException(data + " cannot be parsed as version range: Range is two versions separated by dash, version ranges separated by comma");
            }
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                List bl2 = (List)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(TuplesKt.to(Companion.parseVersion((String)it.get(0), transform), Companion.parseVersion((String)it.get(1), transform)));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            pairArray = thisCollection$iv.toArray(new Pair[0]);
            return RangesKt.range(Arrays.copyOf(pairArray, pairArray.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataParser$Companion$IdeVersion;", "", "v", "", "<init>", "(Ljava/lang/String;)V", "getV", "()Ljava/lang/String;", "compareTo", "", "other", "intellij.gradle"})
        public static final class IdeVersion
        implements Comparable<IdeVersion> {
            @NotNull
            private final String v;

            public IdeVersion(@NotNull String v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                this.v = v;
            }

            @NotNull
            public final String getV() {
                return this.v;
            }

            @Override
            public int compareTo(@NotNull IdeVersion other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                return VersionComparatorUtil.compare((String)this.v, (String)other.v, IdeVersion::compareTo$lambda$0);
            }

            private static final int compareTo$lambda$0(String it) {
                return 0;
            }
        }
    }
}

