/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.backend.formatter;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.service.AsyncDocumentFormattingService;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.formatting.service.FormattingService;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShFileType;
import com.intellij.sh.backend.formatter.ShShfmtFormatterUtil;
import com.intellij.sh.codeStyle.ShCodeStyleSettings;
import com.intellij.sh.parser.ShShebangParserUtil;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.settings.ShSettings;
import com.intellij.util.SmartList;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShExternalFormatter
extends AsyncDocumentFormattingService {
    @NonNls
    private static final List<String> KNOWN_SHELLS = Arrays.asList("bash", "posix", "mksh");
    private static final Set<FormattingService.Feature> FEATURES = EnumSet.noneOf(FormattingService.Feature.class);

    public boolean canFormat(@NotNull PsiFile file) {
        if (file == null) {
            ShExternalFormatter.$$$reportNull$$$0(0);
        }
        return file instanceof ShFile;
    }

    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        Set<FormattingService.Feature> set = FEATURES;
        if (set == null) {
            ShExternalFormatter.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    protected String getNotificationGroupId() {
        return "Shell Script";
    }

    @NotNull
    protected String getName() {
        String string = ShBundle.message((String)"sh.shell.script", (Object[])new Object[0]);
        if (string == null) {
            ShExternalFormatter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    protected AsyncDocumentFormattingService.FormattingTask createFormattingTask(final @NotNull AsyncFormattingRequest request) {
        FormattingContext formattingContext;
        Project project;
        String shFmtExecutable;
        if (request == null) {
            ShExternalFormatter.$$$reportNull$$$0(3);
        }
        if (!ShShfmtFormatterUtil.isValidPath(shFmtExecutable = ShSettings.getShfmtPath((Project)(project = (formattingContext = request.getContext()).getProject())))) {
            return null;
        }
        ShShfmtFormatterUtil.checkShfmtForUpdate(project);
        String interpreter = ShShebangParserUtil.getInterpreter((ShFile)((ShFile)formattingContext.getContainingFile()), KNOWN_SHELLS, (String)"bash");
        CodeStyleSettings settings = formattingContext.getCodeStyleSettings();
        ShCodeStyleSettings shSettings = (ShCodeStyleSettings)settings.getCustomSettings(ShCodeStyleSettings.class);
        if (((String)ShSettings.I_DO_MIND_SUPPLIER.get()).equals(shFmtExecutable)) {
            return null;
        }
        Path path = Optional.ofNullable(request.getIOFile()).map(File::toPath).orElse(null);
        if (path == null) {
            return null;
        }
        @NonNls SmartList params = new SmartList();
        params.add("-ln=" + interpreter);
        if (!settings.getIndentOptions((FileType)ShFileType.INSTANCE).USE_TAB_CHARACTER) {
            int tabSize = settings.getIndentOptions((FileType)ShFileType.INSTANCE).INDENT_SIZE;
            params.add("-i=" + tabSize);
        }
        if (shSettings.BINARY_OPS_START_LINE) {
            params.add("-bn");
        }
        if (shSettings.SWITCH_CASES_INDENTED) {
            params.add("-ci");
        }
        if (shSettings.REDIRECT_FOLLOWED_BY_SPACE) {
            params.add("-sr");
        }
        if (shSettings.KEEP_COLUMN_ALIGNMENT_PADDING) {
            params.add("-kp");
        }
        if (shSettings.MINIFY_PROGRAM) {
            params.add("-mn");
        }
        params.add(EelNioBridgeServiceKt.asEelPath((Path)path).toString());
        EelDescriptor eelDescriptor = EelProviderUtil.getEelDescriptor((Project)project);
        try {
            EelPathUtils.FileTransferAttributesStrategy.RequirePosixPermissions forceExecutePermission = EelPathUtils.FileTransferAttributesStrategy.copyWithRequiredPosixPermissions((PosixFilePermission[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE});
            GeneralCommandLine commandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withExePath(EelNioBridgeServiceKt.asEelPath((Path)EelPathUtils.transferLocalContentToRemote((Path)Path.of(shFmtExecutable, new String[0]), (EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Temporary(eelDescriptor), (EelPathUtils.FileTransferAttributesStrategy)forceExecutePermission)).toString()).withWorkingDirectory(path.getParent()).withParameters((List)params);
            final OSProcessHandler handler = new OSProcessHandler(commandLine.withCharset(StandardCharsets.UTF_8));
            return new AsyncDocumentFormattingService.FormattingTask(){

                public void run() {
                    handler.addProcessListener((ProcessListener)new CapturingProcessAdapter(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            int exitCode;
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if ((exitCode = event.getExitCode()) == 0) {
                                request.onTextReady(this.getOutput().getStdout());
                            } else {
                                request.onError(ShBundle.message((String)"sh.shell.script", (Object[])new Object[0]), this.getOutput().getStderr());
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/sh/backend/formatter/ShExternalFormatter$1$1", "processTerminated"));
                        }
                    });
                    handler.startNotify();
                }

                public boolean cancel() {
                    handler.destroyProcess();
                    return true;
                }

                public boolean isRunUnderProgress() {
                    return true;
                }
            };
        }
        catch (ExecutionException e) {
            request.onError(ShBundle.message((String)"sh.shell.script", (Object[])new Object[0]), e.getMessage());
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/backend/formatter/ShExternalFormatter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/backend/formatter/ShExternalFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFormat";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFormattingTask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

