/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.bitext;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;
import org.languagetool.bitext.BitextReader;
import org.languagetool.bitext.StringPair;

public class TabBitextReader
implements BitextReader {
    protected BufferedReader in;
    protected StringPair nextPair;
    protected String nextLine;
    protected int sentencePos;
    private String prevLine;
    private int lineCount = -1;

    public TabBitextReader(String filename, String encoding) {
        try {
            this.in = encoding == null ? new BufferedReader(new InputStreamReader(new FileInputStream(filename))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
            this.nextLine = this.in.readLine();
            this.prevLine = "";
            this.nextPair = this.tab2StringPair(this.nextLine);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    protected StringPair tab2StringPair(String line) {
        if (line == null) {
            return null;
        }
        String[] fields = line.split("\t");
        if (fields.length < 2) {
            throw new RuntimeException("Unexpected format, expected two tab-separated columns: " + line);
        }
        return new StringPair(fields[0], fields[1]);
    }

    @Override
    public Iterator<StringPair> iterator() {
        return new TabReader();
    }

    @Override
    public int getColumnCount() {
        return this.sentencePos;
    }

    @Override
    public int getTargetColumnCount() {
        return 1;
    }

    @Override
    public int getLineCount() {
        return this.lineCount;
    }

    @Override
    public int getSentencePosition() {
        return this.sentencePos;
    }

    @Override
    public String getCurrentLine() {
        return this.prevLine;
    }

    class TabReader
    implements Iterator<StringPair> {
        TabReader() {
        }

        @Override
        public boolean hasNext() {
            return TabBitextReader.this.nextLine != null;
        }

        @Override
        public StringPair next() {
            try {
                StringPair result = TabBitextReader.this.nextPair;
                TabBitextReader.this.sentencePos = TabBitextReader.this.nextPair.getSource().length() + 1;
                if (TabBitextReader.this.nextLine != null) {
                    TabBitextReader.this.prevLine = TabBitextReader.this.nextLine;
                    TabBitextReader.this.nextLine = TabBitextReader.this.in.readLine();
                    TabBitextReader.this.nextPair = TabBitextReader.this.tab2StringPair(TabBitextReader.this.nextLine);
                    ++TabBitextReader.this.lineCount;
                    if (TabBitextReader.this.nextLine == null) {
                        TabBitextReader.this.in.close();
                    }
                }
                return result;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

