/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.jdom.Element;
import org.jdom.output.EclipseXMLOutputter;
import org.jdom.output.Format;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class EclipseJDOMUtil {
    private EclipseJDOMUtil() {
    }

    private static EclipseXMLOutputter createOutputter(String lineSeparator) {
        EclipseXMLOutputter xmlOutputter = new EclipseXMLOutputter(lineSeparator);
        Format format = Format.getCompactFormat().setIndent("\t").setTextMode(Format.TextMode.NORMALIZE).setEncoding("UTF-8").setOmitEncoding(false).setOmitDeclaration(false);
        xmlOutputter.setFormat(format);
        return xmlOutputter;
    }

    public static void output(@NotNull Element element, @NotNull File file, @NotNull Project project) throws IOException {
        if (element == null) {
            EclipseJDOMUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            EclipseJDOMUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            EclipseJDOMUtil.$$$reportNull$$$0(2);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            EclipseJDOMUtil.output(element, (Writer)writer, project);
        }
    }

    public static void output(@NotNull Element element, @NotNull @NonNls Writer writer, @NotNull Project project) throws IOException {
        if (element == null) {
            EclipseJDOMUtil.$$$reportNull$$$0(3);
        }
        if (writer == null) {
            EclipseJDOMUtil.$$$reportNull$$$0(4);
        }
        if (project == null) {
            EclipseJDOMUtil.$$$reportNull$$$0(5);
        }
        EclipseJDOMUtil.output(element, writer, CodeStyle.getSettings((Project)project).getLineSeparator());
    }

    public static void output(@NotNull Element element, @NonNls @NotNull Writer writer, String lineSeparator) throws IOException {
        if (element == null) {
            EclipseJDOMUtil.$$$reportNull$$$0(6);
        }
        if (writer == null) {
            EclipseJDOMUtil.$$$reportNull$$$0(7);
        }
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write(lineSeparator);
        EclipseJDOMUtil.createOutputter(lineSeparator).output(element, writer);
        writer.write(lineSeparator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "writer";
                break;
            }
        }
        objectArray[1] = "org/jdom/output/EclipseJDOMUtil";
        objectArray[2] = "output";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

