/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures;

import androidx.compose.foundation.gestures.DragEvent;
import androidx.compose.foundation.gestures.DraggableKt;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.TouchInputEventSmoother;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.indirect.IndirectTouchEvent;
import androidx.compose.ui.input.indirect.IndirectTouchEventType;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import androidx.compose.ui.platform.ViewConfiguration;
import androidx.compose.ui.unit.VelocityKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u000fH\u0002J\u001e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/compose/foundation/gestures/IndirectTouchEventProcessor;", "", "startGestureTrigger", "Lkotlin/Function0;", "", "onDragEvent", "Lkotlin/Function1;", "Landroidx/compose/foundation/gestures/DragEvent;", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "getStartGestureTrigger", "()Lkotlin/jvm/functions/Function0;", "getOnDragEvent", "()Lkotlin/jvm/functions/Function1;", "velocityTracker", "Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "hasCrossedTouchSlop", "", "previousIndirectTouchPosition", "Landroidx/compose/ui/geometry/Offset;", "J", "positionAccumulator", "startEventPosition", "touchInputEventSmoother", "Landroidx/compose/foundation/gestures/TouchInputEventSmoother;", "requireVelocityTracker", "processIndirectTouchEvent", "event", "Landroidx/compose/ui/input/indirect/IndirectTouchEvent;", "orientation", "Landroidx/compose/foundation/gestures/Orientation;", "viewConfiguration", "Landroidx/compose/ui/platform/ViewConfiguration;", "resetProcessor", "Companion", "foundation"})
@SourceDebugExtension(value={"SMAP\nDraggable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Draggable.kt\nandroidx/compose/foundation/gestures/IndirectTouchEventProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,1338:1\n1#2:1339\n30#3:1340\n30#3:1344\n53#4,3:1341\n53#4,3:1345\n*S KotlinDebug\n*F\n+ 1 Draggable.kt\nandroidx/compose/foundation/gestures/IndirectTouchEventProcessor\n*L\n1202#1:1340\n1203#1:1344\n1202#1:1341,3\n1203#1:1345,3\n*E\n"})
final class IndirectTouchEventProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Unit> startGestureTrigger;
    @NotNull
    private final Function1<DragEvent, Unit> onDragEvent;
    @Nullable
    private VelocityTracker velocityTracker;
    private boolean hasCrossedTouchSlop;
    private long previousIndirectTouchPosition;
    private long positionAccumulator;
    private long startEventPosition;
    @NotNull
    private TouchInputEventSmoother touchInputEventSmoother;
    private static final int PixelSensitivity = 2;

    public IndirectTouchEventProcessor(@NotNull Function0<Unit> startGestureTrigger, @NotNull Function1<? super DragEvent, Unit> onDragEvent) {
        Intrinsics.checkNotNullParameter(startGestureTrigger, (String)"startGestureTrigger");
        Intrinsics.checkNotNullParameter(onDragEvent, (String)"onDragEvent");
        this.startGestureTrigger = startGestureTrigger;
        this.onDragEvent = onDragEvent;
        this.previousIndirectTouchPosition = Offset.Companion.getZero-F1C5BW0();
        this.positionAccumulator = Offset.Companion.getZero-F1C5BW0();
        this.startEventPosition = Offset.Companion.getZero-F1C5BW0();
        this.touchInputEventSmoother = new TouchInputEventSmoother();
    }

    @NotNull
    public final Function0<Unit> getStartGestureTrigger() {
        return this.startGestureTrigger;
    }

    @NotNull
    public final Function1<DragEvent, Unit> getOnDragEvent() {
        return this.onDragEvent;
    }

    private final VelocityTracker requireVelocityTracker() {
        VelocityTracker velocityTracker = this.velocityTracker;
        if (velocityTracker == null) {
            boolean bl = false;
            String string = "VelocityTracker was not initialized.";
            throw new IllegalArgumentException(string.toString());
        }
        return velocityTracker;
    }

    public final boolean processIndirectTouchEvent(@NotNull IndirectTouchEvent event, @NotNull Orientation orientation, @NotNull ViewConfiguration viewConfiguration) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)viewConfiguration, (String)"viewConfiguration");
        if (this.velocityTracker == null) {
            this.velocityTracker = new VelocityTracker();
        }
        long smoothedEventPosition = this.touchInputEventSmoother.smoothEventPosition-dBAh8RU(event, orientation);
        int n = event.getType-LxEHWp8();
        if (IndirectTouchEventType.equals-impl0(n, IndirectTouchEventType.Companion.getPress-LxEHWp8())) {
            this.resetProcessor();
            this.requireVelocityTracker().addPosition-Uv8p0NA(event.getUptimeMillis(), smoothedEventPosition);
            this.previousIndirectTouchPosition = smoothedEventPosition;
            this.startEventPosition = smoothedEventPosition;
            bl = false;
        } else if (IndirectTouchEventType.equals-impl0(n, IndirectTouchEventType.Companion.getMove-LxEHWp8())) {
            long delta = Offset.minus-MK-Hz9U(smoothedEventPosition, this.previousIndirectTouchPosition);
            boolean consumed = false;
            this.positionAccumulator = Offset.plus-MK-Hz9U(this.positionAccumulator, delta);
            if (!this.hasCrossedTouchSlop && Math.abs(DraggableKt.access$toFloat-3MmeM6k(this.positionAccumulator, orientation)) > viewConfiguration.getTouchSlop()) {
                long l;
                long v2$iv$iv;
                long v1$iv$iv;
                float val1$iv$iv;
                boolean $i$f$packFloats;
                float val2$iv$iv;
                float x$iv;
                boolean $i$f$Offset;
                float y$iv;
                this.hasCrossedTouchSlop = true;
                this.startGestureTrigger.invoke();
                float postSlopDelta = (Math.abs(DraggableKt.access$toFloat-3MmeM6k(this.positionAccumulator, orientation)) - viewConfiguration.getTouchSlop()) * Math.signum(DraggableKt.access$toFloat-3MmeM6k(this.positionAccumulator, orientation));
                if (orientation == Orientation.Horizontal) {
                    float f = postSlopDelta;
                    y$iv = 0.0f;
                    $i$f$Offset = false;
                    float f2 = x$iv;
                    val2$iv$iv = y$iv;
                    $i$f$packFloats = false;
                    v1$iv$iv = Float.floatToRawIntBits(val1$iv$iv);
                    v2$iv$iv = Float.floatToRawIntBits(val2$iv$iv);
                    l = Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
                } else {
                    x$iv = 0.0f;
                    y$iv = postSlopDelta;
                    $i$f$Offset = false;
                    val1$iv$iv = x$iv;
                    val2$iv$iv = y$iv;
                    $i$f$packFloats = false;
                    v1$iv$iv = Float.floatToRawIntBits(val1$iv$iv);
                    v2$iv$iv = Float.floatToRawIntBits(val2$iv$iv);
                    l = Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
                }
                delta = l;
                this.onDragEvent.invoke((Object)new DragEvent.DragStarted(this.startEventPosition, null));
                consumed = true;
            }
            if (this.hasCrossedTouchSlop && Math.abs(DraggableKt.access$toFloat-3MmeM6k(delta, orientation)) > 2.0f) {
                this.requireVelocityTracker().addPosition-Uv8p0NA(event.getUptimeMillis(), smoothedEventPosition);
                consumed = true;
                this.onDragEvent.invoke((Object)new DragEvent.DragDelta(delta, true, null));
            }
            this.previousIndirectTouchPosition = smoothedEventPosition;
            bl = consumed;
        } else if (IndirectTouchEventType.equals-impl0(n, IndirectTouchEventType.Companion.getRelease-LxEHWp8())) {
            boolean bl2;
            if (this.hasCrossedTouchSlop) {
                float maxVelocity = viewConfiguration.getMaximumFlingVelocity();
                DragEvent.DragStopped event2 = new DragEvent.DragStopped(this.requireVelocityTracker().calculateVelocity-AH228Gc(VelocityKt.Velocity(maxVelocity, maxVelocity)), true, null);
                this.onDragEvent.invoke((Object)event2);
                bl2 = true;
            } else {
                bl2 = false;
            }
            boolean consumed = bl2;
            this.resetProcessor();
            bl = consumed;
        } else {
            this.onDragEvent.invoke((Object)DragEvent.DragCancelled.INSTANCE);
            this.resetProcessor();
            bl = false;
        }
        return bl;
    }

    public final void resetProcessor() {
        VelocityTracker velocityTracker = this.velocityTracker;
        if (velocityTracker != null) {
            velocityTracker.resetTracking();
        }
        this.hasCrossedTouchSlop = false;
        this.previousIndirectTouchPosition = Offset.Companion.getZero-F1C5BW0();
        this.positionAccumulator = Offset.Companion.getZero-F1C5BW0();
        this.startEventPosition = Offset.Companion.getZero-F1C5BW0();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/compose/foundation/gestures/IndirectTouchEventProcessor$Companion;", "", "<init>", "()V", "PixelSensitivity", "", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

