/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.ConfusionString;
import org.languagetool.rules.ngrams.ConfusionProbabilityRule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.FalseFriendRuleLoader;
import org.languagetool.rules.patterns.PatternToken;

public abstract class EnglishForL2SpeakersFalseFriendRule
extends ConfusionProbabilityRule {
    private static final Map<Language, List<AbstractPatternRule>> motherTongue2rules = new HashMap<Language, List<AbstractPatternRule>>();
    private final Language lang;
    private final Language motherTongue;

    public EnglishForL2SpeakersFalseFriendRule(ResourceBundle messages, LanguageModel languageModel, Language motherTongue, Language lang) {
        super(messages, languageModel, lang, 3);
        this.lang = Objects.requireNonNull(lang);
        this.motherTongue = Objects.requireNonNull(motherTongue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AbstractPatternRule> getRules() {
        EnglishForL2SpeakersFalseFriendRule englishForL2SpeakersFalseFriendRule = this;
        synchronized (englishForL2SpeakersFalseFriendRule) {
            if (!motherTongue2rules.containsKey(this.motherTongue)) {
                FalseFriendRuleLoader loader = new FalseFriendRuleLoader("\"{0}\" ({1}) means {2} ({3}).", "Did you maybe mean {0}?");
                try (InputStream is = JLanguageTool.getDataBroker().getFromRulesDirAsStream("false-friends.xml");){
                    motherTongue2rules.put(this.motherTongue, loader.getRules(is, this.lang, this.motherTongue));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return motherTongue2rules.get(this.motherTongue);
    }

    protected String getMessage(ConfusionString textString, ConfusionString suggestion) {
        for (AbstractPatternRule rule : this.getRules()) {
            List patternTokens = rule.getPatternTokens();
            for (PatternToken patternToken : patternTokens) {
                if (!textString.getString().equals(patternToken.getString()) && !this.isBaseformMatch(textString, patternToken)) continue;
                return rule.getMessage();
            }
        }
        return super.getMessage(textString, suggestion);
    }

    private boolean isBaseformMatch(ConfusionString textString, PatternToken patternToken) {
        if (patternToken.isInflected()) {
            try {
                List readings = this.lang.getTagger().tag(Collections.singletonList(textString.getString()));
                for (AnalyzedTokenReadings reading : readings) {
                    if (!reading.getReadings().stream().anyMatch(k -> k.getLemma() != null && k.getLemma().equals(patternToken.getString()))) continue;
                    return true;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

