/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.Diacritics;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.en.Adjectives;
import ai.grazie.rules.en.AgreementSet;
import ai.grazie.rules.en.AuxMainVerbForm;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.EnglishTreeSupport;
import ai.grazie.rules.en.EnglishValences;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.PassiveToActive;
import ai.grazie.rules.en.PolarityItemViolations;
import ai.grazie.rules.en.PunctuationRules;
import ai.grazie.rules.en.QuantifierNounCompatibility;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.StyleRules;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.en.WordSeparation;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.util.CharUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import kotlin.Pair;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tools.StringTools;

public class Articles {
    private static final WordSet requiresA = new WordSet(((StreamEx)StreamEx.of(WordSet.loadResource((String)"org/languagetool/rules/en/det_a.txt", (Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$static$0(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).words).append((Object)"unibody").append((Object)"unix").filter(s -> !s.equalsIgnoreCase("URL"))).toSet());
    private static final WordSet requiresAn = WordSet.loadResource("org/languagetool/rules/en/det_an.txt", s -> s.startsWith("*") ? s.substring(1) : s);
    static final WordSet requiresArticle = WordSet.loadResource("en/words/need_article.txt");
    static final Map<String, List<String>> adjsToNouns = WordSet.multiValueMap(WordSet.loadLines("en/words/adjs_to_nouns.txt"));
    private static final String vowels = IntStreamEx.of((IntStream)"aAeEiIoOuU".chars()).mapToObj(c -> (char)c + (String)Diacritics.normal2DiacriticChars.getOrDefault((char)c, (Object)"")).joining();
    private static final String definitelySpelledAsVowelUpper = IntStreamEx.of((IntStream)"AEIO".chars()).mapToObj(c -> (char)c + (String)Diacritics.normal2DiacriticChars.getOrDefault((char)c, (Object)"")).joining();
    private static final NodePattern singularTheNouns = NodePattern.N.form("start|finish|end|beginning|middle").noDependents("cop");
    private static final NodePattern ordinal = NodePattern.or(NodePattern.N.pos("ORD"), NodePattern.N.form("first"), EnglishTreePatterns.ordinalWithSuffix);
    private static final NodePattern suggestOnlyThe = NodePattern.or(singularTheNouns, NodePattern.N.withDependent("amod", NodePattern.or(ordinal, NodePattern.N.form("last|current|next|preceding"))));
    static final NodePattern suggestOnlySingular = NodePattern.or(NodePattern.N.form("world|presence|basis|sharing|education|trust"), singularTheNouns, NodePattern.N.withDependent("amod", ordinal).noDependents("nummod|nmod:poss"), StyleRules.informalAddressing.and(CommonPatterns.firstWord));
    static final NodePattern geoRequiringThe = NodePattern.N.pos("NN.*").andOr(Number.pluralSingularGeoRequiringThe, NodePattern.N.form("Alps|Andes|Appalachians|Atlantic|Bahamas|Baltic|Caribbean|Caspian|Caucasus|Comoros|Danube|equator|Euphrates|Gambia|Ganges|Gobi|Himalayas|Indus|Kalahari|Maldives|Netherlands|Nile|Ob|Occident|Orient|Orinoco|Philippines|Pyrenees|Rhine|Rhone|Rockies|Sahara|Thames|Tiber|Tigris|UAE|UK|Urals|USA|Volga|Yangtze").noDependents("compound|nmod").noDependents("amod", NodePattern.N.label("NATIONALITY_OR_GROUP")).andNot(NodePattern.N.withHead("nmod", NodePattern.N.form("republic"))), NodePattern.N.inFormSequence(1, "Amazon|Colorado|Columbia|Hudson|Lena|Mackenzie|Mekong|Mississippi|Missouri|Niger|Ohio|Seine|Tagus", "River"), NodePattern.N.inFormSequence(1, "Atlas|Rocky", "Mountains"), NodePattern.N.formCaseSensitive("Republic").directlyAfter(CommonPatterns.capitalized.withHeadRelation("compound|amod").noForm("democratic|islamic")), NodePattern.N.inFormSequence(1, "Adriatic|Aegean|Arabian|Baltic|Black|Caribbean|Caspian|Coral", "Sea"), NodePattern.N.inFormSequence(1, "Arctic|Atlantic", "Ocean"), NodePattern.N.inFormSequence(1, "Ivory", "Coast"), NodePattern.N.inFormSequence(0, 1, "Netherlands", "Antilles"), NodePattern.N.inFormSequence(0, 1, "Rio", "Grande"), NodePattern.N.inFormSequence(1, "Great", "Lakes"), NodePattern.N.inFormSequence(1, "United", "States|Kingdom"), NodePattern.N.inFormSequence(1, "Far|Middle|Near", "East"), NodePattern.N.inFormSequence(1, "South|North", "Pole"), NodePattern.N.inFormSequence(0, "Gulf", "of", "Aden|Mexico|Oman"), NodePattern.N.formCaseSensitive("Isle").directlyBefore(NodePattern.N.form("of").directlyBefore(CommonPatterns.capitalized)), NodePattern.N.inFormSequence(0, "Tropic", "of", "Cancer|Capricorn"), NodePattern.N.form("desert|canal").withDependent("compound", NodePattern.N.pos("NNP"))).noDependents("amod|compound", NodePattern.N.form("southern|northern|eastern|western|new|old|future|past")).andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("v\\."), NodePattern.N.inFormSequence(0, "v", "\\."))));
    private static final NodePattern capitalizedMiddleA = CommonPatterns.capitalizedMiddle.form("a");
    private static final NodePattern fromToNounEllipsis = NodePattern.N.markAs("FromTo").withDependent("case", NodePattern.N.form("from|to")).withHead("obl", NodePattern.N.withDependent("obl", NodePattern.N.after("FromTo").withDependent("case", NodePattern.N.form("from|to"))));
    private static final NodePattern adjSubjectAmbiguity = NodePattern.ROOT.potentialPos("VBZ").withDependent("amod", NodePattern.N.potentialPos("NN.*"));
    static final NodePattern noMisparsedDet = NodePattern.N.noDependents("amod|advmod|compound|nmod|obl:npmod", NodePattern.N.beforeHead().andOr(NodePattern.N.withPhraseStart(NodePattern.N.pos("DT|PRP\\$").noForm("such")), NodePattern.N.withDependent("nmod:poss|det"), NodePattern.N.withDependent("obl", NodePattern.N.pos("DT")))).andNot(NodePattern.N.withPrevSibling(Number.pluralDeterminers)).andNot(NodePattern.N.withHead("compound", NodePattern.N.withDependent("nmod:poss|det")));
    private static final NodePattern noDeterminerDependent = noMisparsedDet.andNot(EnglishTreePatterns.someAnyEveryNoX).noForm("mine").noDependents("nmod:poss|nummod").noDependents("nmod", NodePattern.N.beforeHead().and(CommonPatterns.possiblySkipDown("flat", NodePattern.N.withDependent("case", EnglishTreePatterns.apostropheS.afterHead()))).trace("misparsed nmod:poss")).noDependents("det", NodePattern.N.noForm("such")).noDependents("case", EnglishTreePatterns.apostropheS.directlyAfterHead()).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("dep").noLemma(".*"))).andNot(NodePattern.N.withDependent("amod|compound", NodePattern.or(NodePattern.N.withPhraseStart(NodePattern.N.withHeadRelation("nummod")), NodePattern.N.withDependent("nummod")).andNot(Semantics.timeUnits))).andNot(NodePattern.N.withDependent("cc:preconj", NodePattern.N.form("n?either")).noDependents("conj"));
    static final NodePattern nounWithoutDeterminer = NodePattern.N.pos("NN.*").and(noDeterminerDependent);
    private static final String definitelyConsonantsUpper = "BDGKPTV";
    private static final String definitelyConsonantsLower = "bcdfghjklmnpqrstvwxz";
    private static final String spelledLettersA = "bcdgjkpqtuvwyz";
    private static final String spelledLettersAn = "aefhilmnorsx";
    private static final NodePattern articleExcludingQuotation = NodePattern.or(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.PUNCT.noSpaceAfter().noForm("\\("), EnglishTreePatterns.onlyQuotes)), EnglishTreePatterns.quotations, CommonPatterns.parenthesis);
    static final NodePattern singularCountableNoun = NodePattern.N.pos("NN").noPos("NNS|NNP.*|VB.*|CD|DT|PRP.*|RB|CC").andOr(NodePattern.N.form("collection"), NodePattern.N.form("country").withDependent("amod|det", NodePattern.N.directlyBeforeHead()), NodePattern.N.form("form|sense").andOr(NodePattern.N.withDependent("nmod|compound"), NodePattern.N.directlyBefore(NodePattern.N.form("of"))), Semantics.definitelyCountable, NodePattern.not(NodePattern.or(Semantics.possiblyUncountableForm, EnglishTreePatterns.someAnyEveryNoX))).andNot(NodePattern.N.pos("IN").directlyAfter(CommonPatterns.noSpaceHyphen)).andNot(EnglishTreePatterns.withToMark).noDependents("amod", NodePattern.N.lemma("many|much|few|little"));
    static final NodePattern textUnits = NodePattern.N.lemma("page|block|line|passage|column|paragraph|string|range|segment|part|amount|wall|screen|piece|fragment|sample|body");
    static final NodePattern textActions = NodePattern.N.potentialLemma("edit|format|encode|wrap|highlight|search|store|extract|find|replace|click");
    private static final NodePattern mealNames = NodePattern.N.form("breakfast|dinner|lunch|supper");
    private static final NodePattern article = NodePattern.N.form("an?|the");
    private static final NodePattern longOptionName = CommonPatterns.capitalizedMiddle.andOr(NodePattern.N.withDependent("det", Articles.article), NodePattern.N.directlyAfter(Articles.article)).and(node -> node.tagIndependentlyLowForm().hasPos("VB"));
    private static final NodePattern noArticleSource = NodePattern.N.form("source").andOr(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("from|open|closed")), NodePattern.N.withHead("obl|nmod", NodePattern.N.lemma("depend.*")));
    private static final NodePattern xPrepX = NodePattern.or(NodePattern.N.sameWordAs(-2).withDependent("case", NodePattern.N.directlyBeforeHead()), NodePattern.N.sameWordAs(2).withNeighbor(2, NodePattern.N.withDependent("case", NodePattern.N.directlyBeforeHead())));
    private static final NodePattern withPrepositonAsNmod = NodePattern.N.withDependent("nmod", NodePattern.N.pos("IN"));
    static final NodePattern prepositionsInNounCoordination = NodePattern.N.pos("IN").withHead("nmod", NodePattern.or(NodePattern.N.withHead("conj", withPrepositonAsNmod), NodePattern.N.withDependent("conj", NodePattern.N.directlyBefore(NodePattern.N.pos("IN")))));
    private static final NodePattern possibleTimeIndication = Semantics.timeUnits.withDependent("amod", NodePattern.N.form("last|next|previous|following|(up|forth)?coming"));
    private static final NodePattern bareCoordination = CommonPatterns.possiblyConj(nounWithoutDeterminer.pos("NN").markAs("N1").withDependent("conj", nounWithoutDeterminer.pos("NN").withDependent("cc", NodePattern.N.form("and|or").directlyAfter("N1").directlyBeforeHead()).noDependents("amod")).andNot(CommonPatterns.severalDependents("conj")).noDependents("amod")).trace("bare coordination");
    private static final NodePattern objCompoundAmbiguity = NodePattern.N.markAs("Obj").withHead("obj", NodePattern.or(NodePattern.N.withHeadRelation("acl").directlyAfter(NodePattern.N.pos("NNP").withDependent("nummod")), NodePattern.N.pos("VBG").withHead("acl|xcomp", NodePattern.N.withHeadRelation("root|ccomp").pos("NN").withDependent("det")), NodePattern.N.noSpaceBefore().withHeadRelation("parataxis").noDependents(NodePattern.N.beforeHead()).directlyAfter(CommonPatterns.HYPHEN_NODE), NodePattern.ROOT.andOr(CommonPatterns.firstWord.noPotentialPos("VB.*"), NodePattern.N.withDependent("det"), NodePattern.N.withDependent("advmod", NodePattern.N.directlyBeforeHead().pos("NN").noPos("RB")), NodePattern.N.potentialPos("NNS").withOnlyDependents(NodePattern.N.withHeadRelation("obj|nsubj|punct")).andNot(EnglishTreePatterns.unlikelyToBeNoun), NodePattern.N.potentialPos("NN").and(NodePattern.markedNodeMatches("Obj", NodePattern.N.withDependent("acl", NodePattern.N.directlyAfterHead().pos("VBD").withDependent("obj|xcomp"))))), NodePattern.N.directlyBefore("Obj").andOr(NodePattern.N.withHeadRelation("csubj").pos("VBG"), NodePattern.N.withHeadRelation("parataxis").beforeHead()), NodePattern.N.directlyAfterHead().withHead("parataxis", NodePattern.ROOT.pos("NNS?")).potentialPos("NN")));
    private static final NodePattern singleCompoundHyphen = CommonPatterns.noSpaceHyphen.andOr(NodePattern.N.directlyBeforeHead(), NodePattern.N.directlyAfterHead()).directlyAfter(NodePattern.N.anyPos().withHeadRelation("compound").spaceBefore());
    private static final NodePattern possiblyNounWithNumber = NodePattern.or(CommonPatterns.beforeSkipping(NodePattern.N.form("[#\u2116]"), NodePattern.or(NodePattern.N.potentialPos("CD"), NodePattern.N.form("\\d.*"))), NodePattern.N.withDependent("appos", CommonPatterns.withNumberLikeForm.directlyAfter(NodePattern.N.noForm("[<>=]"))));
    private static final NodePattern lot = NodePattern.N.form("lot");
    static final NodePattern allowMissingArticle = NodePattern.or(NodePattern.N.withHeadRelation("compound|appos|conj|flat|xcomp|compound:prt|nmod:poss|list|goeswith|vocative|amod|aux(:pass)?|cop|case|dep"), NodePattern.N.withHeadRelation("obl:npmod").andNot(lot), NodePattern.N.withHeadRelation("parataxis").andNot(EnglishTreePatterns.clause), NodePattern.N.withDependent("conj").withDependent("amod", NodePattern.N.beforeHead().withNextSibling(CommonPatterns.comma.beforeHead())), bareCoordination, NodePattern.N.afterHead().withHeadRelation("obj").andOr(NodePattern.N.withPrevSibling(NodePattern.N.pos("NN.*|JJ").afterHead().withHeadRelation("conj")), NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("obj"))), NodePattern.N.withHead("nmod", NodePattern.N.withDependent("det", NodePattern.N.directlyBeforeHead()).markAs("NmodHead")).withDependent("compound", Semantics.possiblyUncountableForm.directlyBeforeHead().withNeighbor(-2, NodePattern.N.alreadyMarkedAs("NmodHead"))).trace("the X of Y assumption"), NodePattern.N.withHead("obj", NodePattern.or(NodePattern.N.noForm("have").potentialPos("NN").withDependent("nsubj", NodePattern.N.noPos("PRP.*|NNS|WP").directlyBeforeHead()), NodePattern.N.withDependent("(nsubj|aux):pass"))), EnglishTreePatterns.oblWithoutCase.noDependents("compound", NodePattern.N.beforeHead().withDependent("case")), EnglishTreePatterns.objOnNonVerb, NodePattern.N.withDependent("parataxis", NodePattern.N.beforeHead()), NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("nmod").withDependent("det|nmod:poss")), NodePattern.or(CommonPatterns.firstPhrase, EnglishTreePatterns.inShortCapitalizedSentence, NodePattern.N.withHead("obj", CommonPatterns.firstWord.andOr(NodePattern.N.potentialPos("NN"), CommonPatterns.quotedWord, NodePattern.N.pos("VBN").potentialPos("JJ").withPhraseEnd(NodePattern.not(NodePattern.PUNCT))))), EnglishTreePatterns.byPP.andNot(PassiveToActive.passiveAgent.withHead("obl", NodePattern.N.pos("VBN"))), NodePattern.N.withDependent("compound", NodePattern.N.onlyPos("PRP.*").noFormCaseSensitive("IT")), NodePattern.N.potentialPos("VB.*").andOr(NodePattern.N.withDependent("nsubj.*").noHeadRelation("acl:relcl").andOr(NodePattern.N.noDependents("cop"), NodePattern.N.withDependent("aux.*")), NodePattern.N.withHeadRelation("obj").withNextSibling(NodePattern.N.withHeadRelation("conj").onlyPos("VB.*")).noDependents("det|nmod.*|compound"), NodePattern.N.withHead("obj", NodePattern.N.pos("NN.*")), NodePattern.N.withHeadRelation("obl").withDependent("case", NodePattern.N.inFormSequence(0, "instead", "of")).and(CommonPatterns.beforeSkipping(CommonPatterns.comma, CommonPatterns.skipUp("det", NodePattern.N.pos("NN.*")))).trace("work with, instead of challenge, Obj")), NodePattern.N.pos("NN.*").withHead("obl", NodePattern.N.withDependent("cop").withDependent("det").potentialPos("JJ.*")), NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE), CommonPatterns.insideQuotes, CommonPatterns.possiblySkipDown("appos|dep", EnglishTreePatterns.phraseInApostrophes), NodePattern.N.withDependent("appos", NodePattern.N.withDependent("punct", NodePattern.N.form("[<>]"))), NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.form("}"), CommonPatterns.comparisonOperators))), CommonPatterns.inParentheses.withDependent("conj").withOnlyDependents(NodePattern.N.withHeadRelation("conj|punct")), NodePattern.N.directlyAfter(NodePattern.N.form("[/#]")), NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE.andNot(singleCompoundHyphen)), NodePattern.N.withDependent("conj", NodePattern.N.pos("NN.*").and(CommonPatterns.lastChildPhrase).directlyAfter(NodePattern.N.pos("NN.*").withHeadRelation("conj"))), NodePattern.N.withHead("obj", NodePattern.N.pos("VBG").directlyAfter(CommonPatterns.noSpaceHyphen).and(CommonPatterns.skipUp("acl", NodePattern.ROOT))), NodePattern.N.withHead(EnglishTreePatterns.kinda), EnglishTreePatterns.kinda.withDependent("appos"), NodePattern.N.withHead("nmod", Semantics.anyGroup), NodePattern.N.directlyBefore(NodePattern.N.pos("NN.*")), NodePattern.N.directlyBeforeHead().withHead("advmod", NodePattern.N.pos("JJ")), NodePattern.N.withDependent("flat"), CommonPatterns.capitalizedMiddle, CommonPatterns.beforeSkipping(EnglishTreePatterns.aposOrQuote.noSpaceAfter().spaceBefore(), CommonPatterns.capitalizedMiddle), NodePattern.N.withDependent("compound", CommonPatterns.capitalizedMiddle).andOr(NodePattern.N.withHead("nmod", CommonPatterns.capitalizedMiddle.withDependent("det")), NodePattern.N.withDependent("appos", CommonPatterns.inParentheses)), NodePattern.N.directlyAfter(EnglishTreePatterns.apostropheS.withHeadRelation("case")), objCompoundAmbiguity, NodePattern.N.withPhraseStart(NodePattern.N.form("and").directlyBefore(NodePattern.N.form("[" + vowels + "].+"))).withHeadRelation("obj"), NodePattern.N.withHead("nsubj", NodePattern.N.withHeadRelation("ccomp|parataxis").withPrevSibling(NodePattern.N.pos("NN.*").withHeadRelation("obj"))), possiblyNounWithNumber, NodePattern.N.withHeadRelation("acl|advcl").potentialPos("VBN"), NodePattern.N.withDependent("nmod", NodePattern.N.form("concept|notion|entity|word|idea").withDependent("case", NodePattern.N.form("as"))).trace("form as a concept"), NodePattern.N.withDependent("cc.*", NodePattern.N.directlyBeforeHead()), SubjectVerbAgreement.hasClauseCompoundAmbiguity, NodePattern.N.withDependent("case", NodePattern.N.noPos()).trace("typo in the preposition"), NodePattern.N.withDependent("case", NodePattern.N.inFormSequence(0, "such", "as")).andOr(NodePattern.N.withDependent("conj"), NodePattern.N.noDependents(NodePattern.N.afterHead())), NodePattern.N.withDependent("case", NodePattern.N.form("like")).andOr(NodePattern.N.withHead("nmod", EnglishTreePatterns.typeSynonyms), NodePattern.N.withDependent("conj", NodePattern.N.form("others"))), NodePattern.N.withDependent("case", NodePattern.N.form("of")).withHead(NodePattern.N.lemma("look|notion|regardless|level|knowledge")), NodePattern.N.withDependent("case", NodePattern.N.form("with")).withHead(NodePattern.N.lemma("fill|forceful|act")), NodePattern.N.withDependent("case", NodePattern.N.form("without").directlyBefore(NodePattern.N.pos("VBG"))), NodePattern.N.withDependent("case", NodePattern.N.form("without")).form("incident|ceremony|cease|fail|let|class|weekend|cause|ado|issue|tuition|mention|question|extension"), NodePattern.N.inPhrase(NodePattern.N.withDependent("punct", NodePattern.N.pos("NN.*"))), NodePattern.N.withDependent("case", NodePattern.N.form("to")).withHead("obl", NodePattern.N.lemma("prefer|prone|susceptible")), NodePattern.N.inFormSequence(1, "than|as", "ideal"), NodePattern.N.withDependent("amod", NodePattern.N.form("due")), NodePattern.N.form("victim").withHead(NodePattern.N.lemma("fall")), NodePattern.N.form("case|association|combination|agreement|brief|spirit|opposite|type|consequence|(back|fore)ground").withDependent("case", NodePattern.N.form("in")), NodePattern.N.form("type").inSentenceWith(NodePattern.N.form("text")), NodePattern.N.form("need").andOr(NodePattern.N.withDependent("case", NodePattern.N.form("in|of")), NodePattern.N.inFormSequence(1, "if", "need", "be")), NodePattern.N.form("extension|collection|inauguration|investigation|nomination").withDependent("case", NodePattern.N.form("for").beforeHead()), NodePattern.N.inFormSequence(2, "out", "of", "process"), NodePattern.N.inFormSequence(2, "up", "to", "standard"), NodePattern.N.inFormSequence(1, "in", "process").andNot(EnglishValences.isArgument), NodePattern.N.inFormSequence(1, "snake|camel|pascal|kebab|variable|lower|upper|correct.*", "case"), NodePattern.N.inFormSequence(1, "in", "general|sequence"), NodePattern.N.inFormSequence(1, "as", "standard"), NodePattern.N.inFormSequence(1, "on", "end"), NodePattern.N.inFormSequence(1, "on|in|into|single|Indian|double|close|(un)?broken", "file"), NodePattern.N.inFormSequence(2, "end", "of", "file"), NodePattern.N.inFormSequence(1, "for", "debate|company"), NodePattern.N.inFormSequence(1, "evolver", "group"), NodePattern.N.inFormSequence(1, "from", "outside|ideal"), NodePattern.N.inFormSequence(1, "play", "house"), NodePattern.N.inFormSequence(1, "page", "load"), NodePattern.N.withHead("obj", NodePattern.N.pos("VBG").withHeadRelation("parataxis").andNot(EnglishTreePatterns.clause)), NodePattern.N.directlyAfter(NodePattern.or(WordSeparation.hardcodedPhrasalParticle, WordSeparation.spacedPhrasalVerbParticle.directlyAfter(NodePattern.N.withHeadRelation("conj")))), NodePattern.N.form("scale").andOr(NodePattern.N.directlyAfter(NodePattern.N.form("at|of|with|in")), Articles.objectOf(NodePattern.N)), NodePattern.N.form(".{4,}tion").withDependent("amod", NodePattern.N.form("mass").beforeHead()), NodePattern.N.form("form").withDependent("case", NodePattern.N.form("in|from")).noDependents("case", NodePattern.N.form("of")), NodePattern.N.form("form").directlyAfter(NodePattern.N.lemma("take")).andNot(NodePattern.N.inFormSequence(0, "form", "of")), NodePattern.N.withHead("nmod", Semantics.timeUnits).withDependent("case", NodePattern.N.form("of")), NodePattern.N.inFormSequence(2, "out", "of", "pocket"), NodePattern.N.inFormSequence(2, "explanations?", "of", "vote"), NodePattern.N.inFormSequence(1, "server", "load"), NodePattern.N.lemma("minimum|maximum").andOr(NodePattern.N.withHead(NodePattern.N.lemma("point")), NodePattern.N.directlyAfter(NodePattern.N.form("at"))), NodePattern.N.form("format").andOr(NodePattern.N.withDependent("case", NodePattern.N.beforeHead()), NodePattern.N.withHead("obj", NodePattern.N.pos("VBG"))), NodePattern.N.form("section").andOr(NodePattern.N.inFormSequence(1, "horizontal|vertical|cross|median", "section"), NodePattern.N.directlyBefore(NodePattern.N.pos("CD")), NodePattern.N.directlyAfter(NodePattern.N.form("in")).withOnlyDependents(NodePattern.N.form("in"))), NodePattern.N.form("account").andOr(NodePattern.N.withDependent("case", NodePattern.N.form("into")), NodePattern.N.inFormSequence(1, "on", "account"), NodePattern.N.withDependent("case", NodePattern.N.form("to|out")).withHead("obl", NodePattern.N.lemma("hold|turn|leave|bring|call")), Articles.objectOf(NodePattern.N.lemma("take|give|keep|render")), NodePattern.N.directlyAfter(NodePattern.N.inFormSequence(1, "units?", "of"))), NodePattern.N.form("menu").withDependent("amod|compound").withDependent("case", NodePattern.N.form("via")), NodePattern.N.form("economy").andOr(NodePattern.N.noHeadRelation("obj").noDependents("amod|compound|nmod"), NodePattern.N.withDependent("nmod", NodePattern.N.form("effort")), NodePattern.N.withHead("obj", NodePattern.N.lemma("get|go|ride|drive|jump|travel|hop|arrive|move|leave|come|fly"))), NodePattern.N.form("grip").withHead("obj", NodePattern.N.lemma("lose")), NodePattern.N.form("script").andOr(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.not(Semantics.isProgrammingLanguage).label("NATIONALITY_OR_GROUP|LOCATION|LANGUAGE"), NodePattern.N.form("off|gothic"))), NodePattern.N.directlyAfter(NodePattern.N.form("of")).withHead(textUnits)), NodePattern.N.form("type").withDependent("amod", NodePattern.N.form("wooden|move?able")), NodePattern.N.form("proportion").andOr(NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("to"))), NodePattern.N.withDependent("case", NodePattern.N.form("in")).noDependents("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("of"))), NodePattern.N.withHeadRelation("obl.*|nmod").noDependents("nmod")), NodePattern.N.form("option").after(longOptionName), noArticleSource, xPrepX, NodePattern.N.form("direction|angle").withDependent("case", NodePattern.N.form("in")).noDependents(NodePattern.N.afterHead()), NodePattern.N.inFormSequence(1, 3, "from", ".*", "to", ".*"), NodePattern.N.inFormSequence(2, "from", ".*", ".*", "to", ".*").withDependent("compound", NodePattern.N.directlyBeforeHead()), NodePattern.N.pos("JJ.*"), NodePattern.N.withDependent("case", NodePattern.N.form("per")), NodePattern.N.form("road").withDependent("compound"), NodePattern.N.form("query").withDependent("compound", Semantics.dataSynonyms), NodePattern.N.form("house").withHead("obj", NodePattern.N.lemma("move")), NodePattern.N.form("magazine").withDependent("compound"), NodePattern.N.form("collection").withDependent("compound|amod|nmod", NodePattern.or(Semantics.dataSynonyms, Semantics.trashSynonyms, Semantics.feeSynonyms, NodePattern.N.lemma("log|dump"))), NodePattern.N.withHead("nmod", NodePattern.N.form("plenty")), NodePattern.N.form("background").withDependent("case", NodePattern.N.form("of")), NodePattern.N.form("end").directlyBefore(NodePattern.N.pos("VB.*").afterHead().withHead("advcl|parataxis|dep", NodePattern.N.pos("VB.*"))), NodePattern.N.inFormSequence(3, "there", "is", "not", ".+"), NodePattern.N.inFormSequence(1, "under", "load"), NodePattern.N.inFormSequence(2, "in", "good", "company"), NodePattern.N.inFormSequence(2, "of", "such", "period").withHeadRelation("nmod"), NodePattern.N.inFormSequence(1, "on", "step|set"), NodePattern.N.inFormSequence(2, "letter", "of", "introduction|guarantee|complaint"), NodePattern.N.inFormSequence(2, "age", "of", "majority"), NodePattern.N.inFormSequence(1, "in|cognitive|neurogical", "deficit"), NodePattern.N.form("framework").withHead("obj", NodePattern.N.form("test")), NodePattern.N.form("source").andOr(NodePattern.N.withNextSibling(NodePattern.N.pos("NNS").withHeadRelation("conj")), NodePattern.N.withDependent("conj", NodePattern.N.pos("NNS"))), NodePattern.N.form("artist|doctor|musician|reader|hitchhiker|(di)?rector|president|driver|producer|extremist|refugee|farmer|postman|soldier|student|teacher|admin(istrator)?|professor|developer|engineer|programmer|linguist|investor|pala?eontologist|politician|electrician|consultant|writer|painter|blogger|essayist|novelist|portraitist|landscapist|scholar|golfer|worker|researcher|careerist|governor|warden|principal|harbormaster|conductor|officer|captain|foreman|superintendent|senior|official|philosopher|logician|scientist|architect|dean|mayor|specialist|analyst|notary|registrar|chair(wo)?man|clerk|minister|advisor|lecturer|representative|librarian|commandor|CEO|manager|deputy|executive|agent|ambassador|nurse|midwife|secretary|master|bachelor|associate").withDependent("appos", NodePattern.N.label("PERSON")), Semantics.humanLikePattern.withHead("obj", CommonPatterns.skipUp("xcomp", NodePattern.or(EnglishTreePatterns.imperativeVB, EnglishTreePatterns.possiblyImperativeVB, EnglishTreePatterns.imperativePossible, NodePattern.N.withDependent("nsubj", NodePattern.N.form("you"))))).trace("misparsed vocative"));
    private static final NodePattern possiblyUncountableDeverbalNouns = NodePattern.N.form(".{5,}tion|.{3,}[auo]tion|.{4,}sion|.+ment|sharing").andNot(Articles.requiresArticle.formPattern).andNot(Semantics.definitelyCountable);
    static final NodePattern allowMissingArticleAfterWithout = NodePattern.or(NodePattern.N.form("portfolio|limit|number|compare|pause|pity|reference"), allowMissingArticle, NodePattern.N.potentialPos("VBG"), NodePattern.N.inPhrase(NodePattern.ROOT.onlyPos("NNS?").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?")), NodePattern.N.form("lease").withHead(NodePattern.N.form("push")), Semantics.possiblePluralNN, mealNames, possiblyUncountableDeverbalNouns);
    static final String MISSING_ARTICLE = "Missing article?";
    static final String SUPERLATIVE_MSG = "Superlatives normally require 'the'";
    static final String GEO_MSG = "This geographical name requires 'the'";
    static final String NOUNS_WITH_NUMBERS_MSG = "Don\u2019t use articles before nouns with numbers";
    static final String DANGLING_MSG = "Is a noun (or equivalent) missing after this article?";
    static final String WITH_POSSESSIVE_MSG = "Articles can\u2019t be combined with possessive pronouns";
    private static final NodePattern theALetter = NodePattern.N.inFormSequence(1, "the", "a", "in");
    private static final NodePattern rSharp = NodePattern.N.inFormSequence(0, "an?", "r", "#");
    private static final Pattern spellFirstLetter = Pattern.compile(".\\d*|[bcdfghjklmnpqrstvwxz]+value|std.*|[xhn][bcdfghjklmnpqrstvwxz].*");
    private static final NodePattern comparativeAdj = NodePattern.N.directlyAfter(NodePattern.N.directlyBeforeHead().form("so|as").withHeadRelation("advmod|mark")).potentialPos("JJ.*");
    private static final NodePattern withComparativeAdj = NodePattern.N.withDependent("amod", comparativeAdj.directlyBeforeHead());
    private static final NodePattern withThe = NodePattern.N.withDependent("det", NodePattern.N.form("the"));
    private static final NodePattern unknownWord = NodePattern.N.noPos().andNot(CommonPatterns.capitalized).andNot(NodePattern.PUNCT).andNot(NodePattern.custom(n -> n.tree().treeSupport().isAcceptedBySpellchecker(n.form())));
    private static final NodePattern ambiguousPhraseStart = NodePattern.N.withHead("amod|compound|det", NodePattern.N.noDependents("case|cop"));
    private static final NodePattern singularCopulaHead = NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.form(".*s")).noDependents("case");
    private static final NodePattern only = NodePattern.N.form("only");
    private static final NodePattern subjectWithExpletive = NodePattern.N.withHead("nsubj.*", NodePattern.N.withDependent("expl"));
    private static final NodePattern suggestAny = subjectWithExpletive.withHead(PolarityItemViolations.npiLicensingClause).noDependents("nummod");
    private static final NodePattern aVsAn = NodePattern.N.form("an?").withHeadRelation("det").andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("/"), EnglishTreePatterns.capitalizedUnknown.andNot(CommonPatterns.upperCase)))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("/"))).andNot(CommonPatterns.capitalizedMiddle).andNot(theALetter).andNot(rSharp).and((article, match) -> {
        Node next = article.nextNode();
        if (next == null || next.startOffset() - article.endOffset() > 1) {
            return null;
        }
        String replacement = Articles.fixIndefiniteArticle(article);
        return replacement == null ? null : match.withTouchedNode(Articles.skipPunctuationForward(next)).withCorrector(NodeCorrector.rawReplace(article.textRange(), replacement)).withMessage(Articles.aVsAnMessage(replacement));
    }).andOptionally(NodePattern.N.withHead("det", Semantics.possiblyUncountableForm.andNot(Semantics.definitelyCountable)).correct(NodeCorrector.replace(""))).andOptionally(NodePattern.N.withHead(suggestAny).correct(NodeCorrector.replace("any"))).and(CommonPatterns.highlightWithTrailingSpace());
    private static final NodePattern mistypedSpecifier = NodePattern.or(NodePattern.N.form("out|you"), NodePattern.N.inFormSequence(1, "you", "['\u2019`\u2018]re"));
    private static final NodePattern variableA = NodePattern.N.form("a").andOr(NodePattern.N.directlyAfter(CommonPatterns.arithmetics), NodePattern.N.directlyBefore(CommonPatterns.arithmetics), NodePattern.N.directlyAfterHead().markAs("A").withHead("appos|det|dep", NodePattern.N.withDependent("det", NodePattern.N.before("A"))), NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound"), NodePattern.N.directlyBefore(NodePattern.N.form("that|who|which").withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.withHeadRelation("acl:relcl"))).directlyAfter(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound")));
    private static final NodePattern letterA = NodePattern.N.form("a").andOr(NodePattern.N.directlyBefore(NodePattern.N.lemma("letter|sound")), NodePattern.N.noSpaceAfter());
    private static final NodePattern mistypedAndInPhraseWithThe = NodePattern.or(NodePattern.N.inFormSequence(1, "one", "an", "only"), NodePattern.N.inFormSequence(1, "one", "an", "the", "same"));
    private static final NodePattern emphaticRepetition = NodePattern.N.directlyBefore(CommonPatterns.comma).andOr(NodePattern.N.sameWordAs(2), NodePattern.N.sameWordAs(3).directlyAfter(NodePattern.N.potentialPos("VB.*").sameWordAs(3)), NodePattern.N.withNeighbor(2, NodePattern.or(NodePattern.N.inFormSequence(0, "what", "was|were|is"), NodePattern.N.inFormSequence(0, "you", "know"), NodePattern.N.pos("UH"))));
    private static final NodePattern complexPreposition = NodePattern.N.pos("VBG").withNeighbor(1, NodePattern.N.pos("IN").withHeadRelation("case")).withNeighbor(2, NodePattern.N);
    private static final NodePattern misparsedSecondCase = CommonPatterns.capitalized.markAs("Case").withHead("case", NodePattern.N.withDependent("case", NodePattern.N.before("Case")));
    private static final NodePattern withCompoundContinuation = NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.or(NodePattern.not(NodePattern.PUNCT), CommonPatterns.HYPHEN_NODE));
    private static final NodePattern superlative = NodePattern.N.pos("JJS|RBS").andNot(NodePattern.N.directlyAfter(NodePattern.or(EnglishTreePatterns.aposOrQuote, EnglishTreePatterns.dashes, mistypedSpecifier, NodePattern.N.form("from|to|[=:]"), NodePattern.N.formCaseSensitive("\\p{Lu}\\p{Ll}+s")))).andNot(NodePattern.N.form("most").andOr(NodePattern.N.withHead("amod", NodePattern.N.pos("NN.*")), NodePattern.N.directlyAfter(NodePattern.N.form("a")))).andNot(NodePattern.N.form("best").withHead("amod", NodePattern.N.form("practi[sc]e"))).andNot(NodePattern.N.inFormSequence(0, "least", "privilege")).andNot(NodePattern.N.inFormSequence(2, "line", "of", "best", "fit")).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE)).andNot(CommonPatterns.capitalizedMiddle).includeIntoReport();
    private static final NodePattern toPlural = NodePattern.custom((node, match) -> match.withCorrector(Articles.changeNumber(node, Number.plural)));
    private static final NodePattern childBeforeArticle = NodePattern.or(NodePattern.N.withHeadRelation("case|cc.*|cop|aux.*|advmod|obl|mark|nsubj.*").andNot(misparsedSecondCase), NodePattern.PUNCT.andNot(EnglishTreePatterns.aposOrQuote).andNot(singleCompoundHyphen));

    private static NodePattern objectOf(NodePattern head) {
        return NodePattern.or(NodePattern.N.withHead("obj|nsubj:pass", head), NodePattern.N.withHead("nsubj", NodePattern.N.lemma("have|need").withDependent("xcomp|ccomp", head)));
    }

    private static String aVsAnMessage(String replacement) {
        return "Use '" + replacement + "' before a " + ("a".equalsIgnoreCase(replacement) ? "consonant" : "vowel") + " sound";
    }

    @Nullable
    private static String fixIndefiniteArticle(Node article) {
        String replacement = Articles.getIndefiniteArticle(article.nextNode());
        if (replacement == null || article.hasForm(replacement) || !article.tree().treeSupport().isAcceptedBySpellchecker(Objects.requireNonNull(article.nextNode()).form()) && !article.nextNode().hasPos(".*") && !article.nextNode().hasForm("[a-z]")) {
            return null;
        }
        return Character.isUpperCase(article.form().charAt(0)) ? StringTools.uppercaseFirstChar((String)replacement) : replacement;
    }

    @Nullable
    private static Node skipPunctuationForward(@Nullable Node node) {
        return node == null ? null : node.skipForward(NodePattern.PUNCT::matches);
    }

    @Nullable
    static String getIndefiniteArticle(@Nullable Node next) {
        Node nextWord = Articles.skipPunctuationForward(next);
        return nextWord == null ? null : Articles.getIndefiniteArticle(nextWord.form());
    }

    @Nullable
    public static String getIndefiniteArticle(String nextText) {
        boolean needsAn;
        String nextWord = EnglishTreeSupport.getFirstWord(nextText);
        String lower = nextWord.toLowerCase(Locale.ROOT);
        if (lower.equals("mu")) {
            return null;
        }
        boolean needsA = requiresA.contains(nextWord) || requiresA.contains(lower) || lower.startsWith("one") && !nextWord.startsWith("onE");
        boolean bl = needsAn = requiresAn.contains(nextWord) || requiresAn.contains(lower);
        if (needsA) {
            return needsAn ? null : "a";
        }
        if (needsAn) {
            return "an";
        }
        if (nextWord.contains(".")) {
            return null;
        }
        char firstChar = nextWord.charAt(0);
        if (!lower.equals(nextWord) && !StringTools.isCapitalizedWord((String)nextWord)) {
            boolean hasClearPhonetics;
            boolean bl2 = hasClearPhonetics = nextWord.equals(nextWord.toUpperCase(Locale.ROOT)) && (CharUtil.isAnyOf(definitelyConsonantsUpper, firstChar) || CharUtil.isAnyOf(definitelySpelledAsVowelUpper, firstChar));
            if (!hasClearPhonetics) {
                return null;
            }
        } else if (nextWord.length() >= 2 && nextWord.chars().noneMatch(c -> CharUtil.isAnyOf(vowels, (char)c)) && !CharUtil.isAnyOf(definitelyConsonantsUpper, firstChar)) {
            return null;
        }
        if (!Character.isLetter(firstChar)) {
            return null;
        }
        if (spellFirstLetter.matcher(lower).matches()) {
            if (CharUtil.isAnyOf(spelledLettersA, Character.toLowerCase(firstChar))) {
                return "a";
            }
            if (CharUtil.isAnyOf(spelledLettersAn, Character.toLowerCase(firstChar))) {
                return "an";
            }
            return null;
        }
        return CharUtil.isAnyOf(vowels, firstChar) ? "an" : "a";
    }

    static NodePattern incorrectArticlePattern() {
        NodePattern meals = mealNames.and(NodePattern.or(NodePattern.N.withHead("obj", NodePattern.N.lemma("have")).noDependents("amod|compound"), NodePattern.N.withDependent("case", NodePattern.N.form("for")))).noDependents("nmod|acl.*|amod").and(Articles.removeArticle()).message("Meal names normally have no articles");
        NodePattern firstSight = NodePattern.N.form("sight").directlyAfter(NodePattern.N.form("first").noDependents("advmod", NodePattern.N.form("very"))).and(Articles.removeArticle()).message("'First sight' is typically used without an article");
        NodePattern bed = NodePattern.N.form("bed").and(NodePattern.or(NodePattern.N.withHead("obl", NodePattern.N.lemma("go|stay|be")), NodePattern.N.withDependent("case", NodePattern.N.form("in")).withDependent("cop"))).noDependents("acl:relcl").and(Articles.removeArticle()).message("If you mean 'go to sleep', use no article before 'bed'");
        NodePattern worldWar = NodePattern.N.withNeighbor(-1, NodePattern.N.formCaseSensitive("World")).formCaseSensitive("War").withNeighbor(1, NodePattern.N.formCaseSensitive("I|II|III|1|2|3|One|Two|Three").markAs("Number")).and(Articles.removeArticle()).message("'World War $Number' is usually used without articles");
        return NodePattern.or(Articles.removeIndefinite(), Articles.anTypo(), Articles.aToAnd(), Articles.andToAn(), Articles.anUncountable(), Articles.aPlural(), Articles.twoDeterminers(), Articles.dangling(), worldWar, Articles.numberedNouns(), meals, firstSight, bed, aVsAn, Articles.plenty(), Articles.kindOfA()).andNot(CommonPatterns.beforeSlashOrParenth);
    }

    static NodePattern missingArticlePattern() {
        NodePattern geography = geoRequiringThe.reportEverythingTouched().and((node, match) -> {
            List touched = ((StreamEx)StreamEx.of(match.touchedNodes()).sortedBy(Tree.Token::startOffset)).toList();
            return match.withMarkedNode("Start", (Node)touched.get(0));
        }).andNot(CommonPatterns.skipUp("flat", NodePattern.or(NodePattern.N.withDependent("det", NodePattern.N.form("the")), NodePattern.N.withDependent("nmod:poss"), NodePattern.ROOT.noDependents("cop")))).andNot(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("compound|nmod:poss|amod|appos|obl:npmod|list|flat.*|<unk>|dep"))).andNot(NodePattern.markedNodeMatches("Start", CommonPatterns.afterSkipping(CommonPatterns.comma, CommonPatterns.withNumberLikeForm))).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE)).andNot(NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen)).andNot(NodePattern.N.directlyBefore(CommonPatterns.capitalized.andNot(geoRequiringThe))).andNot(EnglishTreePatterns.inShortCapitalizedSentence).message(GEO_MSG).and(Articles.forceThe());
        NodePattern aNummod = NodePattern.N.form("dozen|hundred|thousand|million|billion|(ga)?zillion").beforeHead().withHead("nummod", NodePattern.not(EnglishTreePatterns.compound).and(noMisparsedDet)).noDependents("det|nmod:poss").noDependents("compound|nummod").noDependents("amod|advmod", NodePattern.not(NodePattern.N.form("about|more"))).andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("det|nmod:poss|nummod"))).andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.quotations)).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("[0-9.,]+"))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("per"))).message("Missing indefinite article before a numeral?").and(Articles.forceA());
        return NodePattern.or(geography, Articles.superlative(), aNummod, Articles.missing()).andNot(CommonPatterns.beforeSlashOrParenth);
    }

    private static NodePattern removeIndefinite() {
        NodePattern pluralSubject = NodePattern.N.pos("NNP?S").noDependents("case");
        return NodePattern.N.form("an?").directlyBefore(NodePattern.custom(node -> !node.neighbor(-1).lowForm().equals(Articles.getIndefiniteArticle(node.form()))).andOr(NodePattern.N.withDependent("nsubj", pluralSubject).noDependents("cop|aux|aux:pass"), NodePattern.ROOT.withDependent("compound", pluralSubject), NodePattern.N.noDependents(NodePattern.N.beforeHead().noForm("an?")).andOr(NodePattern.N.withHead("parataxis|appos", NodePattern.ROOT.and(pluralSubject).andNot(EnglishTreePatterns.clause)), NodePattern.N.withHeadRelation("ccomp").withPrevSibling(pluralSubject.afterHead()))).potentialPos("VB")).correct(NodeCorrector.replace("")).message(DANGLING_MSG).trace("remove indefinite");
    }

    private static boolean suggestionAffectsArticle(String suggestion, Node article, Node head) {
        if (article.nextNode() != head) {
            return false;
        }
        String correctArticle = Articles.getIndefiniteArticle(suggestion);
        return correctArticle != null && !correctArticle.equals(article.lowForm());
    }

    private static NodePattern anUncountable() {
        NodePattern allowedAnUncountable = NodePattern.or(NodePattern.N.withDependent("acl:relcl"), NodePattern.N.withDependent("amod", EnglishTreePatterns.degreeAdj));
        Map<String, String> countableReplacements = Map.of("causation", "cause");
        NodePattern withMuch = NodePattern.N.withDependent("amod", NodePattern.N.form("much").beforeHead());
        NodePattern uncountable = NodePattern.or(withMuch, Semantics.definitelyUncountableNoun.includeIntoReport()).noHeadRelation("compound").noForm("plenty").andNot(Semantics.singularUncountableAllowingArticle).noDependents("conj", NodePattern.not(Semantics.possiblyUncountableForm)).andNot(allowedAnUncountable).andNot(NodePattern.N.spaceBefore().directlyAfter(NodePattern.PUNCT)).andNot(NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen)).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE)).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("conj", NodePattern.N.withDependent("obj")))).andNot(NodePattern.N.form("precision").and(CommonPatterns.beforeSkipping(NodePattern.N.form("of"), EnglishTreePatterns.number))).andNot(NodePattern.N.form("multiplicity").withDependent("nmod", NodePattern.N.pos("NNS").withDependent("case", NodePattern.N.form("of")))).andNot(NodePattern.N.form("distrust").withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("of")))).andNot(NodePattern.N.form("terra").withDependent("flat", NodePattern.N.directlyAfterHead().form(".+a"))).andNot(NodePattern.N.inFormSequence(5, "tis", "a", "dull", "and", "endless", "strife"));
        return NodePattern.N.form("an?").includeIntoReport(ReportingKind.Hover).withHead("det", uncountable.andNot(NodePattern.N.withHeadRelation("conj").directlyBefore(NodePattern.N.pos("NN")))).andNot(NodePattern.N.directlyAfter(comparativeAdj)).and((a, match) -> {
            Node head = Objects.requireNonNull(a.head());
            String replacement = (String)countableReplacements.get(head.lowForm());
            if (replacement != null) {
                return EnglishTreePatterns.typoReplacement(replacement).match(head, match);
            }
            match = match.withReportedRange(CommonPatterns.withTrailingSpace(a), a.tree()).withCorrector(NodeCorrector.replace(a, ""));
            if (!withMuch.matches(head)) {
                List suggestions = ((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)head.similarWordsOfPos("NN").filter(sug -> !Semantics.isPossiblyUncountableNoun.test((String)sug))).filter(sug -> !EnglishTreePatterns.adjectiveUnlikelyToBeNounLemmas.contains(sug))).filter(sug -> !StringTools.startsWithUppercase((String)sug) || StringTools.startsWithUppercase((String)head.form()))).filter(sug -> !Articles.suggestionAffectsArticle(sug, a, head))).filter(sug -> ((EnglishTreeSupport)a.tree().treeSupport()).hasFrequencyAtLeast((String)sug, 54))).limit(2L)).toList();
                match = match.withCorrector(NodeCorrector.replace(head, suggestions));
            }
            return match.withMessage("Uncountable '" + head.form() + "' shouldn\u2019t have indefinite articles");
        });
    }

    private static NodePattern numberedNouns() {
        NodePattern range = NodePattern.or(NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.N.form("[-\u2013\u2014+].*")), NodePattern.N.withDependent("nmod|nummod", NodePattern.N.pos("CD").withDependent("case", NodePattern.N.form("to"))));
        NodePattern possiblyTheOnePronoun = withThe.withDependent("nummod|dep", NodePattern.N.form("one"));
        return NodePattern.N.pos("NN.*").withDependent("nummod|dep", NodePattern.N.pos("CD").directlyAfterHead().andNot(range).andNot(EnglishTreePatterns.singleYearCD).noForm("one").noDependents("conj")).noDependents("amod").noDependents("conj", NodePattern.N.withDependent("det")).noLemma("year|number|range").noPos("NNP").andNot(CommonPatterns.possiblySkipDown("appos|nummod", NodePattern.N.label("MISC|PERSON"))).andNot(NodePattern.N.label("PRODUCT").and(CommonPatterns.possiblySkipDown("compound", CommonPatterns.capitalizedMiddle))).andNot(possiblyTheOnePronoun).and(Articles.removeArticle()).message(NOUNS_WITH_NUMBERS_MSG);
    }

    private static NodePattern removeArticle() {
        return NodePattern.N.withDependent("det", NodePattern.N.form("an?|the").and(CommonPatterns.highlightWithTrailingSpace()).correct(NodeCorrector.replace("")));
    }

    private static NodePattern aPlural() {
        NodePattern specifiers = NodePattern.N.form("few|little");
        NodePattern quotedNoun = NodePattern.custom((noun, m) -> ((StreamEx)m.getMarkedNode("Article").nextUntil(noun).filter(EnglishTreePatterns.withOnlyQuote::matches)).count() % 2L == 1L ? m : null);
        NodePattern pluralNoun = NodePattern.or(NodePattern.custom(node -> Number.npNumberWithNumerals(node) == Number.plural), NodePattern.N.form("sports|physics|maths|arts|mechanics|materials|robotics")).noHeadRelation("nmod:poss|compound").noDependents("amod", specifiers).noDependents("amod", NodePattern.N.withDependent("conj", NodePattern.or(NodePattern.N.pos("DT"), NodePattern.N.withDependent("det")))).noDependents("conj", NodePattern.N.withDependent("compound")).andNot(NodePattern.N.withDependent("amod").withHead("conj", NodePattern.N.pos("JJ.*"))).andNot(specifiers).andNot(quotedNoun).andNot(fromToNounEllipsis).andNot(adjSubjectAmbiguity).andNot(CommonPatterns.capitalized.directlyAfter("Article")).noDependents("case", NodePattern.N.pos("POS").afterHead()).noDependents("nummod|compound|nmod:npmod", NodePattern.N.form("couple|bit")).andNot(NodePattern.N.withHeadRelation("obl:npmod").directlyBefore(NodePattern.N.withHeadRelation("obl:npmod"))).andNot(NodePattern.N.withDependent("compound").withHead("obj", NodePattern.N.withDependent("iobj"))).andNot(NodePattern.N.withDependent("acl", NodePattern.N.pos("VBN").directlyBefore(NodePattern.N.form("per")))).noForm("ways").noForm("masters|bachelors|associates").noForm("thanks").andNot(NodePattern.N.inFormSequence(1, "clever", "clogs")).andNot(NodePattern.N.inFormSequence(0, ".*seconds", "since")).andNot(NodePattern.N.inFormSequence(0, "thumbs", "up|down")).andNot(NodePattern.N.withDependent("nummod", NodePattern.N.markAs("Num")).withDependent("amod", NodePattern.N.before("Num").form("impressive|solid|further|excellent|titanic"))).markAs("PluralNoun");
        NodePattern an_x_a_day = NodePattern.N.afterHead().directlyAfter(NodePattern.N.form("an?")).andOr(NodePattern.N.withHead("nmod:(np|t)mod", NodePattern.N.withDependent("det|nummod")), NodePattern.N.withHeadRelation("obl:(np|t)mod").withPrevSibling(CommonPatterns.possiblySkipDown("compound", NodePattern.N.withDependent("det|nummod"))));
        NodePattern pluralize = NodePattern.N.noDependents("cop", NodePattern.custom(cop -> Number.verbNumber(cop) == Number.singular)).andNot(an_x_a_day);
        NodePattern withPunctDep = CommonPatterns.possiblySkipDown("conj", NodePattern.N.withDependent("punct", NodePattern.not(CommonPatterns.noSpaceHyphen)));
        return NodePattern.N.form("an?").spaceAfter().markAs("Article").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("worth"))).andNot(NodePattern.N.inFormSequence(0, "a", "capp?ella|little|few")).andNot(NodePattern.N.inFormSequence(0, "a", "great|good", "many")).withHead("det", NodePattern.or(pluralNoun.withOptionalDependent("compound", Semantics.numberDelegatingGroup.markAs("Group")), Semantics.numberDelegatingGroup.markAs("Group").withHead("nmod:npmod", pluralNoun), NodePattern.N.pos("CD").withHead("nummod", pluralNoun).noLemma("dozen|hundred|thousand|million|billion|(ga)?zillion")).andNot(NodePattern.N.withDependent("compound", NodePattern.or(withPunctDep, NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("amod|compound").and(withPunctDep)), NodePattern.N.withDependent("conj").withPrevSibling(NodePattern.N.withHeadRelation("amod|compound"))))).andNot(EnglishTreePatterns.nmodWithoutCase.trace("nmod without case|mark"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("JJ|VBN").withHeadRelation("amod")).withHead(NodePattern.or(NodePattern.N.withDependent("nummod"), NodePattern.N.form("tens"), NodePattern.N.lemma("dozen|hundred|thousand|million|billion|(ga)?zillion")))).andNot(NodePattern.N.formCaseSensitive("A").andOr(CommonPatterns.capitalizedMiddle, NodePattern.N.inSentenceWith(capitalizedMiddleA))).andNot(NodePattern.markedNodeMatches("Group", QuantifierNounCompatibility.quantifiedNpVsCcompAmbiguity)).andOr(NodePattern.markedNodeMatches("Group", NodePattern.N.correct(NodeCorrector.insertAfter(" of")).message("Did you forget 'of' after '$_'?")), NodePattern.custom((article, match) -> {
            Node head = Objects.requireNonNull(article.head());
            String fixed = Articles.fixIndefiniteArticle(article);
            NodeCorrector toSingular = Articles.changeNumber(head, Number.singular);
            if (toSingular != null) {
                match = match.withCorrector(toSingular.join(fixed == null ? null : NodeCorrector.rawReplace(article.textRange(), fixed)));
            }
            if (suggestAny.matches(head) && Objects.requireNonNull(head.head()).hasForm("are|were")) {
                match = match.withCorrector(NodeCorrector.replace(article, "any"));
            }
            if (pluralize.matches(head)) {
                NodeCorrector toPlural = Articles.changeNumber(head, Number.plural);
                match = match.withCorrector(toPlural != null ? toPlural : NodeCorrector.replace(article, ""));
            }
            return CommonPatterns.highlightWithTrailingSpace().match(article, match);
        }).includeIntoReport().and(NodePattern.markedNodeMatches("PluralNoun", NodePattern.N.message("Indefinite articles should not be used with plural nouns like '$_'").includeIntoReport())));
    }

    private static NodePattern usePossessiveDeterminer() {
        NodePattern verbsForOblRelatesToObj = NodePattern.N.lemma("thank|praise|commend|respect|applaud|excuse|blame");
        NodePattern verbsOnOblRelatesToObj = NodePattern.N.lemma("congratulate");
        NodePattern possessiveDeterminerFromObj = NodePattern.N.afterHead().onlyPos("NN").andOr(NodePattern.N.withHead(verbsForOblRelatesToObj).withDependent("case", NodePattern.N.form("for")), NodePattern.N.withHead(verbsOnOblRelatesToObj).withDependent("case", NodePattern.N.form("on"))).withHead("obl", NodePattern.N.withDependent("obj", NodePattern.N.afterHead().andOr(NodePattern.N.pos("PRP_.+"), NodePattern.N.pos("NNS?").and(Semantics.Animacy.humanLike.pattern)).markAs("Antecedent"))).noDependents("amod", CommonPatterns.possiblySkipDown("advmod", NodePattern.N.form("so|such"))).noDependents("compound", NodePattern.N.pos("VBG")).andNot(NodePattern.N.withPrevSibling(NodePattern.PUNCT)).and(Articles.forcePossessive(NodePointer.marked("Antecedent"))).and(Articles.forceThe()).message("A determiner might be missing before '$_'");
        NodePattern itsOwnNoun = NodePattern.N.withDependent("amod", NodePattern.N.form("own")).withHead("obj", CommonPatterns.skipUp("xcomp", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.or(NodePattern.N.pos("NNS").withDependent("acl:relcl", NodePattern.N.withDependent("nsubj:pass", NodePattern.N.pos("PRP_S.+").markAs("Antecedent"))), NodePattern.N.pos("PRP_.+|NNS?").markAs("Antecedent"))))).and(Articles.forcePossessive(NodePointer.marked("Antecedent"))).message("A possessive determiner might be missing before 'own'");
        return NodePattern.or(possessiveDeterminerFromObj, itsOwnNoun);
    }

    private static NodePattern xIsNoun() {
        NodePattern salutation = NodePattern.N.form("(mr|mr?s|dr|prof)\\.?");
        NodePattern uncountable = Semantics.possiblyUncountableForm.andNot(Semantics.definitelyCountable);
        NodePattern couldBeVerb = NodePattern.or(NodePattern.N.potentialPos("VB").andOr(NodePattern.N.withDependent("obj"), NodePattern.N.withDependent("ccomp").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.noForm("it|this"))), NodePattern.N.pos("NN").potentialPos("VBD"));
        NodePattern unlikelyWithAmAre = NodePattern.N.form("lack|list").withDependent("cop", NodePattern.N.onlyPos("VBP"));
        NodePattern timeIndication = NodePattern.or(possibleTimeIndication.andOr(NodePattern.N.withDependent("mark", NodePattern.N.form("as")), NodePattern.N.noDependents(NodePattern.N.afterHead())), NodePattern.N.inFormSequence(0, "half", "past"));
        return NodePattern.or(NodePattern.N.withDependent("nsubj", NodePattern.or(CommonPatterns.letterWord.noPos(), NodePattern.N.pos("NNP|PRP"), NodePattern.N.form("this"), salutation.withDependent("flat", CommonPatterns.capitalizedMiddle)).beforeHead()), NodePattern.N.withDependent("csubj", NodePattern.N.pos("VBG")), NodePattern.N.withDependent("expl")).withDependent("cop", NodePattern.not(mistypedSpecifier).beforeHead().andNot(EnglishTreePatterns.clausalCopula).markAs("Cop")).andNot(NodePattern.N.withDependent("amod", CommonPatterns.possiblySkipDown("amod", superlative))).andNot(timeIndication).noDependents("cop", EnglishTreePatterns.itsConfusion).noDependents("amod|compound", NodePattern.or(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE), NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE))).noDependents("flat|case").andOr(NodePattern.N.withDependent("amod|advmod", NodePattern.N.directlyBeforeHead().potentialPos("RB").andOr(NodePattern.N.withDependent("advmod", superlative.markAs("Most")), only.withHead(NodePattern.N.noPos("JJ.*")).markAs("Only"))), NodePattern.N.noDependents("advmod", NodePattern.N.noPos("WRB")).andNot(EnglishTreePatterns.unlikelyToBeNoun.potentialPos("JJ"))).andNot(CommonPatterns.capitalizedMiddle.noDependents(NodePattern.N.after("Cop").andNot(NodePattern.PUNCT))).andNot(CommonPatterns.capitalizedMiddle.andOr(NodePattern.N.label(".*"), NodePattern.N.withDependent("compound", NodePattern.N.label("PERSON")), NodePattern.N.withDependent("conj", CommonPatterns.capitalizedMiddle.pos("NNP")))).andNot(noArticleSource).andNot(uncountable).andNot(NodePattern.N.withNeighbor(1, NodePattern.N.pos("VB[NG]")).withNeighbor(2, uncountable)).noForm("president|part|able|family|bout|popular").andNot(couldBeVerb).andNot(NodePattern.N.withHeadRelation("parataxis").directlyAfter(CommonPatterns.noSpaceHyphen)).andNot(unlikelyWithAmAre).andNot(bareCoordination).andNot(CommonPatterns.possiblySkipDown("compound", NodePattern.N.withDependent("nummod"))).andNot(NodePattern.N.inFormSequence(0, "proof", "against")).andNot(NodePattern.N.inFormSequence(0, "subject", "to")).andNot(NodePattern.N.inFormSequence(0, "neck", "and", "neck")).andNot(NodePattern.N.sameWordAs(2).withNeighbor(2, NodePattern.N.withDependent("case"))).andOptionally(NodePattern.N.noDependents("acl:relcl").noDependents("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("of"))).andNot(EnglishTreePatterns.unlikelyToBeVerb).andNot(EnglishValences.definitelyIntransitive.withDependent("nsubj", NodePattern.N.noForm("it"))).and(Articles.forcePastParticiple())).andOptionally(EnglishTreePatterns.unlikelyToBeNoun.withDependent("amod", NodePattern.N.directlyBeforeHead().noPos("RB|ORD")).correct(NodeCorrector.insertBefore("to ")).markAs("MissingTo")).andOptionally(NodePattern.N.withHeadRelation("ccomp").withPhraseStart(NodePattern.N.inFormSequence(0, "it", EnglishTreePatterns.apostropheS.getFormRegex()).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "its")))).andOr(NodePattern.markedNodeMatches("Most", NodePattern.N).and(NodePattern.custom((noun, m) -> m.withCorrector(NodeCorrector.insertBefore(noun, Articles.getIndefiniteArticle(noun.form()) + " ")))), NodePattern.markedNodeMatches("Only", NodePattern.N).withDependent("acl:relcl"), suggestOnlyThe, Articles.forceA()).andOptionally(NodePattern.N.withDependent("amod", NodePattern.N.withDependent("advmod", NodePattern.N.form("quite").and(Articles.forceA())))).andOr(NodePattern.markedNodeMatches("Most", NodePattern.N.correct(NodeCorrector.insertBefore("the "))), NodePattern.markedNodeMatches("Only", NodePattern.N.includeIntoReport().correct(NodeCorrector.insertBefore("the "))), NodePattern.N.withDependent("amod", NodePattern.N.noPos("ORD|RB")).noDependents("cop", NodePattern.N.pos("VBD")), withComparativeAdj, Articles.forceThe()).trace("X is noun");
    }

    private static NodePattern ofAllKinds() {
        NodePattern allBeforeOf = NodePattern.N.form("all").directlyBefore("Of").includeIntoReport().markAs("All");
        return NodePattern.N.pos("NNS").andNot(CommonPatterns.upperCase).andNot(CommonPatterns.capitalizedMiddle).withDependent("case", NodePattern.N.form("of").markAs("Of").includeIntoReport()).andOr(NodePattern.N.withHead("nmod|obl.*", allBeforeOf.withHead("dep|nmod|appos", NodePattern.N.pos("NNS"))), NodePattern.N.withHead("nmod", NodePattern.N.pos("NNS")).withPrevSibling(allBeforeOf)).withOnlyDependents(NodePattern.N.withHeadRelation("conj|case|amod")).trace("things of all kinds").correct(NodeCorrector.replace(NodePointer.marked("All"), "of").join(NodeCorrector.replace(NodePointer.marked("Of"), "all")));
    }

    private static NodePattern partitiveOf() {
        NodePattern allowWithoutThe = NodePattern.or(NodePattern.N.form("humanity|humankind|mankind|life|creation|civilization|nature|time|space|eternity|reality|existence|heaven|hell|society|history|" + Semantics.disciplines), Semantics.sport, Semantics.timeUnits.pos("NN").withDependent("amod", NodePattern.N.form("last")), NodePattern.N.inFormSequence(1, "high|middle|secondary|primary", "school"), NodePattern.N.form("congress"));
        return NodePattern.N.pos("NNS?").andNot(CommonPatterns.upperCase).andNot(CommonPatterns.capitalizedMiddle).withDependent("case", NodePattern.N.form("of").markAs("Of").includeIntoReport()).withHead("nmod|obl.*", NodePattern.N.form("several|few|many|most|some|all").directlyBefore("Of").includeIntoReport().noDependents("det", NodePattern.N.form("the"))).noDependents("cc:preconj").noDependents("amod", NodePattern.N.form("such")).noDependents("compound", NodePattern.N.noPos()).noPos("CD").andNot(allowWithoutThe.withHead("nmod|obl.*", NodePattern.N.form("all|most").noHeadRelation("obl:tmod").andNot(EnglishTreePatterns.oblWithoutCase))).andOr(NodePattern.N.form("sudden").and(Articles.forceA()), Articles.forceThe().correct(NodeCorrector.replace(NodePointer.marked("Of"), "")));
    }

    private static NodePattern insideOutside() {
        NodePattern ofPlaceTime = NodePattern.or(NodePattern.N.label("ORGANIZATION|GEO_POLITICAL_ENTITY"), Semantics.geographicalRegions, NodePattern.N.lemma("area|zone|space|project|directory|team|company|class(room)?|school|academ(y|ia)|prison|office|marriage|context|setting|panel|that|network"), NodePattern.N.form("hours"));
        NodePattern outsideOfTheBox = NodePattern.N.inFormSequence(0, "outside", "of", "the", "box").withHeadRelation("advmod");
        return NodePattern.N.lemma("(in|out)side").noHeadRelation("ccomp").andOr(CommonPatterns.possiblyConj(NodePattern.N.withDependent("obl|nmod", NodePattern.N.withDependent("case", NodePattern.N.form("of")).andNot(ofPlaceTime.trace("unlikely to be a noun")).noForm("it").andNot(EnglishTreePatterns.demonstratives).trace("the outside of X"))).noDependents("cop|aux|aux:pass"), QuantifierNounCompatibility.definitelySg.withDependent("amod").trace("shiny outside"), NodePattern.N.withPrevSibling(NodePattern.N.form("on")).noDependents().trace("on the outside"), NodePattern.N.form("insides").noHeadRelation("advmod|<unk>").andNot(CommonPatterns.possiblyConj(NodePattern.N.withDependent("case", NodePattern.N.form("with")).withDependent("amod")).trace("with soft insides")).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withDependent("case", NodePattern.N.form("with")).withDependent("amod")).trace("foods with hard outsides but soft insides"))).andNot(outsideOfTheBox).and(Articles.forceThe()).andNot(NodePattern.N.withHead("conj", NodePattern.or(NodePattern.not(noDeterminerDependent), NodePattern.N.noPos("NN.*"))));
    }

    private static NodePattern missingGeneralCase() {
        NodePattern onlyThe = NodePattern.or(suggestOnlyThe, NodePattern.N.withDependent("amod", NodePattern.or(NodePattern.N.label("NATIONALITY_OR_GROUP"), NodePattern.N.form("same"))));
        NodePattern agreesWithSingularVerb = NodePattern.N.withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.custom(n -> Number.verbNumber(EnglishTreePatterns.findFiniteVerb(n)) == Number.singular));
        NodePattern professionalPosition = NodePattern.N.pos("NN").lemma("artist|doctor|musician|reader|hitchhiker|(di)?rector|president|driver|producer|extremist|refugee|farmer|postman|soldier|student|teacher|admin(istrator)?|professor|developer|engineer|programmer|linguist|investor|pala?eontologist|politician|electrician|consultant|writer|painter|blogger|essayist|novelist|portraitist|landscapist|scholar|golfer|worker|researcher|careerist|governor|warden|principal|harbormaster|conductor|officer|captain|foreman|superintendent|senior|official|philosopher|logician|scientist|architect|dean|mayor|specialist|analyst|notary|registrar|chair(wo)?man|clerk|minister|advisor|lecturer|representative|librarian|commandor|CEO|manager|deputy|executive|agent|ambassador|nurse|midwife|secretary|master|bachelor|associate|member|head|leader|chief|speaker").withHead("nmod", NodePattern.N.lemma("position|post|duty")).withDependent("case", NodePattern.N.form("of")).trace("the post of Mayor");
        return NodePattern.or(Articles.requiresArticle.formPattern, Semantics.requiresArticleInContext).and(QuantifierNounCompatibility.definitelySg).andNot(allowMissingArticle).andNot(NodePattern.N.potentialPos("VB").withDependent("aux")).andNot(CommonPatterns.severalDependents("case").withDependent("case", NodePattern.N.noPos())).andNot(lot.directlyAfter(NodePattern.N.pos("JJ"))).andNot(NodePattern.N.form("center|centre").withDependent("compound", NodePattern.N.label("GEO_POLITICAL_ENTITY"))).andNot(professionalPosition).andOr(Articles.soAdjNoun(), NodePattern.N.andOptionally(NodePattern.N.withHeadRelation("acl:relcl").and(Articles.forcePastParticiple())).andOr(onlyThe, Articles.forceA()).andOr(Semantics.anyGroup.and(EnglishTreePatterns.isSubjectOfExpl.withHead(NodePattern.N.form("are"))), lot, Articles.forceThe()).andOr(singularCopulaHead, onlyThe, lot.directlyBefore(NodePattern.N.form("of")).correct(NodeCorrector.replace("lots")), agreesWithSingularVerb, Semantics.possiblyNumberDelegatingGroup.and(Number.withOfNmod), toPlural));
    }

    private static NodePattern soAdjNoun() {
        return NodePattern.N.withDependent("amod", NodePattern.N.beforeHead().directlyAfter(NodePattern.N.form("so").markAs("So")).withPhraseEnd(NodePattern.N.markAs("AdjEnd"))).and((noun, match) -> {
            NodeCorrector toPlural;
            String suchArticle;
            Node so = match.getMarkedNode("So");
            if (!so.hierarchy().has((Object)noun)) {
                return null;
            }
            Node adjEnd = match.getMarkedNode("AdjEnd");
            String adjEndArticle = Articles.getIndefiniteArticle(adjEnd.nextNode());
            if (adjEndArticle != null) {
                match = match.withCorrector(NodeCorrector.insertAfter(adjEnd, " " + adjEndArticle)).withReportedNode(adjEnd.neighbor(1));
            }
            if ((suchArticle = Articles.getIndefiniteArticle(so.nextNode())) != null) {
                match = match.withCorrector(NodeCorrector.replace(so, "such " + suchArticle)).withReportedNode(so);
            }
            if ((toPlural = Articles.changeNumber(noun, Number.plural)) != null) {
                match = match.withCorrector(NodeCorrector.replace(so, "such").join(toPlural)).withReportedNodes(so, noun);
            }
            return match;
        });
    }

    @Nullable
    private static NodeCorrector changeNumber(Node node, Number to) {
        return StreamEx.of((Collection)((Collection)new AgreementSet(node, to).changeNumber().getLeft())).reduce(NodeCorrector::or).orElse(null);
    }

    private static NodePattern missing() {
        NodePattern sameNoun = NodePattern.N.form("same").withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").and(Articles.forceThe());
        NodePattern theBeforeMain = NodePattern.N.pos("NN").withDependent("amod", NodePattern.N.form("main").noPos("NNP").noDependents(".*").markAs("Main")).noForm("memory").andNot(allowMissingArticle).noDependents("amod|compound", NodePattern.N.before("Main")).and(Articles.forceThe());
        NodePattern inTheMain = NodePattern.N.form("main").withDependent("case", NodePattern.N.form("in")).andNot(CommonPatterns.insideQuotes).and(Articles.forceThe());
        NodePattern comeToRescue = NodePattern.N.inFormSequence(2, "comes?|coming|came", "to", "rescue").noDependents("obj").and(Articles.forceThe());
        NodePattern uncountable = NodePattern.or(Semantics.possiblyUncountableLemma.andNot(Semantics.definitelyCountable), possiblyUncountableDeverbalNouns);
        NodePattern theAdjNoun = NodePattern.or(NodePattern.or(NodePattern.N.withDependent("amod", NodePattern.N.form("below|above").beforeHead().markAs("Adj").andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.inFormSequence(0, "above", "average"))).andNot(NodePattern.N.withHead(NodePattern.N.lemma("year"))), NodePattern.N.withDependent("amod", NodePattern.N.form("following|aforementioned|aforesaid|foregoing|forenamed").beforeHead().markAs("Adj").andNot(CommonPatterns.capitalizedMiddle)), NodePattern.N.withDependent("amod", NodePattern.N.form("last|next").markAs("Adj")).andNot(possibleTimeIndication).withDependent("cop"), NodePattern.N.withDependent("amod", NodePattern.N.form("appropriate").markAs("Adj")).noPos("NNS|VBG").andNot(uncountable), NodePattern.N.withDependent("amod", NodePattern.N.form("necessary").markAs("Adj")).withHeadRelation("nsubj(:pass)?|obj").noDependents("compound").andNot(uncountable)).message("'$Adj' usually goes with an article"), NodePattern.N.withDependent("amod", NodePattern.N.inFormSequence(2, "above", "-", "mentioned|named").markAs("Adj")).message("'above-$Adj' usually goes with an article")).noLemma("one").andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE)).andNot(NodePattern.N.withDependent("amod", CommonPatterns.firstWord.pos("NNP"))).andNot(NodePattern.N.pos("NNS").withDependent("amod", NodePattern.N.form("following")).withNextSibling(NodePattern.N.pos("VBZ"))).andOptionally(NodePattern.N.pos("NN").withDependent("cop", NodePattern.N.lemma("be")).noDependents("amod", NodePattern.N.form("last|next")).and(Articles.forceA())).and(Articles.forceThe()).trace("the adj noun");
        NodePattern theNounAdvmod = NodePattern.N.onlyPos("NNS?").noPotentialPos("RB").withDependent("advmod", NodePattern.N.form("below|above").afterHead().andNot(CommonPatterns.capitalized).andNot(CommonPatterns.lastToken).andNot(CommonPatterns.beforeSkipping(CommonPatterns.HYPHEN_NODE.noSpaceAfter(), CommonPatterns.withNumberLikeForm))).andNot(Number.withPossibleCcTypo).andNot(possiblyNounWithNumber.trace("Figures 5a and 5b")).andNot(SubjectVerbAgreement.hasClauseCompoundAmbiguity).noHeadRelation("conj").andNot(CommonPatterns.skipUp("obj", EnglishTreePatterns.imperativeVB)).and(Articles.forceThe());
        NodePattern withoutANoun = NodePattern.or(NodePattern.N.withDependent("case", CommonPatterns.possiblySkipDown("conj", NodePattern.N.form("without"))), NodePattern.N.directlyAfter(NodePattern.N.form("without").withHeadRelation("mark")).withHeadRelation("nsubj")).andNot(allowMissingArticleAfterWithout).andNot(NodePattern.N.withHead(Semantics.generalTruth).andNot(Articles.requiresArticle.formPattern)).and(Articles.forceA()).andOptionally(NodePattern.or(NodePattern.N.noForm("lot").withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("of|for"))), NodePattern.N.directlyBefore(NodePattern.N.form("for").andOr(NodePattern.N.withHeadRelation("case"), prepositionsInNounCoordination))).and(Articles.forceThe()));
        NodePattern negatedPossession = NodePattern.N.withHead("obj", NodePattern.or(EnglishTreePatterns.negated.form("have"), NodePattern.N.inFormSequence(1, "never", "had|miss(es)?"))).andNot(CommonPatterns.capitalizedMiddle).noForm("class|any.*").andNot(mealNames).andNot(possiblyUncountableDeverbalNouns).noDependents("amod", NodePattern.N.form("enough")).andOptionally(NodePattern.N.withDependent("amod", NodePattern.N.form("necessary")).and(Articles.forceThe())).and(Articles.forceA());
        String suggestIndefiniteObject = "give|provide|see|get|have";
        NodePattern aChanceTo = NodePattern.N.form("chance").withDependent("acl", EnglishTreePatterns.withToMark).withHead(NodePattern.N.noDependents("advmod", EnglishTreePatterns.negation)).and(Articles.forceA()).andOptionally(NodePattern.not(NodePattern.N.withHead("obj", NodePattern.N.lemma(suggestIndefiniteObject))).and(Articles.forceThe()));
        NodePattern withAmodMisparsedAsObjHead = NodePattern.N.markAs("Obj").withHead("obj", CommonPatterns.firstWord.pos("VBN").withOnlyDependents(NodePattern.N.alreadyMarkedAs("Obj")));
        NodePattern theAbstractNounTo = NodePattern.N.form("ability|right|opportunity|power|time|capacity|courage|need").and(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("i?obj|obl|nmod").noDependents("det|nmod:poss"))).andOr(NodePattern.N.withDependent("acl", EnglishTreePatterns.withToMark), NodePattern.N.withNextSibling(EnglishTreePatterns.withToMark.withHeadRelation("advcl"))).noDependents("case", NodePattern.N.form("of")).andNot(NodePattern.N.directlyAfter(NodePattern.N.lemma("not"))).andNot(withAmodMisparsedAsObjHead).andOptionally(NodePattern.N.withHead("obj", NodePattern.N.lemma(suggestIndefiniteObject + "|miss").andNot(EnglishTreePatterns.negated)).and(Articles.forceA())).and(Articles.forceThe());
        NodePattern theDeverbalNounOf = NodePattern.or(NodePattern.N.form("participation|provision").noDependents("case", NodePattern.N.form("of|by")), NodePattern.N.form("limitation").andOr(NodePattern.N.withDependent("nmod", singularCountableNoun).and(Articles.forceA()), EnglishTreePatterns.compound)).noHeadRelation("conj").andNot(CommonPatterns.firstPhrase.withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?")).withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("of"))).andOptionally(CommonPatterns.skipUp("compound", NodePattern.N.withHead("nsubj|obj", NodePattern.or(NodePattern.N.lemma("have"), EnglishTreePatterns.withModal, NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.lemma("be"))))).and(Articles.forceA())).and(Articles.forceThe());
        NodePattern theAdjectiveAsGroupNoun = Semantics.adjectivesPossiblyDenotingGroups.andOr(NodePattern.N.form("poor").withHead("conj", NodePattern.N.markAs("Head")), NodePattern.N.markAs("Head")).and(NodePattern.markedNodeMatches("Head", NodePattern.N.pos("NN").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod").noPos("NNP")).noDependents("case", NodePattern.N.form("as")).noDependents("det|nmod:poss|amod", NodePattern.N.beforeHead()).noDependents("conj", NodePattern.N.noPos("JJ"))).noDependents(NodePattern.N.afterHead().noPos().and(CommonPatterns.letterWord)).noLabel(".*").andNot(CommonPatterns.lastToken).andNot(CommonPatterns.capitalizedMiddle).and(Articles.forceThe());
        NodePattern theMeansTo = NodePattern.N.form("means").withHead("obj", NodePattern.N.pos("VB.*")).withDependent("acl", EnglishTreePatterns.withToMark).noDependents("amod").and(Articles.forceThe());
        NodePattern suchANoun = NodePattern.N.pos("NN").noHeadRelation("nmod:poss").noForm("text").and(CommonPatterns.possiblySkipDown("amod", NodePattern.N.withDependent("amod|advmod|det", NodePattern.N.form("such").noDependents("conj")))).markAs("SuchNoun").andOr(NodePattern.N.directlyBefore(NodePattern.N.form("as").withHead("case", NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound"))), Articles.forceA()).andOr(singularCopulaHead, toPlural).andNot(NodePattern.N.withDependent("case", NodePattern.N.form("in")).form("detail|shape")).andNot(NodePattern.N.withHead(NodePattern.N.withPrevSibling(NodePattern.or(NodePattern.N.sameWordAs("SuchNoun"), NodePattern.N.withPhraseEnd(NodePattern.N.sameWordAs("SuchNoun")))))).andNot(NodePattern.N.inFormSequence(2, "of", "such", "period")).andNot(NodePattern.N.withDependent("case", NodePattern.N.form("of")).withHead("nmod", NodePattern.N.withDependent("nummod"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.inFormSequence(0, "as", "to|that").withHead("mark", EnglishTreePatterns.verbalClause))).andNot(possiblyUncountableDeverbalNouns);
        NodePattern bodyParts = NodePattern.N.lemma("face|arm|leg|hand|head|eye|ear|nose|mouth|lips|teeth|tongue|neck|chest|belly|hip|shoulder|elbow|wrist|finger|thumb|back|spine|heart|stomach|throat|forehead|chin|cheek|jaw").andNot(CommonPatterns.capitalizedMiddle).noDependents("case", NodePattern.N.form("as")).andOr(NodePattern.N.afterHead().markAs("BodyPart").withDependent("case", NodePattern.N.pos("IN").form("in|for").markAs("Case")).andOr(NodePattern.N.withHead("obl", NodePattern.N.pos("VB.*").withDependent("obj|aux:pass")), NodePattern.N.withHead("nmod", NodePattern.N.pos("NNS?").withHeadRelation("obj").andNot(NodePattern.N.sameWordAs("BodyPart"))).withOnlyDependents(NodePattern.N.alreadyMarkedAs("Case"))), NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl(:npmod|:tmod)?").withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("of")).andNot(Semantics.Animacy.inanimate.pattern)), NodePattern.N.inFormSequence(2, "with|by|to", "naked", "eye")).trace("body parts").and(Articles.forceThe());
        String decadePattern = "([12]\\d)?\\d0";
        NodePattern decades = NodePattern.or(NodePattern.N.formCaseSensitive("(mid-)?" + decadePattern + "s"), NodePattern.N.form(decadePattern).noSpaceAfter().directlyBefore(EnglishTreePatterns.apostropheS), NodePattern.N.lemma("twenty|thirty|fourty|fifty|sixty|seventy|eighty|ninety").pos("NNS")).andOr(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl(:npmod|:tmod)?|nmod")), NodePattern.N.withHead("compound", EnglishTreePatterns.apostropheS), NodePattern.ROOT).noDependents("cop|aux|aux:pass", NodePattern.N.directlyBeforeHead()).noLabel(".*").andNot(NodePattern.N.withHead("obj", NodePattern.N.lemma("earn|gain"))).andNot(NodePattern.N.withDependent("case", NodePattern.N.form("to")).withHead(NodePattern.N.lemma("increase|decrease|fluctuate|double|decline|dwindle|shrink|diminish|raise|lower|reduce"))).noDependents("case", CommonPatterns.HYPHEN_LIKE_NODE.trace("1950s - 1960s")).andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen)).andNot(CommonPatterns.possiblyConj(NodePattern.N.withDependent("det|nmod:poss"))).and(Articles.forceThe());
        return NodePattern.or(nounWithoutDeterminer.andOr(theBeforeMain.includeIntoReport().message("'The' seems to be missing before 'main'"), Articles.insideOutside().includeIntoReport().message("'The' seems to be missing before the '$_'"), theAdjNoun, Articles.usePossessiveDeterminer(), theDeverbalNounOf.includeIntoReport().message("An article seems to be missing before '$_ of'"), singularCountableNoun.includeIntoReport().andOr(suchANoun.message("An article seems to be missing after 'such'"), Articles.xIsNoun().message(MISSING_ARTICLE), sameNoun.message("'The' seems to be missing before 'same'"), inTheMain.message("'The' seems to be missing before 'main'"), aChanceTo.message("An article seems to be missing before 'chance to'"), theAbstractNounTo.message("An article seems to be missing before '$_ to'"), withoutANoun.message("'Without' typically requires an article"), negatedPossession.message("Negative constructions typically go with an article"), Articles.missingGeneralCase().message("'$_' usually goes with an article")), bodyParts.message(MISSING_ARTICLE), theNounAdvmod.message("'The' seems to be missing before the noun"), theMeansTo.message("'The' seems to be missing before 'means'"), Articles.ofAllKinds().message("Use 'of all $_' to describe a diverse group"), Articles.partitiveOf().withHead(NodePattern.N.message("'The' seems to be missing after '$_ of'"))), decades.message("Use 'the' with decades"), comeToRescue.message("'The' seems to be missing before 'rescue'"), theAdjectiveAsGroupNoun.message("'The' seems to be missing before '$_'"));
    }

    private static NodePattern dangling() {
        NodePattern aListItem = NodePattern.N.form("a").and(node -> {
            Node next = node.nextNode();
            Node prev = node.prevNode();
            if (next == null) {
                return true;
            }
            if (prev == null && next.hasForm("\\.")) {
                return true;
            }
            if (next.hasForm("\\)")) {
                return next.nextNode() != null;
            }
            return false;
        });
        NodePattern possibleEllipsis = NodePattern.or(NodePattern.N.withHeadRelation("conj|appos"), NodePattern.N.withHeadRelation("obl|nmod|amod").andOr(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("obl|amod|cc")), NodePattern.N.directlyBeforeHead().withHead(NodePattern.N.withDependent("cop"))), NodePattern.N.markAs("Adj").beforeHead().withHead("amod|nmod", NodePattern.N.withDependent("det", NodePattern.N.withNextSibling(NodePattern.N.pos("JJ.*").before("Adj")))), CommonPatterns.skipUp("nmod", NodePattern.N.withHead("obl|appos", NodePattern.N.withHeadRelation("obl|amod"))));
        NodePattern operator = NodePattern.not(CommonPatterns.lastWord).form("[?!]");
        NodePattern theComparative = NodePattern.N.form("the").directlyBefore(NodePattern.N.potentialPos("JJR"));
        NodePattern misparsedTheComparative = theComparative.and(n -> n.back().anyMatch(theComparative::matches));
        NodePattern symbolNPHead = NodePattern.PUNCT.noForm("[.!?]").andNot(PunctuationRules.commaLike).spaceBefore();
        NodePattern singleLetter = NodePattern.N.form("\\p{L}");
        NodePattern inSeparateLetterWord = NodePattern.custom(n -> ((StreamEx)n.forward().takeWhile(singleLetter::matches)).count() + ((StreamEx)((StreamEx)n.back().skip(1L)).takeWhile(singleLetter::matches)).count() > 3L).trace("P A O L A");
        NodePattern oversplitCode = NodePattern.N.directlyBefore(NodePattern.N.form(":")).directlyAfter(NodePattern.N.form(":")).trace("oversplit code");
        return NodePattern.N.form("an?|the").andOr(Articles.theTheyThere(), NodePattern.N.noHeadRelation("det|amod|root|cc|aux|fixed|appos").andNot(NodePattern.N.withHead(NodePattern.N.pos("NN.?")).directlyBeforeHead()).andNot(NodePattern.N.withHead(oversplitCode)).andOptionally(NodePattern.N.withHeadRelation("goeswith|case").correct(NodeCorrector.replace(""))), NodePattern.N.withHead("det", Adjectives.anAdjectivePattern.andNot(possibleEllipsis).andNot(CommonPatterns.lastToken).andOptionally(NodePattern.N.withDependent("cop").noDependents("amod|nmod").noDependents("obl", NodePattern.N.afterHead().withDependent("case", NodePattern.N.form("of"))).correct(NodeCorrector.replace(NodePointer.marked("An"), "")))), NodePattern.N.withHead("det", NodePattern.N.pos("IN").noForm("via").noPotentialPos("RB|NN.?").noPos("JJS").noDependents(EnglishTreePatterns.compound.directlyBeforeHead()).andNot(CommonPatterns.capitalized).andNot(NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen))).trace("det + IN"), NodePattern.N.form("an?").beforeHead().withHeadRelation("det").andOr(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("case")).withNextSibling(NodePattern.N.beforeHead().withHeadRelation("nummod")), NodePattern.N.withHead(NodePattern.N.pos("JJR")).directlyBefore(NodePattern.N.withHeadRelation("advmod"))).correct(NodeCorrector.replace("")), NodePattern.N.withHeadRelation("det").directlyBefore(NodePattern.N.form("[,.;!?]").markAs("Punct").andNot(operator)).andOptionally(NodePattern.N.beforeHead().withHead("det", NodePattern.N.pos("NN.*|JJ.*").andNot(EnglishTreePatterns.unlikelyToBeNoun)).correct(NodeCorrector.replace(NodePointer.marked("Punct"), ""))).andOptionally(NodePattern.N.directlyAfter(NodePattern.N.form("and")).and(NodePattern.markedNodeMatches("Punct", NodePattern.N.form("[.,]").directlyBefore(CommonPatterns.letterWord))).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("Punct"), "then")))).andNot(emphaticRepetition).message(DANGLING_MSG).trace("dangling").and(CommonPatterns.highlightWithTrailingSpace()).andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyBefore(CommonPatterns.capitalizedMiddle).withHead(CommonPatterns.capitalizedMiddle.pos("NN.*"))).andNot(aListItem).andNot(variableA).andOr(NodePattern.N.noPos("SYM"), NodePattern.N.withHead("det", NodePattern.N.markAs("Head")).directlyBefore(CommonPatterns.comma).withNeighbor(2, NodePattern.not(EnglishTreePatterns.quotations))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("/"))).andNot(NodePattern.N.directlyBefore(CommonPatterns.beforeSlash)).noHeadRelation("conj|flat|mark|nummod|list").noDependents("conj|compound|nmod|fixed|list").andNot(misparsedTheComparative).andNot(inSeparateLetterWord).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("following").and(n -> n.forward().anyMatch(nn -> nn.hasForm("[:?]"))))).andNot(CommonPatterns.lastWord.withHead("dep|det|list|nmod|appos", CommonPatterns.skipUp("appos", NodePattern.ROOT.pos("NN.*")))).andNot(NodePattern.N.form("the").directlyBeforeHead().withHead("nsubj", NodePattern.N.noPos())).andNot(NodePattern.N.directlyBefore(NodePattern.or(EnglishTreePatterns.quotations, symbolNPHead, NodePattern.N.pos("JJ").directlyBefore(NodePattern.N.pos("ORD"))))).andNot(NodePattern.N.inFormSequence(0, "a", "\\.").noSpaceAfter().withNeighbor(2, CommonPatterns.capitalized.noSpaceBefore()).trace("abbreviation-like")).andNot(NodePattern.N.formCaseSensitive("A").directlyBefore(CommonPatterns.colon)).andNot(NodePattern.N.withHead("det", NodePattern.or(Adjectives.adjsMissingNounPosTag, NodePattern.N.pos("JJ.*").directlyBefore(NodePattern.N.form(".*\\p{L}.*").noPos())))).andNot(NodePattern.N.before(NodePattern.N.withHeadRelation("flat")));
    }

    private static NodePattern theTheyThere() {
        NodePattern pluralCop = NodePattern.N.form("are|were");
        NodePattern there = NodePattern.N.withHead(NodePattern.or(NodePattern.or(NodePattern.N.pos("NN.*"), NodePattern.N.noPos().potentialPos("NN.*")).withDependent("cop", pluralCop).noDependents("det", NodePattern.N.form("the")), pluralCop)).correct(NodeCorrector.replace("there"));
        return NodePattern.N.form("the").withHead("nsubj|expl", NodePattern.custom(n -> Number.verbNumber(EnglishTreePatterns.findFiniteVerb(n)) != Number.singular).noForm("need")).andOptionally(there).andOr(TreeMigration.revise("specific to tree-en", NodePattern.N.withHead(NodePattern.N.withHeadRelation("xcomp")).correct(NodeCorrector.replace("them"))), NodePattern.N.correct(NodeCorrector.replace("they")));
    }

    private static NodePattern anTypo() {
        NodePattern possiblyVerb = NodePattern.N.potentialPos("VB[DPZ]?").andNot(EnglishTreePatterns.unlikelyToBeVerb).noHeadRelation("cop|aux|aux:pass");
        NodePattern pastClause = NodePattern.or(NodePattern.N.potentialPos("VBD"), NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.pos("VBD")));
        NodePattern clauseBeforeAn = NodePattern.or(possiblyVerb, EnglishTreePatterns.clause.noPos("W.*")).andOr(NodePattern.markedNodeMatches("Verb2", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")), NodePattern.N.pos("VBG").and(NodePattern.markedNodeMatches("Verb2", NodePattern.N.pos("VBG"))), NodePattern.markedNodeMatches("An", NodePattern.N.directlyBeforeHead().withHead(NodePattern.N.withHeadRelation("xcomp"))), NodePattern.not(NodePattern.markedNodeMatches("Verb2", NodePattern.N.withHeadRelation("xcomp"))).andNot(pastClause.and(NodePattern.markedNodeMatches("Verb2", NodePattern.not(pastClause)))).andNot(NodePattern.not(pastClause).and(NodePattern.markedNodeMatches("Verb2", pastClause))));
        NodePattern canVerb = NodePattern.N.pos("VB").includeIntoReport().and(NodePattern.markedNodeMatches("Prev", NodePattern.N.form(".+c").markAs("C").includeIntoReport())).and((node, match) -> {
            Node c = match.getMarkedNode("C");
            String withoutC = c.form().substring(0, c.form().length() - 1);
            if (node.tree().treeSupport().tagToken(withoutC).hasPos(".*")) {
                return match.withCorrector(NodeCorrector.replaceNodes(c, c.neighbor(1), withoutC + " can"));
            }
            return null;
        }).message("The verb '$_' doesn\u2019t seem to fit after 'an'");
        NodePattern aOrAnd = possiblyVerb.markAs("Verb2").and(node -> "a".equals(Articles.getIndefiniteArticle(node.form()))).noDependents(NodePattern.N.before("An")).andNot(subjectWithExpletive).withNeighbor(-2, NodePattern.custom((prev, m) -> ((StreamEx)prev.hierarchy().takeWhile(n -> !n.isAfter(prev))).map(n -> clauseBeforeAn.match((Node)n, m)).findFirst(Objects::nonNull).orElse(null))).includeIntoReport().andOr(NodePattern.N.pos("NN").noPos("NNS").noDependents("ccomp|xcomp|advcl").andNot(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("xcomp"))).andNot(NodePattern.N.withHead("compound", NodePattern.N.pos("NNS"))).correct(NodeCorrector.replace(NodePointer.marked("An"), "a")).message(Articles.aVsAnMessage("a")), NodePattern.N.message("Did you mean 'and'?")).trace("aOrAnd").correct(NodeCorrector.replace(NodePointer.marked("An"), "and")).and((node, match) -> match.concedingToOtherGrammarCheckers());
        NodePattern clauseAfterAn = NodePattern.N.noHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").markAs("Verb2").withHead(clauseBeforeAn.before("An"));
        NodePattern nounLike = NodePattern.N.pos("NN.*|PDT|PRP");
        NodePattern couldBeSubjectlessClause = NodePattern.ROOT.and(CommonPatterns.firstWord).potentialPos("VB.*");
        NodePattern npDirectlyBeforeAn = nounLike.alreadyMarkedAs("Prev").andNot(couldBeSubjectlessClause);
        NodePattern andConj = NodePattern.or(NodePattern.N.beforeHead().withHead("advmod", clauseAfterAn), NodePattern.N.pos("NN.*|CD|PRP.*").andOr(CommonPatterns.skipUp("nmod:poss|nummod", NodePattern.N.withHead("conj|appos", npDirectlyBeforeAn.andOr(NodePattern.N.withHeadRelation("i?obj|obl|nmod"), NodePattern.ROOT.withDependent("cop")))), NodePattern.markedNodeMatches("Prev", NodePattern.N.form("this").withHead("nsubj.*", NodePattern.N.noDependents("cop", NodePattern.N.before("Prev"))))), NodePattern.N.pos("VB[ZPD]").withHeadRelation("conj|xcomp").and(NodePattern.custom(n -> CommonPatterns.haveSamePos(n, Objects.requireNonNull(n.head())))), NodePattern.N.pos("IN").andOr(NodePattern.N.noDependents().withHead("case", NodePattern.N.noHeadRelation("compound").noDependents("cop|aux|aux:pass", NodePattern.not(NodePattern.N.alreadyMarkedAs("An"))).and(NodePattern.markedNodeMatches("Prev", NodePattern.N.noPos("IN")))).andNot(NodePattern.markedNodeMatches("An", NodePattern.or(NodePattern.N.withDependent("punct|cc"), NodePattern.N.withHeadRelation("det").afterHead()))), NodePattern.N.withHeadRelation("obl|conj").and(NodePattern.markedNodeMatches("Prev", NodePattern.N.potentialPos("IN|RB"))), NodePattern.N.withHeadRelation("advmod").directlyBefore(NodePattern.or(CommonPatterns.withNumberLikeForm, NodePattern.N.pos("CD")))), CommonPatterns.skipUp("det", NodePattern.or(nounLike.withHead("nmod|conj|appos", npDirectlyBeforeAn), NodePattern.N.beforeHead().withHead("nsubj.*", clauseAfterAn.withHeadRelation("parataxis|conj").withPhraseStart(NodePattern.N.alreadyMarkedAs("An").directlyAfter(NodePattern.not(NodePattern.PUNCT)))))), only.withHead(NodePattern.N.sameWordAs("Prev")), NodePattern.N.form("even").withHead("advmod", NodePattern.or(NodePattern.N.withHeadRelation("conj"), CommonPatterns.skipUp("amod", NodePattern.or(NodePattern.N.withDependent("amod", NodePattern.N.alreadyMarkedAs("Prev")), NodePattern.N.withHead(npDirectlyBeforeAn.withDependent("amod")))))), NodePattern.markedNodeMatches("An", mistypedAndInPhraseWithThe), NodePattern.N.inFormSequence(2, "once", "an", "for", "all"), NodePattern.N.inFormSequence(2, "on", "an", "off").withHeadRelation("case")).and(NodePattern.markedNodeMatches("An", EnglishTreePatterns.typoReplacement("and"))).and((node, match) -> match.concedingToOtherGrammarCheckers()).trace("andConj");
        return NodePattern.N.form("an").includeIntoReport().markAs("An").directlyAfter(NodePattern.N.markAs("Prev")).directlyBefore(NodePattern.not(CommonPatterns.capitalizedMiddle).andOr(aOrAnd, canVerb, andConj));
    }

    private static NodePattern aToAnd() {
        return NodePattern.N.form("an?").andNot(NodePattern.N.directlyBefore(NodePattern.N.noPos())).withHeadRelation("cc").correct(NodeCorrector.replace("and")).andOptionally(NodePattern.N.form("a").and(CommonPatterns.highlightWithTrailingSpace())).message("Did you mean 'and'?").trace("aToAnd").and((node, match) -> match.concedingToOtherGrammarCheckers());
    }

    private static NodePattern andToAn() {
        return NodePattern.N.form("and").markAs("And").directlyBefore(NodePattern.N.form("[" + vowels + "].+")).withHead("cc|det", NodePattern.N.potentialPos("NN").andOr(NodePattern.N.withHead("nsubj|conj", CommonPatterns.possiblySkipDown("cop", NodePattern.N.directlyBefore("And")).withDependent("expl", EnglishTreePatterns.tHere)), NodePattern.ROOT.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?").withDependent("cop", NodePattern.N.directlyBefore("And")), NodePattern.N.withHead("obj", NodePattern.N.pos("VB.*").directlyBefore("And")).andNot(NodePattern.custom(node -> node.tagIndependently().posReadings().contains(Objects.requireNonNull(node.head()).posReadings().get(0)))))).and(EnglishTreePatterns.typoReplacement("an"));
    }

    private static NodePattern twoDeterminers() {
        NodePattern beforePreposition = NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("case"));
        NodePattern stopChild = NodePattern.or(NodePattern.N.withHeadRelation("amod"), EnglishTreePatterns.quotations, CommonPatterns.openingParen, NodePattern.N.withDependent("punct", EnglishTreePatterns.quotations), CommonPatterns.capitalizedMiddle, theALetter, NodePattern.N.noSpaceBefore().directlyAfter(CommonPatterns.HYPHEN_NODE));
        NodePattern possessivePronoun = NodePattern.N.withHeadRelation("nmod.*").pos("PRP\\$").noLabel(".*");
        return NodePattern.N.form("an?|the").andOr(NodePattern.N.withHead("det.*|case|goeswith|cc.*", NodePattern.N.markAs("Head")), NodePattern.N.withHead("dep", NodePattern.or(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").markAs("Head"), NodePattern.N.onlyPos("NN").markAs("Head"), NodePattern.N.withHead("advmod", NodePattern.ROOT.pos("NN.*").markAs("Head"))))).and(CommonPatterns.highlightWithTrailingSpace()).andNot(NodePattern.N.form("the").withHead(NodePattern.N.withDependent("det", mistypedAndInPhraseWithThe))).andNot(emphaticRepetition).andNot(variableA).andNot(NodePattern.N.directlyBefore(letterA)).and((article, match) -> {
            Node dependent;
            Node head = match.getMarkedNode("Head");
            if (possessivePronoun.matches(article.prevNode())) {
                return Articles.correctTwoDeterminers(match, article, article.prevNode()).withMessage(WITH_POSSESSIVE_MSG);
            }
            Iterator<Node> iterator = head.allDependents().iterator();
            while (!(!iterator.hasNext() || (dependent = iterator.next()).isAfter(head) || dependent.isAfter(article) && stopChild.matches(dependent))) {
                if ((dependent.prevNode() == article || dependent.nextNode() == article) && possessivePronoun.matches(dependent)) {
                    return Articles.correctTwoDeterminers(match, article, dependent).withMessage(WITH_POSSESSIVE_MSG);
                }
                if (!dependent.hasHeadRelation("det|dep|compound") || dependent.hasDependent("punct")) continue;
                if (dependent.hasForm("this") || dependent.isAfter(article) && dependent.hasForm("another")) {
                    return Articles.correctTwoDeterminers(match, article, dependent).withMessage("Articles can\u2019t be combined with other determiners like '" + dependent.lowForm() + "'");
                }
                if (!dependent.isAfter(article) || !dependent.hasForm("an?|the")) continue;
                if (CommonPatterns.capitalizedMiddle.matches(article.nextNode())) {
                    return null;
                }
                if (beforePreposition.matches(dependent)) {
                    return null;
                }
                return Articles.correctTwoDeterminers(match, article, dependent).withMessage("Two articles can\u2019t occur together");
            }
            return null;
        });
    }

    private static NodeMatch correctTwoDeterminers(NodeMatch match, Node article, Node dependent) {
        String fixed;
        NodeCorrector removeArticle = Articles.removeAndFixArticle(article);
        if (dependent.hasForm("an?") && (fixed = Articles.fixIndefiniteArticle(dependent)) != null) {
            removeArticle = removeArticle.join(NodeCorrector.replace(dependent, fixed));
        }
        match = match.withReportedNodes(article, dependent).withCorrector(removeArticle);
        if (!(NodePattern.N.directlyBefore(NodePattern.N.pos("RB")).matches(article) && !Objects.requireNonNull(article.head()).hasDependent("amod") || Articles.isDeterminerRepetition(article, dependent))) {
            match = match.withCorrector(Articles.removeAndFixArticle(dependent));
            if (dependent.form().length() == 1 && dependent.nextNode() != null) {
                match = match.withReportedRange(dependent.startOffset(), dependent.nextNode().startOffset(), dependent.tree());
            }
        }
        return match;
    }

    private static boolean isDeterminerRepetition(Node det1, Node det2) {
        return det1 == det2.prevNode() && (det1.form().equals(det2.form()) || det1.hasForm("an?") && det2.hasForm("an?"));
    }

    private static NodePattern superlative() {
        NodePattern markedSuperlative = superlative.markAs("Superlative");
        return NodePattern.N.pos("NN.*").andOr(NodePattern.N.pos("NN"), NodePattern.N.withDependent("cop")).noHeadRelation("compound|amod").noDependents("det", NodePattern.N.form("the")).noDependents("nmod:poss|compound").andOr(nounWithoutDeterminer.noDependents("cop", EnglishTreePatterns.itsConfusion).noDependents("acl", NodePattern.N.directlyAfterHead()), NodePattern.N.withDependent("det", NodePattern.N.form("an?")).andNot(NodePattern.N.withHead(NodePattern.N.lemma("have|want")))).withDependent("amod", NodePattern.or(markedSuperlative, NodePattern.N.pos("JJ").andNot(NodePattern.N.potentialPos("RB")).withDependent("advmod", markedSuperlative), NodePattern.N.withDependent("conj", NodePattern.N.withDependent("advmod", markedSuperlative)), NodePattern.N.withDependent("conj").withDependent("advmod", markedSuperlative))).markAs("Noun").and(NodePattern.markedNodeMatches("Superlative", NodePattern.N.before("Noun"))).andNot(NodePattern.N.withDependent("case", NodePattern.N.form("of")).withHead("nmod", NodePattern.or(withThe, NodePattern.N.withDependent("nmod:poss"), NodePattern.N.form("lists?")))).andNot(NodePattern.not(Semantics.timeUnits).withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("of")))).andNot(NodePattern.N.withHead("xcomp", NodePattern.N.lemma("vote"))).andNot(NodePattern.N.markAs("Conj").withHead("conj|list|appos", NodePattern.or(NodePattern.N.withDependent("conj|list|appos", NodePattern.N.after("Conj")), NodePattern.N.withDependent("nmod:poss", withThe)))).andNot(NodePattern.ROOT.noDependents("cop|acl:relcl")).andNot(EnglishTreePatterns.inShortCapitalizedSentence).message(SUPERLATIVE_MSG).and(Articles.forceThe());
    }

    private static NodePattern plenty() {
        return NodePattern.N.inFormSequence(1, "a", "plenty").andOr(NodePattern.N.directlyBefore(NodePattern.N.form("of")).and(Articles.removeArticle()).message("'plenty of' goes without an article"), NodePattern.N.noDependents("nmod").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "aplenty")).message("As an adverb 'aplenty' is spelled together"));
    }

    private static NodePattern kindOfA() {
        return NodePattern.N.inFormSequence(0, "kind|sort|type", "of", "an?").reportEverythingTouched(ReportingKind.Hover).withDependent("det", NodePattern.N.form("the|a").directlyBeforeHead()).withDependent("cop", NodePattern.N.lemma("be")).correct(NodeCorrector.replace(NodePointer.neighbor(2), "")).message("If '$_ of' refers to a category, the following noun does not require an article");
    }

    static NodePattern forceThe() {
        return Articles.forceArticle("the");
    }

    private static NodePattern forcePossessive(@NotNull NodePointer anchor) {
        NodePattern female = NodePattern.or(Semantics.kindredRelationFemale, NodePattern.N.lemma("woman|girl(friend)?|dudette|lady|princess"));
        NodePattern male = NodePattern.or(Semantics.kindredRelationMale, NodePattern.N.lemma("man|boy(friend)?|dude|guy|(lord|prince)(ling)?"));
        NodePattern nonGendered = NodePattern.or(Semantics.abstractHuman, Semantics.kindredRelationNonGendered, NodePattern.N.lemma("artist|doctor|musician|reader|hitchhiker|(di)?rector|president|driver|producer|extremist|refugee|farmer|postman|soldier|student|teacher|admin(istrator)?|professor|developer|engineer|programmer|linguist|investor|pala?eontologist|politician|electrician|consultant|writer|painter|blogger|essayist|novelist|portraitist|landscapist|scholar|golfer|worker|researcher|careerist|governor|warden|principal|harbormaster|conductor|officer|captain|foreman|superintendent|senior|official|philosopher|logician|scientist|architect|dean|mayor|specialist|analyst|notary|registrar|chair(wo)?man|clerk|minister|advisor|lecturer|representative|librarian|commandor|CEO|manager|deputy|executive|agent|ambassador|nurse|midwife|secretary|master|bachelor|associate|client|customer|friend|user|colleague|teammate|groupmate|citizen|nominee|immigrant|emigrant|migrant|refugee|resident|slave|veteran|patient|employee|subordinate|chief|superior|superordinate|reportee|underboss|boss|subsidiary|managee|manager|leadee|leader"));
        return NodePattern.custom((node, match) -> {
            Node antecedent = anchor.findNode(match);
            if (antecedent.hasPos("PRP.+")) {
                String pronounLowForm = antecedent.lowForm();
                String possessive = Articles.pronounToPossessiveDeterminer(pronounLowForm);
                return Articles.forceArticle(possessive).match(node, match);
            }
            if (antecedent.hasPos("NNS") || antecedent.hasDependent("conj") || antecedent.hasForm("(every|any|no)(one|body)")) {
                return Articles.forceArticle("their").match(node, match);
            }
            if (antecedent.hasPos("NN")) {
                if (female.matches(antecedent)) {
                    return Articles.forceArticle("her").match(node, match);
                }
                if (male.matches(antecedent)) {
                    return Articles.forceArticle("his").match(node, match);
                }
                if (nonGendered.matches(antecedent)) {
                    return Articles.forceArticle("their").and(Articles.forceArticle("his")).and(Articles.forceArticle("her")).match(node, match);
                }
                return null;
            }
            return null;
        });
    }

    static String pronounToPossessiveDeterminer(String pronounLowForm) {
        return switch (pronounLowForm) {
            case "i", "me" -> "my";
            case "you" -> "your";
            case "he", "him" -> "his";
            case "she", "her" -> "her";
            case "it" -> "its";
            case "we", "us" -> "our";
            case "they", "them" -> "their";
            default -> "";
        };
    }

    private static NodePattern forcePastParticiple() {
        return NodePattern.N.directlyAfter(NodePattern.N.lemma("be")).potentialPos("VB.*").andNot(AuxMainVerbForm.nonPassive).correct(NodeCorrector.inflect("VB.*", "VBN"));
    }

    static NodePattern forceA() {
        return NodePattern.custom((node, match) -> {
            String article = Articles.getIndefiniteArticle(Articles.findArticlePos(node));
            return article == null ? null : Articles.forceArticle(article).match(node, match);
        });
    }

    static NodePattern forceArticle(String article) {
        return NodePattern.custom((node, match) -> {
            Pair<NodeCorrector, TextRange> forced = Articles.forceArticle(article, node);
            return forced == null ? null : match.withCorrector((NodeCorrector)forced.getFirst()).withReportedRange((TextRange)forced.getSecond(), node.tree());
        });
    }

    @Nullable
    static Pair<NodeCorrector, TextRange> forceArticle(String article, Node npHead) {
        Node prevNode;
        Node anchor;
        block13: {
            block12: {
                Node existingDet = StreamEx.of(npHead.findDependents("det")).findFirst(n -> !n.posReadings().isEmpty()).orElse(null);
                if (existingDet != null && !existingDet.lowForm().equals("such")) {
                    return new Pair((Object)NodeCorrector.replace(existingDet, article), (Object)CommonPatterns.withTrailingSpace(existingDet));
                }
                anchor = Articles.findArticlePos(npHead);
                if (articleExcludingQuotation.matches(anchor)) break block12;
                if (((StreamEx)anchor.nextUntil(npHead).filter(EnglishTreePatterns.quotations::matches)).count() % 2L != 1L) break block13;
            }
            return null;
        }
        if (anchor.hasForm("that")) {
            return null;
        }
        if (unknownWord.matches(anchor) || unknownWord.matches(anchor.prevNode())) {
            if (ambiguousPhraseStart.matches(anchor)) {
                return null;
            }
            if (anchor.lowForm().startsWith(article)) {
                String suffix = anchor.lowForm().substring(article.length());
                if (npHead.tree().treeSupport().tagToken(suffix).hasPos(".*")) {
                    return new Pair((Object)NodeCorrector.replace(anchor, article + " " + suffix), (Object)anchor.textRange());
                }
            }
        }
        if ((prevNode = npHead.prevNode()) != null && prevNode.hasForm("a|an|the|one")) {
            return null;
        }
        if (anchor.hasForm("and")) {
            String indefinite;
            String andReplacement = article;
            if (article.startsWith("a") && (indefinite = Articles.getIndefiniteArticle(anchor.neighbor(1).form())) != null) {
                andReplacement = indefinite;
            }
            return new Pair((Object)NodeCorrector.replace(anchor, andReplacement), (Object)CommonPatterns.withTrailingSpace(anchor));
        }
        Node reportEnd = (Node)((StreamEx)anchor.forward().dropWhile(withCompoundContinuation::matches)).findFirst().orElseThrow();
        return new Pair((Object)NodeCorrector.insertBefore(anchor, article + " "), (Object)new TextRange(anchor.startOffset(), reportEnd.endOffset()));
    }

    @NotNull
    private static Node findArticlePos(Node node) {
        if (withComparativeAdj.matches(node)) {
            return node;
        }
        Node anchor = node.phraseStart();
        for (Node dependent : node.allDependents()) {
            if (dependent.isAfter(node) || dependent.hasHeadRelation("amod")) break;
            if (dependent.hasHeadRelation("compound")) {
                Node punct;
                Node nestedCase = dependent.findSingleDependent("case");
                if (nestedCase != null && CommonPatterns.noSpaceHyphen.matches(anchor = nestedCase.phraseEnd().neighbor(1))) {
                    anchor = anchor.neighbor(-1);
                }
                if ((punct = (Node)StreamEx.of(dependent.allDependents()).findFirst(EnglishTreePatterns.aposOrQuote::matches).orElse(null)) != null) {
                    anchor = punct;
                }
            }
            if (!childBeforeArticle.matches(dependent)) continue;
            anchor = Objects.requireNonNull(dependent.phraseEnd().nextNode());
        }
        if (anchor.hasHeadRelation("case")) {
            return complexPreposition.matches(anchor) ? anchor.neighbor(2) : anchor;
        }
        if (anchor.hasForm("only|such|quite|also") && anchor.isBefore(node)) {
            anchor = anchor.neighbor(1);
        }
        return anchor;
    }

    @NotNull
    static NodeCorrector removeAndFixArticle(Node removed) {
        Node next = removed.nextNode();
        return NodeCorrector.replace(removed, "").join(next == null ? null : Articles.fixArticle(removed, next.form()));
    }

    @Nullable
    static NodeCorrector fixArticle(Node replaced, String nextWord) {
        String fixed;
        Node prev = replaced.prevNode();
        if (prev != null && prev.hasForm("an?") && prev.hasHeadRelation("det.*|case") && (fixed = Articles.getIndefiniteArticle(nextWord)) != null && !fixed.equalsIgnoreCase(prev.form())) {
            return NodeCorrector.replace(prev, fixed);
        }
        return null;
    }

    private static /* synthetic */ String lambda$static$0(String s) {
        return s.startsWith("*") ? s.substring(1) : s;
    }
}

