/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.instructions.ClassInstructions;
import com.intellij.rt.coverage.data.instructions.InstructionsUtil;
import com.intellij.rt.coverage.util.TestTrackingCallback;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectData
implements CoverageData,
Serializable {
    public static ProjectData ourProjectData;
    private List<Pattern> myIncludePatterns;
    private List<Pattern> myExcludePatterns;
    private List<Pattern> myAnnotationsToIgnore;
    private final Map<String, ClassData> myClasses = new ConcurrentHashMap<String, ClassData>(1000);
    private boolean myCollectInstructions;
    private Map<String, ClassInstructions> myInstructions;
    public final TestTrackingCallback myTestTrackingCallback;

    public ProjectData() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    public ProjectData(TestTrackingCallback testTrackingCallback) {
        void var1_1;
        this.myTestTrackingCallback = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ClassData getClassData(String name) {
        void var1_1;
        return this.myClasses.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ClassData getOrCreateClassData(String name) {
        void var2_2;
        ClassData classData = this.myClasses.get(name);
        if (classData == null) {
            void var1_1;
            classData = new ClassData(name);
            this.myClasses.put((String)var1_1, classData);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void addClassData(ClassData classData) {
        void var1_1;
        this.myClasses.put(classData.getName(), (ClassData)var1_1);
    }

    public int getClassesNumber() {
        return this.myClasses.size();
    }

    public Map<String, ClassData> getClasses() {
        return new HashMap<String, ClassData>(this.myClasses);
    }

    public Collection<ClassData> getClassesCollection() {
        return this.myClasses.values();
    }

    public List<Pattern> getIncludePatterns() {
        return this.myIncludePatterns;
    }

    /*
     * WARNING - void declaration
     */
    public void setIncludePatterns(List<Pattern> patterns) {
        void var1_1;
        this.myIncludePatterns = var1_1;
    }

    public List<Pattern> getExcludePatterns() {
        return this.myExcludePatterns;
    }

    /*
     * WARNING - void declaration
     */
    public void setExcludePatterns(List<Pattern> patterns) {
        void var1_1;
        this.myExcludePatterns = var1_1;
    }

    public List<Pattern> getAnnotationsToIgnore() {
        return this.myAnnotationsToIgnore;
    }

    /*
     * WARNING - void declaration
     */
    public void setAnnotationsToIgnore(List<Pattern> annotations) {
        void var1_1;
        this.myAnnotationsToIgnore = var1_1;
    }

    public boolean isInstructionsCoverageEnabled() {
        return this.myCollectInstructions;
    }

    /*
     * WARNING - void declaration
     */
    public void setInstructionsCoverage(boolean collectInstructions) {
        void var1_1;
        this.myCollectInstructions = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void merge(CoverageData data) {
        void var1_1;
        ProjectData projectData = (ProjectData)data;
        for (Map.Entry<String, ClassData> entry : projectData.myClasses.entrySet()) {
            void var3_3;
            String key = entry.getKey();
            ClassData mergedData = entry.getValue();
            ClassData classData = this.myClasses.get(key);
            if (classData == null) {
                classData = new ClassData(mergedData.getName());
                this.myClasses.put(key, classData);
            }
            classData.merge((CoverageData)var3_3);
        }
        InstructionsUtil.merge((ProjectData)var1_1, this, null);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, ClassInstructions> getInstructions() {
        void var1_1;
        Map<String, ClassInstructions> instructions = this.myInstructions;
        if (instructions == null) {
            ProjectData projectData = this;
            synchronized (projectData) {
                instructions = this.myInstructions;
                if (instructions == null) {
                    this.myInstructions = instructions = new ConcurrentHashMap<String, ClassInstructions>();
                }
            }
        }
        return var1_1;
    }

    public static ProjectData getProjectData() {
        return ourProjectData;
    }

    /*
     * WARNING - void declaration
     */
    public void testEnded(String name) {
        if (this.myTestTrackingCallback != null) {
            void var1_1;
            this.myTestTrackingCallback.testEnded((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testStarted(String name) {
        if (this.myTestTrackingCallback != null) {
            void var1_1;
            this.myTestTrackingCallback.testStarted((String)var1_1);
        }
    }
}

