/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant.ant;

import com.intellij.lang.ant.ReflectedProject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.gant.GantScriptType;
import org.jetbrains.plugins.groovy.gant.ant.AntBuilderMethod;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public final class AntTasksProvider {
    private static final Logger LOG = Logger.getInstance(AntTasksProvider.class);
    private static final Key<CachedValue<Set<LightMethodBuilder>>> GANT_METHODS = Key.create((String)"gantMethods");
    private static final Object ourLock = new Object();
    public static final ParameterizedCachedValueProvider<Map<List<Path>, AntClassLoader>, Project> PROVIDER = project -> {
        Map map2 = ContainerUtil.createSoftValueMap();
        return CachedValueProvider.Result.create((Object)map2, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
    };
    public static final Key<ParameterizedCachedValue<Map<List<Path>, AntClassLoader>, Project>> KEY = Key.create((String)"ANtClassLoader");

    private AntTasksProvider() {
    }

    public static Set<LightMethodBuilder> getAntTasks(PsiElement place) {
        PsiFile file = place.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return Collections.emptySet();
        }
        return (Set)CachedValuesManager.getManager((Project)file.getProject()).getCachedValue((UserDataHolder)file, GANT_METHODS, () -> {
            Map<String, Class<?>> antObjects = AntTasksProvider.getAntObjects((GroovyFile)file);
            HashSet<LightMethodBuilder> methods = new HashSet<LightMethodBuilder>();
            Project project = file.getProject();
            PsiClassType mapType = TypesUtil.createType("java.util.LinkedHashMap", (PsiElement)file);
            PsiClassType stringType = TypesUtil.createType("java.lang.String", (PsiElement)file);
            PsiClassType closureType = TypesUtil.createType("groovy.lang.Closure", (PsiElement)file);
            for (String name : antObjects.keySet()) {
                methods.addAll(AntBuilderMethod.methods(file, name, antObjects.get(name), (PsiType)mapType, (PsiType)stringType, (PsiType)closureType));
            }
            return CachedValueProvider.Result.create(methods, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)project)});
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Class<?>> getAntObjects(GroovyFile groovyFile) {
        AntClassLoader loader;
        Project project = groovyFile.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)groovyFile);
        HashSet<VirtualFile> jars = new HashSet<VirtualFile>();
        if (module != null) {
            ContainerUtil.addAll(jars, (Object[])OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots());
        }
        if (groovyFile.isScript() && GroovyScriptUtil.getScriptType(groovyFile) instanceof GantScriptType) {
            jars.addAll(GantScriptType.additionalScopeFiles(groovyFile));
        }
        ArrayList<Path> files = new ArrayList<Path>();
        for (VirtualFile jar : jars) {
            VirtualFile localFile = VfsUtil.getLocalFile((VirtualFile)jar);
            if (!localFile.isInLocalFileSystem()) continue;
            files.add(localFile.toNioPath());
        }
        if (JavaPsiFacade.getInstance((Project)project).findClass("org.apache.tools.ant.Project", groovyFile.getResolveScope()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ant library not available in " + groovyFile.getVirtualFile().getPath() + "; files=" + String.valueOf(files));
            }
            return Collections.emptyMap();
        }
        Object object = ourLock;
        synchronized (object) {
            Map map2 = (Map)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)project, KEY, PROVIDER, false, (Object)project);
            loader = (AntClassLoader)((Object)map2.get(files));
            if (loader == null) {
                loader = new AntClassLoader(files);
                map2.put(files, loader);
            }
        }
        return loader.getAntObjects();
    }

    private static final class AntClassLoader
    extends UrlClassLoader {
        private static final boolean isParallelCapable = AntClassLoader.registerAsParallelCapable();
        private final Future<Map<String, Class<?>>> myFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                ReflectedProject antProject = ReflectedProject.getProject((ClassLoader)((Object)this));
                HashMap result2 = new HashMap();
                if (antProject != null) {
                    Map dataTypeDefinitions;
                    Map taskDefinitions = antProject.getTaskDefinitions();
                    if (taskDefinitions != null) {
                        result2.putAll(taskDefinitions);
                    }
                    if ((dataTypeDefinitions = antProject.getDataTypeDefinitions()) != null) {
                        result2.putAll(dataTypeDefinitions);
                    }
                }
                return result2;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
        });

        AntClassLoader(List<Path> files) {
            super(AntClassLoader.getBuilder(files), isParallelCapable);
        }

        private static UrlClassLoader.Builder getBuilder(List<Path> files) {
            return AntClassLoader.build().files(files).allowLock(false).noPreload().parent(ClassLoader.getPlatformClassLoader());
        }

        @NotNull
        Map<String, Class<?>> getAntObjects() {
            Map result2 = (Map)ProgressIndicatorUtils.awaitWithCheckCanceled(this.myFuture);
            Map map2 = result2 == null ? Collections.emptyMap() : result2;
            if (map2 == null) {
                AntClassLoader.$$$reportNull$$$0(0);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/gant/ant/AntTasksProvider$AntClassLoader", "getAntObjects"));
        }
    }
}

