/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.language.commit;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.TextProblemSeverities;
import com.intellij.grazie.text.CheckerRunner;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.Text;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class CommitAnnotator
implements Annotator {
    CommitAnnotator() {
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            CommitAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CommitAnnotator.$$$reportNull$$$0(1);
        }
        if (!CommitMessage.isCommitMessage((PsiElement)element) || !GrazieConfig.Companion.get().getCheckingContext().isCheckInCommitMessagesEnabled()) {
            return;
        }
        for (TextContent text : TextExtractor.findTextsAt(element, EnumSet.of(TextContent.TextDomain.PLAIN_TEXT))) {
            CommitAnnotator.checkText(holder, text);
        }
    }

    private static void checkText(AnnotationHolder holder, TextContent text) {
        CheckerRunner runner = new CheckerRunner(text);
        runner.run().forEach(problem -> {
            if (problem.fitsGroup(RuleGroup.UNDECORATED_SINGLE_SENTENCE) && Text.isSingleSentence(Text.findParagraphRange(text, problem.getHighlightRanges().getFirst()).subSequence((CharSequence)text))) {
                return;
            }
            List<ProblemDescriptor> descriptors = runner.toProblemDescriptors((TextProblem)problem, true);
            if (descriptors.isEmpty()) {
                return;
            }
            String message = problem.getDescriptionTemplate(true);
            String tooltip = problem.getTooltipTemplate();
            LocalQuickFix[] fixes = runner.toFixes((TextProblem)problem, descriptors.getFirst());
            for (TextRange range : problem.getHighlightRanges()) {
                boolean isStyle = problem.isStyleLike();
                AnnotationBuilder annotation = holder.newAnnotation(isStyle ? TextProblemSeverities.STYLE_SUGGESTION : TextProblemSeverities.GRAMMAR_ERROR, message).tooltip(tooltip).textAttributes(isStyle ? TextProblemSeverities.STYLE_SUGGESTION_ATTRIBUTES : TextProblemSeverities.GRAMMAR_ERROR_ATTRIBUTES).range(text.textRangeToFile(range));
                for (LocalQuickFix fix : fixes) {
                    annotation = annotation.withFix((IntentionAction)fix);
                }
                annotation.create();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/grazie/ide/language/commit/CommitAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

