/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.utils;

import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.Text;
import com.intellij.util.containers.ContainerUtil;

public final class ProblemFilterUtil {
    public static boolean isInitialCasingIssue(TextProblem problem) {
        return ContainerUtil.exists(problem.getHighlightRanges(), r -> r.getStartOffset() == 0) && problem.fitsGroup(RuleGroup.CASING);
    }

    public static boolean isUndecoratedSingleSentenceIssue(TextProblem problem) {
        return Text.isSingleSentence(problem.getText()) && problem.fitsGroup(RuleGroup.UNDECORATED_SINGLE_SENTENCE);
    }
}

