/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.JavaModuleTestCase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaPsiTestCase
extends JavaModuleTestCase {
    protected PsiManagerEx myPsiManager;
    protected PsiFile myFile;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myPsiManager = PsiManagerEx.getInstanceEx((Project)this.myProject);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myPsiManager = null;
            this.myFile = null;
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @NotNull
    protected PsiFile createDummyFile(@NotNull String fileName, @NotNull String text) throws IncorrectOperationException {
        if (fileName == null) {
            JavaPsiTestCase.$$$reportNull$$$0(0);
        }
        if (text == null) {
            JavaPsiTestCase.$$$reportNull$$$0(1);
        }
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, type, (CharSequence)text);
        if (psiFile == null) {
            JavaPsiTestCase.$$$reportNull$$$0(2);
        }
        return psiFile;
    }

    @NotNull
    protected PsiFile createFile(@NonNls @NotNull String fileName, @NotNull String text) throws Exception {
        if (fileName == null) {
            JavaPsiTestCase.$$$reportNull$$$0(3);
        }
        if (text == null) {
            JavaPsiTestCase.$$$reportNull$$$0(4);
        }
        PsiFile psiFile = this.createFile(this.myModule, fileName, text);
        if (psiFile == null) {
            JavaPsiTestCase.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    @NotNull
    protected PsiFile createFile(@NotNull Module module2, @NotNull String fileName, @NotNull String text) throws Exception {
        if (module2 == null) {
            JavaPsiTestCase.$$$reportNull$$$0(6);
        }
        if (fileName == null) {
            JavaPsiTestCase.$$$reportNull$$$0(7);
        }
        if (text == null) {
            JavaPsiTestCase.$$$reportNull$$$0(8);
        }
        PsiFile psiFile = this.createFile(module2, this.getTempDir().createVirtualDir(), fileName, text);
        if (psiFile == null) {
            JavaPsiTestCase.$$$reportNull$$$0(9);
        }
        return psiFile;
    }

    @NotNull
    protected PsiFile createFile(@NotNull Module module2, @NotNull VirtualFile vDir, @NotNull String fileName, @NotNull String text) throws IOException {
        if (module2 == null) {
            JavaPsiTestCase.$$$reportNull$$$0(10);
        }
        if (vDir == null) {
            JavaPsiTestCase.$$$reportNull$$$0(11);
        }
        if (fileName == null) {
            JavaPsiTestCase.$$$reportNull$$$0(12);
        }
        if (text == null) {
            JavaPsiTestCase.$$$reportNull$$$0(13);
        }
        VirtualFile virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> {
            if (!ModuleRootManager.getInstance((Module)module2).getFileIndex().isInSourceContent(vDir)) {
                this.addSourceContentToRoots(module2, vDir);
            }
            VirtualFile vFile = Objects.requireNonNull(vDir.createChildData((Object)vDir, fileName));
            VfsUtil.saveText((VirtualFile)vFile, (String)text);
            return vFile;
        });
        IndexingTestUtil.waitUntilIndexesAreReady(this.myProject);
        PsiFile psiFile = Objects.requireNonNull(this.myPsiManager.findFile(virtualFile));
        if (psiFile == null) {
            JavaPsiTestCase.$$$reportNull$$$0(14);
        }
        return psiFile;
    }

    protected void addSourceContentToRoots(@NotNull Module module2, @NotNull VirtualFile vDir) {
        if (module2 == null) {
            JavaPsiTestCase.$$$reportNull$$$0(15);
        }
        if (vDir == null) {
            JavaPsiTestCase.$$$reportNull$$$0(16);
        }
        PsiTestUtil.addSourceContentToRoots(module2, vDir);
    }

    protected PsiElement configureByFileWithMarker(@NotNull String filePath, @NotNull String marker) throws Exception {
        if (filePath == null) {
            JavaPsiTestCase.$$$reportNull$$$0(17);
        }
        if (marker == null) {
            JavaPsiTestCase.$$$reportNull$$$0(18);
        }
        VirtualFile vFile = VfsTestUtil.findFileByCaseSensitivePath(filePath);
        Object fileText = VfsUtilCore.loadText((VirtualFile)vFile);
        int offset = ((String)(fileText = StringUtil.convertLineSeparators((String)fileText))).indexOf(marker);
        JavaPsiTestCase.assertTrue((offset >= 0 ? 1 : 0) != 0);
        fileText = ((String)fileText).substring(0, offset) + ((String)fileText).substring(offset + marker.length());
        this.myFile = this.createFile(vFile.getName(), (String)fileText);
        return this.myFile.findElementAt(offset);
    }

    @NotNull
    protected String getTestDataPath() {
        String string = PathManagerEx.getTestDataPath();
        if (string == null) {
            JavaPsiTestCase.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    protected String loadFile(@NotNull String name) throws Exception {
        if (name == null) {
            JavaPsiTestCase.$$$reportNull$$$0(20);
        }
        String result = FileUtil.loadFile((File)new File(this.getTestDataPath() + File.separatorChar + name));
        String string = StringUtil.convertLineSeparators((String)result);
        if (string == null) {
            JavaPsiTestCase.$$$reportNull$$$0(21);
        }
        return string;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public Document getDocument(@NotNull PsiFile file) {
        if (file == null) {
            JavaPsiTestCase.$$$reportNull$$$0(22);
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file);
    }

    public Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            JavaPsiTestCase.$$$reportNull$$$0(23);
        }
        return FileDocumentManager.getInstance().getDocument(file);
    }

    public void commitDocument(@NotNull Document document) {
        if (document == null) {
            JavaPsiTestCase.$$$reportNull$$$0(24);
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 9, 14, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/JavaPsiTestCase";
                break;
            }
            case 6: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/JavaPsiTestCase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyFile";
                break;
            }
            case 5: 
            case 9: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataPath";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDummyFile";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 14: 
            case 19: 
            case 21: {
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addSourceContentToRoots";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "configureByFileWithMarker";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "commitDocument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 9, 14, 19, 21 -> new IllegalStateException(string);
        };
    }
}

