/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.LibraryLoadException;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.Setup;
import org.jetbrains.skiko.SkikoProperties;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J \u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u0011\u001a\u00020\u0007J\b\u0010\u0012\u001a\u00020\u0007H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/skiko/Library;", "", "<init>", "()V", "copyDir", "Ljava/io/File;", "loadLibraryOrCopy", "", "library", "unpackIfNeeded", "dest", "resourceName", "", "deleteOnExit", "", "loaded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "load", "findAndLoad", "skiko"})
@SourceDebugExtension(value={"SMAP\nLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Library.kt\norg/jetbrains/skiko/Library\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class Library {
    @NotNull
    public static final Library INSTANCE = new Library();
    @Nullable
    private static File copyDir;
    @NotNull
    private static AtomicBoolean loaded;

    private Library() {
    }

    private final void loadLibraryOrCopy(File library) {
        try {
            System.load(library.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError e) {
            String string = e.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"already loaded in another classloader", (boolean)false, (int)2, null) : false;
            if (bl) {
                File file = copyDir = Files.createTempDirectory("skiko", new FileAttribute[0]).toFile();
                Intrinsics.checkNotNull((Object)file);
                String string2 = library.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                File tempFile = FilesKt.resolve((File)file, (String)string2);
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(library.toPath(), tempFile.toPath(), copyOptionArray);
                tempFile.deleteOnExit();
                System.load(tempFile.getAbsolutePath());
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File unpackIfNeeded(File dest, String resourceName, boolean deleteOnExit) {
        File file = new File(dest, resourceName);
        if (!file.exists()) {
            File tempFile = File.createTempFile("skiko", "", dest);
            if (deleteOnExit) {
                file.deleteOnExit();
            }
            CopyOption[] copyOptionArray = (CopyOption[])Library.class.getResourceAsStream('/' + resourceName);
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)copyOptionArray;
                boolean bl = false;
                CopyOption[] copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                long l = Files.copy(input, tempFile.toPath(), copyOptionArray2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)copyOptionArray, (Throwable)throwable);
            }
            copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(tempFile.toPath(), file.toPath(), copyOptionArray);
        }
        return file;
    }

    public final synchronized void load() {
        if (!loaded.compareAndSet(false, true)) {
            return;
        }
        this.findAndLoad();
        Setup.init$default(Setup.INSTANCE, false, false, false, false, false, 31, null);
        try {
            org.jetbrains.skia.impl.Library.Companion._nAfterLoad();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void findAndLoad() {
        String string;
        String icu;
        String name = "skiko-" + OsArch_jvmKt.getHostId();
        String platformName = System.mapLibraryName(name);
        String string2 = icu = OsArch_jvmKt.getHostOs().isWindows() ? "icudtl.dat" : null;
        if (OsArch_jvmKt.getHostOs() == OS.Android) {
            System.loadLibrary("skiko-" + OsArch_jvmKt.getHostId());
            return;
        }
        String skikoLibraryPath = SkikoProperties.INSTANCE.getLibraryPath();
        if (skikoLibraryPath != null) {
            File library = new File(new File(skikoLibraryPath), platformName);
            this.loadLibraryOrCopy(library);
            if (icu != null && copyDir != null) {
                File file = copyDir;
                Intrinsics.checkNotNull((Object)file);
                this.unpackIfNeeded(file, icu, true);
            }
            return;
        }
        File jvmFiles = new File(System.getProperty("java.home"), OsArch_jvmKt.getHostOs().isWindows() ? "bin" : "lib");
        Intrinsics.checkNotNull((Object)platformName);
        File pathInJvm = FilesKt.resolve((File)jvmFiles, (String)platformName);
        if (pathInJvm.exists()) {
            boolean bl;
            String string3 = icu;
            if (string3 != null) {
                String it = string3;
                boolean bl2 = false;
                bl = !FilesKt.resolve((File)jvmFiles, (String)it).exists();
            } else {
                bl = false;
            }
            if (!bl) {
                this.loadLibraryOrCopy(pathInJvm);
                return;
            }
        }
        InputStream inputStream = Library.class.getResourceAsStream('/' + platformName + ".sha256");
        if (inputStream == null) {
            throw new LibraryLoadException("Cannot find " + platformName + ".sha256, proper native dependency missing.");
        }
        InputStream hashResourceStream = inputStream;
        Closeable bl2 = hashResourceStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)bl2;
            boolean bl = false;
            InputStream inputStream2 = it;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            string = (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).readLine();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)bl2, (Throwable)throwable);
        }
        String hash = string;
        File dataDir = new File(new File(SkikoProperties.INSTANCE.getDataPath()), hash);
        dataDir.mkdirs();
        File library = this.unpackIfNeeded(dataDir, platformName, false);
        this.loadLibraryOrCopy(library);
        if (icu != null) {
            File file;
            if (copyDir != null) {
                File file2 = copyDir;
                Intrinsics.checkNotNull((Object)file2);
                file = this.unpackIfNeeded(file2, icu, true);
            } else {
                file = this.unpackIfNeeded(dataDir, icu, false);
            }
        }
    }

    static {
        loaded = new AtomicBoolean(false);
    }
}

