/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.signature.SignatureVisitor;

public final class TraceSignatureVisitor
extends SignatureVisitor {
    private static final Map<Character, String> BASE_TYPES;
    private final boolean isInterface;
    private final StringBuilder declaration;
    private StringBuilder returnType;
    private StringBuilder exceptions;
    private boolean formalTypeParameterVisited;
    private boolean interfaceBoundVisited;
    private boolean parameterTypeVisited;
    private boolean interfaceVisited;
    private int argumentStack;
    private int arrayStack;
    private String separator = "";

    /*
     * WARNING - void declaration
     */
    public TraceSignatureVisitor(int accessFlags) {
        super(589824);
        void var1_1;
        this.isInterface = (var1_1 & 0x200) != 0;
        this.declaration = new StringBuilder();
    }

    /*
     * WARNING - void declaration
     */
    private TraceSignatureVisitor(StringBuilder stringBuilder) {
        super(589824);
        void var1_1;
        this.isInterface = false;
        this.declaration = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitFormalTypeParameter(String name) {
        void var1_1;
        this.declaration.append(this.formalTypeParameterVisited ? ", " : "<").append((String)var1_1);
        this.formalTypeParameterVisited = true;
        this.interfaceBoundVisited = false;
    }

    public final SignatureVisitor visitClassBound() {
        this.separator = " extends ";
        this.startType();
        return this;
    }

    public final SignatureVisitor visitInterfaceBound() {
        this.separator = this.interfaceBoundVisited ? ", " : " extends ";
        this.interfaceBoundVisited = true;
        this.startType();
        return this;
    }

    public final SignatureVisitor visitSuperclass() {
        this.endFormals();
        this.separator = " extends ";
        this.startType();
        return this;
    }

    public final SignatureVisitor visitInterface() {
        if (this.interfaceVisited) {
            this.separator = ", ";
        } else {
            this.separator = this.isInterface ? " extends " : " implements ";
            this.interfaceVisited = true;
        }
        this.startType();
        return this;
    }

    public final SignatureVisitor visitParameterType() {
        this.endFormals();
        if (this.parameterTypeVisited) {
            this.declaration.append(", ");
        } else {
            this.declaration.append('(');
            this.parameterTypeVisited = true;
        }
        this.startType();
        return this;
    }

    public final SignatureVisitor visitReturnType() {
        this.endFormals();
        if (this.parameterTypeVisited) {
            this.parameterTypeVisited = false;
        } else {
            this.declaration.append('(');
        }
        this.declaration.append(')');
        this.returnType = new StringBuilder();
        return new TraceSignatureVisitor(this.returnType);
    }

    public final SignatureVisitor visitExceptionType() {
        if (this.exceptions == null) {
            this.exceptions = new StringBuilder();
        } else {
            this.exceptions.append(", ");
        }
        return new TraceSignatureVisitor(this.exceptions);
    }

    /*
     * WARNING - void declaration
     */
    public final void visitBaseType(char descriptor) {
        void var1_2;
        String baseType = BASE_TYPES.get(Character.valueOf(descriptor));
        if (baseType == null) {
            throw new IllegalArgumentException();
        }
        this.declaration.append((String)var1_2);
        this.endType();
    }

    /*
     * WARNING - void declaration
     */
    public final void visitTypeVariable(String name) {
        void var1_1;
        this.declaration.append(this.separator).append((String)var1_1);
        this.separator = "";
        this.endType();
    }

    public final SignatureVisitor visitArrayType() {
        this.startType();
        this.arrayStack |= 1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitClassType(String name) {
        if ("java/lang/Object".equals(name)) {
            boolean bl = this.argumentStack % 2 != 0 || this.parameterTypeVisited;
            if (bl) {
                this.declaration.append(this.separator).append(name.replace('/', '.'));
            }
        } else {
            void var1_1;
            this.declaration.append(this.separator).append(var1_1.replace('/', '.'));
        }
        this.separator = "";
        this.argumentStack <<= 1;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitInnerClassType(String name) {
        void var1_1;
        if (this.argumentStack % 2 != 0) {
            this.declaration.append('>');
        }
        this.argumentStack /= 2;
        this.declaration.append('.');
        this.declaration.append(this.separator).append(var1_1.replace('/', '.'));
        this.separator = "";
        this.argumentStack <<= 1;
    }

    public final void visitTypeArgument() {
        if (this.argumentStack % 2 == 0) {
            ++this.argumentStack;
            this.declaration.append('<');
        } else {
            this.declaration.append(", ");
        }
        this.declaration.append('?');
    }

    /*
     * WARNING - void declaration
     */
    public final SignatureVisitor visitTypeArgument(char tag) {
        void var1_1;
        if (this.argumentStack % 2 == 0) {
            ++this.argumentStack;
            this.declaration.append('<');
        } else {
            this.declaration.append(", ");
        }
        if (tag == '+') {
            this.declaration.append("? extends ");
        } else if (var1_1 == 45) {
            this.declaration.append("? super ");
        }
        this.startType();
        return this;
    }

    public final void visitEnd() {
        if (this.argumentStack % 2 != 0) {
            this.declaration.append('>');
        }
        this.argumentStack /= 2;
        this.endType();
    }

    public final String getDeclaration() {
        return this.declaration.toString();
    }

    public final String getReturnType() {
        if (this.returnType == null) {
            return null;
        }
        return this.returnType.toString();
    }

    public final String getExceptions() {
        if (this.exceptions == null) {
            return null;
        }
        return this.exceptions.toString();
    }

    private void endFormals() {
        if (this.formalTypeParameterVisited) {
            this.declaration.append('>');
            this.formalTypeParameterVisited = false;
        }
    }

    private void startType() {
        this.arrayStack <<= 1;
    }

    private void endType() {
        if (this.arrayStack % 2 == 0) {
            this.arrayStack /= 2;
            return;
        }
        while (this.arrayStack % 2 != 0) {
            this.arrayStack /= 2;
            this.declaration.append("[]");
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        HashMap<Character, String> baseTypes = new HashMap<Character, String>();
        baseTypes.put(Character.valueOf('Z'), "boolean");
        baseTypes.put(Character.valueOf('B'), "byte");
        baseTypes.put(Character.valueOf('C'), "char");
        baseTypes.put(Character.valueOf('S'), "short");
        baseTypes.put(Character.valueOf('I'), "int");
        baseTypes.put(Character.valueOf('J'), "long");
        baseTypes.put(Character.valueOf('F'), "float");
        baseTypes.put(Character.valueOf('D'), "double");
        baseTypes.put(Character.valueOf('V'), "void");
        BASE_TYPES = Collections.unmodifiableMap(var0);
    }
}

